/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.textstream.receivers;

import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileLoggingTextOutputReceiver
implements TextOutputReceiver {
    private final Log log = LogFactory.getLog(this.getClass());
    private Path filepath;
    private BufferedWriter writer;

    public FileLoggingTextOutputReceiver(Path file) {
        this.filepath = file;
    }

    @Override
    public void onStart() {
        try {
            FileOutputStream fos = new FileOutputStream(this.filepath.toFile());
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            this.writer = new BufferedWriter(osw);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)"File not found.", (Throwable)e);
        }
    }

    @Override
    public void onFinished() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to close the output writer.", (Throwable)e);
        }
    }

    @Override
    public void onFatalError(Exception e) {
        try {
            this.writer.write(e.toString());
        }
        catch (IOException iOException) {
            this.log.error((Object)"Unable to write exception.", (Throwable)e);
        }
        this.onFinished();
    }

    @Override
    public void addOutput(String line) {
        try {
            this.writer.write(line);
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to write.", (Throwable)e);
        }
    }
}

