/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.gui;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.outputwriter.common.OutputLocation;
import de.rcenvironment.components.outputwriter.common.OutputLocationList;
import de.rcenvironment.components.outputwriter.gui.EditOutputLocationsCommand;
import de.rcenvironment.components.outputwriter.gui.Messages;
import de.rcenvironment.components.outputwriter.gui.OutputLocationEditDialog;
import de.rcenvironment.components.outputwriter.gui.RemoveOutputLocationsCommand;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class OutputLocationPane
implements Refreshable {
    protected Section section;
    protected Composite client;
    protected ComponentInstanceProperties configuration;
    protected Table table;
    protected Button buttonAdd;
    protected Button buttonEdit;
    protected Button buttonRemove;
    protected ButtonSelectionAdapter buttonListener;
    protected MenuItem itemAdd;
    protected MenuItem itemEdit;
    protected MenuItem itemRemove;
    protected Image icon;
    protected TableColumnLayout tableLayout;
    protected WorkflowNodeCommand.Executor executor;
    protected ObjectMapper jsonMapper;

    public OutputLocationPane(WorkflowNodeCommand.Executor executor) {
        this.executor = executor;
        this.jsonMapper = JsonUtils.getDefaultObjectMapper();
        this.jsonMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
    }

    public void refresh() {
        this.updateTable();
    }

    public Control getControl() {
        return this.section;
    }

    public void setConfiguration(ComponentInstanceProperties configuration) {
        this.configuration = configuration;
        this.updateTable();
    }

    public Control createControl(Composite parent, String title, FormToolkit toolkit) {
        this.section = toolkit.createSection(parent, 320);
        this.section.setText(title);
        this.client = toolkit.createComposite((Composite)this.section);
        this.client.setLayout((Layout)new GridLayout(2, false));
        Composite tableComposite = toolkit.createComposite(this.client);
        this.tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)this.tableLayout);
        this.table = toolkit.createTable(tableComposite, 68354);
        this.table.setHeaderVisible(true);
        GridData tableLayoutData = new GridData(4, 4, true, true, 1, 3);
        tableLayoutData.heightHint = 100;
        tableComposite.setLayoutData((Object)tableLayoutData);
        Listener tableListener = this.getTableListener(parent);
        this.table.addListener(12, tableListener);
        this.table.addListener(1, tableListener);
        this.table.addListener(5, tableListener);
        this.table.addListener(32, tableListener);
        this.table.addListener(8, tableListener);
        TableColumn colName = new TableColumn(this.table, 0);
        colName.setText(Messages.outputLocFilename);
        TableColumn colFolder = new TableColumn(this.table, 0);
        colFolder.setText(Messages.targetFolder);
        TableColumn colInputs = new TableColumn(this.table, 0);
        colInputs.setText(Messages.inputsForOutputLocation);
        this.tableLayout.setColumnData((Widget)colInputs, (ColumnLayoutData)new ColumnWeightData(20, true));
        this.tableLayout.setColumnData((Widget)colName, (ColumnLayoutData)new ColumnWeightData(20, true));
        this.tableLayout.setColumnData((Widget)colFolder, (ColumnLayoutData)new ColumnWeightData(20, true));
        this.buttonAdd = toolkit.createButton(this.client, Messages.add, 0x800000);
        this.buttonAdd.setLayoutData((Object)new GridData(4, 128, false, false));
        this.buttonEdit = toolkit.createButton(this.client, Messages.edit, 0x800000);
        this.buttonEdit.setLayoutData((Object)new GridData(4, 128, false, false));
        this.buttonEdit.setEnabled(false);
        this.buttonRemove = toolkit.createButton(this.client, Messages.remove, 0x800000);
        this.buttonRemove.setLayoutData((Object)new GridData(4, 128, false, false));
        this.buttonRemove.setEnabled(false);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputLocationPane.this.updateButtonActivation();
            }
        });
        this.buttonListener = new ButtonSelectionAdapter();
        this.buttonAdd.addSelectionListener((SelectionListener)this.buttonListener);
        this.buttonEdit.addSelectionListener((SelectionListener)this.buttonListener);
        this.buttonRemove.addSelectionListener((SelectionListener)this.buttonListener);
        this.fillContextMenu(this.table);
        this.table.addKeyListener((KeyListener)new DeleteKeyListener());
        this.section.setClient((Control)this.client);
        toolkit.paintBordersFor(this.client);
        this.section.setExpanded(true);
        return this.section;
    }

    private void fillContextMenu(Table tab) {
        Menu menu = new Menu((Control)tab);
        this.itemAdd = new MenuItem(menu, 8);
        this.itemAdd.setText(Messages.add);
        this.itemAdd.addSelectionListener((SelectionListener)this.buttonListener);
        this.itemEdit = new MenuItem(menu, 8);
        this.itemEdit.setText(Messages.edit);
        this.itemEdit.addSelectionListener((SelectionListener)this.buttonListener);
        this.itemRemove = new MenuItem(menu, 8);
        this.itemRemove.setText(Messages.remove);
        this.itemRemove.addSelectionListener((SelectionListener)this.buttonListener);
        tab.setMenu(menu);
    }

    private Listener getTableListener(Composite parent) {
        Listener tableListener = new Listener(){
            private Shell tip = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        break;
                    }
                    case 32: {
                        break;
                    }
                    case 8: {
                        if (OutputLocationPane.this.buttonEdit == null || !OutputLocationPane.this.buttonEdit.isEnabled() || event.button != 1) break;
                        OutputLocationPane.this.onEditClicked();
                        break;
                    }
                }
            }
        };
        return tableListener;
    }

    protected void onRemovedClicked() {
        TableItem[] selection = this.table.getSelection();
        LinkedList<String> names = new LinkedList<String>();
        int i = 0;
        while (i < selection.length) {
            names.add((String)selection[i].getData());
            ++i;
        }
        this.executeRemoveCommand(names);
    }

    protected void executeRemoveCommand(String name) {
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(name);
        this.executeRemoveCommand(nameList);
    }

    protected void executeRemoveCommand(List<String> names) {
        RemoveOutputLocationsCommand command = new RemoveOutputLocationsCommand(names, this);
        this.execute(command);
    }

    protected void updateTable() {
        if (!this.getControl().isDisposed()) {
            this.fillTable();
            this.updateButtonActivation();
        }
    }

    protected void fillTable() {
        if (this.client.isVisible() && !this.table.isDisposed()) {
            this.table.removeAll();
            String jsonString = this.configuration.getConfigurationDescription().getConfigurationValue("outputLocations");
            if (jsonString == null) {
                jsonString = "";
            }
            try {
                OutputLocationList list = (OutputLocationList)this.jsonMapper.readValue(jsonString, OutputLocationList.class);
                for (OutputLocation ol : list.getOutputLocations()) {
                    TableItem item = new TableItem(this.table, 0);
                    item.setData((Object)ol.getGroupId());
                    item.setText(0, ol.getFilename());
                    item.setText(1, ol.getFolderForSaving());
                    item.setText(2, ol.getInputs().toString());
                }
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).debug((Object)("Error when reading targets from JSON: " + e.getMessage()));
            }
        }
    }

    protected void onEditClicked() {
        String id = (String)this.table.getSelection()[0].getData();
        OutputLocation selectedLocation = new OutputLocation();
        TreeSet<String> paths = new TreeSet<String>();
        List<String> possibleInputs = this.getPossibleInputs();
        ArrayList<String> selectedInputs = new ArrayList<String>();
        ArrayList<String> otherOutputLocationNamesWithPahts = new ArrayList<String>();
        String jsonString = this.configuration.getConfigurationDescription().getConfigurationValue("outputLocations");
        if (jsonString == null) {
            jsonString = "{}";
        }
        try {
            OutputLocationList list = (OutputLocationList)this.jsonMapper.readValue(jsonString, OutputLocationList.class);
            selectedLocation = list.getOutputLocationById(id);
            for (OutputLocation ol : list.getOutputLocations()) {
                paths.add(ol.getFolderForSaving());
                if (ol.getGroupId().equals(id)) continue;
                selectedInputs.addAll(ol.getInputs());
                otherOutputLocationNamesWithPahts.add(String.valueOf(ol.getFolderForSaving()) + File.separator + ol.getFilename());
            }
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).debug((Object)("Error when parsing JSON file " + e.getMessage()));
        }
        OutputLocationEditDialog dialog = new OutputLocationEditDialog(Display.getDefault().getActiveShell(), Messages.outputLocationEditDialogTitle, paths, possibleInputs, selectedInputs, otherOutputLocationNamesWithPahts);
        dialog.initializeValues(selectedLocation);
        if (!(dialog.open() != 0 || dialog.getChosenFilename().equals(selectedLocation.getFilename()) && dialog.getChosenFolderForSaving().equals(selectedLocation.getFolderForSaving()) && dialog.getChosenHeader().equals(selectedLocation.getHeader()) && dialog.getChosenFormatString().equals(selectedLocation.getFormatString()) && dialog.getChosenHandle().equals((Object)selectedLocation.getHandleExistingFile()) && dialog.getChosenInputSet().equals(selectedLocation.getInputs()))) {
            OutputLocation out = new OutputLocation(id, dialog.getChosenFilename(), dialog.getChosenFolderForSaving(), dialog.getChosenHeader(), dialog.getChosenFormatString(), dialog.getChosenHandle(), dialog.getChosenInputSet());
            EditOutputLocationsCommand command = new EditOutputLocationsCommand(out, this);
            this.execute(command);
        }
        this.refresh();
    }

    protected void onAddClicked() {
        TreeSet<String> paths = new TreeSet<String>();
        List<String> possibleInputs = this.getPossibleInputs();
        ArrayList<String> selectedInputs = new ArrayList<String>();
        ArrayList<String> otherOutputLocationNameswithPaths = new ArrayList<String>();
        String jsonString = this.configuration.getConfigurationDescription().getConfigurationValue("outputLocations");
        if (jsonString == null) {
            jsonString = "{}";
        }
        try {
            OutputLocationList list = (OutputLocationList)this.jsonMapper.readValue(jsonString, OutputLocationList.class);
            for (OutputLocation ol : list.getOutputLocations()) {
                paths.add(ol.getFolderForSaving());
                selectedInputs.addAll(ol.getInputs());
                otherOutputLocationNameswithPaths.add(String.valueOf(ol.getFolderForSaving()) + File.separator + ol.getFilename());
            }
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).debug((Object)("Error when parsing JSON file " + e.getMessage()));
        }
        OutputLocationEditDialog dialog = new OutputLocationEditDialog(Display.getDefault().getActiveShell(), Messages.outputLocationAddDialogTitle, paths, possibleInputs, selectedInputs, otherOutputLocationNameswithPaths);
        if (dialog.open() == 0) {
            OutputLocation out = new OutputLocation(dialog.getChosenFilename(), dialog.getChosenFolderForSaving(), dialog.getChosenHeader(), dialog.getChosenFormatString(), dialog.getChosenHandle(), dialog.getChosenInputSet());
            EditOutputLocationsCommand command = new EditOutputLocationsCommand(out, this);
            this.execute(command);
        }
        this.refresh();
    }

    private List<String> getPossibleInputs() {
        ArrayList<String> possibleInputs = new ArrayList<String>();
        for (EndpointDescription input : this.configuration.getInputDescriptionsManager().getEndpointDescriptions()) {
            if (input.getDataType().equals((Object)DataType.FileReference) || input.getDataType().equals((Object)DataType.DirectoryReference)) continue;
            possibleInputs.add(input.getName());
        }
        return possibleInputs;
    }

    protected void execute(WorkflowNodeCommand command) {
        if (this.executor == null) {
            throw new RuntimeException("No executor set for execution of workflow node commands");
        }
        if (command != null) {
            this.executor.execute(command);
        }
    }

    protected void updateButtonActivation() {
        TableItem[] selection = this.table.getSelection();
        boolean hasSelection = selection.length != 0;
        this.buttonRemove.setEnabled(hasSelection);
        if (selection.length == 1 && !this.getPossibleInputs().isEmpty()) {
            this.buttonEdit.setEnabled(true);
        } else {
            this.buttonEdit.setEnabled(false);
        }
        if (this.getPossibleInputs().isEmpty()) {
            this.buttonAdd.setEnabled(false);
            if (this.table.getItemCount() == 0) {
                this.table.setEnabled(false);
            }
        } else {
            this.buttonAdd.setEnabled(true);
            this.table.setEnabled(true);
        }
        this.itemEdit.setEnabled(this.buttonEdit.isEnabled());
        this.itemRemove.setEnabled(this.buttonRemove.isEnabled());
        this.itemAdd.setEnabled(this.buttonAdd.isEnabled());
    }

    private class ButtonSelectionAdapter
    extends SelectionAdapter {
        private ButtonSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == OutputLocationPane.this.buttonAdd || e.widget == OutputLocationPane.this.itemAdd) {
                OutputLocationPane.this.onAddClicked();
            } else if (e.widget == OutputLocationPane.this.buttonEdit || e.widget == OutputLocationPane.this.itemEdit) {
                OutputLocationPane.this.onEditClicked();
            } else if (e.widget == OutputLocationPane.this.buttonRemove || e.widget == OutputLocationPane.this.itemRemove) {
                OutputLocationPane.this.onRemovedClicked();
            }
        }
    }

    private class DeleteKeyListener
    implements KeyListener {
        private DeleteKeyListener() {
        }

        public void keyPressed(KeyEvent event) {
            if (event.keyCode == 127 && OutputLocationPane.this.buttonRemove.isEnabled()) {
                OutputLocationPane.this.onRemovedClicked();
            }
        }

        public void keyReleased(KeyEvent event) {
        }
    }
}

