/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.dialog;

import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.Border;
import com.googlecode.lanterna.gui.GUIScreen;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.Window;
import com.googlecode.lanterna.gui.component.ActionListBox;
import com.googlecode.lanterna.gui.component.Button;
import com.googlecode.lanterna.gui.component.EmptySpace;
import com.googlecode.lanterna.gui.component.Label;
import com.googlecode.lanterna.gui.component.Panel;
import com.googlecode.lanterna.gui.component.TextBox;
import com.googlecode.lanterna.gui.layout.BorderLayout;
import com.googlecode.lanterna.gui.layout.LayoutParameter;
import com.googlecode.lanterna.gui.layout.LinearLayout;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

public class FileDialog
extends Window {
    private final Label labelCurrentDirectory;
    private final TextBox fileText;
    private final ActionListBox dirView;
    private final ActionListBox fileView;
    private File currentDirectory;
    private File selectedFile = null;

    public static File showOpenFileDialog(GUIScreen owner, File directory, String title) {
        FileDialog dialog = new FileDialog(directory, title, Kind.Open);
        owner.showWindow(dialog);
        return dialog.getSelectedFile();
    }

    public static File showSaveFileDialog(GUIScreen owner, File directory, String title) {
        FileDialog dialog = new FileDialog(directory, title, Kind.Save);
        owner.showWindow(dialog);
        return dialog.getSelectedFile();
    }

    private FileDialog(File directory, String title, Kind kind) {
        super(title);
        Panel panelFileDir = new Panel(Panel.Orientation.HORISONTAL);
        this.fileView = this.createFileListBox();
        this.dirView = this.createFileListBox();
        this.fileText = new TextBox();
        Panel panelButtons = new Panel(Panel.Orientation.HORISONTAL);
        Button okButton = new Button(kind.name(), new Action(){

            @Override
            public void doAction() {
                FileDialog.this.selectedFile = new File(FileDialog.this.currentDirectory, FileDialog.this.fileText.getText());
                FileDialog.this.close();
            }
        });
        Button cancelButton = new Button("Cancel", new Action(){

            @Override
            public void doAction() {
                FileDialog.this.close();
            }
        });
        this.labelCurrentDirectory = new Label();
        this.addComponent(this.labelCurrentDirectory, LinearLayout.GROWS_HORIZONTALLY);
        panelFileDir.setLayoutManager(new BorderLayout());
        panelFileDir.addComponent(this.fileView.addBorder(new Border.Bevel(true), "Files"), BorderLayout.CENTER);
        panelFileDir.addComponent(this.dirView.addBorder(new Border.Bevel(true), "Directories"), BorderLayout.RIGHT);
        this.addComponent(panelFileDir, LinearLayout.GROWS_HORIZONTALLY);
        this.addComponent(new EmptySpace(40, 1), new LayoutParameter[0]);
        this.addComponent(this.fileText, LinearLayout.GROWS_HORIZONTALLY);
        this.addComponent(new EmptySpace(40, 1), new LayoutParameter[0]);
        panelButtons.addComponent(new EmptySpace(), LinearLayout.GROWS_HORIZONTALLY);
        panelButtons.addComponent(okButton, new LayoutParameter[0]);
        panelButtons.addComponent(cancelButton, new LayoutParameter[0]);
        this.addComponent(panelButtons, LinearLayout.GROWS_HORIZONTALLY);
        this.reloadViews(directory);
    }

    private void reloadViews(File directory) {
        this.currentDirectory = directory.getAbsoluteFile();
        this.dirView.clearItems();
        this.fileView.clearItems();
        this.labelCurrentDirectory.setText(this.currentDirectory.getAbsolutePath());
        File[] entries = directory.listFiles();
        Arrays.sort(entries, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        });
        this.dirView.addAction("..", new Action(){

            @Override
            public void doAction() {
                FileDialog.this.reloadViews(FileDialog.this.currentDirectory.getParentFile());
            }
        });
        for (final File entry : entries) {
            if (entry.isDirectory()) {
                this.dirView.addAction(entry.getName(), new Action(){

                    @Override
                    public void doAction() {
                        FileDialog.this.reloadViews(entry);
                    }
                });
                continue;
            }
            this.fileView.addAction(entry.getName(), new Action(){

                @Override
                public void doAction() {
                    FileDialog.this.fileText.setText(entry.getName());
                    FileDialog.this.setFocus(FileDialog.this.fileText);
                }
            });
        }
    }

    private File getSelectedFile() {
        return this.selectedFile;
    }

    private ActionListBox createFileListBox() {
        return new ActionListBox(){

            @Override
            protected Theme.Definition getListItemThemeDefinition(Theme theme) {
                return theme.getDefinition(Theme.Category.TEXTBOX);
            }

            @Override
            protected Theme.Definition getSelectedListItemThemeDefinition(Theme theme) {
                return theme.getDefinition(Theme.Category.TEXTBOX_FOCUSED);
            }
        };
    }

    private static enum Kind {
        Open,
        Save;

    }
}

