/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.utils.common;

import de.rcenvironment.toolkit.utils.common.ConsistencyChecks;
import de.rcenvironment.toolkit.utils.common.IdGeneratorType;
import java.security.SecureRandom;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.binary.Hex;

public final class IdGenerator {
    public static final int MAX_RANDOM_STRING_LENGTH = 64;
    private static final SecureRandom sharedSecureRandom = new SecureRandom();

    private IdGenerator() {
    }

    public static String createRandomHexString(int length, IdGeneratorType generatorType) {
        IdGenerator.validateRequestedLength(length);
        byte[] bytes = new byte[length / 2];
        switch (generatorType) {
            case FAST: {
                ThreadLocalRandom.current().nextBytes(bytes);
                break;
            }
            case SECURE: {
                sharedSecureRandom.nextBytes(bytes);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        String string = IdGenerator.endodeBytesAsHexAndValidateLength(bytes, length);
        return string;
    }

    public static String fastRandomHexString(int length) {
        return IdGenerator.createRandomHexString(length, IdGeneratorType.FAST);
    }

    public static String secureRandomHexString(int length) {
        return IdGenerator.createRandomHexString(length, IdGeneratorType.SECURE);
    }

    private static void validateRequestedLength(int length) {
        if (length < 2 || length > 64 || length % 2 != 0) {
            throw new IllegalArgumentException("Length must be an even number between 2 and 64");
        }
    }

    private static String endodeBytesAsHexAndValidateLength(byte[] bytes, int length) {
        String string = Hex.encodeHexString((byte[])bytes);
        if (string.length() != length) {
            ConsistencyChecks.reportFailure("Unexpected string length: " + string);
        }
        return string;
    }
}

