/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.tiglviewer.gui.runtime;

import de.rcenvironment.components.tiglviewer.execution.TiglViewerView;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.File;
import java.io.IOException;
import org.apache.commons.exec.OS;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class TiglViewerRuntimeView
extends TiglViewerView {
    private static final Log LOGGER = LogFactory.getLog(TiglViewerRuntimeView.class);

    public void showView(File tempFile) {
        try {
            final String secondId = tempFile.getCanonicalPath().replaceAll(":", "&#38");
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow[] windows = wb.getWorkbenchWindows();
            IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
            if (window == null) {
                window = windows[0];
            }
            final IWorkbenchPage page = window.getActivePage();
            ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                @Override
                @TaskDescription(value="Starting TiGLViewer")
                public void run() {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (OS.isFamilyWindows()) {
                                    page.showView("de.rcenvironment.core.gui.tiglviewer.views.TIGLViewer", secondId, 1);
                                }
                            }
                            catch (PartInitException e) {
                                LOGGER.error((Object)e);
                            }
                        }
                    });
                }
            });
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error((Object)"TiGLViewer component cannot open TiGLViewer. Maybe no GUI available?");
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }
}

