/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.validation.api;

import de.rcenvironment.core.utils.common.StringUtils;

public class ComponentValidationMessage {
    private final Type type;
    private final String property;
    private final String relativeMessage;
    private final String absoluteMessage;
    private final boolean revalidateOnWorkflowStart;

    public ComponentValidationMessage(Type type, String property, String relativeMessage, String absoluteMessage) {
        this(type, property, relativeMessage, absoluteMessage, false);
    }

    public ComponentValidationMessage(Type type, String property, String relativeMessage, String absoluteMessage, boolean revalidateOnWorkflowStart) {
        this.type = type;
        this.property = property;
        this.relativeMessage = relativeMessage;
        this.absoluteMessage = absoluteMessage;
        this.revalidateOnWorkflowStart = revalidateOnWorkflowStart;
    }

    public Type getType() {
        return this.type;
    }

    public String getProperty() {
        return this.property;
    }

    public String getRelativeMessage() {
        return this.relativeMessage;
    }

    public String getAbsoluteMessage() {
        return this.absoluteMessage;
    }

    public boolean isRevalidateOnWorkflowStart() {
        return this.revalidateOnWorkflowStart;
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof ComponentValidationMessage) {
            ComponentValidationMessage other = (ComponentValidationMessage)obj;
            String thisString = this.property + this.relativeMessage + this.absoluteMessage;
            String otherString = other.property + other.relativeMessage + other.absoluteMessage;
            result = thisString.equals(otherString);
        }
        return result;
    }

    public int hashCode() {
        return StringUtils.nullSafe((String)(String.valueOf(this.property) + this.relativeMessage + this.absoluteMessage)).hashCode();
    }

    public String toString() {
        if (this.property != null && !this.property.isEmpty() && this.relativeMessage != null && !this.relativeMessage.isEmpty()) {
            return StringUtils.format((String)"%s: %s", (Object[])new Object[]{this.property, this.relativeMessage});
        }
        return this.absoluteMessage;
    }

    public static enum Type {
        WARNING,
        ERROR;

    }
}

