/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.management.internal;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroupListener;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.component.api.ComponentIdRules;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.api.UserComponentIdMappingService;
import de.rcenvironment.core.component.authorization.api.ComponentAuthorizationSelector;
import de.rcenvironment.core.component.authorization.api.NamedComponentAuthorizationSelector;
import de.rcenvironment.core.component.authorization.impl.ComponentAuthorizationSelectorImpl;
import de.rcenvironment.core.component.authorization.impl.NamedComponentAuthorizationSelectorImpl;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.management.api.LocalComponentRegistrationService;
import de.rcenvironment.core.component.management.api.PermissionMatrixChangeListener;
import de.rcenvironment.core.component.management.internal.ComponentDataConverter;
import de.rcenvironment.core.component.management.internal.ComponentPermissionStorage;
import de.rcenvironment.core.component.management.internal.DistributedComponentEntryImpl;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class LocalComponentRegistrationServiceImpl
implements LocalComponentRegistrationService,
AuthorizationAccessGroupListener {
    private static final String ERROR_PLACEHOLDER_EXTERNAL_ID = "rce/UNKNOWN";
    private static final int ACTIVATION_TO_COMPONENT_PUBLISHING_DELAY_MSEC = 50;
    private final Map<String, DistributedComponentEntry> componentEntriesByInstallationId = new HashMap<String, DistributedComponentEntry>();
    private final Map<ComponentAuthorizationSelector, Collection<DistributedComponentEntry>> remotableCompEntriesByAuthorizationSelector = new HashMap<ComponentAuthorizationSelector, Collection<DistributedComponentEntry>>();
    private final Map<ComponentAuthorizationSelector, AuthorizationPermissionSet> nonLocalPermissionSetsBySelector = new HashMap<ComponentAuthorizationSelector, AuthorizationPermissionSet>();
    private volatile boolean startupPublishDelayExceeded = false;
    private UserComponentIdMappingService userComponentIdMappingService;
    private AuthorizationService authorizationService;
    private DistributedComponentKnowledgeService componentDistributor;
    private AuthorizationPermissionSet permissionSetLocalOnly;
    private final Object installationsAndPermissionsLock = new Object();
    private final Log log = LogFactory.getLog(this.getClass());
    private final AsyncOrderedCallbackManager<PermissionMatrixChangeListener> permissionMatrixChangesCallbackManager = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);
    private List<AuthorizationAccessGroup> availableAccessGroups;
    private ComponentPermissionStorage permissionStorage;
    private final CountDownLatch localComponentRegistrationCompleteLatch = new CountDownLatch(2);
    private final CountDownLatch localComponentInitializationCompleteLatch = new CountDownLatch(1);
    private final AsyncTaskService asyncTaskService = ConcurrencyUtils.getAsyncTaskService();
    private volatile boolean initializing;
    private Map<String, String> associatedSelectorDisplayNames = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOrUpdateLocalComponentInstallation(ComponentInstallation componentInstallation) {
        Optional<String> validationError = ComponentIdRules.validateComponentInterfaceIds(componentInstallation.getComponentInterface());
        if (validationError.isPresent()) {
            this.log.error((Object)("Skipping registration of local component/tool " + componentInstallation.getInstallationId() + "; reason: " + validationError.get()));
            return;
        }
        ComponentAuthorizationSelector componentSelector = this.getComponentSelector(componentInstallation);
        AuthorizationPermissionSet permissionSet = this.getComponentPermissionSet(componentSelector, true);
        DistributedComponentEntryImpl newEntry = ComponentDataConverter.createLocalDistributedComponentEntry(componentInstallation, permissionSet, this.authorizationService);
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            if (!permissionSet.isLocalOnly() && componentInstallation.getComponentInterface().getLocalExecutionOnly()) {
                this.log.warn((Object)("Registering the local-only component " + componentInstallation.getInstallationId() + " while remote access permissions are set for its selector; this is not an immediate problem, " + "as publication is still prevented by the local-only filter, but the setting is unusual/inconsistent"));
            }
            DistributedComponentEntry replacedEntry = this.componentEntriesByInstallationId.put(componentInstallation.getInstallationId(), newEntry);
            if (!componentInstallation.getComponentInterface().getLocalExecutionOnly()) {
                this.addRemotableComponentToAuthorizationTracking(newEntry, componentSelector);
            }
            if (replacedEntry != null) {
                this.removeComponentFromAuthorizationTracking(replacedEntry, componentSelector);
            }
            this.updatePublicationEntriesForLocalComponents();
        }
        this.notifyChangeListenersAsync(false, true, false);
        this.log.debug((Object)StringUtils.format((String)"Registered or updated local component %s, reusing the previous access type %s (access groups: %s)", (Object[])new Object[]{componentInstallation.getComponentInterface().getIdentifierAndVersion(), newEntry.getType(), permissionSet}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOrUpdateSingleVersionLocalComponentInstallation(ComponentInstallation componentInstallation, AuthorizationPermissionSet permissionSet) {
        boolean permissionAssignmentsChanged;
        Objects.requireNonNull(permissionSet);
        if (!permissionSet.isLocalOnly() && componentInstallation.getComponentInterface().getLocalExecutionOnly()) {
            this.log.warn((Object)("Setting non-local permissions for the local-only component " + componentInstallation.getInstallationId() + "; this will be shown on the local node, but the component will still not be published"));
        }
        ComponentAuthorizationSelector authorizationSelector = this.getComponentSelector(componentInstallation);
        DistributedComponentEntryImpl newEntry = ComponentDataConverter.createLocalDistributedComponentEntry(componentInstallation, permissionSet, this.authorizationService);
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            DistributedComponentEntry replacedEntry = this.componentEntriesByInstallationId.put(componentInstallation.getInstallationId(), newEntry);
            permissionAssignmentsChanged = this.updatePermissionSet(authorizationSelector, permissionSet);
            if (!componentInstallation.getComponentInterface().getLocalExecutionOnly()) {
                this.addRemotableComponentToAuthorizationTracking(newEntry, authorizationSelector);
            }
            if (replacedEntry != null) {
                this.removeComponentFromAuthorizationTracking(replacedEntry, authorizationSelector);
            }
            this.updatePublicationEntriesForLocalComponents();
        }
        this.notifyChangeListenersAsync(false, true, permissionAssignmentsChanged);
        this.log.debug((Object)StringUtils.format((String)"Registered or updated local component %s with access type %s (access groups: %s)", (Object[])new Object[]{componentInstallation.getComponentInterface().getIdentifierAndVersion(), newEntry.getType(), permissionSet}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLocalComponentInstallation(String compInstallationId) {
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            DistributedComponentEntry removedCompEntry = this.componentEntriesByInstallationId.remove(compInstallationId);
            if (removedCompEntry == null) {
                this.log.warn((Object)("Received a call to remove component " + compInstallationId + ", but no matching component was found"));
                return;
            }
            if (!removedCompEntry.getComponentInterface().getLocalExecutionOnly()) {
                ComponentAuthorizationSelector authSelector = this.getComponentSelector(removedCompEntry.getComponentInstallation());
                this.removeComponentFromAuthorizationTracking(removedCompEntry, authSelector);
            }
            this.updatePublicationEntriesForLocalComponents();
        }
        this.notifyChangeListenersAsync(false, true, false);
        this.log.debug((Object)("Removed component: " + compInstallationId));
    }

    @Override
    public void reportBuiltinComponentLoadingComplete() {
        this.localComponentRegistrationCompleteLatch.countDown();
        this.log.debug((Object)"Built-in component loading reported as finished");
    }

    @Override
    public void reportToolIntegrationRegistrationComplete() {
        this.localComponentRegistrationCompleteLatch.countDown();
        this.log.debug((Object)"Tool integration component loading reported as finished");
    }

    @Override
    public boolean waitForLocalComponentInitialization(int maxWait, TimeUnit timeUnit) throws InterruptedException {
        return this.localComponentInitializationCompleteLatch.await(maxWait, timeUnit);
    }

    @Activate
    protected void activate() {
        this.availableAccessGroups = this.authorizationService.listAccessibleGroups(true);
        this.initializing = true;
        this.asyncTaskService.execute("Asynchronous component registry initialization", this::initializeAsync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAsync() {
        try {
            if (!this.localComponentRegistrationCompleteLatch.await(1L, TimeUnit.MINUTES)) {
                throw new RuntimeException("Component registration did not complete within a reasonable time");
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            this.log.info((Object)"Interrupted while waiting for component registration to complete - assuming early shutdown, skipping component publication");
            this.initializing = false;
            return;
        }
        this.log.debug((Object)"Startup component registration complete, restoring and applying component authorization entries");
        Map<ComponentAuthorizationSelector, AuthorizationPermissionSet> restoredAssignments = this.permissionStorage.restorePersistedAssignments();
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            for (Map.Entry<ComponentAuthorizationSelector, AuthorizationPermissionSet> e : restoredAssignments.entrySet()) {
                AuthorizationPermissionSet newPermissionSet;
                ComponentAuthorizationSelector selector = e.getKey();
                if (!this.updatePermissionSet(selector, newPermissionSet = e.getValue())) {
                    this.log.warn((Object)("Unexpected result: Applying the restored permission assignment " + e.getValue() + " for " + e.getKey() + " caused no local change"));
                }
                this.updatePermissionSetsOfRegisteredComponents(selector, newPermissionSet);
            }
        }
        this.notifyChangeListenersAsync(false, true, true);
        this.initializing = false;
        this.asyncTaskService.scheduleAfterDelay(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @TaskDescription(value="Publish workflow components")
            public void run() {
                Object object = LocalComponentRegistrationServiceImpl.this.installationsAndPermissionsLock;
                synchronized (object) {
                    LocalComponentRegistrationServiceImpl.this.startupPublishDelayExceeded = true;
                    LocalComponentRegistrationServiceImpl.this.log.debug((Object)"Startup component initialization complete, triggering initial publication");
                    LocalComponentRegistrationServiceImpl.this.updatePublicationEntriesForLocalComponents();
                    LocalComponentRegistrationServiceImpl.this.localComponentInitializationCompleteLatch.countDown();
                    LocalComponentRegistrationServiceImpl.this.log.debug((Object)"Local component initialization complete");
                }
            }
        }, 50L);
    }

    @Reference
    protected void bindUserComponentIdMappingService(UserComponentIdMappingService newInstance) {
        this.userComponentIdMappingService = newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference
    protected void bindAuthorizationService(AuthorizationService newInstance) {
        this.authorizationService = newInstance;
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            this.permissionSetLocalOnly = this.authorizationService.getDefaultAuthorizationObjects().permissionSetLocalOnly();
        }
    }

    @Reference
    protected void bindPermissionStorage(ComponentPermissionStorage newInstance) {
        this.permissionStorage = newInstance;
    }

    @Reference
    protected void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService newInstance) {
        this.componentDistributor = newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthorizationPermissionSet getComponentPermissionSet(ComponentAuthorizationSelector selector, boolean replaceNullResult) {
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            AuthorizationPermissionSet permissionSet = this.nonLocalPermissionSetsBySelector.get(selector);
            if (permissionSet != null) {
                return permissionSet;
            }
            if (replaceNullResult) {
                return this.permissionSetLocalOnly;
            }
            return null;
        }
    }

    @Override
    public ComponentAuthorizationSelector getComponentSelector(String internalId) {
        String externalId;
        try {
            externalId = this.userComponentIdMappingService.fromInternalToExternalId(internalId);
        }
        catch (OperationFailureException e) {
            this.log.error((Object)("Failed to generate external id from internal id " + internalId + "; falling back to " + ERROR_PLACEHOLDER_EXTERNAL_ID + " placeholder (as this should never happen)"), (Throwable)e);
            externalId = ERROR_PLACEHOLDER_EXTERNAL_ID;
        }
        return new ComponentAuthorizationSelectorImpl(externalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentAuthorizationSelector getComponentSelector(ComponentInstallation component) {
        String externalId;
        String internalId = component.getComponentInterface().getIdentifier();
        try {
            externalId = this.userComponentIdMappingService.fromInternalToExternalId(internalId);
        }
        catch (OperationFailureException e) {
            this.log.error((Object)("Failed to generate external id from internal id " + internalId + "; falling back to " + ERROR_PLACEHOLDER_EXTERNAL_ID + " placeholder (as this should never happen)"), (Throwable)e);
            externalId = ERROR_PLACEHOLDER_EXTERNAL_ID;
        }
        Map<String, String> map = this.associatedSelectorDisplayNames;
        synchronized (map) {
            this.associatedSelectorDisplayNames.put(externalId, component.getComponentInterface().getDisplayName());
        }
        return new ComponentAuthorizationSelectorImpl(externalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AuthorizationAccessGroup> listAvailableAuthorizationAccessGroups() {
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            return this.availableAccessGroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NamedComponentAuthorizationSelector> listAuthorizationSelectorsForRemotableComponents() {
        Set<ComponentAuthorizationSelector> selectors;
        ArrayList<NamedComponentAuthorizationSelector> result = new ArrayList<NamedComponentAuthorizationSelector>();
        Map<String, String> map = this.installationsAndPermissionsLock;
        synchronized (map) {
            selectors = this.remotableCompEntriesByAuthorizationSelector.keySet();
        }
        map = this.associatedSelectorDisplayNames;
        synchronized (map) {
            for (ComponentAuthorizationSelector selector : selectors) {
                String associatedName = this.associatedSelectorDisplayNames.get(selector.getId());
                if (associatedName == null) {
                    associatedName = "<" + selector.getId() + ">";
                }
                result.add(new NamedComponentAuthorizationSelectorImpl(selector.getId(), associatedName));
            }
        }
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NamedComponentAuthorizationSelector> listAuthorizationSelectorsForRemotableComponentsIncludingOrphans() {
        HashSet<ComponentAuthorizationSelector> selectors = new HashSet<ComponentAuthorizationSelector>();
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            selectors.addAll(this.remotableCompEntriesByAuthorizationSelector.keySet());
            selectors.addAll(this.nonLocalPermissionSetsBySelector.keySet());
        }
        ArrayList<NamedComponentAuthorizationSelector> result = new ArrayList<NamedComponentAuthorizationSelector>();
        Map<String, String> map = this.associatedSelectorDisplayNames;
        synchronized (map) {
            for (ComponentAuthorizationSelector selector : selectors) {
                String displayName = this.associatedSelectorDisplayNames.containsKey(selector.getId()) ? this.associatedSelectorDisplayNames.get(selector.getId()) : selector.getId();
                result.add(new NamedComponentAuthorizationSelectorImpl(selector.getId(), displayName));
            }
        }
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NamedComponentAuthorizationSelector> listAuthorizationSelectorsForAccessGroup(AuthorizationAccessGroup accessGroup, boolean includeOrphanedSelectors) {
        Set<ComponentAuthorizationSelector> selectors;
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            selectors = includeOrphanedSelectors ? this.nonLocalPermissionSetsBySelector.keySet() : this.remotableCompEntriesByAuthorizationSelector.keySet();
        }
        Set selectorsForAccessGroup = selectors.stream().filter(selector -> this.getComponentPermissionSet((ComponentAuthorizationSelector)selector, true).includesAccessGroup(accessGroup)).collect(Collectors.toSet());
        ArrayList<NamedComponentAuthorizationSelector> result = new ArrayList<NamedComponentAuthorizationSelector>();
        Map<String, String> map = this.associatedSelectorDisplayNames;
        synchronized (map) {
            for (ComponentAuthorizationSelector selector2 : selectorsForAccessGroup) {
                String displayName = this.associatedSelectorDisplayNames.containsKey(selector2.getId()) ? this.associatedSelectorDisplayNames.get(selector2.getId()) : selector2.getId();
                result.add(new NamedComponentAuthorizationSelectorImpl(selector2.getId(), displayName));
            }
        }
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ComponentAuthorizationSelector, AuthorizationPermissionSet> listAssignedComponentPermissions() {
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            TreeMap<ComponentAuthorizationSelector, AuthorizationPermissionSet> result = new TreeMap<ComponentAuthorizationSelector, AuthorizationPermissionSet>(new Comparator<ComponentAuthorizationSelector>(){

                @Override
                public int compare(ComponentAuthorizationSelector o1, ComponentAuthorizationSelector o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            });
            result.putAll(this.nonLocalPermissionSetsBySelector);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComponentPermissions(ComponentAuthorizationSelector selector, AuthorizationPermissionSet newPermissionSet) {
        boolean permissionsChanged;
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            permissionsChanged = this.updatePermissionSet(selector, newPermissionSet);
            if (permissionsChanged) {
                this.updatePermissionSetsOfRegisteredComponents(selector, newPermissionSet);
                this.updatePublicationEntriesForLocalComponents();
            } else {
                this.log.debug((Object)("No change in effective permissions for component selector \"" + selector + "\"; not updating component pool"));
            }
        }
        if (permissionsChanged) {
            this.notifyChangeListenersAsync(false, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComponentPermissionState(ComponentAuthorizationSelector selector, AuthorizationAccessGroup accessGroup, boolean newState) {
        AuthorizationPermissionSet modifiedPermissionSet = null;
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            AuthorizationPermissionSet existingPermissionSet = this.getComponentPermissionSet(selector, true);
            if (this.authorizationService.isPublicAccessGroup(accessGroup)) {
                if (newState && !existingPermissionSet.isPublic()) {
                    modifiedPermissionSet = this.authorizationService.getDefaultAuthorizationObjects().permissionSetPublicInLocalNetwork();
                } else if (!newState && !existingPermissionSet.isLocalOnly()) {
                    modifiedPermissionSet = this.authorizationService.getDefaultAuthorizationObjects().permissionSetLocalOnly();
                }
            } else if (newState && !existingPermissionSet.includesAccessGroup(accessGroup)) {
                if (existingPermissionSet.isPublic()) {
                    this.log.info((Object)StringUtils.format((String)"Ignored request to add group permission %s to component selector %s as it is already set to public access", (Object[])new Object[]{accessGroup, selector}));
                } else {
                    ArrayList<AuthorizationAccessGroup> newGroups = new ArrayList<AuthorizationAccessGroup>(existingPermissionSet.getAccessGroups());
                    newGroups.add(accessGroup);
                    modifiedPermissionSet = this.authorizationService.buildPermissionSet(newGroups);
                    this.log.debug((Object)StringUtils.format((String)"Adding access group %s to the permission set of component selector %s; new list of permissions: %s", (Object[])new Object[]{accessGroup.getFullId(), selector.getId(), modifiedPermissionSet.getSignature()}));
                }
            } else if (!newState && existingPermissionSet.includesAccessGroup(accessGroup)) {
                if (existingPermissionSet.isPublic()) {
                    this.log.error((Object)StringUtils.format((String)"Ignoring attempt to remove group permission %s from component selector %s which is set to public access; the result of this operation would be undefined. Setting the new access to \"local\" for safety.", (Object[])new Object[]{accessGroup, selector}));
                    modifiedPermissionSet = this.authorizationService.getDefaultAuthorizationObjects().permissionSetLocalOnly();
                } else {
                    ArrayList newGroups = new ArrayList(existingPermissionSet.getAccessGroups());
                    newGroups.remove(accessGroup);
                    modifiedPermissionSet = this.authorizationService.buildPermissionSet(newGroups);
                    this.log.debug((Object)StringUtils.format((String)"Removing access group %s from the permission set of component selector %s; new list of permissions: %s", (Object[])new Object[]{accessGroup.getFullId(), selector.getId(), modifiedPermissionSet.getSignature()}));
                }
            }
            if (modifiedPermissionSet != null) {
                if (!this.updatePermissionSet(selector, modifiedPermissionSet)) {
                    this.log.error((Object)"Unexpected state: modifying a single permission entry did not result in an overall permission change?");
                }
                this.updatePermissionSetsOfRegisteredComponents(selector, modifiedPermissionSet);
                this.updatePublicationEntriesForLocalComponents();
            }
        }
        if (modifiedPermissionSet != null) {
            this.notifyChangeListenersAsync(false, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restrictComponentPermissionsToIntersectionWith(ComponentAuthorizationSelector selector, AuthorizationPermissionSet maximumPermissionSet) {
        boolean permissionsChanged;
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            AuthorizationPermissionSet oldPermissionSet = this.nonLocalPermissionSetsBySelector.get(selector);
            AuthorizationPermissionSet newPermissionSet = oldPermissionSet == null ? this.permissionSetLocalOnly : oldPermissionSet.intersectWith(maximumPermissionSet);
            permissionsChanged = this.updatePermissionSet(selector, newPermissionSet);
            if (permissionsChanged) {
                this.updatePermissionSetsOfRegisteredComponents(selector, newPermissionSet);
                this.updatePublicationEntriesForLocalComponents();
            }
        }
        if (permissionsChanged) {
            this.notifyChangeListenersAsync(false, false, true);
        }
    }

    @Override
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, unbind="removePermissionMatrixChangeListener")
    public void addPermissionMatrixChangeListener(PermissionMatrixChangeListener listener) {
        this.permissionMatrixChangesCallbackManager.addListener((Object)listener);
    }

    @Override
    public void removePermissionMatrixChangeListener(PermissionMatrixChangeListener listener) {
        this.permissionMatrixChangesCallbackManager.removeListener((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAvailableAuthorizationAccessGroupsChanged(List<AuthorizationAccessGroup> accessGroups) {
        boolean assignmentsChanged = false;
        Object object = this.installationsAndPermissionsLock;
        synchronized (object) {
            this.availableAccessGroups = accessGroups;
            HashMap<ComponentAuthorizationSelector, AuthorizationPermissionSet> stableIterationCopy = new HashMap<ComponentAuthorizationSelector, AuthorizationPermissionSet>(this.nonLocalPermissionSetsBySelector);
            for (Map.Entry entry : stableIterationCopy.entrySet()) {
                AuthorizationPermissionSet permSet = (AuthorizationPermissionSet)entry.getValue();
                if (permSet.isPublic()) continue;
                Collection originalAccessGroups = permSet.getAccessGroups();
                HashSet filteredAccessGroups = new HashSet(originalAccessGroups);
                filteredAccessGroups.retainAll(this.availableAccessGroups);
                if (originalAccessGroups.size() == filteredAccessGroups.size()) continue;
                ComponentAuthorizationSelector componentSelector = (ComponentAuthorizationSelector)entry.getKey();
                AuthorizationPermissionSet newPermissionSet = this.authorizationService.buildPermissionSet(filteredAccessGroups);
                this.updatePermissionSet(componentSelector, newPermissionSet);
                this.log.debug((Object)("Reduced permission set for component selector " + componentSelector + " from " + originalAccessGroups + " to " + filteredAccessGroups + " after available access groups have changed"));
                this.updatePermissionSetsOfRegisteredComponents(componentSelector, newPermissionSet);
                assignmentsChanged = true;
            }
            if (assignmentsChanged) {
                this.updatePublicationEntriesForLocalComponents();
            }
        }
        this.notifyChangeListenersAsync(true, false, assignmentsChanged);
    }

    private void updatePublicationEntriesForLocalComponents() {
        this.componentDistributor.updateLocalComponentInstallations(this.componentEntriesByInstallationId.values(), this.startupPublishDelayExceeded);
    }

    private boolean updatePermissionSet(ComponentAuthorizationSelector selector, AuthorizationPermissionSet newPermissionSet) {
        boolean modified;
        AuthorizationPermissionSet oldPermissionSet;
        if (newPermissionSet == null || newPermissionSet.isLocalOnly()) {
            newPermissionSet = this.permissionSetLocalOnly;
            oldPermissionSet = this.nonLocalPermissionSetsBySelector.remove(selector);
        } else {
            oldPermissionSet = this.nonLocalPermissionSetsBySelector.put(selector, newPermissionSet);
        }
        if (oldPermissionSet == newPermissionSet) {
            return false;
        }
        if (oldPermissionSet == null) {
            oldPermissionSet = this.permissionSetLocalOnly;
        }
        boolean bl = modified = !oldPermissionSet.equals(newPermissionSet);
        if (modified && !this.initializing) {
            try {
                this.permissionStorage.persistAssignment(selector, newPermissionSet);
            }
            catch (OperationFailureException e) {
                this.log.error((Object)("Error saving component authorization change: " + e.toString()));
            }
        }
        return modified;
    }

    private void addRemotableComponentToAuthorizationTracking(DistributedComponentEntryImpl newEntry, ComponentAuthorizationSelector authSelector) {
        if (newEntry.getComponentInterface().getLocalExecutionOnly()) {
            this.log.warn((Object)("Ignoring request to add local-only component " + newEntry.getComponentInstallation().getInstallationId() + " to authorization tracking; this should be filtered earlier in the call chain"));
            return;
        }
        Collection<DistributedComponentEntry> entrySet = this.remotableCompEntriesByAuthorizationSelector.get(authSelector);
        if (entrySet == null) {
            entrySet = new ArrayList<DistributedComponentEntry>(2);
            this.remotableCompEntriesByAuthorizationSelector.put(authSelector, entrySet);
        }
        entrySet.add(newEntry);
    }

    private void removeComponentFromAuthorizationTracking(DistributedComponentEntry removedCompEntry, ComponentAuthorizationSelector authSelector) {
        if (removedCompEntry.getComponentInterface().getLocalExecutionOnly()) {
            this.log.warn((Object)("Ignoring request to remove local-only component " + removedCompEntry.getComponentInstallation().getInstallationId() + " from authorization tracking; this should be filtered earlier in the call chain"));
            return;
        }
        Collection<DistributedComponentEntry> entrySet = this.remotableCompEntriesByAuthorizationSelector.get(authSelector);
        if (!entrySet.remove(removedCompEntry)) {
            throw new IllegalStateException("Unregistered local component " + removedCompEntry.getComponentInstallation().getInstallationId() + ", but it was not present in the authorization map");
        }
        if (entrySet.isEmpty()) {
            this.remotableCompEntriesByAuthorizationSelector.remove(authSelector);
        }
    }

    private void updatePermissionSetsOfRegisteredComponents(ComponentAuthorizationSelector authSelector, AuthorizationPermissionSet newPermissionSet) {
        Collection<DistributedComponentEntry> oldEntries = this.remotableCompEntriesByAuthorizationSelector.get(authSelector);
        if (oldEntries == null || oldEntries.isEmpty()) {
            return;
        }
        ArrayList<DistributedComponentEntryImpl> newEntries = new ArrayList<DistributedComponentEntryImpl>(oldEntries.size());
        for (DistributedComponentEntry old : oldEntries) {
            ComponentInstallation componentInstallation = old.getComponentInstallation();
            if (!newPermissionSet.isLocalOnly() && componentInstallation.getComponentInterface().getLocalExecutionOnly()) {
                this.log.warn((Object)("Setting non-local permissions for local-only component " + componentInstallation.getInstallationId() + "; this will be shown on the local node, but the component will not be actually published"));
            }
            DistributedComponentEntryImpl newEntry = ComponentDataConverter.createLocalDistributedComponentEntry(componentInstallation, newPermissionSet, this.authorizationService);
            newEntries.add(newEntry);
            this.componentEntriesByInstallationId.put(componentInstallation.getInstallationId(), newEntry);
        }
        this.remotableCompEntriesByAuthorizationSelector.put(authSelector, newEntries);
    }

    private void notifyChangeListenersAsync(final boolean accessGroupsChanged, final boolean componentSelectorsChanged, final boolean assignmentsChanged) {
        this.log.debug((Object)StringUtils.format((String)"Notifying %d listener(s) of a permission matrix change: AGC=%s, CSC=%s, AC=%s", (Object[])new Object[]{this.permissionMatrixChangesCallbackManager.getListenerCount(), accessGroupsChanged, componentSelectorsChanged, assignmentsChanged}));
        this.permissionMatrixChangesCallbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<PermissionMatrixChangeListener>(){

            public void performCallback(PermissionMatrixChangeListener listener) {
                listener.onPermissionMatrixChanged(accessGroupsChanged, componentSelectorsChanged, assignmentsChanged);
            }
        });
    }
}

