/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.management.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroupKeyData;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.authorization.cryptography.api.CryptographyOperationsProvider;
import de.rcenvironment.core.authorization.cryptography.api.SymmetricKey;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.management.internal.ComponentPublicationException;
import de.rcenvironment.core.component.management.internal.DistributedComponentEntryImpl;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.impl.ComponentInstallationImpl;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public final class ComponentDataConverter {
    private static final ObjectMapper sharedJsonMapper = JsonUtils.getDefaultObjectMapper();

    private ComponentDataConverter() {
    }

    public static String serializeComponentInstallationData(ComponentInstallation ci) {
        try {
            return sharedJsonMapper.writeValueAsString((Object)ci);
        }
        catch (IOException e) {
            throw new ComponentPublicationException("Error serializing component descriptor", e);
        }
    }

    public static ComponentInstallation deserializeComponentInstallationData(String jsonData) throws OperationFailureException {
        try {
            return (ComponentInstallation)sharedJsonMapper.readValue(jsonData, ComponentInstallationImpl.class);
        }
        catch (IOException e) {
            throw new OperationFailureException("Error deserializing component descriptor from JSON data: " + jsonData, (Throwable)e);
        }
    }

    public static DistributedComponentEntryImpl createLocalDistributedComponentEntry(ComponentInstallation componentInstallation, AuthorizationPermissionSet permissionSet, AuthorizationService authorizationService) {
        if (permissionSet == null || permissionSet.isLocalOnly()) {
            return new DistributedComponentEntryImpl(componentInstallation.getComponentInterface().getDisplayName(), componentInstallation, permissionSet, permissionSet, false, null);
        }
        try {
            ComponentEntryTransferObject transferObject;
            String rawComponentData = ComponentDataConverter.serializeComponentInstallationData(componentInstallation);
            if (permissionSet.isPublic()) {
                transferObject = new ComponentEntryTransferObject(ComponentDataConverter.serializeComponentInstallationData(componentInstallation), null);
            } else {
                CryptographyOperationsProvider cryptographyOperations = authorizationService.getCryptographyOperationsProvider();
                SymmetricKey componentDataEncryptionKey = cryptographyOperations.generateSymmetricKey();
                String encryptedComponentData = cryptographyOperations.encryptAndEncodeString(componentDataEncryptionKey, rawComponentData);
                HashMap<String, String> authKeys = new HashMap<String, String>();
                for (AuthorizationAccessGroup group : permissionSet.getAccessGroups()) {
                    AuthorizationAccessGroupKeyData keyDataForGroup = authorizationService.getKeyDataForGroup(group);
                    if (keyDataForGroup == null) {
                        LogFactory.getLog(ComponentDataConverter.class).warn((Object)("Found no key data for assigned access group " + group.getFullId() + " when creating publication data for " + componentInstallation.getInstallationId() + "; skipping group"));
                        continue;
                    }
                    SymmetricKey groupKey = keyDataForGroup.getSymmetricKey();
                    authKeys.put(group.getFullId(), cryptographyOperations.encryptAndEncodeString(groupKey, componentDataEncryptionKey.getEncodedForm()));
                }
                transferObject = new ComponentEntryTransferObject(encryptedComponentData, authKeys);
            }
            String serializedForm = sharedJsonMapper.writeValueAsString((Object)transferObject);
            return new DistributedComponentEntryImpl(componentInstallation.getComponentInterface().getDisplayName(), componentInstallation, permissionSet, permissionSet, false, serializedForm);
        }
        catch (OperationFailureException | IOException e) {
            throw new ComponentPublicationException("Error serializing component descriptor", e);
        }
    }

    public static DistributedComponentEntry deserializeRemoteDistributedComponentEntry(String jsonData, AuthorizationService authorizationService) throws OperationFailureException {
        String displayName;
        ComponentInstallation componentInstallation;
        AuthorizationPermissionSet matchingPermissionSet;
        AuthorizationPermissionSet declaredPermissionSet;
        ComponentEntryTransferObject transferObject;
        try {
            transferObject = (ComponentEntryTransferObject)sharedJsonMapper.readValue(jsonData, ComponentEntryTransferObject.class);
        }
        catch (IOException e) {
            throw new OperationFailureException("Error deserializing component entry from JSON data: " + jsonData, (Throwable)e);
        }
        Map<String, String> authKeys = transferObject.getAuthData();
        if (authKeys == null) {
            matchingPermissionSet = declaredPermissionSet = authorizationService.getDefaultAuthorizationObjects().permissionSetPublicInLocalNetwork();
            componentInstallation = ComponentDataConverter.deserializeComponentInstallationData(transferObject.getData());
            displayName = componentInstallation.getComponentInterface().getDisplayName();
        } else {
            ArrayList<AuthorizationAccessGroup> declaredGroups = new ArrayList<AuthorizationAccessGroup>(authKeys.size());
            ArrayList<AuthorizationAccessGroup> matchingGroups = new ArrayList<AuthorizationAccessGroup>(authKeys.size());
            String authMapValueForFirstMatchingGroup = null;
            for (Map.Entry<String, String> authEntry : authKeys.entrySet()) {
                AuthorizationAccessGroup remoteGroup = authorizationService.representRemoteGroupId(authEntry.getKey());
                declaredGroups.add(remoteGroup);
                if (!authorizationService.isGroupAccessible(remoteGroup)) continue;
                matchingGroups.add(remoteGroup);
                if (authMapValueForFirstMatchingGroup != null) continue;
                authMapValueForFirstMatchingGroup = authEntry.getValue();
            }
            declaredPermissionSet = authorizationService.buildPermissionSet(declaredGroups);
            matchingPermissionSet = authorizationService.buildPermissionSet(matchingGroups);
            if (!matchingPermissionSet.isLocalOnly()) {
                CryptographyOperationsProvider cryptographyOperations = authorizationService.getCryptographyOperationsProvider();
                AuthorizationAccessGroup groupForDecryption = (AuthorizationAccessGroup)matchingGroups.get(0);
                SymmetricKey groupKey = authorizationService.getKeyDataForGroup(groupForDecryption).getSymmetricKey();
                SymmetricKey componentDataKey = cryptographyOperations.decodeSymmetricKey(cryptographyOperations.decodeAndDecryptString(groupKey, authMapValueForFirstMatchingGroup));
                String decryptedComponentData = cryptographyOperations.decodeAndDecryptString(componentDataKey, transferObject.getData());
                componentInstallation = ComponentDataConverter.deserializeComponentInstallationData(decryptedComponentData);
                displayName = componentInstallation.getComponentInterface().getDisplayName();
            } else {
                componentInstallation = null;
                displayName = "Inaccessible component";
            }
        }
        return new DistributedComponentEntryImpl(displayName, componentInstallation, declaredPermissionSet, matchingPermissionSet, true, null);
    }

    public static class ComponentEntryTransferObject {
        private Map<String, String> authData;
        private String data;

        public ComponentEntryTransferObject() {
        }

        ComponentEntryTransferObject(String data, Map<String, String> authKeys) {
            this.authData = authKeys;
            this.data = data;
        }

        public Map<String, String> getAuthData() {
            return this.authData;
        }

        public void setAuthData(Map<String, String> authKeys) {
            this.authData = authKeys;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}

