/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.eventlog.internal.impl;

import de.rcenvironment.core.eventlog.ComponentEventLogger;
import de.rcenvironment.core.eventlog.EventLogger;
import de.rcenvironment.core.eventlog.WorkflowEventLogger;
import de.rcenvironment.core.eventlog.internal.EventLogContext;
import de.rcenvironment.core.eventlog.internal.EventLogMessageType;
import de.rcenvironment.core.eventlog.internal.EventLogService;
import de.rcenvironment.core.eventlog.internal.impl.EventLogMessage;
import de.rcenvironment.core.eventlog.internal.impl.EventLogServiceForwardToACLImpl;

public class EventLoggerImpl
implements EventLogger,
WorkflowEventLogger,
ComponentEventLogger {
    private static EventLogService eventLogService = new EventLogServiceForwardToACLImpl();
    private EventLogContext context;
    private String sourceId;
    private String workflowId;
    private String componentId;

    public EventLoggerImpl(EventLogContext context, Class<?> clazz, String workflowId, String componentId) {
        this.context = context;
        this.sourceId = clazz.getName();
        this.workflowId = workflowId;
        this.componentId = componentId;
    }

    @Override
    public void error(boolean localized, String message, Object ... parameters) {
        this.error(null, localized, message, parameters);
    }

    @Override
    public void error(Throwable detailInformation, boolean localized, String message, Object ... parameters) {
        this.createMessage(EventLogMessageType.ERROR, detailInformation, localized, message, parameters);
    }

    @Override
    public void warn(boolean localized, String message, Object ... parameters) {
        this.warn(null, localized, message, parameters);
    }

    @Override
    public void warn(Throwable detailInformation, boolean localized, String message, Object ... parameters) {
        this.createMessage(EventLogMessageType.WARNING, detailInformation, localized, message, parameters);
    }

    @Override
    public void info(boolean localized, String message, Object ... parameters) {
        this.createMessage(EventLogMessageType.INFO, null, localized, message, parameters);
    }

    @Override
    public void debug(String message, Object ... parameters) {
        this.debug(null, message, parameters);
    }

    @Override
    public void debug(Throwable detailInformation, String message, Object ... parameters) {
        this.createMessage(EventLogMessageType.DEBUG_DEFAULT, detailInformation, false, message, parameters);
    }

    @Override
    public void debugVerbose(String message, Object ... parameters) {
        this.debugVerbose(null, message, parameters);
    }

    @Override
    public void debugVerbose(Throwable detailInformation, String message, Object ... parameters) {
        this.createMessage(EventLogMessageType.DEBUG_VERBOSE, detailInformation, false, message, parameters);
    }

    @Override
    public boolean isDebugVerboseEnabled() {
        return true;
    }

    @Override
    public void stateChanged(Object oldState, Object newState) {
    }

    @Override
    public void stdout(String line) {
        this.createMessage(EventLogMessageType.STDOUT, null, false, line, new Object[0]);
    }

    @Override
    public void stderr(String line) {
        this.createMessage(EventLogMessageType.STDERR, null, false, line, new Object[0]);
    }

    private void createMessage(EventLogMessageType messageType, Throwable detailInformation, boolean localized, String message, Object ... parameters) {
        EventLogMessage messageObject = new EventLogMessage();
        messageObject.setContext(this.context);
        messageObject.setSourceId(this.sourceId);
        messageObject.setWorkflowId(this.workflowId);
        messageObject.setComponentId(this.componentId);
        messageObject.setMessageType(messageType);
        messageObject.setDetailInformation(detailInformation);
        messageObject.setLocalized(localized);
        messageObject.setMessage(message);
        messageObject.setParameters(parameters);
        eventLogService.dispatchMessage(messageObject);
    }
}

