/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.legacy.internal;

import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.Assertions;

public final class NetworkUtils {
    private static final String ERROR_PARAMETERS_NULL = "The parameter \"%s\" must not be null.";
    private static final String IPV4_REGEX = "[0-9][0-9]?[0-9]?\\.[0-9][0-9]?[0-9]?\\.[0-9][0-9]?[0-9]?\\.[0-9][0-9]?[0-9]?";

    private NetworkUtils() {
    }

    public static boolean isHostInNetwork(String hostname, String network) {
        Assertions.isDefined((Object)hostname, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"hostname"}));
        Assertions.isDefined((Object)network, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"network"}));
        boolean returnCode = true;
        if (hostname.equals(network)) {
            returnCode = true;
        } else if (!hostname.matches(IPV4_REGEX)) {
            returnCode = false;
        } else if (!network.matches("[0-9][0-9]?[0-9]?\\.[0-9][0-9]?[0-9]?\\.[0-9][0-9]?[0-9]?\\.[0-9][0-9]?[0-9]?/[0-9][0-9]?")) {
            returnCode = false;
        } else {
            String[] splittedNetwork = network.split("/");
            splittedNetwork[1] = NetworkUtils.convertFromCidrToNetmask(splittedNetwork[1]);
            byte[] addressToTest = NetworkUtils.addressToByte(hostname);
            byte[] subnet = NetworkUtils.addressToByte(splittedNetwork[0]);
            byte[] mask = NetworkUtils.addressToByte(splittedNetwork[1]);
            byte[] addressSubnet = new byte[addressToTest.length];
            int i = 0;
            while (i < addressToTest.length) {
                addressSubnet[i] = new Integer(addressToTest[i] & mask[i]).byteValue();
                ++i;
            }
            i = 0;
            while (i < mask.length) {
                if (subnet[i] != addressSubnet[i]) {
                    returnCode = false;
                    break;
                }
                ++i;
            }
        }
        return returnCode;
    }

    public static byte[] addressToByte(String address) {
        Assertions.isDefined((Object)address, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"address"}));
        if (!address.matches(IPV4_REGEX)) {
            throw new IllegalArgumentException("Wrong format of the address: " + address);
        }
        String[] parts = address.split("\\.");
        byte[] byteAddress = new byte[parts.length];
        int i = 0;
        while (i < parts.length) {
            byteAddress[i] = new Integer(parts[i]).byteValue();
            ++i;
        }
        return byteAddress;
    }

    public static String convertFromCidrToNetmask(String cidr) {
        Assertions.isDefined((Object)cidr, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"cidr"}));
        Integer cidrInt = null;
        try {
            cidrInt = new Integer(cidr);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid cidr notation: " + cidr);
        }
        if (cidrInt < 0 || cidrInt > 32) {
            throw new IllegalArgumentException("Invalid cidr notation: " + cidr);
        }
        String[] netmaskParts = new String[4];
        int i = 0;
        while (i < netmaskParts.length) {
            netmaskParts[i] = "";
            ++i;
        }
        i = 0;
        while (i < 32) {
            if (i < cidrInt) {
                int n = i / 8;
                netmaskParts[n] = String.valueOf(netmaskParts[n]) + "1";
            } else {
                int n = i / 8;
                netmaskParts[n] = String.valueOf(netmaskParts[n]) + "0";
            }
            ++i;
        }
        String netmask = "";
        int i2 = 0;
        while (i2 < netmaskParts.length) {
            netmask = String.valueOf(netmask) + Integer.parseInt(netmaskParts[i2], 2);
            if (i2 < netmaskParts.length - 1) {
                netmask = String.valueOf(netmask) + ".";
            }
            ++i2;
        }
        return netmask;
    }
}

