/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import com.jcraft.jsch.Session;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.When;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListener;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListenerAdapter;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionSetup;
import de.rcenvironment.core.communication.sshconnection.impl.SshConnectionSetupImpl;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.core.utils.executor.testutils.IntegrationTestExecutorUtils;
import de.rcenvironment.core.utils.ssh.jsch.executor.JSchRCECommandLineExecutor;
import de.rcenvironment.extras.testscriptrunner.common.ShutdownHooks;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.CommonStateAndSteps;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;

public class SshCommandExecutionDefinitions {
    private static SshConnectionSetupImpl currentConnection;
    private Boolean connectResult;
    private final Log log = LogFactory.getLog(this.getClass());

    @Given(value="^a SSH connection to ([^ ,]+)(?:,| on)? port ([^ ]+) with (?:default login|login \"([^\"]*)\" and password \"([^\"]*)\")$")
    public void connectToSshPort(String host, String portString, String loginName, String loginPassphrase) {
        if (loginName == null && loginPassphrase == null) {
            loginName = "test";
            loginPassphrase = "test";
        }
        int port = Integer.parseInt(portString);
        if (currentConnection != null && currentConnection.isConnected()) {
            this.log.info((Object)"Reusing established SSH connection");
            return;
        }
        this.log.info((Object)StringUtils.format((String)"Opening SSH connection to %s@%s:%d", (Object[])new Object[]{loginName, host, port}));
        currentConnection = new SshConnectionSetupImpl("default", "", host, port, loginName, null, false, false, false, false, (SshConnectionListener)new SshConnectionListenerAdapter(){

            public void onConnected(SshConnectionSetup setup) {
                SshCommandExecutionDefinitions.this.connectResult = true;
            }

            public void onConnectionAttemptFailed(SshConnectionSetup setup, String reason, boolean firstConsecutiveFailure, boolean willAutoRetry) {
                SshCommandExecutionDefinitions.this.log.error((Object)("Failed to open SSH connection: " + reason));
                SshCommandExecutionDefinitions.this.connectResult = false;
            }
        });
        Session session = currentConnection.connect(loginPassphrase);
        Objects.requireNonNull(this.connectResult, "Unknown connection result");
        if (!this.connectResult.booleanValue()) {
            throw new AssertionError((Object)"Failed to connect");
        }
        Objects.requireNonNull(session, "Null session");
        ShutdownHooks.register("teardownSshConnections", new Runnable(){

            @Override
            public void run() {
                if (currentConnection != null && currentConnection.isConnected()) {
                    SshCommandExecutionDefinitions.this.log.info((Object)"Closing SSH connections");
                    currentConnection.disconnect();
                    currentConnection = null;
                }
            }
        });
    }

    @When(value="^executing the command \"(.+)\"(?: \\(expecting \"([^\"]+)\"\\))?$")
    public void executeAndWait(String command, String expectedResponse) throws Throwable {
        this.log.info((Object)StringUtils.format((String)"Executing SSH command \"%s\"", (Object[])new Object[]{command}));
        Session session = currentConnection.getSession();
        Objects.requireNonNull(session, "Session is <null>");
        JSchRCECommandLineExecutor executor = new JSchRCECommandLineExecutor(session);
        executor.start(command);
        CapturingTextOutReceiver stdoutCapture = new CapturingTextOutReceiver();
        CapturingTextOutReceiver stderrCapture = new CapturingTextOutReceiver();
        TextStreamWatcher stdoutWatcher = new TextStreamWatcher(executor.getStdout(), ConcurrencyUtils.getAsyncTaskService(), new TextOutputReceiver[]{stdoutCapture}).start();
        TextStreamWatcher stderrWatcher = new TextStreamWatcher(executor.getStderr(), ConcurrencyUtils.getAsyncTaskService(), new TextOutputReceiver[]{stderrCapture}).start();
        int exitCode = executor.waitForTermination();
        stdoutWatcher.waitForTermination();
        stderrWatcher.waitForTermination();
        IntegrationTestExecutorUtils.ExecutionResult executionResult = new IntegrationTestExecutorUtils.ExecutionResult(exitCode, stdoutCapture.getBufferedOutput(), stderrCapture.getBufferedOutput());
        if (executionResult.stderr.length() != 0 || executionResult.stderrLines.size() != 0) {
            Assert.fail((String)"Unexpected state: received StdErr output when executing a SSH command");
        }
        this.log.info((Object)StringUtils.format((String)"Output for SSH command \"%s\" (%d lines):\n%s", (Object[])new Object[]{command, executionResult.stdoutLines.size(), executionResult.stdout}));
        CommonStateAndSteps.getCurrent().setCurrentExecutionResult(executionResult);
        this.log.debug((Object)("Execution of SSH command \"" + command + "\" finished"));
        if (expectedResponse != null && !expectedResponse.isEmpty()) {
            this.log.info((Object)("Expecting response: " + expectedResponse));
            CommonStateAndSteps.getCurrent().assertSelectedOutputContains("", "should", expectedResponse);
        }
    }
}

