/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.inputprovider.execution.validator;

import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractComponentValidator;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class InputProviderComponentValidator
extends AbstractComponentValidator {
    public String getIdentifier() {
        return "de.rcenvironment.inputprovider";
    }

    protected List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        this.validateExistingEndpoints(componentDescription, messages, DataType.FileReference);
        this.validateExistingEndpoints(componentDescription, messages, DataType.DirectoryReference);
        return messages;
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }

    private void validateExistingEndpoints(ComponentDescription componentDescription, List<ComponentValidationMessage> messages, DataType dataType) {
        Set outputs = this.getOutputs(componentDescription, dataType);
        for (EndpointDescription outputDescription : outputs) {
            Map metaData = outputDescription.getMetaData();
            String name = (String)metaData.get("startValue");
            Collection<String> values = metaData.values();
            if (dataType.equals((Object)DataType.FileReference)) {
                this.validateExistingFiles(messages, outputDescription.getName(), values, name);
                continue;
            }
            if (!dataType.equals((Object)DataType.DirectoryReference)) continue;
            this.validateExistingDirectories(messages, outputDescription.getName(), values, name);
        }
    }

    private void validateExistingFiles(List<ComponentValidationMessage> messages, String outputName, Collection<String> values, String fileName) {
        if (!values.contains("atWorkflowStart")) {
            if (Paths.get(fileName, new String[0]).isAbsolute()) {
                this.validateFileFromFileSystem(messages, outputName, fileName);
            } else {
                this.validateFileFromProject(messages, outputName, fileName);
            }
        }
    }

    private void validateFileFromProject(List<ComponentValidationMessage> messages, String outputName, String fileName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IResource member = workspaceRoot.findMember(fileName);
        if (member == null || !member.exists()) {
            this.createFileDoesNotExistMessage(messages, outputName, fileName);
        } else if (!(member instanceof IFile)) {
            String text = StringUtils.format((String)"'%s': '%s' is not a file", (Object[])new Object[]{outputName, fileName});
            messages.add(new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "", text, text, true));
        }
    }

    private void validateFileFromFileSystem(List<ComponentValidationMessage> messages, String outputName, String fileName) {
        File newFile = new File(fileName);
        if (!newFile.isFile()) {
            this.createFileDoesNotExistMessage(messages, outputName, fileName);
        }
    }

    private void createFileDoesNotExistMessage(List<ComponentValidationMessage> messages, String outputName, String fileName) {
        String text = StringUtils.format((String)"'%s': missing file '%s'", (Object[])new Object[]{outputName, fileName});
        messages.add(new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "", text, text, true));
    }

    private void validateExistingDirectories(List<ComponentValidationMessage> messages, String outputName, Collection<String> values, String pathName) {
        if (pathName.equals("##RUNTIME_INPUT_DIRECTORY##")) {
            String text = StringUtils.format((String)"'%s': '%s' only valid if used via remote access", (Object[])new Object[]{outputName, pathName});
            messages.add(new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "", text, text, false));
            return;
        }
        if (!values.contains("atWorkflowStart")) {
            if (Paths.get(pathName, new String[0]).isAbsolute()) {
                this.validateDirFromFileSystem(messages, outputName, pathName);
            } else {
                this.validateDirFromProject(messages, outputName, pathName);
            }
        }
    }

    private void validateDirFromProject(List<ComponentValidationMessage> messages, String outputName, String pathName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IResource member = workspaceRoot.findMember(pathName);
        if (member == null || !member.exists()) {
            this.createDirDoesNotExistMessage(messages, outputName, pathName);
        } else if (!(member instanceof IFolder)) {
            String text = StringUtils.format((String)"'%s': '%s' is not a directory", (Object[])new Object[]{outputName, pathName});
            messages.add(new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "", text, text, true));
        }
    }

    private void validateDirFromFileSystem(List<ComponentValidationMessage> messages, String outputName, String pathName) {
        File newFile = new File(pathName);
        if (!newFile.isDirectory()) {
            this.createDirDoesNotExistMessage(messages, outputName, pathName);
        }
    }

    private void createDirDoesNotExistMessage(List<ComponentValidationMessage> messages, String outputName, String pathName) {
        String text = StringUtils.format((String)"'%s': missing directory '%s'", (Object[])new Object[]{outputName, pathName});
        messages.add(new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "", text, text, true));
    }
}

