/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;

public class FileSearchQuery
implements ISearchQuery {
    private final FileTextSearchScope fScope;
    private final String fSearchText;
    private final boolean fIsRegEx;
    private final boolean fIsCaseSensitive;
    private final boolean fIsWholeWord;
    private FileSearchResult fResult;
    private boolean fSearchInBinaries;

    public FileSearchQuery(String searchText, boolean isRegEx, boolean isCaseSensitive, FileTextSearchScope scope) {
        this(searchText, isRegEx, isCaseSensitive, false, false, scope);
    }

    public FileSearchQuery(String searchText, boolean isRegEx, boolean isCaseSensitive, boolean isWholeWord, boolean searchInBinaries, FileTextSearchScope scope) {
        this.fSearchText = searchText;
        this.fIsRegEx = isRegEx;
        this.fIsCaseSensitive = isCaseSensitive;
        this.fIsWholeWord = isWholeWord;
        this.fScope = scope;
        this.fSearchInBinaries = searchInBinaries;
    }

    public FileTextSearchScope getSearchScope() {
        return this.fScope;
    }

    @Override
    public boolean canRunInBackground() {
        return true;
    }

    @Override
    public IStatus run(IProgressMonitor monitor) {
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        Pattern searchPattern = this.getSearchPattern();
        TextSearchResultCollector collector = new TextSearchResultCollector(textResult, this.isFileNameSearch(), this.fSearchInBinaries);
        return TextSearchEngine.create().search(this.fScope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    private boolean isScopeAllFileTypes() {
        String[] fileNamePatterns = this.fScope.getFileNamePatterns();
        if (fileNamePatterns == null) {
            return true;
        }
        String[] stringArray = fileNamePatterns;
        int n = fileNamePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String fileNamePattern = stringArray[n2];
            if ("*".equals(fileNamePattern)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getLabel() {
        return SearchMessages.FileSearchQuery_label;
    }

    public String getSearchString() {
        return this.fSearchText;
    }

    public String getResultLabel(int nMatches) {
        String searchString = this.getSearchString();
        if (searchString.length() > 0) {
            if (this.isScopeAllFileTypes()) {
                if (nMatches == 1) {
                    Object[] args = new Object[]{searchString, this.fScope.getDescription()};
                    return Messages.format(SearchMessages.FileSearchQuery_singularLabel, args);
                }
                Object[] args = new Object[]{searchString, nMatches, this.fScope.getDescription()};
                return Messages.format(SearchMessages.FileSearchQuery_pluralPattern, args);
            }
            if (nMatches == 1) {
                Object[] args = new Object[]{searchString, this.fScope.getDescription(), this.fScope.getFilterDescription()};
                return Messages.format(SearchMessages.FileSearchQuery_singularPatternWithFileExt, args);
            }
            Object[] args = new Object[]{searchString, nMatches, this.fScope.getDescription(), this.fScope.getFilterDescription()};
            return Messages.format(SearchMessages.FileSearchQuery_pluralPatternWithFileExt, args);
        }
        if (nMatches == 1) {
            Object[] args = new Object[]{this.fScope.getFilterDescription(), this.fScope.getDescription()};
            return Messages.format(SearchMessages.FileSearchQuery_singularLabel_fileNameSearch, args);
        }
        Object[] args = new Object[]{this.fScope.getFilterDescription(), nMatches, this.fScope.getDescription()};
        return Messages.format(SearchMessages.FileSearchQuery_pluralPattern_fileNameSearch, args);
    }

    public IStatus searchInFile(AbstractTextSearchResult result, IProgressMonitor monitor, IFile file) {
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope(new IResource[]{file}, new String[]{"*"}, true);
        Pattern searchPattern = this.getSearchPattern();
        TextSearchResultCollector collector = new TextSearchResultCollector(result, this.isFileNameSearch(), this.fSearchInBinaries);
        return TextSearchEngine.create().search(scope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    protected Pattern getSearchPattern() {
        return PatternConstructor.createPattern(this.fSearchText, this.fIsRegEx, true, this.fIsCaseSensitive, this.fIsWholeWord);
    }

    public boolean isFileNameSearch() {
        return this.fSearchText.length() == 0;
    }

    public boolean isRegexSearch() {
        return this.fIsRegEx;
    }

    public boolean isCaseSensitive() {
        return this.fIsCaseSensitive;
    }

    public boolean isWholeWord() {
        return this.fIsWholeWord;
    }

    @Override
    public boolean canRerun() {
        return true;
    }

    @Override
    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new FileSearchResult(this);
            new SearchResultUpdater(this.fResult);
        }
        return this.fResult;
    }

    private static final class TextSearchResultCollector
    extends TextSearchRequestor {
        private final AbstractTextSearchResult fResult;
        private final boolean fIsFileSearchOnly;
        private final boolean fSearchInBinaries;
        private final boolean fIsLightweightAutoRefresh;
        private Map<IFile, ArrayList<FileMatch>> fCachedMatches;
        private Object fLock = new Object();

        private TextSearchResultCollector(AbstractTextSearchResult result, boolean isFileSearchOnly, boolean searchInBinaries) {
            this.fResult = result;
            this.fIsFileSearchOnly = isFileSearchOnly;
            this.fSearchInBinaries = searchInBinaries;
            this.fIsLightweightAutoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.lightweight.enabled", false, null);
        }

        @Override
        public boolean canRunInParallel() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean acceptFile(IFile file) throws CoreException {
            if (this.fIsLightweightAutoRefresh && !file.exists()) {
                return false;
            }
            if (this.fIsFileSearchOnly) {
                Object object = this.fLock;
                synchronized (object) {
                    this.fResult.addMatch(new FileMatch(file));
                }
            }
            this.flushMatches();
            return true;
        }

        @Override
        public boolean reportBinaryFile(IFile file) {
            return this.fSearchInBinaries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) throws CoreException {
            ArrayList<FileMatch> matches;
            Object object = this.fLock;
            synchronized (object) {
                block10: {
                    if (this.fCachedMatches != null) break block10;
                    return false;
                }
                matches = this.fCachedMatches.get(matchRequestor.getFile());
            }
            int matchOffset = matchRequestor.getMatchOffset();
            LineElement lineElement = this.getLineElement(matchOffset, matchRequestor, matches);
            if (lineElement != null) {
                FileMatch fileMatch = new FileMatch(matchRequestor.getFile(), matchOffset, matchRequestor.getMatchLength(), lineElement);
                Object object2 = this.fLock;
                synchronized (object2) {
                    block11: {
                        if (this.fCachedMatches != null) break block11;
                        return false;
                    }
                    matches = this.fCachedMatches.get(matchRequestor.getFile());
                    if (matches == null) {
                        matches = new ArrayList();
                        this.fCachedMatches.put(matchRequestor.getFile(), matches);
                    }
                    matches.add(fileMatch);
                }
            }
            return true;
        }

        private LineElement getLineElement(int offset, TextSearchMatchAccess matchRequestor, ArrayList<FileMatch> matches) {
            int lineNumber = 1;
            int lineStart = 0;
            if (matches != null) {
                FileMatch last = matches.get(matches.size() - 1);
                LineElement lineElement = last.getLineElement();
                if (lineElement.contains(offset)) {
                    return lineElement;
                }
                lineStart = lineElement.getOffset() + lineElement.getLength();
                lineNumber = lineElement.getLine() + 1;
            }
            if (offset < lineStart) {
                return null;
            }
            int i = lineStart;
            int contentLength = matchRequestor.getFileContentLength();
            while (i < contentLength) {
                char ch;
                if ((ch = matchRequestor.getFileContentChar(i++)) != '\n' && ch != '\r') continue;
                if (ch == '\r' && i < contentLength && matchRequestor.getFileContentChar(i) == '\n') {
                    ++i;
                }
                if (offset < i) {
                    String lineContent = TextSearchResultCollector.getContents(matchRequestor, lineStart, i);
                    return new LineElement((IResource)matchRequestor.getFile(), lineNumber, lineStart, lineContent);
                }
                ++lineNumber;
                lineStart = i;
            }
            if (offset < i) {
                String lineContent = TextSearchResultCollector.getContents(matchRequestor, lineStart, i);
                return new LineElement((IResource)matchRequestor.getFile(), lineNumber, lineStart, lineContent);
            }
            return null;
        }

        private static String getContents(TextSearchMatchAccess matchRequestor, int start, int end) {
            StringBuilder buf = new StringBuilder();
            int i = start;
            while (i < end) {
                char ch = matchRequestor.getFileContentChar(i);
                if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
                    buf.append(' ');
                } else {
                    buf.append(ch);
                }
                ++i;
            }
            return buf.toString();
        }

        @Override
        public void beginReporting() {
            this.fCachedMatches = new HashMap<IFile, ArrayList<FileMatch>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endReporting() {
            this.flushMatches();
            Object object = this.fLock;
            synchronized (object) {
                this.fCachedMatches = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushMatches() {
            Object object = this.fLock;
            synchronized (object) {
                if (this.fCachedMatches != null && !this.fCachedMatches.isEmpty()) {
                    for (ArrayList<FileMatch> matches : this.fCachedMatches.values()) {
                        this.fResult.addMatches(matches.toArray(new Match[matches.size()]));
                    }
                    this.fCachedMatches.clear();
                }
            }
        }
    }
}

