/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.input.CharacterPattern;
import com.googlecode.lanterna.input.Key;
import java.util.Arrays;
import java.util.List;

class BasicCharacterPattern
implements CharacterPattern {
    private Key result;
    private char[] pattern;

    BasicCharacterPattern(Key result, char ... pattern) {
        this.result = result;
        this.pattern = pattern;
    }

    @Override
    public boolean matches(List<Character> currentMatching) {
        int minSize = Math.min(currentMatching.size(), this.pattern.length);
        for (int i = 0; i < minSize; ++i) {
            if (this.pattern[i] == currentMatching.get(i).charValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Key getResult(List<Character> matching) {
        return this.result;
    }

    @Override
    public boolean isCompleteMatch(List<Character> currentMatching) {
        return this.pattern.length == currentMatching.size();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasicCharacterPattern)) {
            return false;
        }
        BasicCharacterPattern other = (BasicCharacterPattern)obj;
        return Arrays.equals(this.pattern, other.pattern);
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Arrays.hashCode(this.pattern);
        return hash;
    }
}

