/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.DefaultInstanceValidator;
import de.rcenvironment.core.start.common.validation.spi.InstanceValidator;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;

@Component(service={InstanceValidator.class})
public class JavaVersionValidator
extends DefaultInstanceValidator {
    private static final String VALIDATION_DISPLAY_NAME = "Java Runtime Version";
    private static final int REQUIRED_UPDATE_VERSION = 161;

    public InstanceValidationResult validate() {
        String javaVersion = System.getProperty("java.version");
        Optional<Boolean> isGreaterThan8u161 = this.isVersionCompatible(javaVersion);
        if (isGreaterThan8u161.isPresent()) {
            if (isGreaterThan8u161.get().booleanValue()) {
                return InstanceValidationResultFactory.createResultForPassed((String)VALIDATION_DISPLAY_NAME);
            }
            String logMessage = String.format("Java runtime version 8u161 required. Current java runtime version: %s", javaVersion);
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)VALIDATION_DISPLAY_NAME, (String)logMessage, (String)logMessage);
        }
        String logMessage = String.format("Could not parse java version string: %s. Proceeding, but component authorization may not work", javaVersion);
        return InstanceValidationResultFactory.createResultForFailureWhichAllowesToProceed((String)VALIDATION_DISPLAY_NAME, (String)logMessage, (String)logMessage);
    }

    private Optional<Boolean> isVersionCompatible(String javaVersion) {
        if (javaVersion.startsWith("1.7")) {
            return Optional.of(false);
        }
        if (javaVersion.startsWith("9") || javaVersion.startsWith("10") || javaVersion.startsWith("11")) {
            return Optional.of(true);
        }
        if (javaVersion.startsWith("1.8")) {
            try {
                return Optional.of(this.tryCheckJava8VersionString(javaVersion));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private boolean tryCheckJava8VersionString(String javaVersion) {
        if (!javaVersion.contains("_")) {
            String errorMessage = String.format("Could not locate underscore indicating start of update-version. Java version string: %s", javaVersion);
            throw new IllegalArgumentException(errorMessage);
        }
        int underscoreIndex = javaVersion.indexOf(95);
        StringBuilder updateStringBuilder = new StringBuilder();
        int currentIndex = underscoreIndex + 1;
        char currentChar = javaVersion.charAt(currentIndex);
        while (currentIndex < javaVersion.length() && Character.isDigit(currentChar)) {
            updateStringBuilder.append(currentChar);
            if (++currentIndex >= javaVersion.length()) continue;
            currentChar = javaVersion.charAt(currentIndex);
        }
        try {
            int updateVersion = Integer.parseInt(updateStringBuilder.toString());
            return updateVersion >= 161;
        }
        catch (NumberFormatException numberFormatException) {
            String errorMessage = String.format("Could not parse update version %s. Java version string: %s", updateStringBuilder, javaVersion);
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

