/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.internal.ComponentStatesChangedEntirelyVerifier;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentDisconnectWatcher
implements Runnable {
    public static final long DEFAULT_DISCONNECT_REPORTING_INTERVAL_MSEC = TimeUnit.SECONDS.toMillis(90L);
    public static final long DEFAULT_FAILURE_INTERVAL_MSEC = TimeUnit.DAYS.toMillis(3L);
    public static final long DEFAULT_TEST_INTERVAL_MSEC = 10000L;
    protected static long maxDisconnectReportingIntervalMsec = DEFAULT_DISCONNECT_REPORTING_INTERVAL_MSEC;
    protected static long maxFailureIntervalMsec = DEFAULT_FAILURE_INTERVAL_MSEC;
    private static final Log LOG = LogFactory.getLog(ComponentDisconnectWatcher.class);
    private static final boolean VERBOSE_LOGGING = DebugSettings.getVerboseLoggingEnabled((String)"WorkflowExecution");
    private final Map<String, Long> componentHeartbeatTimestamps = new HashMap<String, Long>();
    private final Set<String> componentsMarkedAsDisconnected = new HashSet<String>();
    private final ComponentStatesChangedEntirelyVerifier compStatesEntirelyChangedVerifier;
    private final String logMessage;

    public ComponentDisconnectWatcher(ComponentStatesChangedEntirelyVerifier compStatesEntirelyChangedVerifier, WorkflowExecutionContext wfExeCtx) {
        this.compStatesEntirelyChangedVerifier = compStatesEntirelyChangedVerifier;
        this.logMessage = StringUtils.format((String)"Checking component heartbeats for workflow '%s' (%s)", (Object[])new Object[]{wfExeCtx.getInstanceName(), wfExeCtx.getExecutionIdentifier()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announceComponentHeartbeat(String compExecutionId) {
        Map<String, Long> map = this.componentHeartbeatTimestamps;
        synchronized (map) {
            this.componentHeartbeatTimestamps.put(compExecutionId, System.currentTimeMillis());
            if (this.componentsMarkedAsDisconnected.contains(compExecutionId)) {
                LOG.info((Object)("Component " + compExecutionId + " has become reachable again; resuming workflow"));
                this.componentsMarkedAsDisconnected.remove(compExecutionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TaskDescription(value="Peridically check for heartbeat messages from components")
    public void run() {
        if (VERBOSE_LOGGING) {
            LOG.debug((Object)this.logMessage);
        }
        long currentTimestamp = System.currentTimeMillis();
        HashSet<String> compExeIdsLost = new HashSet<String>();
        Map<String, Long> map = this.componentHeartbeatTimestamps;
        synchronized (map) {
            for (String compExeId : this.componentHeartbeatTimestamps.keySet()) {
                long lastHeartbeatAge = currentTimestamp - this.componentHeartbeatTimestamps.get(compExeId);
                if (lastHeartbeatAge > maxFailureIntervalMsec && !this.compStatesEntirelyChangedVerifier.isComponentInFinalState(compExeId)) {
                    compExeIdsLost.add(compExeId);
                    continue;
                }
                if (lastHeartbeatAge <= maxDisconnectReportingIntervalMsec || this.compStatesEntirelyChangedVerifier.isComponentInFinalState(compExeId) || this.componentsMarkedAsDisconnected.contains(compExeId)) continue;
                LOG.info((Object)("Component " + compExeId + " has become disconnected or overloaded; the workflow will resume if and when it reconnects"));
                this.componentsMarkedAsDisconnected.add(compExeId);
            }
        }
        if (!compExeIdsLost.isEmpty()) {
            this.compStatesEntirelyChangedVerifier.announceLostComponents(compExeIdsLost);
        }
    }
}

