/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout.util.RandomLocationTransformer;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FRLayout<V, E>
extends AbstractLayout<V, E>
implements IterativeContext {
    private double forceConstant;
    private double temperature;
    private int currentIteration;
    private int mMaxIterations = 700;
    private Map<V, FRVertexData> frVertexData = LazyMap.decorate(new HashMap(), new Factory<FRVertexData>(){

        @Override
        public FRVertexData create() {
            return new FRVertexData();
        }
    });
    private double attraction_multiplier = 0.75;
    private double attraction_constant;
    private double repulsion_multiplier = 0.75;
    private double repulsion_constant;
    private double max_dimension;
    private double EPSILON = 1.0E-6;

    public FRLayout(Graph<V, E> g) {
        super(g);
    }

    public FRLayout(Graph<V, E> g, Dimension d) {
        super(g, new RandomLocationTransformer(d), d);
        this.initialize();
        this.max_dimension = Math.max(d.height, d.width);
    }

    @Override
    public void setSize(Dimension size) {
        if (!this.initialized) {
            this.setInitializer(new RandomLocationTransformer(size));
        }
        super.setSize(size);
        this.max_dimension = Math.max(size.height, size.width);
    }

    public void setAttractionMultiplier(double attraction) {
        this.attraction_multiplier = attraction;
    }

    public void setRepulsionMultiplier(double repulsion) {
        this.repulsion_multiplier = repulsion;
    }

    @Override
    public void reset() {
        this.doInit();
    }

    @Override
    public void initialize() {
        this.doInit();
    }

    private void doInit() {
        Graph graph = this.getGraph();
        Dimension d = this.getSize();
        if (graph != null && d != null) {
            this.currentIteration = 0;
            this.temperature = d.getWidth() / 10.0;
            this.forceConstant = Math.sqrt(d.getHeight() * d.getWidth() / (double)graph.getVertexCount());
            this.attraction_constant = this.attraction_multiplier * this.forceConstant;
            this.repulsion_constant = this.repulsion_multiplier * this.forceConstant;
        }
    }

    @Override
    public synchronized void step() {
        ++this.currentIteration;
        while (true) {
            try {
                for (Object v1 : this.getGraph().getVertices()) {
                    this.calcRepulsion(v1);
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (Object e : this.getGraph().getEdges()) {
                    this.calcAttraction(e);
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (Object v : this.getGraph().getVertices()) {
                    if (this.isLocked(v)) continue;
                    this.calcPositions(v);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        this.cool();
    }

    protected synchronized void calcPositions(V v) {
        FRVertexData fvd = this.getFRData(v);
        if (fvd == null) {
            return;
        }
        Object xyd = this.transform((Object)v);
        double deltaLength = Math.max(this.EPSILON, fvd.norm());
        double newXDisp = fvd.getX() / deltaLength * Math.min(deltaLength, this.temperature);
        if (Double.isNaN(newXDisp)) {
            throw new IllegalArgumentException("Unexpected mathematical result in FRLayout:calcPositions [xdisp]");
        }
        double newYDisp = fvd.getY() / deltaLength * Math.min(deltaLength, this.temperature);
        ((Point2D)xyd).setLocation(((Point2D)xyd).getX() + newXDisp, ((Point2D)xyd).getY() + newYDisp);
        double borderWidth = this.getSize().getWidth() / 50.0;
        double newXPos = ((Point2D)xyd).getX();
        if (newXPos < borderWidth) {
            newXPos = borderWidth + Math.random() * borderWidth * 2.0;
        } else if (newXPos > this.getSize().getWidth() - borderWidth) {
            newXPos = this.getSize().getWidth() - borderWidth - Math.random() * borderWidth * 2.0;
        }
        double newYPos = ((Point2D)xyd).getY();
        if (newYPos < borderWidth) {
            newYPos = borderWidth + Math.random() * borderWidth * 2.0;
        } else if (newYPos > this.getSize().getHeight() - borderWidth) {
            newYPos = this.getSize().getHeight() - borderWidth - Math.random() * borderWidth * 2.0;
        }
        ((Point2D)xyd).setLocation(newXPos, newYPos);
    }

    protected void calcAttraction(E e) {
        double yDelta;
        Pair endpoints = this.getGraph().getEndpoints(e);
        Object v1 = endpoints.getFirst();
        Object v2 = endpoints.getSecond();
        boolean v1_locked = this.isLocked(v1);
        boolean v2_locked = this.isLocked(v2);
        if (v1_locked && v2_locked) {
            return;
        }
        Object p1 = this.transform(v1);
        Object p2 = this.transform(v2);
        if (p1 == null || p2 == null) {
            return;
        }
        double xDelta = ((Point2D)p1).getX() - ((Point2D)p2).getX();
        double deltaLength = Math.max(this.EPSILON, Math.sqrt(xDelta * xDelta + (yDelta = ((Point2D)p1).getY() - ((Point2D)p2).getY()) * yDelta));
        double force = deltaLength * deltaLength / this.attraction_constant;
        if (Double.isNaN(force)) {
            throw new IllegalArgumentException("Unexpected mathematical result in FRLayout:calcPositions [force]");
        }
        double dx = xDelta / deltaLength * force;
        double dy = yDelta / deltaLength * force;
        if (!v1_locked) {
            FRVertexData fvd1 = this.getFRData(v1);
            fvd1.offset(-dx, -dy);
        }
        if (!v2_locked) {
            FRVertexData fvd2 = this.getFRData(v2);
            fvd2.offset(dx, dy);
        }
    }

    protected void calcRepulsion(V v1) {
        FRVertexData fvd1 = this.getFRData(v1);
        if (fvd1 == null) {
            return;
        }
        fvd1.setLocation(0.0, 0.0);
        try {
            for (Object v2 : this.getGraph().getVertices()) {
                double yDelta;
                if (v1 == v2) continue;
                Object p1 = this.transform((Object)v1);
                Object p2 = this.transform(v2);
                if (p1 == null || p2 == null) continue;
                double xDelta = ((Point2D)p1).getX() - ((Point2D)p2).getX();
                double deltaLength = Math.max(this.EPSILON, Math.sqrt(xDelta * xDelta + (yDelta = ((Point2D)p1).getY() - ((Point2D)p2).getY()) * yDelta));
                double force = this.repulsion_constant * this.repulsion_constant / deltaLength;
                if (Double.isNaN(force)) {
                    throw new RuntimeException("Unexpected mathematical result in FRLayout:calcPositions [repulsion]");
                }
                fvd1.offset(xDelta / deltaLength * force, yDelta / deltaLength * force);
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calcRepulsion(v1);
        }
    }

    private void cool() {
        this.temperature *= 1.0 - (double)this.currentIteration / (double)this.mMaxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.mMaxIterations = maxIterations;
    }

    protected FRVertexData getFRData(V v) {
        return this.frVertexData.get(v);
    }

    public boolean isIncremental() {
        return true;
    }

    @Override
    public boolean done() {
        return this.currentIteration > this.mMaxIterations || this.temperature < 1.0 / this.max_dimension;
    }

    protected static class FRVertexData
    extends Point2D.Double {
        protected FRVertexData() {
        }

        protected void offset(double x, double y) {
            this.x += x;
            this.y += y;
        }

        protected double norm() {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }
    }
}

