/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.execution;

import de.rcenvironment.components.switchcmp.common.ScriptValidation;
import de.rcenvironment.components.switchcmp.common.SwitchComponentHistoryDataItem;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.scripting.ScriptingService;
import de.rcenvironment.core.scripting.ScriptingUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.lang3.text.WordUtils;

public class SwitchComponent
extends DefaultComponent {
    protected static ScriptingService scriptingService;
    private static final String QUOTE = "\\\\Q";
    private static final String ENDQUOTE = "\\\\E";
    private ScriptLanguage scriptLanguage;
    private ScriptEngine engine;
    private String condition;
    private CloseOutputBehavior closeOutputBehavior;
    private ComponentContext componentContext;
    private SwitchComponentHistoryDataItem historyDataItem;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public void start() throws ComponentException {
        this.condition = this.componentContext.getConfigurationValue("conditionKey");
        this.closeOutputBehavior = this.getCloseOutputBehavior();
        this.scriptLanguage = ScriptLanguage.getByName((String)"Jython");
        scriptingService = (ScriptingService)this.componentContext.getService(ScriptingService.class);
        this.engine = scriptingService.createScriptEngine(this.scriptLanguage);
        String errorMessage = ScriptValidation.validateScript((String)this.condition, (ScriptEngine)this.engine, this.getInputAndConnectionStatus(), this.getInputsAndDataTypes());
        if (!errorMessage.isEmpty()) {
            throw new ComponentException(errorMessage);
        }
    }

    private CloseOutputBehavior getCloseOutputBehavior() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("closeOutputsOnTrue")).booleanValue()) {
            return CloseOutputBehavior.CloseOutputsOnTrue;
        }
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("closeOutputsOnFalse")).booleanValue()) {
            return CloseOutputBehavior.CloseOutputsOnFalse;
        }
        return CloseOutputBehavior.NeverCloseOutputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processInputs() throws ComponentException {
        String outputName;
        Object returnValue;
        Object datum;
        this.initializeNewHistoryDataItem();
        String conditionWithActualValues = this.condition;
        TypedDatum switchDatum = this.componentContext.readInput("To_forward");
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            datum = this.componentContext.readInput(inputName);
            if (datum.getDataType().equals((Object)DataType.Float) || datum.getDataType().equals((Object)DataType.Integer)) {
                conditionWithActualValues = conditionWithActualValues.replace(inputName, Pattern.quote(datum.toString()).replaceAll(QUOTE, "")).replaceAll(ENDQUOTE, "");
            }
            if (!datum.getDataType().equals((Object)DataType.Boolean)) continue;
            conditionWithActualValues = conditionWithActualValues.replace(inputName, WordUtils.capitalize((String)Pattern.quote(datum.toString()).replaceAll(QUOTE, ""))).replaceAll(ENDQUOTE, "");
        }
        String evalScript = "if " + conditionWithActualValues + ":\n    returnValue=True\nelse:\n    returnValue=False";
        try {
            datum = ScriptingUtils.SCRIPT_EVAL_LOCK_OBJECT;
            synchronized (datum) {
                this.engine.eval(evalScript);
                returnValue = this.engine.get("returnValue");
            }
        }
        catch (ScriptException e) {
            throw new ComponentException(StringUtils.format((String)"Failed to interpret condition '%s': %s", (Object[])new Object[]{conditionWithActualValues, e.getMessage()}), (Throwable)e);
        }
        this.componentContext.getLog().componentInfo(StringUtils.format((String)"Evaluated '%s' -> %b", (Object[])new Object[]{conditionWithActualValues, returnValue}));
        if (this.historyDataItem != null) {
            this.historyDataItem.setActualCondition(StringUtils.format((String)"%s -> %b", (Object[])new Object[]{conditionWithActualValues, returnValue}));
            this.historyDataItem.setConditionPattern(this.condition);
        }
        if (((Boolean)returnValue).booleanValue()) {
            this.componentContext.writeOutput("True", switchDatum);
            if (this.closeOutputBehavior == CloseOutputBehavior.CloseOutputsOnTrue) {
                this.componentContext.closeAllOutputs();
            }
            outputName = "True";
        } else {
            this.componentContext.writeOutput("False", switchDatum);
            if (this.closeOutputBehavior == CloseOutputBehavior.CloseOutputsOnFalse) {
                this.componentContext.closeAllOutputs();
            }
            outputName = "False";
        }
        this.componentContext.getLog().componentInfo(StringUtils.format((String)"Wrote to '%s': %s", (Object[])new Object[]{outputName, switchDatum}));
        this.writeFinalHistoryDataItem();
    }

    public void completeStartOrProcessInputsAfterFailure() throws ComponentException {
        this.writeFinalHistoryDataItem();
    }

    private void initializeNewHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.historyDataItem = new SwitchComponentHistoryDataItem("de.rcenvironment.switchcmp");
        }
    }

    private void writeFinalHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyDataItem);
        }
    }

    private Map<String, Boolean> getInputAndConnectionStatus() {
        HashMap<String, Boolean> inputs = new HashMap<String, Boolean>();
        for (String name : this.componentContext.getInputs()) {
            inputs.put(name, true);
        }
        for (String name : this.componentContext.getInputsNotConnected()) {
            inputs.put(name, false);
        }
        return inputs;
    }

    private Map<String, DataType> getInputsAndDataTypes() {
        HashMap<String, DataType> inputs = new HashMap<String, DataType>();
        for (String name : this.componentContext.getInputs()) {
            inputs.put(name, this.componentContext.getInputDataType(name));
        }
        for (String name : this.componentContext.getInputsNotConnected()) {
            inputs.put(name, this.componentContext.getInputDataType(name));
        }
        return inputs;
    }

    private static enum CloseOutputBehavior {
        NeverCloseOutputs,
        CloseOutputsOnTrue,
        CloseOutputsOnFalse;

    }
}

