/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common.widgets;

import de.rcenvironment.core.gui.resources.api.FontManager;
import de.rcenvironment.core.gui.resources.api.FontSource;
import de.rcenvironment.core.gui.resources.api.StandardFonts;
import de.rcenvironment.core.utils.common.StringUtils;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class LineNumberStyledText
extends StyledText
implements LineStyleListener,
ModifyListener,
KeyListener {
    private static final int KEYCODE_A = 97;
    private int lineCount = 0;
    private StyleRange styleRange = new StyleRange();
    private MenuItem cutItem = null;
    private MenuItem pasteItem = null;

    public LineNumberStyledText(Composite parent, int style) {
        super(parent, style);
        this.addContextMenu();
        this.styleRange.foreground = Display.getCurrent().getSystemColor(15);
        this.addLineStyleListener(this);
        this.addModifyListener(this);
        this.addKeyListener(this);
        this.setFont(FontManager.getInstance().getFont((FontSource)StandardFonts.CONSOLE_TEXT_FONT));
        this.updateLineNumbers();
    }

    public void lineGetStyle(LineStyleEvent arg0) {
        int bulletLength = Integer.toString(this.lineCount).length();
        int bulletWidth = (bulletLength + 1) * this.getLineHeight() / 2;
        this.styleRange.metrics = new GlyphMetrics(0, 0, bulletWidth);
        if (arg0.bullet == null) {
            arg0.bullet = new Bullet(16, this.styleRange);
        } else {
            arg0.bullet.style = this.styleRange;
        }
        int bulletLine = this.getLineAtOffset(arg0.lineOffset) + 1;
        arg0.bullet.text = StringUtils.format((String)("%" + bulletLength + "s"), (Object[])new Object[]{bulletLine});
        arg0.tabStops = new int[]{bulletWidth, 3 * bulletWidth};
    }

    private void updateLineNumbers() {
        int sel = this.getCaretOffset();
        int scrollbarSel = this.getTopIndex();
        this.lineCount = this.getLineCount();
        super.setText(this.getText());
        this.setCaretOffset(sel);
        this.setTopIndex(scrollbarSel);
    }

    private void addContextMenu() {
        Menu menu = new Menu((Control)this);
        this.cutItem = new MenuItem(menu, 8);
        this.cutItem.setText("Cut\tCtrl+X");
        this.cutItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LineNumberStyledText.this.invokeAction(131199);
            }
        });
        MenuItem item = new MenuItem(menu, 8);
        item.setText("Copy\tCtrl+C");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LineNumberStyledText.this.invokeAction(17039369);
            }
        });
        this.pasteItem = new MenuItem(menu, 8);
        this.pasteItem.setText("Paste\tCtrl+V");
        this.pasteItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LineNumberStyledText.this.invokeAction(16908297);
            }
        });
        item = new MenuItem(menu, 8);
        item.setText("Select All\tCtrl+A");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LineNumberStyledText.this.selectAll();
            }
        });
        this.setMenu(menu);
    }

    public void setEnabled(boolean enabled) {
        this.setSelection(0);
        this.setBackgroundEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setText(String text) {
        super.setText(text);
        this.updateLineNumbers();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.cutItem == null || this.pasteItem == null) {
            return;
        }
        this.cutItem.setEnabled(editable);
        this.pasteItem.setEnabled(editable);
    }

    public void setBackgroundEnabled(boolean enabled) {
        if (enabled) {
            this.getCaret().setVisible(false);
            this.setBackground(Display.getCurrent().getSystemColor(1));
        } else {
            this.setBackground(Display.getCurrent().getSystemColor(22));
            this.getCaret().setVisible(true);
        }
    }

    public void modifyText(ModifyEvent arg0) {
        if (this.lineCount != this.getLineCount()) {
            this.updateLineNumbers();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.stateMask == 262144 && e.keyCode == 97) {
            this.selectAll();
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }
}

