/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.bootstrap.profile.CommonProfile;
import de.rcenvironment.core.configuration.bootstrap.profile.Profile;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileException;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileUtils;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.InstanceValidator;
import de.rcenvironment.core.start.validators.internal.ProfileDirectoriesAccessibleValidator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ProfileDirectoryVersionValidator
implements InstanceValidator {
    private static final String PROFILE_VALIDATION_FAILED = "Profile directory version";
    private static ConfigurationService configService;
    private final Log log = LogFactory.getLog(this.getClass());

    public InstanceValidationResult validate() {
        Profile userProfile;
        CommonProfile commonProfile;
        try {
            File commonProfileDirectory = ProfileUtils.getProfilesParentDirectory().toPath().resolve("common").toFile();
            commonProfile = new CommonProfile.Builder(commonProfileDirectory).create(false).migrate(false).buildCommonProfile();
        }
        catch (ProfileException profileException) {
            String errorMessage = String.format("Could not open profile at \"%s\".", configService.getProfileDirectory());
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)PROFILE_VALIDATION_FAILED, (String)errorMessage);
        }
        InstanceValidationResult commonProfileResult = this.validateProfile(commonProfile);
        if (!InstanceValidationResult.InstanceValidationResultType.PASSED.equals((Object)commonProfileResult.getType())) {
            return commonProfileResult;
        }
        try {
            userProfile = new CommonProfile.Builder(configService.getProfileDirectory()).create(false).migrate(false).buildUserProfile();
        }
        catch (ProfileException profileException) {
            String errorMessage = String.format("Could not open profile at \"%s\".", configService.getProfileDirectory());
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)PROFILE_VALIDATION_FAILED, (String)errorMessage);
        }
        return this.validateProfile((CommonProfile)userProfile);
    }

    private InstanceValidationResult validateProfile(CommonProfile profile) {
        boolean profileHasCurrentVersion;
        try {
            profileHasCurrentVersion = profile.hasCurrentVersion();
        }
        catch (ProfileException e) {
            return this.onProfileException(profile, e);
        }
        if (!profileHasCurrentVersion) {
            int profileVersion;
            boolean profileHasUpgradeableVersion;
            try {
                profileHasUpgradeableVersion = profile.hasUpgradeableVersion();
            }
            catch (ProfileException e) {
                return this.onProfileException(profile, e);
            }
            if (profileHasUpgradeableVersion) {
                int profileVersion2;
                try {
                    profileVersion2 = profile.getVersion();
                }
                catch (ProfileException e) {
                    return this.onProfileException(profile, e);
                }
                String queryMessage = String.format("Your \"%s\" profile is out of date. A version upgrade is required to start RCE. \nDo you wish to upgrade to current version? \n    \nNote: Upgrading causes the profile to be unusable for older versions of RCE. \nYou might want to backup the profile folder located at \"%s\".", profile.getName(), profile.getProfileDirectory().getAbsolutePath());
                String logMessage = String.format("Profile \"%s\" at \"%s\" has outdated version %d, queried user for upgrade confirmation.", profile.getName(), profile.getProfileDirectory().getAbsolutePath(), profileVersion2);
                return InstanceValidationResultFactory.createResultForFailureWhichRequiresUserConfirmation((String)PROFILE_VALIDATION_FAILED, (String)logMessage, (String)queryMessage, () -> {
                    try {
                        profile.upgradeToCurrentVersion();
                    }
                    catch (IOException e) {
                        String errorMessage = String.format("Could not upgrade profile \"%s\" located at \"%s\" to current version.", profile.getName(), profile.getProfileDirectory().getAbsolutePath());
                        throw new InstanceValidationResult.CallbackException(errorMessage, (Throwable)e);
                    }
                });
            }
            try {
                profileVersion = profile.getVersion();
            }
            catch (ProfileException e) {
                return this.onProfileException(profile, e);
            }
            String errorMessage = String.format("Profile \"%s\" has version %d, which cannot be upgraded to the current version.", profile.getName(), profileVersion);
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)PROFILE_VALIDATION_FAILED, (String)errorMessage);
        }
        return InstanceValidationResultFactory.createResultForPassed((String)"Profile directory has valid version.");
    }

    private InstanceValidationResult onProfileException(CommonProfile profile, ProfileException exception) {
        String errorMessage = String.format("Could not determine version of profile \"%s\" due to exception. Refer to the log for more details.", profile.getName());
        this.log.error((Object)errorMessage, (Throwable)exception);
        return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)PROFILE_VALIDATION_FAILED, (String)errorMessage, (String)errorMessage);
    }

    @Reference
    protected void bindConfigurationService(ConfigurationService configIn) {
        configService = configIn;
    }

    public List<Class<? extends InstanceValidator>> getNecessaryPredecessors() {
        ArrayList<Class<? extends InstanceValidator>> predecessors = new ArrayList<Class<? extends InstanceValidator>>();
        predecessors.add(ProfileDirectoriesAccessibleValidator.class);
        return predecessors;
    }
}

