/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.executor.properties;

import de.rcenvironment.core.gui.utils.incubator.WidgetGroupFactory;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.executor.properties.Messages;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class HostSection
extends ValidatingWorkflowNodePropertySection {
    protected static final int TEXT_WIDTH = 220;
    protected static final int BUTTON_WIDTH = 80;
    private boolean pinging = false;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        final Section hostSection = factory.createSection(parent, 320);
        hostSection.setText(Messages.configureHost);
        Composite hostParent = factory.createFlatFormComposite((Composite)hostSection);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        hostParent.setLayout((Layout)layout);
        final Text hostText = WidgetGroupFactory.addLabelAndTextfieldForPropertyToComposite((Composite)hostParent, (String)Messages.hostLabel, (String)"host", (int)220, (int)0).text;
        Button pingHost = factory.createButton(hostParent, "Ping host", 0);
        GridData gridData = new GridData();
        gridData.widthHint = 80;
        pingHost.setLayoutData((Object)gridData);
        WidgetGroupFactory.addLabelAndTextfieldForPropertyToComposite((Composite)hostParent, (String)Messages.portLabel, (String)"port", (int)220, (int)2);
        final Label pingLabel = new Label(hostParent, 0);
        WidgetGroupFactory.addLabelAndTextfieldForPropertyToComposite((Composite)hostParent, (String)Messages.sandboxRootLabel, (String)"sandboxRoot", (int)220, (int)0);
        new Label(hostParent, 0);
        new Label(hostParent, 0);
        Button deleteSandboxButton = factory.createButton(hostParent, "Delete working directory after execution", 32);
        deleteSandboxButton.setData("property.control", (Object)"deleteSandbox");
        hostSection.setClient((Control)hostParent);
        pingHost.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (!HostSection.this.pinging) {
                    final String host = hostText.getText();
                    if (!host.isEmpty()) {
                        pingLabel.setText("Pinging host " + host + " ...");
                    }
                    hostSection.layout();
                    ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Process p1 = Runtime.getRuntime().exec("ping " + host);
                                final int result = p1.waitFor();
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (result == 0) {
                                            pingLabel.setText("Host " + host + " is reachable");
                                        } else {
                                            pingLabel.setText("Could not reach " + host);
                                        }
                                        HostSection.this.pinging = false;
                                        hostSection.layout();
                                    }
                                });
                            }
                            catch (InterruptedException e) {
                                Logger.getLogger(HostSection.class.getName()).log(Level.WARNING, "", e);
                            }
                            catch (IOException e) {
                                Logger.getLogger(HostSection.class.getName()).log(Level.WARNING, "", e);
                            }
                        }
                    });
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }
}

