/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class NumberFn
extends SystemFunction {
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.useContextItemAsDefault(visitor);
        this.argument[0].setFlattened(true);
        return this.simplifyArguments(visitor);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e2 = super.typeCheck(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        if (this.argument[0] instanceof NumberFn) {
            this.argument[0] = ((NumberFn)this.argument[0]).argument[0];
        }
        return this;
    }

    public PathMap.PathMapNodeSet addDocToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodes) {
        PathMap.PathMapNodeSet result = this.argument[0].addToPathMap(pathMap, pathMapNodes);
        if (result != null) {
            result.setAtomized();
        }
        return null;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item arg0 = this.argument[0].evaluateItem(context);
        if (arg0 == null) {
            return DoubleValue.NaN;
        }
        ConversionRules rules = context.getConfiguration().getConversionRules();
        if (arg0 instanceof BooleanValue) {
            return Converter.BOOLEAN_TO_DOUBLE.convert((AtomicValue)arg0).asAtomic();
        }
        if (arg0 instanceof NumericValue) {
            return Converter.NUMERIC_TO_DOUBLE.convert((AtomicValue)arg0).asAtomic();
        }
        if (arg0 instanceof StringValue && !(arg0 instanceof AnyURIValue)) {
            StringConverter sc = StringConverter.getStringConverter(BuiltInAtomicType.DOUBLE, rules);
            ConversionResult cr = sc.convert((AtomicValue)arg0);
            if (cr instanceof ValidationFailure) {
                return DoubleValue.NaN;
            }
            return (AtomicValue)cr;
        }
        return DoubleValue.NaN;
    }

    public static DoubleValue convert(AtomicValue value, Configuration config) {
        try {
            if (value == null) {
                return DoubleValue.NaN;
            }
            if (value instanceof BooleanValue) {
                return new DoubleValue(((BooleanValue)value).getBooleanValue() ? 1.0 : 0.0);
            }
            if (value instanceof DoubleValue) {
                return (DoubleValue)value;
            }
            if (value instanceof NumericValue) {
                return new DoubleValue(((NumericValue)value).getDoubleValue());
            }
            if (value instanceof StringValue && !(value instanceof AnyURIValue)) {
                double d = config.getConversionRules().getStringToDoubleConverter().stringToNumber(value.getStringValueCS());
                return new DoubleValue(d);
            }
            return DoubleValue.NaN;
        }
        catch (NumberFormatException e) {
            return DoubleValue.NaN;
        }
    }
}

