/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.login.internal;

import de.rcenvironment.core.authentication.AuthenticationService;
import de.rcenvironment.core.gui.login.internal.Activator;
import de.rcenvironment.core.gui.login.internal.LoginDialog;
import de.rcenvironment.core.gui.login.internal.Messages;
import de.rcenvironment.core.login.LoginConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogSettings;

public class LoginDialogController {
    private static final String PROPERTIES_PREFIX = "de.rcenvironment.rce.gui.login";
    private static final Log LOGGER = LogFactory.getLog(LoginDialogController.class);
    private LoginDialog loginDialog;
    private AuthenticationService authenticationService;
    private LoginConfiguration loginConfiguration;
    private String certificatePath;
    private String keyPath;
    private String usernameLDAP = "";
    private String tabTitle = Messages.ldapTabName;

    protected LoginDialogController(LoginDialog loginDialog, AuthenticationService authenticationService, LoginConfiguration loginConfiguration) {
        this.loginDialog = loginDialog;
        this.authenticationService = authenticationService;
        this.loginConfiguration = loginConfiguration;
    }

    protected void setUpDialogForLDAP(boolean relogin) {
        this.loadSettings();
        this.loadUsernameLDAP();
    }

    protected void saveSettings() {
        IDialogSettings dialogSettings = Activator.getInstance().getDialogSettings();
        dialogSettings.put("de.rcenvironment.rce.gui.logincertificateFile", this.certificatePath);
        dialogSettings.put("de.rcenvironment.rce.gui.loginkeyFile", this.keyPath);
        dialogSettings.put("de.rcenvironment.rce.gui.loginusernameLDAP", this.loginDialog.getUsernameLDAP());
        dialogSettings.put("de.rcenvironment.rce.gui.logintabTitle", this.tabTitle);
        dialogSettings.put("de.rcenvironment.rce.gui.loginanonymousLogin", this.loginDialog.getAnonymousLogin());
    }

    protected void loadSettings() {
        IDialogSettings dialogSettings = Activator.getInstance().getDialogSettings();
        String settingsCertificatePath = dialogSettings.get("de.rcenvironment.rce.gui.logincertificateFile");
        this.certificatePath = settingsCertificatePath != null ? settingsCertificatePath : this.loginConfiguration.getCertificateFile();
        String settingsKeyPath = dialogSettings.get("de.rcenvironment.rce.gui.loginkeyFile");
        this.keyPath = settingsKeyPath != null ? settingsKeyPath : this.loginConfiguration.getKeyFile();
        String settingsUsernameLdap = dialogSettings.get("de.rcenvironment.rce.gui.loginusernameLDAP");
        this.usernameLDAP = settingsUsernameLdap != null ? settingsUsernameLdap : this.loginConfiguration.getLdapUsername();
        String settingsTabTitle = dialogSettings.get("de.rcenvironment.rce.gui.logintabTitle");
        if (settingsTabTitle != null) {
            this.tabTitle = settingsTabTitle;
        }
    }

    private void loadUsernameLDAP() {
        this.loginDialog.setUsernameLDAP(this.usernameLDAP);
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    public void setTabTitle(String title) {
        this.tabTitle = title;
    }
}

