/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.parts;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentShape;
import de.rcenvironment.core.component.model.api.ComponentSize;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.parts.ComponentStateChangeListener;
import de.rcenvironment.core.gui.workflow.parts.Messages;
import de.rcenvironment.core.gui.workflow.parts.ReadOnlyWorkflowNodePart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowExecutionInformationPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowPart;
import de.rcenvironment.core.gui.workflow.view.ComponentRuntimeView;
import de.rcenvironment.core.gui.workflow.view.properties.ComponentInstancePropertySource;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchAggregator;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchProcessor;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public class WorkflowRunNodePart
extends ReadOnlyWorkflowNodePart {
    private static final int INTEGER_15 = 15;
    private static final int INTEGER_16 = 16;
    private static final int INTEGER_20 = 20;
    private static final int INTEGER_22 = 22;
    private static final Log LOGGER = LogFactory.getLog(WorkflowRunNodePart.class);
    private static final int MAX_BATCH_SIZE = 10000;
    private static final long MAX_BATCH_LATENCY_MSEC = 400L;
    private static final long UNDEFINED = -1L;
    private final NotificationSubscriber stateChangeListener = new ComponentStateChangeListener(this);
    private final BatchAggregator<ComponentState> batchAggregator;
    private ComponentStateFigure stateFigure;
    private boolean initializeStatusTriggered = false;
    private volatile long lastStateNotificationNumber = -1L;
    private volatile long lastIterationCountNotificationNumber = -1L;
    private Label runCountLabel;

    public WorkflowRunNodePart() {
        BatchProcessor<ComponentState> batchProcessor = new BatchProcessor<ComponentState>(){

            public void processBatch(List<ComponentState> batch) {
                WorkflowRunNodePart.this.updateComponentState(batch.get(batch.size() - 1));
            }
        };
        this.batchAggregator = ConcurrencyUtils.getFactory().createBatchAggregator(10000, 400L, (BatchProcessor)batchProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        super.refresh();
        BatchAggregator<ComponentState> batchAggregator = this.batchAggregator;
        synchronized (batchAggregator) {
            if (!this.initializeStatusTriggered) {
                Job job = new Job(StringUtils.format((String)Messages.initializingComponentState, (Object[])new Object[]{((WorkflowNode)this.getModel()).getName()})){

                    protected IStatus run(IProgressMonitor monitor) {
                        WorkflowRunNodePart.this.initializeStatus();
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
                this.initializeStatusTriggered = true;
            }
        }
    }

    @Override
    protected String generateTooltipText() {
        return this.generateTooltipTextBase((WorkflowNode)this.getModel());
    }

    @Override
    protected IFigure createFigure() {
        IFigure figure = super.createBaseFigure();
        this.stateFigure = new ComponentStateFigureImpl();
        this.createExecutionCountLabel();
        ComponentInterface ci = ((WorkflowNode)this.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface();
        if (ci.getShape() == ComponentShape.CIRCLE) {
            this.stateFigure.setBounds(new Rectangle(1, 1, 22, 22));
            this.runCountLabel.setBounds(new Rectangle(19, 2, 15, 15));
            this.informationFigure.setBounds(new Rectangle(22, 20, 16, 16));
        } else if (ci.getSize() == ComponentSize.SMALL) {
            this.stateFigure.setBounds(new Rectangle(-2, -2, 22, 22));
            this.runCountLabel.setBounds(new Rectangle(16, -1, 21, 15));
            this.informationFigure.setBounds(new Rectangle(22, 22, 16, 16));
        } else {
            this.runCountLabel.setBounds(new Rectangle(22, 1, 50, 15));
            this.stateFigure.setBounds(new Rectangle(0, 0, 22, 22));
        }
        figure.add((IFigure)this.stateFigure);
        figure.add((IFigure)this.runCountLabel);
        figure.add(this.informationFigure);
        return figure;
    }

    private void createExecutionCountLabel() {
        this.runCountLabel = new Label("-");
        this.runCountLabel.setTextPlacement(17);
        this.runCountLabel.setTextAlignment(4);
        this.runCountLabel.setLabelAlignment(4);
        this.runCountLabel.setVisible(true);
        this.runCountLabel.setOpaque(false);
        this.runCountLabel.setToolTip((IFigure)new Label("Runs: -"));
    }

    @Override
    public void performRequest(Request req) {
        if (req.getType().equals("open")) {
            Job job = new Job("Opening view"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask("Retrieving workflow information", 2);
                        monitor.worked(1);
                        monitor.worked(2);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                WorkflowRunNodePart.this.openDefaultView();
                            }
                        });
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    @Override
    public Object getAdapter(Class type) {
        if (type == IPropertySource.class) {
            return new ComponentInstancePropertySource(this.getWorkflowExecutionInformation(), ((WorkflowNode)this.getModel()).getIdentifierAsObject());
        }
        return super.getAdapter(type);
    }

    private WorkflowExecutionInformation getWorkflowExecutionInformation() {
        return (WorkflowExecutionInformation)((WorkflowExecutionInformationPart)((WorkflowPart)this.getParent()).getParent()).getModel();
    }

    private ComponentExecutionInformation getComponentExecutionInformation() {
        return this.getWorkflowExecutionInformation().getComponentExecutionInformation(((WorkflowNode)this.getModel()).getIdentifierAsObject());
    }

    private void initializeStatus() {
        try {
            ComponentExecutionInformation compExeInfo = this.getComponentExecutionInformation();
            String stateNotifId = "rce.component.state:" + compExeInfo.getExecutionIdentifier();
            String iterationCountNotifId = "rce.component.noofruns:" + compExeInfo.getExecutionIdentifier();
            LogicalNodeId ctrlerNode = this.getWorkflowExecutionInformation().getNodeId();
            DistributedNotificationService notificationService = (DistributedNotificationService)ServiceRegistry.createAccessFor((Object)this).getService(DistributedNotificationService.class);
            notificationService.subscribe(stateNotifId, this.stateChangeListener, (ResolvableNodeId)ctrlerNode);
            List stateNotifications = (List)notificationService.getNotifications(stateNotifId, (ResolvableNodeId)ctrlerNode).get(stateNotifId);
            if (stateNotifications != null && stateNotifications.size() > 0) {
                this.handleStateNotification(this.getLastNonDisposedStateNotification(stateNotifications));
            }
            notificationService.subscribe(iterationCountNotifId, this.stateChangeListener, (ResolvableNodeId)ctrlerNode);
            List iterationCountNotifs = (List)notificationService.getNotifications(iterationCountNotifId, (ResolvableNodeId)ctrlerNode).get(iterationCountNotifId);
            if (iterationCountNotifs != null && iterationCountNotifs.size() > 0) {
                this.handleExecutionCountNotification((Notification)iterationCountNotifs.get(iterationCountNotifs.size() - 1));
            }
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Could not initialize status.", (Throwable)e);
        }
        catch (RemoteOperationException e) {
            LOGGER.error((Object)("Failed to register workflow state change listeners: " + e.getMessage()));
        }
    }

    private Notification getLastNonDisposedStateNotification(List<Notification> stateNotifications) {
        int i = 1;
        while (i <= stateNotifications.size()) {
            Notification notification = stateNotifications.get(stateNotifications.size() - i);
            ComponentState state = ComponentState.valueOf((String)((String)((Object)notification.getBody())));
            if (state != ComponentState.DISPOSED && state != ComponentState.DISPOSING) {
                return notification;
            }
            ++i;
        }
        return stateNotifications.get(stateNotifications.size() - 1);
    }

    private void openDefaultView() {
        final ComponentExecutionInformation cid = this.getComponentExecutionInformation();
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IConfigurationElement[] confElements = extReg.getConfigurationElementsFor("de.rcenvironment.core.gui.workflow.monitoring");
        IConfigurationElement[] viewConfElements = extReg.getConfigurationElementsFor("org.eclipse.ui.views");
        boolean foundRuntimeView = false;
        IConfigurationElement[] iConfigurationElementArray = confElements;
        int n = confElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElement = iConfigurationElementArray[n2];
            if (cid.getComponentIdentifier().startsWith(confElement.getAttribute("component")) && confElement.getAttribute("default") != null && Boolean.TRUE.toString().matches(confElement.getAttribute("default"))) {
                IConfigurationElement[] iConfigurationElementArray2 = viewConfElements;
                int n3 = viewConfElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement viewConfElement = iConfigurationElementArray2[n4];
                    if (viewConfElement.getAttribute("id").equals(confElement.getAttribute("view"))) {
                        try {
                            final IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewConfElement.getAttribute("class"), cid.getExecutionIdentifier(), 2);
                            ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                                @Override
                                @TaskDescription(value="Initialize component runtime view data")
                                public void run() {
                                    ((ComponentRuntimeView)view).initializeData(cid);
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((ComponentRuntimeView)view).initializeView();
                                        }
                                    });
                                }
                            });
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)view);
                            foundRuntimeView = true;
                            break;
                        }
                        catch (PartInitException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvalidRegistryObjectException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (!foundRuntimeView) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected synchronized void handleStateNotification(Notification notification) {
        long notificationNumber = notification.getHeader().getNumber();
        if (notificationNumber < this.lastStateNotificationNumber) {
            return;
        }
        try {
            ComponentState state = ComponentState.valueOf((String)((String)((Object)notification.getBody())));
            if (state != null && state != ComponentState.DISPOSING && state != ComponentState.DISPOSED) {
                this.batchAggregator.enqueue((Object)state);
                this.lastStateNotificationNumber = notificationNumber;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
    }

    protected void updateComponentState(final ComponentState state) {
        if (this.stateFigure != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    WorkflowRunNodePart.this.stateFigure.setState(state);
                    WorkflowRunNodePart.this.stateFigure.setToolTip((IFigure)new Label("State: " + state.getDisplayName()));
                }
            });
        }
    }

    protected synchronized void handleExecutionCountNotification(Notification notification) {
        long notificationNumber = notification.getHeader().getNumber();
        if (notificationNumber < this.lastIterationCountNotificationNumber) {
            return;
        }
        if (notification.getBody() instanceof String) {
            final String[] counts = StringUtils.splitAndUnescape((String)((String)((Object)notification.getBody())));
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (counts.length == 1) {
                        WorkflowRunNodePart.this.runCountLabel.setText(counts[0]);
                        WorkflowRunNodePart.this.runCountLabel.setToolTip((IFigure)new Label("Runs: " + counts[0]));
                    } else {
                        WorkflowRunNodePart.this.runCountLabel.setText(String.valueOf(String.valueOf(counts.length)) + "/" + String.valueOf(Integer.parseInt(counts[counts.length - 1]) - Integer.parseInt(counts[counts.length - 2])));
                        int innerLoopCount = 1;
                        int previousCount = 0;
                        String countString = "";
                        String[] stringArray = counts;
                        int n = counts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String count = stringArray[n2];
                            int countInt = Integer.parseInt(count);
                            countString = String.valueOf(countString) + innerLoopCount + "/" + (countInt - previousCount) + "\n";
                            ++innerLoopCount;
                            previousCount = countInt;
                            ++n2;
                        }
                        WorkflowRunNodePart.this.runCountLabel.setToolTip((IFigure)new Label("Nested loop run/component runs\n" + countString + "Total component runs: " + counts[counts.length - 1]));
                    }
                }
            });
            this.lastIterationCountNotificationNumber = notificationNumber;
        }
    }

    public static interface ComponentStateFigure
    extends IFigure {
        public void setState(ComponentState var1);

        public ComponentState getState();
    }

    public final class ComponentStateFigureImpl
    extends Panel
    implements ComponentStateFigure {
        private final ImageFigure innerImageFigure = new ImageFigure(Activator.getInstance().getImageRegistry().get(ComponentState.UNKNOWN.name()));
        private ComponentState state;

        public ComponentStateFigureImpl() {
            this.innerImageFigure.setOpaque(false);
            this.add((IFigure)this.innerImageFigure);
            this.setVisible(true);
            this.setOpaque(false);
        }

        public void setBounds(Rectangle rect) {
            super.setBounds(rect);
            Rectangle innerRectangleBounds = new Rectangle(rect.x + 3, rect.y + 3, rect.width - 6, rect.height - 6);
            this.innerImageFigure.setBounds(innerRectangleBounds);
        }

        @Override
        public void setState(ComponentState state) {
            if (this.state == state) {
                return;
            }
            this.state = state;
            Image stateImage = Activator.getInstance().getImageRegistry().get(state.name());
            if (stateImage != null) {
                this.innerImageFigure.setImage(stateImage);
            } else {
                this.innerImageFigure.setImage(Activator.getInstance().getImageRegistry().get(ComponentState.UNKNOWN.name()));
            }
            this.innerImageFigure.setOpaque(false);
            this.setVisible(true);
            this.setOpaque(false);
            WorkflowRunNodePart.this.refresh();
        }

        protected void paintFigure(Graphics graphics) {
        }

        @Override
        public ComponentState getState() {
            return this.state;
        }
    }
}

