/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.configuration.api.PlaceholdersMetaDataDefinition;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowPlaceholderHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.utils.common.components.PropertyTabGuiHelper;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.execute.Messages;
import de.rcenvironment.core.gui.workflow.execute.PlaceholderSortUtils;
import de.rcenvironment.core.gui.workflow.execute.WorkflowPageClearHistoryDialog;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class PlaceholderPage
extends WizardPage {
    private static final Color COLOR_WHITE = Display.getCurrent().getSystemColor(1);
    private static final Color COLOR_RED = Display.getCurrent().getSystemColor(3);
    private static final int HUNDRED = 100;
    private static final Log LOGGER = LogFactory.getLog(PlaceholderPage.class);
    private static final int SHORTTEXT_MAXLENGTH = 140;
    protected final WorkflowDescription workflowDescription;
    protected WorkflowPlaceholderHandler placeholderHelper;
    private Tree componentPlaceholderTree;
    private Map<Integer, Control> controlMap;
    private final String dot = ".";
    private Map<Integer, Button> saveButtonMap;
    private boolean restoredPasswords = false;
    private Map<Integer, String> treeItemNameToPlaceholder;
    private Map<Integer, String> treeItemToUUIDMap;
    private Map<String, Set<String>> placeholderValidators;

    public PlaceholderPage(WorkflowDescription workflowDescription) {
        super(Messages.workflowPageName);
        this.workflowDescription = workflowDescription;
        this.setTitle(Messages.workflowPageTitle);
        this.setDescription(Messages.configure);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)comp);
        IPreferenceStore prefs = Activator.getInstance().getPreferenceStore();
        String placeholderPersistentSettingsUUID = prefs.getString("placeholder_UUID");
        if (placeholderPersistentSettingsUUID.isEmpty()) {
            placeholderPersistentSettingsUUID = UUID.randomUUID().toString();
            prefs.putValue("placeholder_UUID", placeholderPersistentSettingsUUID);
        }
        this.placeholderHelper = WorkflowPlaceholderHandler.createPlaceholderDescriptionFromWorkflowDescription((WorkflowDescription)this.workflowDescription, (String)placeholderPersistentSettingsUUID);
        this.addPlaceholderGroup(comp);
        Button clearHistoryButton = new Button(comp, 0);
        clearHistoryButton.setText(Messages.clearHistoryButton);
        clearHistoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkflowPageClearHistoryDialog chd = new WorkflowPageClearHistoryDialog(PlaceholderPage.this.getShell(), Messages.clearHistoryDialogTitle, PlaceholderPage.this.placeholderHelper, PlaceholderPage.this.workflowDescription);
                chd.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (this.placeholderHelper.getIdentifiersOfPlaceholderContainingComponents().size() == 0) {
            clearHistoryButton.setEnabled(false);
        }
    }

    private void addPlaceholderGroup(Composite container) {
        this.controlMap = new HashMap<Integer, Control>();
        this.saveButtonMap = new HashMap<Integer, Button>();
        this.treeItemNameToPlaceholder = new HashMap<Integer, String>();
        this.treeItemToUUIDMap = new HashMap<Integer, String>();
        Group placeholderInformationGroup = new Group(container, 0);
        placeholderInformationGroup.setText(Messages.placeholderInformationHeader);
        placeholderInformationGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        placeholderInformationGroup.setLayoutData((Object)gridData);
        this.componentPlaceholderTree = new Tree((Composite)placeholderInformationGroup, 2);
        this.componentPlaceholderTree.setLayoutData((Object)gridData);
        this.componentPlaceholderTree.setHeaderVisible(true);
        this.componentPlaceholderTree.setLinesVisible(true);
        this.componentPlaceholderTree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 22;
            }
        });
        this.fillTree();
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                final TreeItem treeItem = (TreeItem)e.item;
                PlaceholderPage.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        treeItem.getParent().getColumn(0).pack();
                        treeItem.getParent().getColumn(0).setWidth(treeItem.getParent().getColumn(0).getWidth() + 10);
                    }
                });
            }
        };
        this.componentPlaceholderTree.addListener(18, listener);
        this.componentPlaceholderTree.addListener(17, listener);
        this.deleteEmptyTreeItems();
        this.openItems();
        this.componentPlaceholderTree.getColumn(0).pack();
        this.componentPlaceholderTree.getColumn(0).setWidth(this.componentPlaceholderTree.getColumn(0).getWidth() + 10);
    }

    private void deleteEmptyTreeItems() {
        TreeItem[] treeItemArray = this.componentPlaceholderTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem tItem = treeItemArray[n2];
            int itemCount = 0;
            TreeItem[] treeItemArray2 = tItem.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem childItem = treeItemArray2[n4];
                ++itemCount;
                if (childItem.getItemCount() > 0) {
                    itemCount += childItem.getItemCount();
                } else if (this.treeItemNameToPlaceholder.containsKey(tItem.hashCode())) {
                    ++itemCount;
                } else {
                    childItem.dispose();
                    --itemCount;
                }
                ++n4;
            }
            if (itemCount <= 1) {
                tItem.dispose();
            }
            ++n2;
        }
    }

    private void openItems() {
        TreeItem[] treeItemArray = this.componentPlaceholderTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem parent = treeItemArray[n2];
            TreeItem[] treeItemArray2 = parent.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem secondLevel = treeItemArray2[n4];
                if (secondLevel.getItemCount() == 0) {
                    Control control = this.controlMap.get(secondLevel.hashCode());
                    if (control instanceof Text) {
                        Text cfr_ignored_0 = (Text)control;
                        parent.setExpanded(true);
                    }
                } else {
                    TreeItem[] treeItemArray3 = secondLevel.getItems();
                    int n5 = treeItemArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        TreeItem thirdLevel = treeItemArray3[n6];
                        Control control = this.controlMap.get(thirdLevel.hashCode());
                        if (control instanceof Text) {
                            Text cfr_ignored_1 = (Text)control;
                            parent.setExpanded(true);
                            secondLevel.setExpanded(true);
                        } else if (control instanceof Combo) {
                            Combo cfr_ignored_2 = (Combo)control;
                            parent.setExpanded(true);
                            secondLevel.setExpanded(true);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void fillTree() {
        TreeColumn column1 = new TreeColumn(this.componentPlaceholderTree, 16384);
        column1.setText("");
        TreeColumn column2 = new TreeColumn(this.componentPlaceholderTree, 0x1000000);
        column2.setText("");
        column2.setWidth(105);
        TreeColumn column3 = new TreeColumn(this.componentPlaceholderTree, 0x1000000);
        column3.setText("");
        column3.setWidth(50);
        TreeColumn column4 = new TreeColumn(this.componentPlaceholderTree, 0x1000000);
        column4.setText("");
        column4.setWidth(100);
        this.placeholderValidators = new HashMap<String, Set<String>>();
        Set componentTypesWithPlaceholder = this.placeholderHelper.getIdentifiersOfPlaceholderContainingComponents();
        Object[] componentTypesWithPlaceholderArray = componentTypesWithPlaceholder.toArray(new String[componentTypesWithPlaceholder.size()]);
        Arrays.sort(componentTypesWithPlaceholderArray);
        Object[] objectArray = componentTypesWithPlaceholderArray;
        int n = componentTypesWithPlaceholderArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object componentID = objectArray[n2];
            TreeItem componentIDTreeItem = new TreeItem(this.componentPlaceholderTree, 0);
            String componentName = this.workflowDescription.getWorkflowNode((String)this.placeholderHelper.getComponentInstances((String)componentID).get(0)).getName();
            String abstractComponentName = this.workflowDescription.getWorkflowNode((String)this.placeholderHelper.getComponentInstances((String)componentID).get(0)).getComponentDescription().getName();
            componentIDTreeItem.setText(0, abstractComponentName);
            componentIDTreeItem.setImage(PlaceholderPage.getImage(this.workflowDescription.getWorkflowNode((String)this.placeholderHelper.getComponentInstances((String)componentID).get(0))));
            PlaceholdersMetaDataDefinition placeholderMetaData = this.getPlaceholderAttributes(componentName);
            List<String> globalPlaceholderOrder = PlaceholderSortUtils.getPlaceholderOrder(this.placeholderHelper.getPlaceholderNameSetOfComponentID((String)componentID), placeholderMetaData);
            if (globalPlaceholderOrder == null) {
                globalPlaceholderOrder = new LinkedList<String>();
            }
            for (String componentPlaceholder : globalPlaceholderOrder) {
                TreeItem compPHTreeItem = new TreeItem(componentIDTreeItem, 0);
                String guiName = placeholderMetaData.getGuiName(componentPlaceholder);
                if (guiName == null) {
                    guiName = "";
                }
                this.treeItemNameToPlaceholder.put(compPHTreeItem.hashCode(), componentPlaceholder);
                compPHTreeItem.setText(0, guiName);
                String currentPlaceholder = String.valueOf(componentID) + "." + componentPlaceholder;
                this.controlMap.put(compPHTreeItem.hashCode(), this.addSWTHandler(compPHTreeItem, String.valueOf(componentName) + "." + componentPlaceholder, guiName, ComponentUtils.isEncryptedPlaceholder((String)currentPlaceholder, (List)WorkflowPlaceholderHandler.getEncryptedPlaceholder()), true));
            }
            List<String> instancesWithPlaceholder = this.placeholderHelper.getComponentInstances((String)componentID);
            instancesWithPlaceholder = PlaceholderSortUtils.sortInstancesWithPlaceholderByName(instancesWithPlaceholder, this.workflowDescription);
            for (String compInstances : instancesWithPlaceholder) {
                ConfigurationDescription configDesc = this.workflowDescription.getWorkflowNode(compInstances).getComponentDescription().getConfigurationDescription();
                boolean hasPlaceholderWithGUIName = false;
                for (String instancePlaceholder : this.placeholderHelper.getPlaceholderNameSetOfComponentInstance(compInstances)) {
                    boolean isActivePlaceholder = WorkflowPlaceholderHandler.isActivePlaceholder((String)instancePlaceholder, (ConfigurationDescription)configDesc);
                    if (!isActivePlaceholder) continue;
                    if (placeholderMetaData.getGuiName(instancePlaceholder) != null && !placeholderMetaData.getGuiName(instancePlaceholder).isEmpty() || placeholderMetaData.getGuiName("*") != null) {
                        hasPlaceholderWithGUIName = true;
                        continue;
                    }
                    for (Map.Entry entry : configDesc.getConfiguration().entrySet()) {
                        if (!ConfigurationDescription.isPlaceholder((String)((String)entry.getValue())) || !WorkflowPlaceholderHandler.getNameOfPlaceholder((String)((String)entry.getValue())).equals(instancePlaceholder)) continue;
                        hasPlaceholderWithGUIName = true;
                    }
                    if (hasPlaceholderWithGUIName) continue;
                    LOGGER.warn((Object)StringUtils.format((String)"Placeholder %s of component %s has no GUI name defined and will be ignored.", (Object[])new Object[]{instancePlaceholder, this.workflowDescription.getWorkflowNode(compInstances).getComponentDescription().getName()}));
                }
                if (!hasPlaceholderWithGUIName) continue;
                TreeItem instanceTreeItem = new TreeItem(componentIDTreeItem, 0);
                String instanceName = this.workflowDescription.getWorkflowNode(compInstances).getName();
                instanceTreeItem.setText(0, instanceName);
                instanceTreeItem.setImage(PlaceholderPage.getImage(this.workflowDescription.getWorkflowNode((String)this.placeholderHelper.getComponentInstances((String)componentID).get(0))));
                List<String> orderedIinstancePlaceholder = PlaceholderSortUtils.getPlaceholderOrder(this.placeholderHelper.getPlaceholderNameSetOfComponentInstance(compInstances), placeholderMetaData);
                for (String instancePlaceholder : orderedIinstancePlaceholder) {
                    boolean isActivePlaceholder = WorkflowPlaceholderHandler.isActivePlaceholder((String)instancePlaceholder, (ConfigurationDescription)configDesc);
                    if (!isActivePlaceholder) continue;
                    TreeItem instancePHTreeItem = new TreeItem(instanceTreeItem, 0);
                    this.treeItemToUUIDMap.put(instancePHTreeItem.hashCode(), compInstances);
                    String guiName = placeholderMetaData.getGuiName(instancePlaceholder);
                    if (guiName == null) {
                        guiName = instancePlaceholder;
                    }
                    this.treeItemNameToPlaceholder.put(instancePHTreeItem.hashCode(), instancePlaceholder);
                    instancePHTreeItem.setText(0, guiName);
                    String currentPlaceholder = String.valueOf(componentID) + "." + instancePlaceholder;
                    this.controlMap.put(instancePHTreeItem.hashCode(), this.addSWTHandler(instancePHTreeItem, String.valueOf(instanceName) + "." + instancePlaceholder, guiName, ComponentUtils.isEncryptedPlaceholder((String)currentPlaceholder, (List)WorkflowPlaceholderHandler.getEncryptedPlaceholder()), false));
                }
            }
            ++n2;
        }
        this.placeApplyToAllButtonsWhereNecessary(this.componentPlaceholderTree);
        column1.pack();
    }

    private Control addSWTHandler(TreeItem item, String placeholderName, final String guiName, boolean isEncrypted, boolean isGlobal) {
        boolean isShorttext;
        TreeEditor textEditor = new TreeEditor(item.getParent());
        Combo booleanCombo = null;
        String finalProposal = null;
        textEditor.horizontalAlignment = 16384;
        textEditor.grabHorizontal = true;
        int style = 2052;
        boolean isPathField = false;
        boolean isBoolean = false;
        boolean isInteger = false;
        boolean isFloat = false;
        String dataType = (String)this.placeholderHelper.getPlaceholdersDataType().get(placeholderName);
        final String componentName = placeholderName.split("\\.")[0];
        if (dataType != null) {
            if (dataType.equals("file") || dataType.equals("dir")) {
                isPathField = true;
            } else if (dataType.equals("bool")) {
                booleanCombo = PlaceholderPage.addBooleanCombo(item);
                isBoolean = true;
            } else if (dataType.equals("int")) {
                isInteger = true;
            } else if (dataType.equals("float")) {
                isFloat = true;
            }
        }
        if (isEncrypted) {
            style |= 0x400000;
        }
        Text placeholderText = new Text((Composite)item.getParent(), style);
        boolean bl = isShorttext = !isFloat && !isInteger && !isBoolean && !isPathField;
        if (!isShorttext) {
            placeholderText.setMessage("No value entered.");
        }
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PlaceholderPage.this.validateInput((Text)e.getSource(), componentName, guiName, isShorttext);
            }
        };
        placeholderText.addModifyListener(modifyListener);
        if (!this.restoredPasswords && isEncrypted) {
            WorkflowPlaceholderHandler.restorePasswords((Map)this.placeholderHelper.getComponentInstanceHistory());
            WorkflowPlaceholderHandler.restorePasswords((Map)this.placeholderHelper.getComponentTypeHistory());
            this.restoredPasswords = true;
        }
        String[] allProposals = new String[]{};
        allProposals = !isGlobal ? this.placeholderHelper.getInstancePlaceholderHistory(this.treeItemNameToPlaceholder.get(item.hashCode()), this.treeItemToUUIDMap.get(item.hashCode())) : this.placeholderHelper.getComponentPlaceholderHistory(this.treeItemNameToPlaceholder.get(item.hashCode()), this.getComponentIDByName(item.getParentItem().getText()), this.workflowDescription.getIdentifier());
        if (allProposals.length > 0) {
            if (isEncrypted) {
                byte[] decoded = new Base64().decode(allProposals[allProposals.length - 1]);
                try {
                    allProposals[allProposals.length - 1] = new String(decoded, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.warn((Object)("Could not decode placeholder " + placeholderName), (Throwable)e);
                }
            }
            finalProposal = allProposals[allProposals.length - 1];
        }
        String[] additionalProposals = this.placeholderHelper.getOtherPlaceholderHistoryValues(this.treeItemNameToPlaceholder.get(item.hashCode()));
        if (allProposals.length == 0) {
            allProposals = additionalProposals;
            if (!isEncrypted && allProposals.length > 0) {
                String valueFromOtherComponentInWorkflow = this.placeholderHelper.getValueFromOtherComponentInWorkflow(this.treeItemNameToPlaceholder.get(item.hashCode()), this.workflowDescription.getIdentifier());
                finalProposal = valueFromOtherComponentInWorkflow != null ? valueFromOtherComponentInWorkflow : allProposals[allProposals.length - 1];
            }
        } else {
            allProposals = additionalProposals;
        }
        if (finalProposal != null && !finalProposal.equals("")) {
            if (!isBoolean) {
                placeholderText.setText(finalProposal);
            } else if (booleanCombo != null) {
                booleanCombo.setText(finalProposal);
            }
        }
        if (isEncrypted) {
            allProposals = new String[]{};
        }
        SimpleContentProposalProvider scp = new SimpleContentProposalProvider(allProposals);
        scp.setFiltering(true);
        ContentProposalAdapter adapter = null;
        adapter = new ContentProposalAdapter((Control)placeholderText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)scp, KeyStroke.getInstance((int)0x1000002), null);
        adapter.setProposalAcceptanceStyle(2);
        adapter.setAutoActivationDelay(1);
        adapter.setPropagateKeys(true);
        if (isPathField) {
            this.addFileChooser(item, dataType, placeholderText);
        }
        if (isBoolean) {
            textEditor.setEditor((Control)booleanCombo, item, 1);
            return booleanCombo;
        }
        if (PlaceholderPage.isTextEmpty(placeholderText) && !isShorttext) {
            this.addPlaceholderValidator(componentName, guiName);
            placeholderText.setBackground(COLOR_RED);
        }
        textEditor.setEditor((Control)placeholderText, item, 1);
        if (isEncrypted) {
            this.addSaveButton(item, placeholderText);
        }
        if (isFloat) {
            NumericalTextConstraintListener floatListener = new NumericalTextConstraintListener(placeholderText, 1);
            placeholderText.addVerifyListener((VerifyListener)floatListener);
        }
        if (isInteger) {
            NumericalTextConstraintListener integerListener = new NumericalTextConstraintListener(placeholderText, 2);
            placeholderText.addVerifyListener((VerifyListener)integerListener);
        }
        return placeholderText;
    }

    private void addSaveButton(TreeItem item, Text placeholderText) {
        TreeEditor checkButton = new TreeEditor(item.getParent());
        checkButton.horizontalAlignment = 16384;
        checkButton.grabHorizontal = true;
        Button checkForSaveButton = new Button((Composite)item.getParent(), 32);
        checkForSaveButton.setText("Save");
        checkButton.minimumWidth = checkForSaveButton.getSize().x;
        checkButton.setEditor((Control)checkForSaveButton, item, 2);
        this.saveButtonMap.put(item.hashCode(), checkForSaveButton);
        if (placeholderText.getText() != null && !placeholderText.getText().equals("")) {
            checkForSaveButton.setSelection(true);
        }
    }

    private void placeApplyToAllButtonsWhereNecessary(Tree baseTree) {
        Map placeholderDataTypes = this.placeholderHelper.getPlaceholdersDataType();
        TreeItem[] treeItemArray = baseTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem componentTree = treeItemArray[n2];
            ArrayList<ExtendedTreeItem> componentKeyValues = new ArrayList<ExtendedTreeItem>();
            TreeItem[] treeItemArray2 = componentTree.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem instanceItem = treeItemArray2[n4];
                TreeItem[] treeItemArray3 = instanceItem.getItems();
                int n5 = treeItemArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    TreeItem keyValue = treeItemArray3[n6];
                    String dataType = (String)placeholderDataTypes.get(String.valueOf(instanceItem.getText()) + "." + this.treeItemNameToPlaceholder.get(keyValue.hashCode()));
                    componentKeyValues.add(new ExtendedTreeItem(keyValue, dataType));
                    ++n6;
                }
                ++n4;
            }
            Map groupedTreeItems = componentKeyValues.stream().collect(Collectors.groupingBy(extendedItem -> extendedItem.treeItem.getText(), Collectors.groupingBy(extendedItem -> extendedItem.dataType, Collectors.toSet())));
            for (Map treeItemGroupByPlaceholderName : groupedTreeItems.values()) {
                for (Set treeItemGroup : treeItemGroupByPlaceholderName.values()) {
                    if (treeItemGroup.size() <= 1) continue;
                    for (ExtendedTreeItem equivalentTreeItem : treeItemGroup) {
                        this.addApplyToAllButton(equivalentTreeItem, componentKeyValues);
                    }
                }
            }
            ++n2;
        }
    }

    private void addPlaceholderValidator(String componentName, String placeholderName) {
        Set<String> placeholderNames = this.placeholderValidators.get(componentName);
        if (placeholderNames == null) {
            placeholderNames = new HashSet<String>();
        }
        placeholderNames.add(placeholderName);
        this.placeholderValidators.put(componentName, placeholderNames);
    }

    private void removePlaceholderValidator(String componentName, String placeholderName) {
        Set<String> placeholderNames = this.placeholderValidators.get(componentName);
        placeholderNames.remove(placeholderName);
        if (placeholderNames.isEmpty()) {
            this.placeholderValidators.remove(componentName);
        }
    }

    private void addApplyToAllButton(ExtendedTreeItem extendedTreeItem, List<ExtendedTreeItem> allItems) {
        TreeEditor buttonEditor = new TreeEditor(extendedTreeItem.treeItem.getParent());
        buttonEditor.horizontalAlignment = 16384;
        buttonEditor.grabHorizontal = true;
        Button placeholderButton = new Button((Composite)extendedTreeItem.treeItem.getParent(), 8);
        placeholderButton.setToolTipText(Messages.applyToAllToolTip);
        placeholderButton.setText(Messages.applyToAll);
        placeholderButton.setSize(placeholderButton.getText().length() * 6, 0);
        placeholderButton.computeSize(-1, extendedTreeItem.treeItem.getParent().getItemHeight());
        placeholderButton.addSelectionListener((SelectionListener)new ButtonListener(extendedTreeItem, allItems));
        buttonEditor.minimumWidth = placeholderButton.getSize().x;
        buttonEditor.setEditor((Control)placeholderButton, extendedTreeItem.treeItem, 3);
    }

    private void addFileChooser(TreeItem item, final String dataType, final Text placeholderText) {
        TreeEditor pathButtonEditor = new TreeEditor(item.getParent());
        pathButtonEditor.horizontalAlignment = 16384;
        pathButtonEditor.grabHorizontal = true;
        Button pathChooserButton = new Button((Composite)item.getParent(), 8);
        pathChooserButton.setText("...");
        pathChooserButton.setSize(pathChooserButton.getText().length() * 6, 0);
        pathChooserButton.computeSize(-1, item.getParent().getItemHeight());
        pathButtonEditor.minimumWidth = pathChooserButton.getSize().x;
        pathChooserButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String selectedPath = dataType.equals("dir") ? PropertyTabGuiHelper.selectDirectoryFromFileSystem((Shell)PlaceholderPage.this.getShell(), (String)"Open path...") : PropertyTabGuiHelper.selectFileFromFileSystem((Shell)PlaceholderPage.this.getShell(), (String[])new String[0], (String)"Open path...");
                if (selectedPath != null) {
                    placeholderText.setText(selectedPath);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        pathButtonEditor.setEditor((Control)pathChooserButton, item, 2);
    }

    private static Combo addBooleanCombo(TreeItem item) {
        Combo combo = new Combo((Composite)item.getParent(), 8);
        combo.add(Boolean.TRUE.toString().toLowerCase());
        combo.add(Boolean.FALSE.toString().toLowerCase());
        combo.setText(Boolean.TRUE.toString().toLowerCase());
        return combo;
    }

    private static Image getImage(WorkflowNode element) {
        byte[] icon = element.getComponentDescription().getIcon16();
        Image image = icon != null ? new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(icon)) : Activator.getInstance().getImageRegistry().get("de.rcenvironment.rce.icon.16");
        return image;
    }

    private String getControlText(int id) {
        Control control = this.controlMap.get(id);
        String text = null;
        if (control instanceof Text) {
            Text current = (Text)control;
            text = current.getText();
        } else if (control instanceof Combo) {
            Combo current = (Combo)control;
            text = current.getText();
        }
        return text;
    }

    protected Control getControl(int id) {
        Control control = this.controlMap.get(id);
        return control;
    }

    private static boolean isTextEmpty(Text source) {
        return source.getText() == null || source.getText().equals("");
    }

    protected void validateInput(Text source, String componentName, String placeholderName, boolean isShorttext) {
        if ((!PlaceholderPage.isTextEmpty(source) || isShorttext) && source.getText().length() <= 140) {
            if (source.getBackground().equals((Object)COLOR_RED)) {
                source.setBackground(COLOR_WHITE);
                this.removePlaceholderValidator(componentName, placeholderName);
            }
        } else {
            source.setBackground(COLOR_RED);
            this.addPlaceholderValidator(componentName, placeholderName);
        }
    }

    public boolean validateErrors() {
        return !this.placeholderValidators.isEmpty();
    }

    public int getErrorAmount() {
        return this.placeholderValidators.size();
    }

    public Map<String, String> getComponentNamesWithError(boolean indicator) {
        Set<String> componentNames = this.placeholderValidators.keySet();
        HashMap<String, String> newComponentNames = new HashMap<String, String>();
        for (String name : componentNames) {
            String additionalInfos = "";
            if (indicator) {
                additionalInfos = " " + Messages.missingPlaceholder;
            }
            newComponentNames.put(name, additionalInfos);
        }
        return newComponentNames;
    }

    protected void performFinish() {
        TreeItem[] treeItemArray = this.componentPlaceholderTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem componentItems = treeItemArray[n2];
            TreeItem[] treeItemArray2 = componentItems.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem componentIDItems = treeItemArray2[n4];
                if (componentIDItems.getItemCount() == 0) {
                    for (String fullPlaceholder : this.placeholderHelper.getPlaceholderOfComponent(this.getComponentIDByName(componentItems.getText()))) {
                        if (!WorkflowPlaceholderHandler.getNameOfPlaceholder((String)fullPlaceholder).equals(this.treeItemNameToPlaceholder.get(componentIDItems.hashCode()))) continue;
                        boolean addToHistory = true;
                        if (this.saveButtonMap.get(componentIDItems.hashCode()) != null) {
                            addToHistory = this.saveButtonMap.get(componentIDItems.hashCode()).getSelection();
                        }
                        this.placeholderHelper.setGlobalPlaceholderValue(fullPlaceholder, this.getComponentIDByName(componentItems.getText()), this.getControlText(componentIDItems.hashCode()), this.workflowDescription.getIdentifier(), addToHistory);
                    }
                } else {
                    TreeItem[] treeItemArray3 = componentIDItems.getItems();
                    int n5 = treeItemArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        TreeItem instancePlaceholderItems = treeItemArray3[n6];
                        for (String fullPlaceholder : this.placeholderHelper.getPlaceholderNamesOfComponentInstance(this.treeItemToUUIDMap.get(instancePlaceholderItems.hashCode()))) {
                            if (!WorkflowPlaceholderHandler.getNameOfPlaceholder((String)fullPlaceholder).equals(this.treeItemNameToPlaceholder.get(instancePlaceholderItems.hashCode()))) continue;
                            boolean addToHistory = true;
                            if (this.saveButtonMap.get(instancePlaceholderItems.hashCode()) != null) {
                                addToHistory = this.saveButtonMap.get(instancePlaceholderItems.hashCode()).getSelection();
                            }
                            this.placeholderHelper.setPlaceholderValue(fullPlaceholder, this.getComponentIDByName(componentIDItems.getText()), this.treeItemToUUIDMap.get(instancePlaceholderItems.hashCode()), this.getControlText(instancePlaceholderItems.hashCode()), this.workflowDescription.getIdentifier(), addToHistory);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void savePlaceholdersToPersistentSettings() {
        IPreferenceStore prefs;
        String placeholderPersistentSettingsUUID;
        if (WorkflowPlaceholderHandler.getPlaceholderPersistentSettingsUUID() == null && (placeholderPersistentSettingsUUID = (prefs = Activator.getInstance().getPreferenceStore()).getString("placeholder_UUID")).isEmpty()) {
            WorkflowPlaceholderHandler.setPlaceholderPersistentSettingsUUID((String)UUID.randomUUID().toString());
            prefs.putValue("placeholder_UUID", placeholderPersistentSettingsUUID);
        }
        this.placeholderHelper.saveHistory();
    }

    protected Map<String, Map<String, String>> getPlaceholders() {
        HashMap<String, Map<String, String>> placeholdersMap = new HashMap<String, Map<String, String>>();
        for (WorkflowNode wn : this.workflowDescription.getWorkflowNodes()) {
            Map compInstPlaceholders;
            HashMap placeholders = new HashMap();
            Map compTypePlaceholders = this.placeholderHelper.getPlaceholdersOfComponentType(wn.getComponentDescription().getIdentifier());
            if (compTypePlaceholders != null) {
                placeholders.putAll(compTypePlaceholders);
            }
            if ((compInstPlaceholders = this.placeholderHelper.getPlaceholdersOfComponentInstance(wn.getIdentifier())) != null) {
                placeholders.putAll(compInstPlaceholders);
            }
            placeholdersMap.put(wn.getIdentifier(), placeholders);
        }
        return placeholdersMap;
    }

    private String getComponentIDByName(String name) {
        for (WorkflowNode wn : this.workflowDescription.getWorkflowNodes()) {
            if (!wn.getName().equals(name)) continue;
            return wn.getComponentDescription().getIdentifier();
        }
        return null;
    }

    private PlaceholdersMetaDataDefinition getPlaceholderAttributes(String name) {
        for (WorkflowNode wn : this.workflowDescription.getWorkflowNodes()) {
            if (!wn.getName().equals(name)) continue;
            return wn.getComponentDescription().getConfigurationDescription().getComponentConfigurationDefinition().getPlaceholderMetaDataDefinition();
        }
        return null;
    }

    public Map<String, Set<String>> getPlaceholderValidators() {
        return this.placeholderValidators;
    }

    protected boolean canFinish() {
        if (this.componentPlaceholderTree != null) {
            return this.componentPlaceholderTree.getItemCount() == 0;
        }
        return false;
    }

    public void dispose() {
        for (Integer key : this.controlMap.keySet()) {
            this.controlMap.get(key).dispose();
        }
        this.componentPlaceholderTree.dispose();
        super.dispose();
    }

    private class ButtonListener
    extends SelectionAdapter {
        private ExtendedTreeItem extendedTreeItem;
        private List<ExtendedTreeItem> allItems;

        ButtonListener(ExtendedTreeItem extendedTreeItem, List<ExtendedTreeItem> allItems) {
            this.extendedTreeItem = extendedTreeItem;
            this.allItems = allItems;
        }

        public void widgetSelected(SelectionEvent event) {
            Control treeItemControl = PlaceholderPage.this.getControl(this.extendedTreeItem.treeItem.hashCode());
            String valueToBeCoppied = null;
            if (treeItemControl instanceof Text) {
                valueToBeCoppied = ((Text)treeItemControl).getText();
            } else if (treeItemControl instanceof Combo) {
                valueToBeCoppied = ((Combo)treeItemControl).getText();
            }
            if (valueToBeCoppied != null && !valueToBeCoppied.isEmpty()) {
                int i = 0;
                while (i < this.allItems.size()) {
                    if (this.extendedTreeItem.treeItem.getText().equals(this.allItems.get((int)i).treeItem.getText())) {
                        Control toReplaceItem;
                        if (this.extendedTreeItem.dataType == null && this.allItems.get((int)i).dataType == null) {
                            toReplaceItem = PlaceholderPage.this.getControl(this.allItems.get((int)i).treeItem.hashCode());
                            if (toReplaceItem instanceof Text) {
                                ((Text)toReplaceItem).setText(valueToBeCoppied);
                            } else if (toReplaceItem instanceof Combo) {
                                ((Combo)toReplaceItem).select(((Combo)treeItemControl).indexOf(valueToBeCoppied));
                            }
                        } else if (this.extendedTreeItem.dataType.equals(this.allItems.get((int)i).dataType)) {
                            toReplaceItem = PlaceholderPage.this.getControl(this.allItems.get((int)i).treeItem.hashCode());
                            if (toReplaceItem instanceof Text) {
                                ((Text)toReplaceItem).setText(valueToBeCoppied);
                            } else if (toReplaceItem instanceof Combo) {
                                ((Combo)toReplaceItem).select(((Combo)treeItemControl).indexOf(valueToBeCoppied));
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private final class ExtendedTreeItem {
        public final TreeItem treeItem;
        public final String dataType;

        ExtendedTreeItem(TreeItem treeItem, String dataType) {
            this.treeItem = treeItem;
            this.dataType = dataType;
        }
    }
}

