/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.management.api.LocalComponentRegistrationService;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInstallationBuilder;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.spi.DistributedComponentKnowledgeListener;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessageStore;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.resources.api.ComponentImageManager;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.common.EditorsHelper;
import de.rcenvironment.core.gui.utils.incubator.ContextMenuItemRemover;
import de.rcenvironment.core.gui.wizards.toolintegration.ShowIntegrationEditWizardHandler;
import de.rcenvironment.core.gui.wizards.toolintegration.ShowIntegrationRemoveHandler;
import de.rcenvironment.core.gui.wizards.toolintegration.ShowIntegrationWizardHandler;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.GUIWorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.gui.workflow.WorkflowNodeLabelConnectionHelper;
import de.rcenvironment.core.gui.workflow.editor.Messages;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditorContextMenuProvider;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditorHelpContextProvider;
import de.rcenvironment.core.gui.workflow.editor.WorkflowNodeFactory;
import de.rcenvironment.core.gui.workflow.editor.WorkflowPaletteFactory;
import de.rcenvironment.core.gui.workflow.editor.WorkflowScalableFreeformRootEditPart;
import de.rcenvironment.core.gui.workflow.editor.WorkflowZoomManager;
import de.rcenvironment.core.gui.workflow.editor.commands.WorkflowNodeDeleteCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.WorkflowNodeLabelConnectionCreateCommand;
import de.rcenvironment.core.gui.workflow.editor.documentation.ToolIntegrationDocumentationGUIHelper;
import de.rcenvironment.core.gui.workflow.editor.handlers.OpenConnectionEditorHandler;
import de.rcenvironment.core.gui.workflow.editor.handlers.OpenConnectionsViewHandler;
import de.rcenvironment.core.gui.workflow.editor.validator.WorkflowDescriptionValidationUtils;
import de.rcenvironment.core.gui.workflow.parts.ConnectionPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowEditorEditPartFactory;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowPart;
import de.rcenvironment.core.gui.workflow.view.outline.OutlineView;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ToggleSnapToGeometryAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class WorkflowEditor
extends GraphicalEditorWithFlyoutPalette
implements ITabbedPropertySheetPageContributor,
DistributedComponentKnowledgeListener {
    public static final int PROP_FINAL_WORKFLOW_DESCRIPTION_SET = 768;
    public static final int PROP_WORKFLOW_VAILDATION_FINISHED = 1024;
    public static final String COMPONENTNAMES_WITH_VERSION = " (%s)";
    public static final String SHOW_LABELS_PREFERENCE_KEY = "showConnections";
    public static final String DRAG_STATE_BENDPOINT = "DRAG_STATE_BENDPOINT";
    protected static final int DEFAULT_TOLERANCE = 10;
    private static final int MOVEMENT = 1;
    private static final String REMOTEACCESS = "remoteaccess";
    private static final Log LOGGER = LogFactory.getLog(WorkflowEditor.class);
    private static final char SELECTION_KEYCODE = 's';
    private static final char CONNECTION_KEYCODE = 'd';
    private static final char OPEN_CONNECTION_VIEW_KEYCODE = 'c';
    private static final String MENU_LISTENER_MARKER = "MENU_LISTENER_MARKER";
    private static final String TOOL_DEACTIVATE_LABEL = "Deactivate Tool...";
    private static final String TOOL_EDIT_LABEL = "Edit Tool...";
    private static final String TOOL_INTEGRATE_LABEL = "Integrate Tool...";
    private static final String TOOLINTEGRATION_ITEM = "toolIntegrationItem";
    private static final int MINUS_ONE = -1;
    private static final int UNDO_LIMIT = 10;
    private static final int TILE_OFFSET = 30;
    private static final int TILE_SIZE = 60;
    private static final int MAXIMUM_LOCAL_COMPONENT_LOADING_WAIT_SECONDS = 20;
    protected final ServiceRegistryPublisherAccess serviceRegistryAccess;
    protected final WorkflowExecutionService workflowExecutionService;
    protected final LocalComponentRegistrationService localComponentRegistrationService;
    protected WorkflowDescription workflowDescription;
    private boolean allLabelsShown = false;
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private GraphicalViewer viewer;
    private PaletteRoot paletteRoot;
    private MenuItem toolIntegrationPaletteMenuItem;
    private MenuItem editToolPaletteMenuItem;
    private MenuItem deactivateToolPaletteMenuItem;
    private MenuItem documentationToolPaletteMenuItem;
    private PaletteViewer paletteViewer = null;
    private ConnectionCreationToolEntry connectionCreationToolEntry = null;
    private int mouseX;
    private int mouseY;
    private final ToolIntegrationContextRegistry toolIntegrationRegistry;
    private ResourceTracker resourceListener = new ResourceTracker();

    public WorkflowEditor() {
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)((Object)this));
        this.toolIntegrationRegistry = (ToolIntegrationContextRegistry)this.serviceRegistryAccess.getService(ToolIntegrationContextRegistry.class);
        this.workflowExecutionService = (WorkflowExecutionService)this.serviceRegistryAccess.getService(WorkflowExecutionService.class);
        this.localComponentRegistrationService = (LocalComponentRegistrationService)this.serviceRegistryAccess.getService(LocalComponentRegistrationService.class);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public WorkflowDescription getWorkflowDescription() {
        return this.workflowDescription;
    }

    private void switchToConnectionTool() {
        if (this.connectionCreationToolEntry == null) {
            for (Object paletteGroupObject : this.paletteViewer.getPaletteRoot().getChildren()) {
                if (!(paletteGroupObject instanceof PaletteGroup)) continue;
                PaletteGroup paletteGroup = (PaletteGroup)paletteGroupObject;
                for (Object paletteEntryObject : paletteGroup.getChildren()) {
                    ConnectionCreationToolEntry entry;
                    if (!(paletteEntryObject instanceof ConnectionCreationToolEntry)) continue;
                    this.connectionCreationToolEntry = entry = (ConnectionCreationToolEntry)paletteEntryObject;
                    this.paletteViewer.setActiveTool((ToolEntry)entry);
                }
            }
        } else {
            this.paletteViewer.setActiveTool((ToolEntry)this.connectionCreationToolEntry);
        }
    }

    private void switchToSelectionTool() {
        this.paletteViewer.setActiveTool(this.paletteViewer.getPaletteRoot().getDefaultEntry());
    }

    public PaletteViewer getPaletteViewer() {
        return this.paletteViewer;
    }

    public CommandStack getEditorsCommandStack() {
        return this.getCommandStack();
    }

    private void openConnectionEditor() {
        OpenConnectionsViewHandler openConnectionViewHandler = new OpenConnectionsViewHandler();
        try {
            openConnectionViewHandler.execute(new ExecutionEvent());
        }
        catch (ExecutionException e1) {
            e1.printStackTrace();
        }
    }

    protected PaletteRoot getPaletteRoot() {
        final ArrayList<DistributedComponentEntry> componentInstallations = new ArrayList<DistributedComponentEntry>();
        IProgressService service = (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
        try {
            service.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Messages.fetchingComponents, 3);
                        monitor.worked(2);
                        componentInstallations.addAll(WorkflowEditor.this.getInitialComponentKnowledge().getAllInstallations());
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        WorkflowPaletteFactory factory = new WorkflowPaletteFactory();
        this.paletteRoot = factory.createPalette(componentInstallations);
        return this.paletteRoot;
    }

    protected void initializeGraphicalViewer() {
        this.viewer = this.getGraphicalViewer();
        WorkflowScalableFreeformRootEditPart rootEditPart = new WorkflowScalableFreeformRootEditPart();
        this.viewer.setRootEditPart((RootEditPart)rootEditPart);
        this.viewer.setEditPartFactory((EditPartFactory)new WorkflowEditorEditPartFactory());
        this.getCommandStack().setUndoLimit(10);
        this.viewer.getControl().addKeyListener((KeyListener)new WorkflowEditorKeyListener());
        this.viewer.setContents((Object)this.workflowDescription);
        this.viewer.addDropTargetListener((TransferDropTargetListener)new TemplateTransferDropTargetListener((EditPartViewer)this.viewer));
        WorkflowEditorContextMenuProvider cmProvider = new WorkflowEditorContextMenuProvider((EditPartViewer)this.viewer, this.getActionRegistry());
        this.viewer.setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu((MenuManager)cmProvider, (ISelectionProvider)this.viewer);
        WorkflowZoomManager zoomManager = (WorkflowZoomManager)rootEditPart.getZoomManager();
        this.getActionRegistry().registerAction((IAction)new ZoomInAction((ZoomManager)zoomManager));
        this.getActionRegistry().registerAction((IAction)new ZoomOutAction((ZoomManager)zoomManager));
        this.viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        this.tabbedPropertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        this.registerChangeListeners();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
                for (Object structuredSelectionObject : structuredSelection.toList()) {
                    if (structuredSelectionObject instanceof ConnectionPart) {
                        ConnectionPart connectionPart = (ConnectionPart)structuredSelectionObject;
                        if (WorkflowEditor.this.viewer.getSelectedEditParts().contains(connectionPart)) {
                            connectionPart.getConnectionFigure().setForegroundColor(ColorConstants.blue);
                            connectionPart.showLabel();
                        }
                    }
                    if (structuredSelectionObject instanceof WorkflowNodePart) {
                        WorkflowNodePart nodePart = (WorkflowNodePart)structuredSelectionObject;
                        ComponentInterface ci = ((WorkflowNode)nodePart.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface();
                        String id = ci.getIdentifierAndVersion().substring(0, ci.getIdentifierAndVersion().lastIndexOf("/"));
                        if (WorkflowEditor.this.toolIntegrationRegistry.hasTIContextMatchingPrefix(id)) {
                            PlatformUI.getWorkbench().getHelpSystem().setHelp(WorkflowEditor.this.viewer.getControl(), "de.rcenvironment.integration.*");
                            continue;
                        }
                        PlatformUI.getWorkbench().getHelpSystem().setHelp(WorkflowEditor.this.viewer.getControl(), id);
                        continue;
                    }
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(WorkflowEditor.this.viewer.getControl(), null);
                }
                WorkflowEditor.this.removeConnectionColorsAndLabel();
            }
        });
        this.viewer.getControl().setData(DRAG_STATE_BENDPOINT, (Object)false);
        this.viewer.getControl().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent ev) {
            }

            public void mouseDown(MouseEvent ev) {
            }

            public void mouseDoubleClick(MouseEvent ev) {
                ConnectionPart connectionPart = WorkflowEditor.this.selectConnection(ev);
                if (connectionPart != null) {
                    WorkflowNode source = null;
                    WorkflowNode target = null;
                    if (connectionPart.getSource().getModel() instanceof WorkflowNode) {
                        source = (WorkflowNode)connectionPart.getSource().getModel();
                    }
                    if (connectionPart.getTarget().getModel() instanceof WorkflowNode) {
                        target = (WorkflowNode)connectionPart.getTarget().getModel();
                    }
                    OpenConnectionEditorHandler openConnectionEditorHandler = new OpenConnectionEditorHandler(source, target);
                    try {
                        openConnectionEditorHandler.execute(new ExecutionEvent());
                    }
                    catch (ExecutionException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.getGraphicalControl().setVisible(true);
        this.getActionRegistry().registerAction((IAction)new ToggleGridAction(this.getGraphicalViewer()));
        this.getActionRegistry().registerAction((IAction)new ToggleSnapToGeometryAction(this.getGraphicalViewer()));
        this.getViewer().setProperty("SnapToGeometry.isEnabled", (Object)true);
        this.getViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(20, 20));
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("de.rcenvironment.rce.gui.workflow.editor.scope");
        IPreferenceStore preferenceStore = Activator.getInstance().getPreferenceStore();
        preferenceStore.setValue(SHOW_LABELS_PREFERENCE_KEY, false);
        ContextMenuItemRemover.removeUnwantedMenuEntries((Control)this.viewer.getControl());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
    }

    public void showAllConnectionLabels() {
        for (Object connectionPartObject : this.viewer.getEditPartRegistry().values()) {
            if (!(connectionPartObject instanceof ConnectionPart)) continue;
            ((ConnectionPart)connectionPartObject).showLabel();
        }
    }

    public void hideUnselectedConnectionLabels() {
        for (Object connectionPartObject : this.viewer.getEditPartRegistry().values()) {
            if (!(connectionPartObject instanceof ConnectionPart)) continue;
            ConnectionPart part = (ConnectionPart)connectionPartObject;
            int selectedCode = 2;
            if (part.getSelected() == selectedCode) continue;
            part.hideLabel();
        }
    }

    private void removeConnectionColorsAndLabel() {
        for (Object connectionPartObject : this.viewer.getEditPartRegistry().values()) {
            if (!(connectionPartObject instanceof ConnectionPart) || this.viewer.getSelectedEditParts().contains(connectionPartObject)) continue;
            ConnectionPart connectionPart = (ConnectionPart)connectionPartObject;
            connectionPart.getConnectionFigure().setForegroundColor(ColorConstants.black);
            IPreferenceStore prefs = Activator.getInstance().getPreferenceStore();
            boolean labelsVisible = prefs.getBoolean(SHOW_LABELS_PREFERENCE_KEY);
            if (labelsVisible) continue;
            connectionPart.hideLabel();
        }
    }

    private ConnectionPart selectConnection(MouseEvent ev) {
        for (Object editPart : this.viewer.getEditPartRegistry().values()) {
            Rectangle toleranceRectangle;
            if (!(editPart instanceof ConnectionPart)) continue;
            int offsetX = ((FigureCanvas)this.getViewer().getControl()).getViewport().getViewLocation().x;
            int offsetY = ((FigureCanvas)this.getViewer().getControl()).getViewport().getViewLocation().y;
            ConnectionPart connectionPart = (ConnectionPart)editPart;
            PointList connectionPoints = connectionPart.getConnectionFigure().getPoints();
            if (!connectionPoints.intersects(toleranceRectangle = new Rectangle(ev.x + offsetX - 5, ev.y + offsetY - 5, 10, 10))) continue;
            this.viewer.select((EditPart)connectionPart);
            this.viewer.reveal((EditPart)connectionPart);
            return connectionPart;
        }
        return null;
    }

    public void dispose() {
        this.serviceRegistryAccess.dispose();
        super.dispose();
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(final PaletteViewer v) {
                super.configurePaletteViewer(v);
                WorkflowEditor.this.paletteViewer = v;
                v.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.stateMask == 65536 && e.keyCode == 100) {
                            WorkflowEditor.this.switchToConnectionTool();
                        } else if (e.stateMask == 65536 && e.keyCode == 115) {
                            WorkflowEditor.this.switchToSelectionTool();
                        }
                    }
                });
                v.getControl().addMenuDetectListener(new MenuDetectListener(){

                    public void menuDetected(MenuDetectEvent menuDetectEvent) {
                        final Menu menu = ((Control)menuDetectEvent.widget).getMenu();
                        if (menu.getData(WorkflowEditor.MENU_LISTENER_MARKER) == null) {
                            menu.setData(WorkflowEditor.MENU_LISTENER_MARKER, (Object)true);
                            menu.addMenuListener((MenuListener)new MenuAdapter(){

                                public void menuShown(MenuEvent menuEvent) {
                                    Object selection = ((StructuredSelection)v.getSelection()).getFirstElement();
                                    if (selection instanceof EditPart) {
                                        String toolName = ((PaletteEntry)((EditPart)selection).getModel()).getDescription();
                                        if (toolName != null && WorkflowEditor.this.getSelectedPaletteComponent(toolName) != null && WorkflowEditor.this.getSelectedPaletteComponent(toolName).getInstallationId().matches("de.rcenvironment.integration.*")) {
                                            this.extendPaletteContextMenu(menu, WorkflowEditor.this.getSelectedPaletteComponent(toolName).getInstallationId());
                                        }
                                        if (toolName != null && WorkflowEditor.this.getSelectedPaletteComponent(toolName) != null && WorkflowEditor.this.getSelectedPaletteComponent(toolName).getInstallationId().matches("de.rcenvironment.remoteaccess.*")) {
                                            this.extendPaletteContextMenuForSshComponent(menu, WorkflowEditor.this.getSelectedPaletteComponent(toolName).getInstallationId());
                                        }
                                    }
                                }

                                private void extendPaletteContextMenu(Menu menu2, String toolID) {
                                    MenuItem separator = new MenuItem(menu2, 2);
                                    separator.setData(WorkflowEditor.TOOLINTEGRATION_ITEM, (Object)true);
                                    WorkflowEditor.this.addShowToolIntegrationWizard(menu2);
                                    WorkflowEditor.this.addShowEditToolIntegrationWizard(menu2);
                                    WorkflowEditor.this.addShowDeleteToolIntegrationWizard(menu2);
                                    WorkflowEditor.this.addGetDocumentation(menu2, toolID);
                                    WorkflowEditor.this.addExportDocumentation(menu2, toolID);
                                }

                                private void extendPaletteContextMenuForSshComponent(Menu menu2, String toolID) {
                                    MenuItem separator = new MenuItem(menu2, 2);
                                    separator.setData(WorkflowEditor.TOOLINTEGRATION_ITEM, (Object)true);
                                    WorkflowEditor.this.addGetDocumentation(menu2, toolID);
                                    WorkflowEditor.this.addExportDocumentation(menu2, toolID);
                                }
                            });
                        }
                    }
                });
                v.getControl().addMouseListener((MouseListener)new MouseAdapter(){
                    private final int offset = 20;

                    public void mouseDoubleClick(MouseEvent e) {
                        Rectangle rectangle;
                        if (v.getActiveTool().getLabel().equals("Add Label")) {
                            WorkflowLabel label = new WorkflowLabel("New label");
                            WorkflowDescription model = (WorkflowDescription)WorkflowEditor.this.viewer.getContents().getModel();
                            rectangle = new Rectangle(30, 30, -1, -1);
                            WorkflowNodeLabelConnectionHelper helper = new WorkflowNodeLabelConnectionHelper(label, model, rectangle);
                            WorkflowNodeLabelConnectionCreateCommand createCommand = helper.createCommand();
                            WorkflowEditor.this.getEditorsCommandStack().execute((Command)createCommand);
                            WorkflowEditor.this.getExistingPaletteGroups();
                            v.setActiveTool(v.getPaletteRoot().getDefaultEntry());
                        }
                        WorkflowDescription model = (WorkflowDescription)WorkflowEditor.this.viewer.getContents().getModel();
                        ComponentInstallation installation = WorkflowEditor.this.getSelectedPaletteComponent(v.getActiveTool().getLabel());
                        rectangle = new Rectangle(30, 30, 60, 60);
                        for (WorkflowNode node : model.getWorkflowNodes()) {
                            Rectangle nodeRect = new Rectangle(node.getX(), node.getY(), 60, 60);
                            if (!nodeRect.intersects(rectangle)) continue;
                            rectangle.translate(20, 20);
                        }
                        if (installation != null) {
                            ComponentDescription description = new ComponentDescription(installation);
                            description.initializeWithDefaults();
                            WorkflowNode node = new WorkflowNode(description);
                            WorkflowNodeLabelConnectionHelper helper = new WorkflowNodeLabelConnectionHelper(node, model, rectangle);
                            WorkflowNodeLabelConnectionCreateCommand createCommand = helper.createCommand();
                            WorkflowEditor.this.getEditorsCommandStack().execute((Command)createCommand);
                            for (Object editpart : WorkflowEditor.this.viewer.getContents().getChildren()) {
                                EditPart currentEditPart;
                                if (!(editpart instanceof EditPart) || !(editpart instanceof WorkflowNodePart) || !((WorkflowNode)(currentEditPart = (EditPart)editpart).getModel()).equals((Object)node)) continue;
                                WorkflowEditor.this.viewer.select(currentEditPart);
                                WorkflowEditor.this.tabbedPropertySheetPage.selectionChanged((IWorkbenchPart)WorkflowEditor.this, WorkflowEditor.this.viewer.getSelection());
                                break;
                            }
                            WorkflowEditor.this.getExistingPaletteGroups();
                            v.setActiveTool(v.getPaletteRoot().getDefaultEntry());
                        }
                    }
                });
                v.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)v));
            }
        };
    }

    private ComponentInstallation getSelectedPaletteComponent(String label) {
        PlatformService platformService = (PlatformService)this.serviceRegistryAccess.getService(PlatformService.class);
        LogicalNodeId localNode = platformService.getLocalDefaultLogicalNodeId();
        Collection installations = this.getInitialComponentKnowledge().getAllInstallations();
        installations = ComponentUtils.eliminateComponentInterfaceDuplicates((Collection)installations, (LogicalNodeId)localNode);
        ComponentInstallation installation = null;
        for (DistributedComponentEntry entry : installations) {
            ComponentInstallation inst = entry.getComponentInstallation();
            String name = inst.getComponentInterface().getDisplayName();
            if (inst.getComponentInterface().getVersion() != null && (this.toolIntegrationRegistry.hasTIContextMatchingPrefix(inst.getComponentInterface().getIdentifierAndVersion()) || inst.getComponentInterface().getIdentifierAndVersion().startsWith("de.rcenvironment.remoteaccess"))) {
                name = String.valueOf(name) + StringUtils.format((String)COMPONENTNAMES_WITH_VERSION, (Object[])new Object[]{inst.getComponentInterface().getVersion()});
            }
            if (!name.equals(label)) continue;
            installation = inst;
            break;
        }
        return installation;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalControl().setVisible(false);
    }

    protected void loadWorkflowFromFile(final File wfFile, final GUIWorkflowDescriptionLoaderCallback wfdc) {
        if (wfFile != null) {
            Job job = new Job(Messages.openWorkflow){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            monitor.beginTask("Waiting for component availability", 1);
                            if (!WorkflowEditor.this.localComponentRegistrationService.waitForLocalComponentInitialization(20, TimeUnit.SECONDS)) {
                                LOGGER.warn((Object)"Local component/tool initialization did not complete within 20 seconds; attempting to open the workflow anyway");
                            }
                            monitor.worked(1);
                            monitor.beginTask(Messages.loadingComponents, 2);
                            monitor.worked(1);
                            WorkflowEditor.this.workflowDescription = WorkflowEditor.this.workflowExecutionService.loadWorkflowDescriptionFromFileConsideringUpdates(wfFile, (WorkflowDescriptionLoaderCallback)wfdc);
                            WorkflowEditor.this.initializeWorkflowDescriptionListener();
                            monitor.worked(1);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (WorkflowEditor.this.viewer.getControl() != null) {
                                        WorkflowEditor.this.viewer.setContents((Object)(this).WorkflowEditor.this.workflowDescription);
                                        WorkflowEditor.this.getGraphicalControl().setVisible(true);
                                        if (WorkflowEditor.this.getEditorSite() != null) {
                                            WorkflowEditor.this.setFocus();
                                        }
                                        WorkflowEditor.this.validateWorkflow();
                                        WorkflowEditor.this.firePropertyChange(768);
                                    }
                                }
                            });
                        }
                        catch (WorkflowFileException | InterruptedException e) {
                            LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)("Failed to open workflow: " + wfFile.getAbsolutePath()), e);
                            Display.getDefault().asyncExec(new Runnable((Exception)e){
                                private final /* synthetic */ Exception val$e;
                                {
                                    this.val$e = exception;
                                }

                                @Override
                                public void run() {
                                    WorkflowEditor.this.closeEditorAndShowMessage(this.val$e.getMessage());
                                }
                            });
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    protected void setInput(IEditorInput input) {
        File wfFile;
        super.setInput(input);
        this.workflowDescription = new WorkflowDescription("");
        GUIWorkflowDescriptionLoaderCallback workflowDescriptionLoader = null;
        if (input instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)input;
            IFile workspaceWfFile = fileEditorInput.getFile();
            workflowDescriptionLoader = new GUIWorkflowDescriptionLoaderCallback(workspaceWfFile);
            if (workspaceWfFile != null && workspaceWfFile.getRawLocation() != null) {
                this.setPartName(workspaceWfFile.getName());
                wfFile = new File(workspaceWfFile.getLocation().toOSString());
            } else {
                this.closeEditorAndShowMessage(StringUtils.format((String)"Workflow file could not be found: %s", (Object[])new Object[]{fileEditorInput.getFile()}));
                wfFile = null;
            }
        } else if (input instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)input;
            wfFile = new File(fileStoreEditorInput.getURI());
            this.setPartName(wfFile.getName());
            workflowDescriptionLoader = new GUIWorkflowDescriptionLoaderCallback();
        } else {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Workflow File Error", (String)"Failed to load workflow file for an unknown reason.");
            wfFile = null;
        }
        this.loadWorkflowFromFile(wfFile, workflowDescriptionLoader);
    }

    protected void closeEditorAndShowMessage(String message) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Workflow File Error", (String)message);
        this.getSite().getPage().closeEditor((IEditorPart)this, false);
    }

    protected void initializeWorkflowDescriptionListener() {
        this.workflowDescription.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WorkflowEditor.this.updateDirty();
            }
        });
    }

    protected void updateDirty() {
        this.firePropertyChange(257);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
                if (file.exists()) {
                    WorkflowDescriptionPersistenceHandler wdHandler = new WorkflowDescriptionPersistenceHandler();
                    this.workflowDescription = this.updateExecutionInformation(this.workflowDescription, wdHandler, file.getRawLocation().toFile());
                    file.setContents((InputStream)new ByteArrayInputStream(wdHandler.writeWorkflowDescriptionToStream(this.workflowDescription).toByteArray()), true, false, monitor);
                    this.workflowDescription.firePropertyChange("e.rcenvironment.wf.n");
                    this.workflowDescription.firePropertyChange("e.rcenvironment.wf.l");
                } else {
                    this.doSaveAs();
                }
            } else if (this.getEditorInput() instanceof FileStoreEditorInput) {
                File file = new File(((FileStoreEditorInput)this.getEditorInput()).getURI().getPath().replaceFirst("/", ""));
                WorkflowDescriptionPersistenceHandler wdHandler = new WorkflowDescriptionPersistenceHandler();
                Throwable throwable = null;
                Object var5_11 = null;
                try (ByteArrayOutputStream outStream = wdHandler.writeWorkflowDescriptionToStream(this.workflowDescription);){
                    if (file.canWrite()) {
                        FileUtils.writeByteArrayToFile((File)file, (byte[])outStream.toByteArray());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.getCommandStack().markSaveLocation();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (OutOfMemoryError error) {
            this.showMemoryExceedingWarningMessage();
            error.printStackTrace();
        }
        this.getCommandStack().markSaveLocation();
        this.validateWorkflow();
    }

    private WorkflowDescription updateExecutionInformation(WorkflowDescription wd, WorkflowDescriptionPersistenceHandler wdHandler, File file) {
        try {
            FileInputStream fileInputStream;
            Throwable throwable = null;
            Object var5_8 = null;
            try {
                fileInputStream = new FileInputStream(file);
                try {
                    String workflowControllerNodeId = wdHandler.readWorkflowControllerNodeId((InputStream)fileInputStream);
                    wd.setControllerNode(NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)workflowControllerNodeId));
                }
                finally {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var5_8 = null;
            try {
                fileInputStream = new FileInputStream(file);
                try {
                    Map componentControllerNodeIds = wdHandler.readComponentControllerNodeIds((InputStream)fileInputStream);
                    for (WorkflowNode wn : wd.getWorkflowNodes()) {
                        ComponentInstallationBuilder builder = ComponentInstallationBuilder.fromComponentInstallation((ComponentInstallation)wn.getComponentDescription().getComponentInstallation());
                        if (componentControllerNodeIds.containsKey(wn.getIdentifierAsObject())) {
                            String compNodeId = (String)componentControllerNodeIds.get(wn.getIdentifierAsObject());
                            builder.setNodeId(NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)compNodeId));
                        }
                        wn.getComponentDescription().setComponentInstallation(builder.build());
                    }
                }
                finally {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Failed to consider stored execution information on workflow saving", (Throwable)e);
        }
        return wd;
    }

    private void validateWorkflow() {
        ComponentValidationMessageStore.getInstance().emptyMessageStore();
        List list = this.viewer.getRootEditPart().getChildren();
        WorkflowDescriptionValidationUtils.validateWorkflowDescription(this.workflowDescription, false, true);
        for (Object object : list) {
            if (!(object instanceof WorkflowPart)) continue;
            WorkflowPart workflowPart = (WorkflowPart)object;
            List children = workflowPart.getChildren();
            for (Object child : children) {
                WorkflowNodePart workflowNodePart;
                if (!(child instanceof WorkflowNodePart) || ((WorkflowNode)(workflowNodePart = (WorkflowNodePart)child).getModel()).isValid()) continue;
                workflowNodePart.updateValid();
            }
        }
        this.firePropertyChange(1024);
    }

    private void cleanNewDescriptionOfDisabledAndNotAvailableNodes(WorkflowDescription newWorkflowDescription) {
        HashSet<WorkflowNode> nodesToDelete = new HashSet<WorkflowNode>();
        nodesToDelete.addAll(this.getDisabledNodes(newWorkflowDescription));
        nodesToDelete.addAll(this.getNotAvailableNodes(newWorkflowDescription));
        if (!nodesToDelete.isEmpty()) {
            new WorkflowNodeDeleteCommand(newWorkflowDescription, new ArrayList<WorkflowNode>(nodesToDelete)).execute();
        }
    }

    private List<WorkflowNode> getInvalidWorkflowNodes(WorkflowDescription newWorkflowDescription) {
        ArrayList<WorkflowNode> result = new ArrayList<WorkflowNode>();
        for (WorkflowNode node : newWorkflowDescription.getWorkflowNodes()) {
            if (node.isValid()) continue;
            result.add(node);
        }
        return result;
    }

    private List<WorkflowNode> getNotAvailableNodes(WorkflowDescription newWorkflowDescription) {
        ArrayList<WorkflowNode> result = new ArrayList<WorkflowNode>();
        for (WorkflowNode node : newWorkflowDescription.getWorkflowNodes()) {
            if (this.isNodeAvailable(node)) continue;
            result.add(node);
        }
        return result;
    }

    private List<WorkflowNode> getDisabledNodes(WorkflowDescription newWorkflowDescription) {
        ArrayList<WorkflowNode> result = new ArrayList<WorkflowNode>();
        for (WorkflowNode node : newWorkflowDescription.getWorkflowNodes()) {
            if (node.isEnabled()) continue;
            result.add(node);
        }
        return result;
    }

    private boolean isNodeAvailable(WorkflowNode node) {
        return !node.getComponentDescription().getIdentifier().startsWith("20ca0171b5e24e10a284af7c1d6d94e9missing_");
    }

    private void markTargetsOfInvalidOrDisabledOrNotAvailableNodesInvalid(WorkflowDescription newWorkflowDescription) {
        HashSet<WorkflowNode> nodesOfInterest = new HashSet<WorkflowNode>();
        nodesOfInterest.addAll(this.getInvalidWorkflowNodes(newWorkflowDescription));
        nodesOfInterest.addAll(this.getNotAvailableNodes(newWorkflowDescription));
        nodesOfInterest.addAll(this.getDisabledNodes(newWorkflowDescription));
        for (WorkflowNode node : nodesOfInterest) {
            for (Connection connection : newWorkflowDescription.getConnections()) {
                if (!connection.getSourceNode().equals((Object)node) || !connection.getTargetNode().isEnabled() || nodesOfInterest.contains(connection.getTargetNode())) continue;
                EndpointDescription inputEp = connection.getInput();
                EndpointDefinition.InputExecutionContraint exeConstraint = inputEp.getEndpointDefinition().getDefaultInputExecutionConstraint();
                if (inputEp.getMetaDataValue("inputExecutionConstraint_4aae3eea") != null) {
                    exeConstraint = EndpointDefinition.InputExecutionContraint.valueOf((String)inputEp.getMetaDataValue("inputExecutionConstraint_4aae3eea"));
                }
                if (!exeConstraint.equals((Object)EndpointDefinition.InputExecutionContraint.Required)) continue;
                newWorkflowDescription.getWorkflowNode(connection.getTargetNode().getIdentifierAsObject()).setValid(false);
                this.workflowDescription.getWorkflowNode(connection.getTargetNode().getIdentifierAsObject()).setValid(false);
            }
        }
    }

    public void doSaveAs() {
        FileDialog fd = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        fd.setText("Save As...");
        String[] filterExt = new String[]{"*.wf"};
        fd.setFilterExtensions(filterExt);
        fd.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        fd.setFileName(this.getTitle());
        fd.setOverwrite(true);
        String selected = fd.open();
        if (selected == null) {
            return;
        }
        if (!selected.substring(selected.lastIndexOf(46) + 1).toLowerCase().equals("wf")) {
            selected = String.valueOf(selected) + ".wf";
        }
        File file = null;
        try {
            byte[] stream;
            file = new File(selected);
            FileWriter fw = new FileWriter(file);
            WorkflowDescriptionPersistenceHandler wdHandler = new WorkflowDescriptionPersistenceHandler();
            byte[] byArray = stream = wdHandler.writeWorkflowDescriptionToStream(this.workflowDescription).toByteArray();
            int n = stream.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                fw.append((char)element);
                ++n2;
            }
            fw.flush();
            fw.close();
            this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (file.getAbsolutePath().startsWith(workspace.getRoot().getFullPath().toFile().getAbsolutePath())) {
                IFile[] ifile = workspace.getRoot().findFilesForLocationURI(file.toURI());
                if (ifile.length == 1) {
                    EditorsHelper.openFileInEditor((IFile)ifile[0], (Runnable[])new Runnable[0]);
                }
            } else {
                EditorsHelper.openExternalFileInEditor((File)file, (Runnable[])new Runnable[0]);
                LOGGER.warn((Object)"Saved workflow openend as external file (not in workspace location). Executing the workflow might not work.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (OutOfMemoryError error) {
            if (file != null) {
                file.deleteOnExit();
            }
            this.showMemoryExceedingWarningMessage();
            error.printStackTrace();
        }
        catch (PartInitException e) {
            LOGGER.warn((Object)"Could not open new file. ", (Throwable)e);
        }
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            LOGGER.warn((Object)"Could not refresh Project Explorer. ", (Throwable)e);
        }
    }

    private void showMemoryExceedingWarningMessage() {
        MessageBox messageBox = new MessageBox(this.viewer.getControl().getShell(), 40);
        messageBox.setMessage(Messages.memoryExceededWarningMessage);
        messageBox.setText(Messages.memoryExceededWarningHeading);
        messageBox.open();
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            if (this.tabbedPropertySheetPage == null || this.tabbedPropertySheetPage.getControl() == null || this.tabbedPropertySheetPage.getControl().isDisposed()) {
                this.tabbedPropertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            return this.tabbedPropertySheetPage;
        }
        if (type == IContextProvider.class) {
            return new WorkflowEditorHelpContextProvider(this.viewer);
        }
        if (type == IContentOutlinePage.class) {
            return new OutlineView(this.getGraphicalViewer());
        }
        if (type == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return super.getAdapter(type);
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        FlyoutPaletteComposite.FlyoutPreferences prefs = super.getPalettePreferences();
        prefs.setPaletteState(4);
        return prefs;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public GraphicalViewer getViewer() {
        return this.viewer;
    }

    private void registerChangeListeners() {
        this.serviceRegistryAccess.registerService(DistributedComponentKnowledgeListener.class, (Object)this);
    }

    private List<String> getExistingPaletteGroups() {
        ArrayList<String> paletteGroups = new ArrayList<String>();
        for (Object child : this.paletteRoot.getChildren()) {
            if (!(child instanceof PaletteDrawer)) continue;
            paletteGroups.add(((PaletteDrawer)child).getLabel());
        }
        return paletteGroups;
    }

    private List<String> getExistingPaletteEntries() {
        ArrayList<String> paletteEntries = new ArrayList<String>();
        for (Object child : this.paletteRoot.getChildren()) {
            if (!(child instanceof PaletteDrawer)) continue;
            for (Object innerChild : ((PaletteDrawer)child).getChildren()) {
                if (!(innerChild instanceof PaletteEntry)) continue;
                paletteEntries.add(((PaletteEntry)innerChild).getLabel());
            }
        }
        return paletteEntries;
    }

    private List<String> getExistingComponentNames(Collection<DistributedComponentEntry> entries) {
        ArrayList<String> existingComponentNames = new ArrayList<String>();
        for (DistributedComponentEntry entry : entries) {
            ComponentInstallation installation = entry.getComponentInstallation();
            String name = installation.getComponentInterface().getDisplayName();
            if (installation.getComponentInterface().getVersion() != null && (this.toolIntegrationRegistry.hasTIContextMatchingPrefix(installation.getComponentInterface().getIdentifierAndVersion()) || installation.getComponentInterface().getIdentifierAndVersion().startsWith("de.rcenvironment.remoteaccess"))) {
                name = String.valueOf(name) + StringUtils.format((String)COMPONENTNAMES_WITH_VERSION, (Object[])new Object[]{installation.getComponentInterface().getVersion()});
            }
            existingComponentNames.add(name);
        }
        return existingComponentNames;
    }

    private CombinedTemplateCreationEntry createPaletteEntry(ComponentInstallation installation) {
        ComponentInterface componentInterface = installation.getComponentInterface();
        ImageDescriptor imageDescriptor = null;
        Image image = ComponentImageManager.getInstance().getIcon16Image(componentInterface);
        imageDescriptor = image == null ? Activator.getInstance().getImageRegistry().getDescriptor("de.rcenvironment.rce.icon.16") : ImageDescriptor.createFromImage((Image)image);
        String name = componentInterface.getDisplayName();
        if (componentInterface.getVersion() != null && (this.toolIntegrationRegistry.hasTIContextMatchingPrefix(componentInterface.getIdentifierAndVersion()) || componentInterface.getIdentifierAndVersion().startsWith("de.rcenvironment.remoteaccess"))) {
            name = String.valueOf(name) + StringUtils.format((String)COMPONENTNAMES_WITH_VERSION, (Object[])new Object[]{componentInterface.getVersion()});
        }
        CombinedTemplateCreationEntry component = new CombinedTemplateCreationEntry(name, name, (CreationFactory)new WorkflowNodeFactory(installation), imageDescriptor, imageDescriptor);
        return component;
    }

    private void addComponentToGroup(CombinedTemplateCreationEntry component, String groupLabel) {
        for (Object group : this.paletteRoot.getChildren()) {
            if (!(group instanceof PaletteDrawer) || !((PaletteDrawer)group).getLabel().equals(groupLabel)) continue;
            ((PaletteDrawer)group).add(this.getIndexForComponentToAdd((PaletteDrawer)group, component.getLabel()), (PaletteEntry)component);
        }
    }

    private int getIndexForComponentToAdd(PaletteDrawer group, String componentLabel) {
        int index = 0;
        for (Object child : group.getChildren()) {
            if (child instanceof PaletteEntry && ((PaletteEntry)child).getLabel().compareToIgnoreCase(componentLabel) > 0) {
                return index;
            }
            ++index;
        }
        return index;
    }

    private PaletteDrawer createPaletteDrawer(String groupLabel) {
        PaletteDrawer group = new PaletteDrawer(groupLabel);
        group.setDescription(groupLabel);
        group.setInitialState(1);
        this.paletteRoot.add(this.getIndexForGroupToAdd(groupLabel), (PaletteEntry)group);
        return group;
    }

    private int getIndexForGroupToAdd(String groupLabel) {
        int index = 0;
        if (groupLabel.startsWith("_")) {
            return this.paletteRoot.getChildren().size();
        }
        for (Object group : this.paletteRoot.getChildren()) {
            if (group instanceof PaletteDrawer && ((PaletteDrawer)group).getLabel().compareToIgnoreCase(groupLabel) > 0) {
                return index;
            }
            ++index;
        }
        return index;
    }

    private void removeComponentFromGroup(PaletteDrawer group, PaletteEntry entry) {
        group.remove(entry);
        if (group.getChildren().size() <= 0) {
            this.paletteRoot.remove((PaletteEntry)group);
        }
    }

    private synchronized void refreshPalette(Collection<DistributedComponentEntry> entries) {
        List<String> paletteEntries = this.getExistingPaletteEntries();
        List<String> paletteGroups = this.getExistingPaletteGroups();
        List<String> componentNames = this.getExistingComponentNames(entries);
        for (DistributedComponentEntry entry : entries) {
            ComponentInstallation installation = entry.getComponentInstallation();
            String name = installation.getComponentInterface().getDisplayName();
            if (installation.getComponentInterface().getVersion() != null && (this.toolIntegrationRegistry.hasTIContextMatchingPrefix(installation.getComponentInterface().getIdentifierAndVersion()) || installation.getComponentInterface().getIdentifierAndVersion().startsWith("de.rcenvironment.remoteaccess"))) {
                name = String.valueOf(name) + StringUtils.format((String)COMPONENTNAMES_WITH_VERSION, (Object[])new Object[]{installation.getComponentInterface().getVersion()});
            }
            if (paletteEntries.contains(name)) continue;
            String group = installation.getComponentInterface().getGroupName();
            CombinedTemplateCreationEntry component = this.createPaletteEntry(installation);
            paletteEntries.add(name);
            if (!paletteGroups.contains(group)) {
                this.createPaletteDrawer(group);
                paletteGroups.add(group);
            }
            this.addComponentToGroup(component, group);
        }
        HashMap componentsToRemove = new HashMap();
        for (Object group : this.paletteRoot.getChildren()) {
            if (!(group instanceof PaletteDrawer)) continue;
            for (Object component : ((PaletteDrawer)group).getChildren()) {
                if (!(component instanceof PaletteEntry) || componentNames.contains(((PaletteEntry)component).getLabel())) continue;
                if (!componentsToRemove.containsKey(group)) {
                    componentsToRemove.put((PaletteDrawer)group, new ArrayList());
                }
                ((List)componentsToRemove.get(group)).add((PaletteEntry)component);
            }
        }
        for (Object group : componentsToRemove.keySet()) {
            for (PaletteEntry entry : (List)componentsToRemove.get(group)) {
                this.removeComponentFromGroup((PaletteDrawer)group, entry);
            }
        }
    }

    public void onDistributedComponentKnowledgeChanged(DistributedComponentKnowledge newState) {
        final Collection cis = newState.getAllInstallations();
        if (PlatformUI.isWorkbenchRunning() && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WorkflowEditor.this.viewer != null && WorkflowEditor.this.viewer.getControl() != null && !WorkflowEditor.this.viewer.getControl().isDisposed()) {
                        WorkflowEditor.this.refreshPalette(cis);
                    } else {
                        LogFactory.getLog(this.getClass()).warn((Object)"Got callback (onDistributedComponentKnowledgeChanged) but widget(s) already disposed; the listener might not be disposed properly");
                    }
                }
            });
        }
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    private DistributedComponentKnowledge getInitialComponentKnowledge() {
        DistributedComponentKnowledgeService registry = (DistributedComponentKnowledgeService)this.serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class);
        return registry.getCurrentSnapshot();
    }

    private void addShowToolIntegrationWizard(Menu menu) {
        this.toolIntegrationPaletteMenuItem = new MenuItem(menu, 0);
        this.toolIntegrationPaletteMenuItem.setText(TOOL_INTEGRATE_LABEL);
        this.toolIntegrationPaletteMenuItem.setData(TOOLINTEGRATION_ITEM, (Object)true);
        this.toolIntegrationPaletteMenuItem.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INTEGRATION_NEW));
        this.toolIntegrationPaletteMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ShowIntegrationWizardHandler handler = new ShowIntegrationWizardHandler();
                try {
                    handler.execute(new ExecutionEvent());
                }
                catch (ExecutionException e) {
                    LogFactory.getLog(this.getClass()).error((Object)"Opening Tool Integration wizard failed", (Throwable)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
    }

    private void addShowEditToolIntegrationWizard(Menu menu) {
        this.editToolPaletteMenuItem = new MenuItem(menu, 0);
        this.editToolPaletteMenuItem.setText(TOOL_EDIT_LABEL);
        this.editToolPaletteMenuItem.setData(TOOLINTEGRATION_ITEM, (Object)true);
        this.editToolPaletteMenuItem.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INTEGRATION_EDIT));
        this.editToolPaletteMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ShowIntegrationEditWizardHandler handler = new ShowIntegrationEditWizardHandler();
                try {
                    handler.execute(new ExecutionEvent());
                }
                catch (ExecutionException e) {
                    LogFactory.getLog(this.getClass()).error((Object)"Opening Tool Edit wizard failed", (Throwable)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
    }

    private void addShowDeleteToolIntegrationWizard(Menu menu) {
        this.deactivateToolPaletteMenuItem = new MenuItem(menu, 0);
        this.deactivateToolPaletteMenuItem.setText(TOOL_DEACTIVATE_LABEL);
        this.deactivateToolPaletteMenuItem.setData(TOOLINTEGRATION_ITEM, (Object)true);
        this.deactivateToolPaletteMenuItem.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INTEGRATION_REMOVE));
        this.deactivateToolPaletteMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ShowIntegrationRemoveHandler handler = new ShowIntegrationRemoveHandler();
                try {
                    handler.execute(new ExecutionEvent());
                }
                catch (ExecutionException e) {
                    LogFactory.getLog(this.getClass()).error((Object)"Opening Tool Deactivation wizard failed", (Throwable)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
    }

    private void addGetDocumentation(Menu menu, final String toolID) {
        this.documentationToolPaletteMenuItem = new MenuItem(menu, 0);
        this.documentationToolPaletteMenuItem.setText("Open Documentation");
        this.documentationToolPaletteMenuItem.setData(TOOLINTEGRATION_ITEM, (Object)true);
        this.documentationToolPaletteMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolIntegrationDocumentationGUIHelper.getInstance().showComponentDocumentation(toolID, false);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
    }

    private void addExportDocumentation(Menu menu, final String toolID) {
        this.documentationToolPaletteMenuItem = new MenuItem(menu, 0);
        this.documentationToolPaletteMenuItem.setText("Export Documentation");
        this.documentationToolPaletteMenuItem.setData(TOOLINTEGRATION_ITEM, (Object)true);
        this.documentationToolPaletteMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolIntegrationDocumentationGUIHelper.getInstance().showComponentDocumentation(toolID, true);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
    }

    public boolean isAllLabelsShown() {
        return this.allLabelsShown;
    }

    public void setAllLabelsShown(boolean allLabelsShown) {
        this.allLabelsShown = allLabelsShown;
    }

    private void movePart(int movementHorizontal, int movementVertical) {
        List selected = this.getGraphicalViewer().getSelectedEditParts();
        if (selected.isEmpty()) {
            return;
        }
        this.getCommandStack().execute((Command)new MovementCommand(selected, movementHorizontal, movementVertical));
    }

    private void closeEditor(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    private void superSetInput(IEditorInput input) {
        IFile file;
        if (this.getEditorInput() != null) {
            file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
            this.setPartName(file.getName());
        }
    }

    private class MovementCommand
    extends Command {
        private int movementHorizontal = 0;
        private int movementVertical = 0;
        private List<AbstractGraphicalEditPart> selected;

        MovementCommand(List<AbstractGraphicalEditPart> sel, int h, int v) {
            this.movementHorizontal = h;
            this.movementVertical = v;
            this.selected = sel;
        }

        public void undo() {
            super.undo();
            this.setValue(-this.movementHorizontal, -this.movementVertical);
        }

        public void redo() {
            super.redo();
            this.setValue(this.movementHorizontal, this.movementVertical);
        }

        public void execute() {
            super.execute();
            this.setValue(this.movementHorizontal, this.movementVertical);
        }

        private void setValue(int h, int v) {
            for (AbstractGraphicalEditPart s : this.selected) {
                if (s.getModel() instanceof WorkflowLabel) {
                    WorkflowLabel label = (WorkflowLabel)s.getModel();
                    label.setLocation(label.getX() + h, label.getY() + v);
                    continue;
                }
                if (!(s.getModel() instanceof WorkflowNode)) continue;
                WorkflowNode node = (WorkflowNode)s.getModel();
                node.setLocation(node.getX() + h, node.getY() + v);
            }
        }
    }

    private class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException exception) {
                throw new RuntimeException(exception);
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !(WorkflowEditor.this.getEditorInput() instanceof IFileEditorInput) || !delta.getResource().equals((Object)((IFileEditorInput)WorkflowEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                Display display = WorkflowEditor.this.getSite().getShell().getDisplay();
                if ((0x2000 & delta.getFlags()) == 0) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!WorkflowEditor.this.isDirty()) {
                                WorkflowEditor.this.closeEditor(false);
                            }
                        }
                    });
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            WorkflowEditor.this.superSetInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            }
            return false;
        }
    }

    private final class WorkflowEditorKeyListener
    implements KeyListener {
        private WorkflowEditorKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.stateMask == 65536 && e.keyCode == 99) {
                WorkflowEditor.this.openConnectionEditor();
            } else if (e.keyCode == 0x1000001) {
                WorkflowEditor.this.movePart(0, -1);
            } else if (e.keyCode == 0x1000002) {
                WorkflowEditor.this.movePart(0, 1);
            } else if (e.keyCode == 0x1000003) {
                WorkflowEditor.this.movePart(-1, 0);
            } else if (e.keyCode == 0x1000004) {
                WorkflowEditor.this.movePart(1, 0);
            }
        }
    }
}

