/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.common.impl;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.common.CommonIdBase;
import de.rcenvironment.core.communication.common.IdType;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeId;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.common.impl.NodeIdentifierImpl;
import de.rcenvironment.core.communication.model.NodeInformationRegistry;
import de.rcenvironment.core.communication.model.internal.NodeInformationRegistryImpl;
import de.rcenvironment.core.communication.model.internal.SharedNodeInformationHolderImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.utils.common.DefaultTimeSource;
import de.rcenvironment.toolkit.utils.common.IdGenerator;
import de.rcenvironment.toolkit.utils.common.IdGeneratorType;
import de.rcenvironment.toolkit.utils.common.TimeSource;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NodeIdentifierServiceImpl
implements NodeIdentifierService {
    private static final int TWO_EXTRA_BYTES_MULTIPLIER = 256;
    private static final String LOG_PATTERN_SETTING_NAME_ASSOCIATION = "Setting name association '%s' for %s";
    private static final String LOG_PATTERN_REPLACING_NAME_ASSOCIATION = "Replacing previous name association '%s' for %s with '%s'";
    private static final String LOG_PATTERN_TRIGGER_SUFFIX = " (triggered by setting that name association for %s)";
    private static final AtomicLong sharedSequentialSessionPartIncrement = new AtomicLong();
    private final NodeInformationRegistry nodeInformationRegistry = new NodeInformationRegistryImpl();
    private final IdGeneratorType idGeneratorType;
    private final TimeSource timeSource = new DefaultTimeSource();
    private final Log log = LogFactory.getLog(this.getClass());

    public NodeIdentifierServiceImpl() {
        this(IdGeneratorType.SECURE);
    }

    public NodeIdentifierServiceImpl(IdGeneratorType idGeneratorPreference) {
        this.idGeneratorType = idGeneratorPreference;
    }

    @Override
    public InstanceNodeId generateInstanceNodeId() {
        String instanceIdString;
        String fullIdString = instanceIdString = this.createRandomHexString(32);
        return new NodeIdentifierImpl(instanceIdString, null, null, fullIdString, this.nodeInformationRegistry, IdType.INSTANCE_NODE_ID);
    }

    @Override
    public CommonIdBase parseSelectableTypeIdString(String instanceIdString, IdType targetIdType) throws IdentifierException {
        return new NodeIdentifierImpl(instanceIdString, this.nodeInformationRegistry, targetIdType);
    }

    @Override
    public InstanceNodeId parseInstanceNodeIdString(String input) throws IdentifierException {
        return new NodeIdentifierImpl(input, this.nodeInformationRegistry, IdType.INSTANCE_NODE_ID);
    }

    @Override
    public InstanceNodeSessionId parseInstanceNodeSessionIdString(String input) throws IdentifierException {
        return new NodeIdentifierImpl(input, this.nodeInformationRegistry, IdType.INSTANCE_NODE_SESSION_ID);
    }

    @Override
    public LogicalNodeId parseLogicalNodeIdString(String input) throws IdentifierException {
        return new NodeIdentifierImpl(input, this.nodeInformationRegistry, IdType.LOGICAL_NODE_ID);
    }

    @Override
    public LogicalNodeSessionId parseLogicalNodeSessionIdString(String input) throws IdentifierException {
        return new NodeIdentifierImpl(input, this.nodeInformationRegistry, IdType.LOGICAL_NODE_SESSION_ID);
    }

    @Override
    public InstanceNodeSessionId generateInstanceNodeSessionId(InstanceNodeId instanceId) {
        String instanceIdString = instanceId.getInstanceNodeIdString();
        String sessionIdPart = this.createTimestampHexString(10);
        String fullIdString = StringUtils.format((String)"%s::%s", (Object[])new Object[]{instanceIdString, sessionIdPart});
        return new NodeIdentifierImpl(instanceIdString, null, sessionIdPart, fullIdString, this.nodeInformationRegistry, IdType.INSTANCE_NODE_SESSION_ID);
    }

    @Override
    public void associateDisplayName(CommonIdBase id, String newName) {
        NodeIdentifierImpl idImpl = (NodeIdentifierImpl)id;
        IdType idType = idImpl.getType();
        String displayNameSourceId = idImpl.getFullIdString();
        switch (idType) {
            case INSTANCE_NODE_SESSION_ID: 
            case LOGICAL_NODE_SESSION_ID: {
                this.associateDisplayNameInternal(idImpl.getInstanceNodeSessionIdString(), newName, displayNameSourceId);
            }
            case INSTANCE_NODE_ID: 
            case LOGICAL_NODE_ID: {
                this.associateDisplayNameInternal(idImpl.getInstanceNodeIdString(), newName, displayNameSourceId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Internal error: Associating display names for logical node ids is not supported yet");
            }
        }
    }

    @Override
    public void printAllNameAssociations(PrintStream output, String introText) {
        this.nodeInformationRegistry.printAllNameAssociations(output, introText);
    }

    private void associateDisplayNameInternal(String fullIdString, String newName, String originalSourceId) {
        SharedNodeInformationHolderImpl informationHolder = this.getMutableNodeInformationHolder(fullIdString);
        String oldName = informationHolder.getDisplayName();
        if (oldName == null) {
            if (originalSourceId.equals(fullIdString)) {
                this.log.debug((Object)StringUtils.format((String)LOG_PATTERN_SETTING_NAME_ASSOCIATION, (Object[])new Object[]{newName, fullIdString}));
            } else {
                this.log.debug((Object)StringUtils.format((String)"Setting name association '%s' for %s (triggered by setting that name association for %s)", (Object[])new Object[]{newName, fullIdString, originalSourceId}));
            }
        } else if (!oldName.equals(newName)) {
            if (originalSourceId.equals(fullIdString)) {
                this.log.debug((Object)StringUtils.format((String)LOG_PATTERN_REPLACING_NAME_ASSOCIATION, (Object[])new Object[]{oldName, fullIdString, newName}));
            } else {
                this.log.debug((Object)StringUtils.format((String)"Replacing previous name association '%s' for %s with '%s' (triggered by setting that name association for %s)", (Object[])new Object[]{oldName, fullIdString, newName, originalSourceId}));
            }
        }
        informationHolder.setDisplayName(newName);
    }

    private SharedNodeInformationHolderImpl getMutableNodeInformationHolder(String key) {
        return (SharedNodeInformationHolderImpl)this.nodeInformationRegistry.getNodeInformationHolder(key);
    }

    private String createRandomHexString(int length) {
        return IdGenerator.createRandomHexString((int)length, (IdGeneratorType)this.idGeneratorType);
    }

    private String createTimestampHexString(int totalLength) {
        long scaledTimestamp = this.timeSource.getCurrentTimeMillis() / 4L;
        if (scaledTimestamp < 0L || scaledTimestamp > 0x7FFFFFFF00L) {
            throw new IllegalStateException();
        }
        long adjustedTimestampValue = scaledTimestamp + sharedSequentialSessionPartIncrement.incrementAndGet();
        String hexString = Long.toHexString(adjustedTimestampValue);
        if (hexString.length() == totalLength) {
            return hexString;
        }
        return String.valueOf("0000000000".substring(0, totalLength - hexString.length())) + hexString;
    }
}

