/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.authorization;

import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.component.authorization.api.NamedComponentAuthorizationSelector;
import de.rcenvironment.core.gui.authorization.AuthorizationConstants;
import de.rcenvironment.core.gui.authorization.AuthorizationLabelProvider;
import de.rcenvironment.core.gui.authorization.ToolbarFilterWidget;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;

public class AssignComponentsDialog
extends TitleAreaDialog {
    private static final int MINUS_ONE = -1;
    private static final int LEFT_BUTTON = 1;
    private Map<NamedComponentAuthorizationSelector, Boolean> originalComponentToStateMapping;
    private Map<NamedComponentAuthorizationSelector, Boolean> changedComponentToStateMappings;
    private String groupName;
    private CheckboxTableViewer componentsTableViewer;
    private AuthorizationService authorizationService;
    private ListSortAction sortActionAscending;
    private ListSortAction sortActionDescending;
    private ComponentsViewerComparator comparator;

    protected AssignComponentsDialog(Shell parentShell, AuthorizationService authorizationService, Map<NamedComponentAuthorizationSelector, Boolean> componentToStateMapping, String groupName) {
        super(parentShell);
        this.groupName = groupName;
        this.originalComponentToStateMapping = componentToStateMapping;
        this.changedComponentToStateMappings = new HashMap<NamedComponentAuthorizationSelector, Boolean>();
        this.authorizationService = authorizationService;
    }

    public void create() {
        super.create();
        this.setTitle("Assign Components");
        this.setMessage(StringUtils.format((String)"Assign components to group '%s'.", (Object[])new Object[]{this.groupName}), 1);
    }

    protected void okPressed() {
        this.changedComponentToStateMappings.clear();
        List<Object> checkedElements = Arrays.asList(this.componentsTableViewer.getCheckedElements());
        TableItem[] tableItemArray = this.componentsTableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean oldState;
            TableItem tableItem = tableItemArray[n2];
            NamedComponentAuthorizationSelector selector = (NamedComponentAuthorizationSelector)tableItem.getData();
            boolean newState = checkedElements.contains(selector);
            if (newState != (oldState = Boolean.valueOf(this.originalComponentToStateMapping.get(selector) != null && this.originalComponentToStateMapping.get(selector) != false))) {
                this.changedComponentToStateMappings.put(selector, newState);
            }
            ++n2;
        }
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(container, 0);
        content.setLayout((Layout)new GridLayout(1, true));
        GridData contentData = new GridData(1808);
        contentData.heightHint = 400;
        content.setLayoutData((Object)contentData);
        ToolBar toolbar = new ToolBar(content, 8519744);
        GridData toolbarGridData = new GridData(136);
        toolbar.setLayoutData((Object)toolbarGridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite(content, 512);
        scrolledComposite.setLayout((Layout)new GridLayout(1, false));
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinSize(250, 200);
        this.componentsTableViewer = CheckboxTableViewer.newCheckList((Composite)scrolledComposite, (int)592384);
        this.componentsTableViewer.getTable().setLayoutData((Object)new GridData(16384, 128, true, true));
        this.componentsTableViewer.setContentProvider((IContentProvider)new ComponentsTableContentProvider());
        this.componentsTableViewer.setCheckStateProvider((ICheckStateProvider)new ComponentCheckStateProvider());
        this.componentsTableViewer.setLabelProvider((IBaseLabelProvider)new AuthorizationLabelProvider());
        this.comparator = new ComponentsViewerComparator();
        this.componentsTableViewer.setComparator((ViewerComparator)this.comparator);
        this.componentsTableViewer.setInput(this.originalComponentToStateMapping.keySet());
        this.componentsTableViewer.getTable().addListener(4, event -> {
            int index = this.componentsTableViewer.getTable().getSelectionIndex();
            this.componentsTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            if (event.button != 1 || event.detail == 32 || index == -1 || !this.componentsTableViewer.getTable().getItem(index).getBounds().contains(new Point(event.x, event.y))) {
                return;
            }
            this.componentsTableViewer.setChecked(this.componentsTableViewer.getElementAt(index), !this.componentsTableViewer.getChecked(this.componentsTableViewer.getElementAt(index)));
        });
        scrolledComposite.setContent(this.componentsTableViewer.getControl());
        this.makeAction();
        this.fillLocalToolbar(toolbar);
        String publicGroupName = this.authorizationService.getDefaultAuthorizationObjects().accessGroupPublicInLocalNetwork().getDisplayName();
        if (!this.groupName.equals(publicGroupName)) {
            Label note = new Label(content, 4);
            note.setText(StringUtils.format((String)"Note:\nComponents that are member of the group \"%s\" are not shown in this dialog!", (Object[])new Object[]{publicGroupName}));
        }
        scrolledComposite.setFocus();
        return container;
    }

    private void fillLocalToolbar(ToolBar toolbar) {
        new ToolbarFilterWidget((StructuredViewer)this.componentsTableViewer, "Filter components...").fill(toolbar, 0);
        new ActionContributionItem((IAction)this.sortActionAscending).fill(toolbar, 1);
        new ActionContributionItem((IAction)this.sortActionDescending).fill(toolbar, 2);
    }

    private void makeAction() {
        this.sortActionAscending = new ListSortAction(1);
        this.sortActionAscending.setImageDescriptor(AuthorizationConstants.SORT_ASC);
        this.sortActionAscending.setText("Sort alphabetically ascending");
        this.sortActionDescending = new ListSortAction(-1);
        this.sortActionDescending.setImageDescriptor(AuthorizationConstants.SORT_DESC);
        this.sortActionDescending.setText("Sort alphabetically descending");
    }

    public Map<NamedComponentAuthorizationSelector, Boolean> getComponentToStateMapping() {
        return this.changedComponentToStateMappings;
    }

    private final class ComponentCheckStateProvider
    implements ICheckStateProvider {
        private ComponentCheckStateProvider() {
        }

        public boolean isChecked(Object arg0) {
            return (Boolean)AssignComponentsDialog.this.originalComponentToStateMapping.get(arg0);
        }

        public boolean isGrayed(Object arg0) {
            return false;
        }
    }

    private final class ComponentsTableContentProvider
    implements IStructuredContentProvider {
        private ComponentsTableContentProvider() {
        }

        public Object[] getElements(Object object) {
            ArrayList<NamedComponentAuthorizationSelector> components = new ArrayList<NamedComponentAuthorizationSelector>();
            for (NamedComponentAuthorizationSelector component : AssignComponentsDialog.this.originalComponentToStateMapping.keySet()) {
                components.add(component);
            }
            return components.toArray();
        }
    }

    public class ComponentsViewerComparator
    extends ViewerComparator {
        public static final int DESCENDING = -1;
        public static final int ASCENDING = 1;
        private int direction = 1;

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public int getDirection() {
            return this.direction;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof NamedComponentAuthorizationSelector && e2 instanceof NamedComponentAuthorizationSelector) {
                NamedComponentAuthorizationSelector component1 = (NamedComponentAuthorizationSelector)e1;
                NamedComponentAuthorizationSelector component2 = (NamedComponentAuthorizationSelector)e2;
                int returncode = component1.compareToIgnoreCase(component2);
                if (this.direction == -1) {
                    returncode = -returncode;
                }
                return returncode;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private final class ListSortAction
    extends Action {
        private int direction;

        protected ListSortAction(int direction) {
            this.direction = direction;
            this.setChecked(AssignComponentsDialog.this.comparator.getDirection() == direction);
        }

        public void run() {
            AssignComponentsDialog.this.comparator.setDirection(this.direction);
            AssignComponentsDialog.this.componentsTableViewer.refresh();
            AssignComponentsDialog.this.sortActionAscending.setChecked(this.direction == 1);
            AssignComponentsDialog.this.sortActionDescending.setChecked(this.direction == -1);
        }
    }
}

