/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.jms.common;

import de.rcenvironment.core.communication.transport.jms.common.AbstractJmsQueueConsumer;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;

public final class NonBlockingResponseInboxConsumer
extends AbstractJmsQueueConsumer
implements Runnable {
    private static final int RESPONSE_LISTENER_MAX_RETRY_COUNT = 20;
    private static final int RESPONSE_LISTENER_RETRY_WAIT_MSEC = 500;
    private final AsyncTaskService threadPool = ConcurrencyUtils.getAsyncTaskService();
    private final Map<String, JmsResponseCallback> responseListenerMap = new HashMap<String, JmsResponseCallback>();

    public NonBlockingResponseInboxConsumer(String queueName, Connection connection) throws JMSException {
        super(connection, queueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResponseListener(final String messageId, JmsResponseCallback jmsResponseListener, final long timeoutMsec) {
        if (messageId == null) {
            this.log.error((Object)"Internal consistency error: message id == null");
            jmsResponseListener.onTimeoutReached();
            return;
        }
        Map<String, JmsResponseCallback> map = this.responseListenerMap;
        synchronized (map) {
            JmsResponseCallback replaced = this.responseListenerMap.put(messageId, jmsResponseListener);
            if (replaced != null) {
                this.log.error((Object)("Internal consistency error: There was already a response listener registered for message id " + messageId));
                jmsResponseListener.onTimeoutReached();
                return;
            }
        }
        this.threadPool.scheduleAfterDelay(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @TaskDescription(value="JMS Network Transport: Check for request completion after timeout")
            public void run() {
                JmsResponseCallback unfulfilledResponseListener;
                Map map = NonBlockingResponseInboxConsumer.this.responseListenerMap;
                synchronized (map) {
                    unfulfilledResponseListener = (JmsResponseCallback)NonBlockingResponseInboxConsumer.this.responseListenerMap.remove(messageId);
                }
                if (unfulfilledResponseListener != null) {
                    NonBlockingResponseInboxConsumer.this.log.debug((Object)("Reached timeout (" + timeoutMsec + "ms) for message id " + messageId));
                    unfulfilledResponseListener.onTimeoutReached();
                }
            }
        }, timeoutMsec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TaskDescription(value="JMS Network Transport: Non-blocking response listener")
    public void run() {
        super.run();
        Map<String, JmsResponseCallback> map = this.responseListenerMap;
        synchronized (map) {
            if (!this.responseListenerMap.isEmpty()) {
                this.log.debug((Object)("Response listener for queue " + this.queueName + " has been shut down while " + this.responseListenerMap.size() + " request(s) were still pending; generating failure responses"));
                for (final JmsResponseCallback listener : this.responseListenerMap.values()) {
                    this.threadPool.execute(new Runnable(){

                        @Override
                        @TaskDescription(value="JMS Network Transport: Handle pending non-blocking request after queue listener shutdown")
                        public void run() {
                            listener.onChannelClosed();
                        }
                    });
                }
                this.responseListenerMap.clear();
            }
        }
    }

    @Override
    protected void dispatchMessage(final Message message, Connection jmsConnection) {
        this.threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @TaskDescription(value="JMS Network Transport: Dispatch incoming response")
            public void run() {
                JmsResponseCallback responseListener;
                String messageId;
                try {
                    messageId = message.getJMSCorrelationID();
                    if (messageId == null) {
                        NonBlockingResponseInboxConsumer.this.log.error((Object)"Unexpected state: null JMS message correlation id");
                        return;
                    }
                }
                catch (JMSException e) {
                    NonBlockingResponseInboxConsumer.this.log.error((Object)"Unexpected error while handling JMS response", (Throwable)e);
                    return;
                }
                int retryCount = 0;
                while (true) {
                    Map map = NonBlockingResponseInboxConsumer.this.responseListenerMap;
                    synchronized (map) {
                        responseListener = (JmsResponseCallback)NonBlockingResponseInboxConsumer.this.responseListenerMap.remove(messageId);
                    }
                    if (responseListener != null) {
                        if (retryCount > 0) {
                            NonBlockingResponseInboxConsumer.this.log.debug((Object)("Successfully fetched mapping information for a network response after retrying for " + retryCount * 500 + " msec; there is probably high CPU load on the local instance"));
                        }
                        break;
                    }
                    if (retryCount >= 20) {
                        NonBlockingResponseInboxConsumer.this.log.debug((Object)("No response listener for message " + messageId + " even after retrying - most likely, the response arrived after the timeout"));
                        return;
                    }
                    ++retryCount;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        NonBlockingResponseInboxConsumer.this.log.warn((Object)"Thread interrupted while retrying to fetch response mapping information");
                        return;
                    }
                }
                responseListener.onResponseReceived(message);
            }
        });
    }

    public static interface JmsResponseCallback {
        public void onResponseReceived(Message var1);

        public void onTimeoutReached();

        public void onChannelClosed();
    }
}

