/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.authorization.impl;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroupKeyData;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.authorization.cryptography.api.CryptographyOperationsProvider;
import de.rcenvironment.core.authorization.cryptography.api.SymmetricKey;
import de.rcenvironment.core.component.authorization.api.ComponentAuthorizationSelector;
import de.rcenvironment.core.component.authorization.api.ComponentExecutionAuthorizationService;
import de.rcenvironment.core.component.authorization.api.RemotableComponentExecutionAuthorizationService;
import de.rcenvironment.core.component.management.api.LocalComponentRegistrationService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.toolkit.utils.common.IdGenerator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ComponentExecutionAuthorizationServiceImpl
implements ComponentExecutionAuthorizationService,
RemotableComponentExecutionAuthorizationService {
    private static final long TOKEN_LIFETIME_MSEC = TimeUnit.MINUTES.toMillis(5L);
    private static final long GC_INTERVAL_MSEC = 15000L;
    private static final int TOKEN_HEX_STRING_LENGTH = 32;
    private final Deque<String> gcQueue = new LinkedList<String>();
    private final Map<String, Long> activeTokens = new HashMap<String, Long>();
    private AuthorizationService authorizationService;
    private LocalComponentRegistrationService localComponentRegistrationService;
    private CryptographyOperationsProvider cryptographyOperationsProvider;
    private final Log log = LogFactory.getLog(this.getClass());

    @Activate
    public void activate() {
        ConcurrencyUtils.getAsyncTaskService().scheduleAfterDelay("Component Authorization Token Garbage Collection", this::runGarbageCollection, 15000L);
    }

    @Override
    @AllowRemoteAccess
    public synchronized String requestExecutionTokenForPublicComponent(String internalComponentId, String componentVersion) throws OperationFailureException {
        ComponentAuthorizationSelector componentSelector = this.localComponentRegistrationService.getComponentSelector(internalComponentId);
        AuthorizationPermissionSet permissionSet = this.localComponentRegistrationService.getComponentPermissionSet(componentSelector, true);
        if (permissionSet.isPublic()) {
            this.log.debug((Object)("Generating access token for public component \"" + internalComponentId + "\""));
            return this.generateAndRegisterToken(String.valueOf(internalComponentId) + ":public");
        }
        throw new OperationFailureException(StringUtils.format((String)"Public execution permission was requested for component \"%s\", but it is not currently public; maybe its permissions have been changed very recently", (Object[])new Object[]{internalComponentId}));
    }

    @Override
    @AllowRemoteAccess
    public String requestEncryptedExecutionTokenViaGroupMembership(String internalComponentId, String componentVersion, String groupId) throws OperationFailureException {
        AuthorizationAccessGroup groupReference;
        ComponentAuthorizationSelector componentSelector = this.localComponentRegistrationService.getComponentSelector(internalComponentId);
        AuthorizationPermissionSet permissionSet = this.localComponentRegistrationService.getComponentPermissionSet(componentSelector, true);
        if (permissionSet.includesAccessGroup(groupReference = this.authorizationService.representRemoteGroupId(groupId))) {
            this.log.debug((Object)StringUtils.format((String)"Generating access token for component \"%s\", accessible via group membership in \"%s\"", (Object[])new Object[]{internalComponentId, groupId}));
            String accessToken = this.generateAndRegisterToken(String.valueOf(internalComponentId) + ":group");
            AuthorizationAccessGroupKeyData groupKeyData = this.authorizationService.getKeyDataForGroup(groupReference);
            SymmetricKey secretGroupKey = groupKeyData.getSymmetricKey();
            return this.cryptographyOperationsProvider.encryptAndEncodeString(secretGroupKey, accessToken);
        }
        throw new OperationFailureException(StringUtils.format((String)"Group-based execution permission was requested for component \"%s\", but it is not currently available for group \"%s\"; maybe its permissions have been changed very recently", (Object[])new Object[]{internalComponentId, groupId}));
    }

    @Override
    public String createAndRegisterExecutionTokenForLocalComponent(String internalComponentId) {
        this.log.debug((Object)("Generating access token for local component \"" + internalComponentId + "\""));
        return this.generateAndRegisterToken(String.valueOf(internalComponentId) + ":local");
    }

    @Override
    public synchronized boolean verifyAndUnregisterExecutionToken(String token) {
        Long expirationTime = this.activeTokens.remove(token);
        if (expirationTime == null) {
            this.log.debug((Object)("Rejecting component execution authorization token " + token + " as it is either invalid, was already used, or was already discarded because it had expired"));
            return false;
        }
        if (System.currentTimeMillis() <= expirationTime) {
            this.log.debug((Object)("Accepting component execution authorization token " + token));
            return true;
        }
        this.log.debug((Object)("Rejecting component execution authorization token " + token + ", which is valid and was not used yet, but has expired"));
        return false;
    }

    @Reference
    protected void bindLocalComponentRegistrationService(LocalComponentRegistrationService newInstance) {
        this.localComponentRegistrationService = newInstance;
    }

    @Reference
    protected void bindAuthorizationService(AuthorizationService newInstance) {
        this.authorizationService = newInstance;
    }

    @Reference
    protected void bindCryptographyOperationsProvider(CryptographyOperationsProvider newInstance) {
        this.cryptographyOperationsProvider = newInstance;
    }

    private String generateAndRegisterToken(String id) {
        String token = String.valueOf(id) + ":" + IdGenerator.secureRandomHexString((int)32);
        long expirationTime = System.currentTimeMillis() + TOKEN_LIFETIME_MSEC;
        this.activeTokens.put(token, expirationTime);
        this.gcQueue.addLast(token);
        return token;
    }

    private synchronized void runGarbageCollection() {
        int removedUnused = 0;
        while (!this.gcQueue.isEmpty()) {
            String firstToken = this.gcQueue.peekFirst();
            Long expirationTime = this.activeTokens.get(firstToken);
            if (expirationTime == null) {
                this.gcQueue.removeFirst();
                continue;
            }
            if (System.currentTimeMillis() <= expirationTime) break;
            this.gcQueue.removeFirst();
            this.activeTokens.remove(firstToken);
            this.log.debug((Object)("Removed unused component execution token " + firstToken + " as it has expired without being used"));
            ++removedUnused;
        }
        if (removedUnused > 0) {
            this.log.debug((Object)("Removed " + removedUnused + " unused component execution token(s) that have timed out"));
        }
    }
}

