/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.communication.sshconnection.SshConnectionContext;
import de.rcenvironment.core.communication.sshconnection.SshConnectionService;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListener;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListenerAdapter;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionSetup;
import de.rcenvironment.core.gui.communication.views.contributors.AddSshConnectionDialog;
import de.rcenvironment.core.gui.communication.views.contributors.EditSshConnectionDialog;
import de.rcenvironment.core.gui.communication.views.contributors.EnterPassphraseDialog;
import de.rcenvironment.core.gui.communication.views.contributors.NetworkViewContributorBase;
import de.rcenvironment.core.gui.communication.views.internal.AnchorPoints;
import de.rcenvironment.core.gui.communication.views.model.NetworkGraphNodeWithContext;
import de.rcenvironment.core.gui.communication.views.model.SimpleNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.NetworkViewContributor;
import de.rcenvironment.core.gui.communication.views.spi.SelfRenderingNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.StandardUserNodeActionNode;
import de.rcenvironment.core.gui.communication.views.spi.StandardUserNodeActionType;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.net.URL;
import java.util.Collection;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MessageBox;

public class SshConnectionSetupsListContributor
extends NetworkViewContributorBase {
    private static final AnchorPoints PARENT_ANCHOR = AnchorPoints.SSH_REMOTE_ACCESS_SECTION_PARENT_NODE;
    private static final int ROOT_PRIORITY = 30;
    private final Log log = LogFactory.getLog(this.getClass());
    private SelfRenderingNetworkViewNode rootNode;
    private final Image connectedImage;
    private final Image disconnectedImage;
    private final ServiceRegistryPublisherAccess serviceRegistryAccess;
    private SshConnectionService sshConnectionService;
    private Collection<SshConnectionSetup> sshConnectionSetups;
    private final WeakHashMap<SshConnectionSetup, SshConnectionSetupNode> wrapperMap = new WeakHashMap();

    public SshConnectionSetupsListContributor() {
        this.connectedImage = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/connectSsh.png")).createImage();
        this.disconnectedImage = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/disconnectSsh.png")).createImage();
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)this);
        this.sshConnectionService = (SshConnectionService)this.serviceRegistryAccess.getService(SshConnectionService.class);
        this.sshConnectionSetups = this.sshConnectionService.getAllSshConnectionSetups();
        this.registerListeners();
    }

    @Override
    public int getRootElementsPriority() {
        return 30;
    }

    @Override
    public Object[] getTopLevelElements(Object parentNode) {
        if (parentNode != PARENT_ANCHOR) {
            return null;
        }
        boolean hasChildren = this.sshConnectionSetups != null && !this.sshConnectionSetups.isEmpty();
        this.rootNode = new SimpleNetworkViewNode("SSH Remote Access Connections", this.disconnectedImage, this, hasChildren);
        return new Object[]{this.rootNode};
    }

    @Override
    public int getInstanceDataElementsPriority() {
        return 0;
    }

    public void showAddConnectionDialog() {
        AddSshConnectionDialog dialog = new AddSshConnectionDialog(this.treeViewer.getTree().getShell());
        if (dialog.open() == 0) {
            final String connectionName = dialog.getConnectionName();
            final boolean connectImmediately = dialog.getAutoRetry();
            final boolean autoRetry = dialog.getConnectImmediately();
            final String host = dialog.getHost();
            final int port = dialog.getPort();
            final String username = dialog.getUsername();
            final String passphrase = dialog.getPassphrase();
            final boolean storePassphrase = dialog.shouldStorePassPhrase();
            final String keyfileLocation = dialog.getKeyfileLocation();
            final boolean usePassphrase = dialog.getUsePassphrase();
            ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                @Override
                @TaskDescription(value="Create new SSH Connection.")
                public void run() {
                    String id = SshConnectionSetupsListContributor.this.sshConnectionService.addSshConnection(new SshConnectionContext(null, connectionName, host, port, username, keyfileLocation, usePassphrase, connectImmediately, autoRetry));
                    SshConnectionSetupsListContributor.this.sshConnectionService.setAuthPhraseForSshConnection(id, passphrase, storePassphrase);
                    if (connectImmediately) {
                        SshConnectionSetupsListContributor.this.sshConnectionService.connectSession(id, passphrase);
                    }
                }
            });
        }
    }

    @Override
    public Object[] getChildrenForNetworkInstanceNode(NetworkGraphNodeWithContext instanceNode) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public boolean hasChildren(Object parentNode) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public Object[] getChildren(Object node) {
        if (node != this.rootNode) {
            throw this.newUnexpectedCallException();
        }
        if (this.sshConnectionSetups.isEmpty()) {
            return EMPTY_ARRAY;
        }
        Object[] nodes = new SshConnectionSetupNode[this.sshConnectionSetups.size()];
        int pos = 0;
        for (SshConnectionSetup setup : this.sshConnectionSetups) {
            SshConnectionSetupNode setupNode = new SshConnectionSetupNode(setup.getId(), setup);
            nodes[pos++] = setupNode;
        }
        return nodes;
    }

    @Override
    public Object getParent(Object node) {
        if (node == this.rootNode) {
            return PARENT_ANCHOR;
        }
        return this.rootNode;
    }

    @Override
    public String getText(Object node) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public Image getImage(Object node) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public void dispose() {
        this.connectedImage.dispose();
        this.disconnectedImage.dispose();
        this.serviceRegistryAccess.dispose();
    }

    private void registerListeners() {
        SshConnectionListenerAdapter listener = new SshConnectionListenerAdapter(){

            public void onCollectionChanged(final Collection<SshConnectionSetup> connections) {
                SshConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SshConnectionSetupsListContributor.this.sshConnectionSetups = connections;
                        if ((this).SshConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        (this).SshConnectionSetupsListContributor.this.treeViewer.refresh((Object)PARENT_ANCHOR, false);
                        (this).SshConnectionSetupsListContributor.this.treeViewer.setExpandedState((Object)SshConnectionSetupsListContributor.this.rootNode, true);
                    }
                });
            }

            public void onConnected(final SshConnectionSetup setup) {
                SshConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SshConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        SshConnectionSetupNode node = SshConnectionSetupsListContributor.this.getSetupNodeForSetup(setup);
                        (this).SshConnectionSetupsListContributor.this.treeViewer.refresh((Object)node);
                        (this).SshConnectionSetupsListContributor.this.treeViewer.setExpandedState((Object)node, true);
                    }
                });
            }

            public void onConnectionAttemptFailed(final SshConnectionSetup setup, final String reason, boolean firstConsecutiveFailure, final boolean willAutoRetry) {
                if (firstConsecutiveFailure) {
                    SshConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageBox dialog = new MessageBox((this).SshConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), 33);
                            String retryMessage = "\n\nWill not try to reconnect.";
                            if (willAutoRetry) {
                                retryMessage = "\n\nWill automatically try to reconnect.";
                            }
                            dialog.setMessage(StringUtils.format((String)"SSH connection attempt to host %s on port %s failed:\n%s%s", (Object[])new Object[]{setup.getHost(), setup.getPort(), reason, retryMessage}));
                            dialog.open();
                        }
                    });
                }
                SshConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SshConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        SshConnectionSetupNode node = SshConnectionSetupsListContributor.this.getSetupNodeForSetup(setup);
                        (this).SshConnectionSetupsListContributor.this.treeViewer.refresh((Object)node);
                    }
                });
            }

            public void onConnectionClosed(final SshConnectionSetup setup, boolean willAutoRetry) {
                SshConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SshConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        SshConnectionSetupNode node = SshConnectionSetupsListContributor.this.getSetupNodeForSetup(setup);
                        (this).SshConnectionSetupsListContributor.this.treeViewer.refresh((Object)node);
                    }
                });
            }
        };
        this.serviceRegistryAccess.registerService(SshConnectionListener.class, (Object)listener);
    }

    private SshConnectionSetupNode getSetupNodeForSetup(SshConnectionSetup setup) {
        return this.wrapperMap.get(setup);
    }

    private final class SshConnectionSetupNode
    implements SelfRenderingNetworkViewNode,
    StandardUserNodeActionNode {
        private final String connectionId;
        private final SshConnectionSetup sshConnectionSetup;

        SshConnectionSetupNode(String connectionId, SshConnectionSetup setup) {
            this.connectionId = connectionId;
            this.sshConnectionSetup = setup;
            SshConnectionSetupsListContributor.this.wrapperMap.put(setup, this);
        }

        @Override
        public NetworkViewContributor getContributor() {
            return SshConnectionSetupsListContributor.this;
        }

        @Override
        public boolean isActionApplicable(StandardUserNodeActionType actionType) {
            switch (actionType) {
                case START: {
                    return !this.sshConnectionSetup.isConnected();
                }
                case STOP: {
                    return this.sshConnectionSetup.isConnected() || this.sshConnectionSetup.isWaitingForRetry();
                }
                case EDIT: {
                    return !this.sshConnectionSetup.isConnected() && !this.sshConnectionSetup.isWaitingForRetry();
                }
                case DELETE: {
                    return !this.sshConnectionSetup.isConnected() && !this.sshConnectionSetup.isWaitingForRetry();
                }
            }
            return false;
        }

        @Override
        public void performAction(StandardUserNodeActionType actionType) {
            switch (actionType) {
                case START: {
                    SshConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (SshConnectionSetupNode.this.sshConnectionSetup.getUsePassphrase()) {
                                EnterPassphraseDialog dialog;
                                String passphrase = SshConnectionSetupsListContributor.this.sshConnectionService.retrieveSshConnectionPassword(SshConnectionSetupNode.this.connectionId);
                                if (passphrase == null && (dialog = new EnterPassphraseDialog(((SshConnectionSetupNode)SshConnectionSetupNode.this).SshConnectionSetupsListContributor.this.treeViewer.getTree().getShell())).open() == 0) {
                                    passphrase = dialog.getPassphrase();
                                    SshConnectionSetupsListContributor.this.sshConnectionService.setAuthPhraseForSshConnection(SshConnectionSetupNode.this.connectionId, dialog.getPassphrase(), dialog.getStorePassphrase());
                                }
                                final String passphraseToConnect = passphrase;
                                ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                                    @Override
                                    @TaskDescription(value="Connect SSH session.")
                                    public void run() {
                                        SshConnectionSetupsListContributor.this.sshConnectionService.connectSession(SshConnectionSetupNode.this.connectionId, passphraseToConnect);
                                    }
                                });
                            } else {
                                ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                                    @Override
                                    @TaskDescription(value="Connect SSH session.")
                                    public void run() {
                                        SshConnectionSetupsListContributor.this.sshConnectionService.connectSession(SshConnectionSetupNode.this.connectionId);
                                    }
                                });
                            }
                        }
                    });
                    break;
                }
                case STOP: {
                    ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                        @Override
                        @TaskDescription(value="Disconnect SSH Connection.")
                        public void run() {
                            SshConnectionSetupsListContributor.this.sshConnectionService.disconnectSession(SshConnectionSetupNode.this.connectionId);
                        }
                    });
                    break;
                }
                case EDIT: {
                    this.performEdit();
                    break;
                }
                case DELETE: {
                    ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                        @Override
                        @TaskDescription(value="Dispose SSH Connection.")
                        public void run() {
                            SshConnectionSetupsListContributor.this.sshConnectionService.disposeConnection(SshConnectionSetupNode.this.connectionId);
                        }
                    });
                    break;
                }
            }
        }

        private void performEdit() {
            String passphrase;
            EditSshConnectionDialog dialog = new EditSshConnectionDialog(SshConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), this.sshConnectionSetup.getDisplayName(), this.sshConnectionSetup.getHost(), this.sshConnectionSetup.getPort(), this.sshConnectionSetup.getUsername(), this.sshConnectionSetup.getKeyfileLocation(), this.sshConnectionSetup.getUsePassphrase(), this.sshConnectionSetup.getStorePassphrase(), this.sshConnectionSetup.getConnectOnStartUp(), this.sshConnectionSetup.getAutoRetry());
            if (this.sshConnectionSetup.getStorePassphrase() && (passphrase = SshConnectionSetupsListContributor.this.sshConnectionService.retrieveSshConnectionPassword(this.sshConnectionSetup.getId())) != null) {
                dialog.setPassphrase(passphrase);
            }
            final String id = this.sshConnectionSetup.getId();
            if (dialog.open() == 0) {
                final String connectionName = dialog.getConnectionName();
                final boolean connectImmediately = dialog.getConnectImmediately();
                final String host = dialog.getHost();
                final int port = dialog.getPort();
                final String username = dialog.getUsername();
                final String passphrase2 = dialog.getPassphrase();
                final boolean storePassphrase = dialog.shouldStorePassPhrase();
                final String keyfileLocation = dialog.getKeyfileLocation();
                final boolean usePassphrase = dialog.getUsePassphrase();
                final boolean autoRetry = dialog.getAutoRetry();
                ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                    @Override
                    @TaskDescription(value="Edit SSH Connection.")
                    public void run() {
                        SshConnectionSetupsListContributor.this.sshConnectionService.editSshConnection(new SshConnectionContext(id, connectionName, host, port, username, keyfileLocation, usePassphrase, connectImmediately, autoRetry));
                        SshConnectionSetupsListContributor.this.sshConnectionService.setAuthPhraseForSshConnection(id, passphrase2, storePassphrase);
                        if (connectImmediately) {
                            SshConnectionSetupsListContributor.this.sshConnectionService.connectSession(id, passphrase2);
                        }
                    }
                });
            }
        }

        @Override
        public String getText() {
            String status = "connected";
            if (!SshConnectionSetupsListContributor.this.sshConnectionService.isConnected(this.connectionId)) {
                status = SshConnectionSetupsListContributor.this.sshConnectionService.isWaitingForRetry(this.connectionId) ? "disconnected, waiting for retry" : "disconnected";
            }
            return StringUtils.format((String)"%s (%s)", (Object[])new Object[]{this.sshConnectionSetup.getDisplayName(), status});
        }

        @Override
        public Image getImage() {
            if (SshConnectionSetupsListContributor.this.sshConnectionService.isConnected(this.connectionId)) {
                return SshConnectionSetupsListContributor.this.connectedImage;
            }
            return SshConnectionSetupsListContributor.this.disconnectedImage;
        }

        @Override
        public boolean getHasChildren() {
            return false;
        }
    }
}

