/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.api;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.monitoring.system.api.RemotableSystemMonitoringService;
import de.rcenvironment.core.monitoring.system.api.SystemMonitoringDataSnapshotListener;
import de.rcenvironment.core.monitoring.system.internal.AsyncSystemMonitoringDataFetchTask;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemMonitoringDataPollingManager {
    private static final int REFRESH_INTERVAL_MSEC = 5000;
    private final CommunicationService communicationService;
    private final AsyncTaskService asyncTaskService;
    private final Map<InstanceNodeSessionId, Future<?>> futureMap = new HashMap();
    private final Log log = LogFactory.getLog(this.getClass());

    public SystemMonitoringDataPollingManager(CommunicationService communicationService, AsyncTaskService asyncTaskService) {
        this.communicationService = communicationService;
        this.asyncTaskService = asyncTaskService;
    }

    public synchronized void startPollingTask(InstanceNodeSessionId nodeId, SystemMonitoringDataSnapshotListener callbackListener) {
        if (nodeId == null) {
            throw new IllegalArgumentException("Node id must not be null");
        }
        RemotableSystemMonitoringService remoteService = (RemotableSystemMonitoringService)this.communicationService.getRemotableService(RemotableSystemMonitoringService.class, (NetworkDestination)nodeId);
        Future<?> existingFuture = this.futureMap.get(nodeId);
        if (existingFuture != null) {
            this.log.debug((Object)("Monitoring start requested for node " + nodeId + ", but it already has a monitoring task; ignoring request"));
            return;
        }
        AsyncSystemMonitoringDataFetchTask backgroundTask = new AsyncSystemMonitoringDataFetchTask(callbackListener, remoteService);
        ScheduledFuture newFuture = this.asyncTaskService.scheduleAtFixedRate((Runnable)backgroundTask, 5000L);
        this.futureMap.put(nodeId, newFuture);
        this.log.debug((Object)("Started system monitoring background task for node " + nodeId));
    }

    public synchronized void cancelPollingTask(InstanceNodeSessionId nodeId) {
        this.removeAndCancelTask(nodeId);
    }

    public synchronized void cancelAllPollingTasks() {
        for (Map.Entry<InstanceNodeSessionId, Future<?>> entry : this.futureMap.entrySet()) {
            InstanceNodeSessionId nodeId = entry.getKey();
            Future<?> taskFuture = entry.getValue();
            this.cancelTaskFuture(nodeId, taskFuture);
        }
        this.futureMap.clear();
    }

    public synchronized void cancelPollingTasks(Set<InstanceNodeSessionId> nodes) {
        if (nodes != null) {
            for (InstanceNodeSessionId nodeId : nodes) {
                this.removeAndCancelTask(nodeId);
            }
        }
    }

    private void removeAndCancelTask(InstanceNodeSessionId nodeId) {
        if (nodeId == null) {
            this.log.warn((Object)"Attempted to cancel a monitoring task with a null node id");
            return;
        }
        Future<?> taskFuture = this.futureMap.remove(nodeId);
        if (taskFuture != null) {
            this.cancelTaskFuture(nodeId, taskFuture);
        }
    }

    private void cancelTaskFuture(InstanceNodeSessionId nodeId, Future<?> future) {
        future.cancel(false);
        this.log.debug((Object)("Stopped system monitoring background task for node " + nodeId));
    }
}

