/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.remoteaccess.server.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.SingleConsoleRowsProcessor;
import de.rcenvironment.core.component.integration.documentation.ToolIntegrationDocumentationService;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.spi.DistributedComponentKnowledgeListener;
import de.rcenvironment.core.component.workflow.execution.api.FinalWorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.headless.api.ExtendedHeadlessWorkflowExecutionContextBuilder;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.PersistentSettingsService;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.embedded.ssh.api.EmbeddedSshServerControl;
import de.rcenvironment.core.monitoring.system.api.LocalSystemMonitoringAggregationService;
import de.rcenvironment.core.monitoring.system.api.model.AverageOfDoubles;
import de.rcenvironment.core.monitoring.system.api.model.SystemLoadInformation;
import de.rcenvironment.core.remoteaccess.server.internal.RemoteAccessService;
import de.rcenvironment.core.remoteaccess.server.internal.RemoteComponentExecutionParameter;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.CommonIdRules;
import de.rcenvironment.core.utils.common.InvalidFilenameException;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class RemoteAccessServiceImpl
implements RemoteAccessService {
    private static final String REQUIRED_INPUTLOADER_VERSION = "1.1";
    private static final String REQUIRED_OUTPUTCOLLECTOR_VERSION = "1.1";
    private static final String TAB = "\t";
    private static final String NAME_DATA_TYPE = "[name]\t[data type]";
    private static final String FORMAT_2F = "%.2f";
    private static final int PERCENT_MULTIPLIER = 100;
    private static final int INT_NO_DATA_PLACEHOLDER = -1;
    private static final double DOUBLE_NO_DATA_PLACEHOLDER = -1.0;
    private static final String DE_RCENVIRONMENT_SCPOUTPUTCOLLECTOR = "de.rcenvironment.scpoutputcollector/";
    private static final String DE_RCENVIRONMENT_SCPINPUTLOADER = "de.rcenvironment.scpinputloader/";
    private static final String KEY_META_DATA = "metaData";
    private static final String KEY_DEFAULT_DATA_TYPE = "defaultDataType";
    private static final String KEY_DATA_TYPE = "dataType";
    private static final String KEY_DATA_TYPES = "dataTypes";
    private static final String KEY_INPUT_HANDLING_OPTIONS = "inputHandlingOptions";
    private static final String KEY_DEFAULT_INPUT_HANDLING = "defaultInputHandling";
    private static final String KEY_EXECUTION_CONSTRAINT_OPTIONS = "inputExecutionConstraintOptions";
    private static final String KEY_DEFAULT_EXECUTION_CONSTRAINT = "defaultInputExecutionConstraint";
    private static final String KEY_DEFAULT_VALUE = "defaultValue";
    private static final String KEY_POSSIBLE_VALUES = "possibleValues";
    private static final int NUMBER_600 = 600;
    private static final int NUMBER_200 = 200;
    private static final int NUMBER_400 = 400;
    private static final String WF_PLACEHOLDER_INPUT_DIR = "##SCP_UPLOAD_DIRECTORY##";
    private static final String WF_PLACEHOLDER_OUTPUT_PARENT_DIR = "##SCP_DOWNLOAD_DIRECTORY##";
    private static final String WF_PLACEHOLDER_UNCOMPRESSED_UPLOAD = "##UNCOMPRESSED_UPLOAD_FLAG##";
    private static final String WF_PLACEHOLDER_UNCOMPRESSED_DOWNLOAD = "##UNCOMPRESSED_DOWNLOAD_FLAG##";
    private static final String WF_PLACEHOLDER_SIMPLE_DESCRIPTION_FORMAT = "##SIMPLE_FORMAT_FLAG##";
    private static final String WF_PLACEHOLDER_TIMESTAMP = "##TIMESTAMP##";
    private static final String WORKFLOW_FILE_ENCODING = "UTF-8";
    private static final String PUBLISHED_WF_DATA_FILE_SUFFIX = ".wf.dat";
    private static final String PUBLISHED_WF_PLACEHOLDER_FILE_SUFFIX = ".ph.dat";
    private static final String PUBLISHED_WF_GROUP_KEY_PREFIX = "WF_GROUP_";
    private static final String PUBLISHED_WF_KEEP_DATA_KEY_PREFIX = "WF_KEEP_DATA";
    private static final String OUTPUT_INDENT = "    ";
    private final Log log = LogFactory.getLog(this.getClass());
    private final Map<String, String> publishedWorkflowTemplates = new HashMap<String, String>();
    private final Map<String, String> publishedWorkflowTemplatePlaceholders = new HashMap<String, String>();
    private final TempFileService tempFileService = TempFileServiceAccess.getInstance();
    private DistributedComponentKnowledgeService componentKnowledgeService;
    private HeadlessWorkflowExecutionService workflowExecutionService;
    private PlatformService platformService;
    private ConfigurationService configurationService;
    private LocalSystemMonitoringAggregationService localSystemMonitoringAggregationService;
    private PersistentSettingsService persistentSettingsService;
    private File publishedWfStorageDir;
    private EmbeddedSshServerControl embeddedSshServerControl;
    private ObjectMapper mapper = new ObjectMapper();
    private ServiceRegistryPublisherAccess serviceRegistryAccess;
    private List<String[]> toolTokens;
    private List<String[]> simpleToolTokens;
    private Map<String, String[]> wfTokens;
    private Map<String, String[]> simpleWfTokens;
    private Map<String, Map<String, String>> wfInputs;
    private Map<String, Map<String, String>> wfOutputs;
    private volatile Map<String, WorkflowExecutionInformation> sessionTokenToWfExecInf;
    private ToolIntegrationDocumentationService toolDocService;

    public void activate() {
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)this);
        this.registerChangeListener();
        this.sessionTokenToWfExecInf = new HashMap<String, WorkflowExecutionInformation>();
        ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

            @Override
            @TaskDescription(value="Server-Side Remote Access: Restore persistently published workflows")
            public void run() {
                RemoteAccessServiceImpl.this.restoreWorkflowTemplatesFromPublishedWfStorage();
            }
        });
        this.embeddedSshServerControl.setAnnouncedVersionOrProperty("RemoteAccess", "9.0.0");
    }

    @Reference
    public void bindToolIntegrationDocumentationService(ToolIntegrationDocumentationService newInstance) {
        this.toolDocService = newInstance;
    }

    private void registerChangeListener() {
        this.serviceRegistryAccess.registerService(DistributedComponentKnowledgeListener.class, (Object)new DistributedComponentKnowledgeListener(){

            public void onDistributedComponentKnowledgeChanged(DistributedComponentKnowledge newKnowledge) {
                RemoteAccessServiceImpl.this.updateToolTokens();
            }
        });
    }

    private void updateToolTokens() {
        this.toolTokens = new ArrayList<String[]>();
        this.simpleToolTokens = new ArrayList<String[]>();
        for (DistributedComponentEntry entry : this.getMatchingPublishedTools()) {
            ComponentInterface compInterface = entry.getComponentInterface();
            String nodeId = entry.getNodeId();
            String nodeName = NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)nodeId).getAssociatedDisplayName();
            try {
                HashMap<String, Object> rawEndpointData;
                HashMap<String, Object> rawEndpointData2;
                HashSet nodeInputSet = new HashSet();
                for (EndpointDefinition ed : entry.getComponentInterface().getInputDefinitionsProvider().getStaticEndpointDefinitions()) {
                    rawEndpointData2 = new HashMap<String, Object>();
                    rawEndpointData2.put("name", ed.getName());
                    rawEndpointData2.put(KEY_DATA_TYPES, ed.getPossibleDataTypes());
                    rawEndpointData2.put(KEY_DEFAULT_DATA_TYPE, ed.getDefaultDataType());
                    rawEndpointData2.put(KEY_INPUT_HANDLING_OPTIONS, ed.getInputDatumOptions());
                    rawEndpointData2.put(KEY_DEFAULT_INPUT_HANDLING, ed.getDefaultInputDatumHandling());
                    rawEndpointData2.put(KEY_EXECUTION_CONSTRAINT_OPTIONS, ed.getInputExecutionConstraintOptions());
                    rawEndpointData2.put(KEY_DEFAULT_EXECUTION_CONSTRAINT, ed.getDefaultInputExecutionConstraint());
                    nodeInputSet.add(rawEndpointData2);
                }
                for (EndpointDefinition ed : entry.getComponentInterface().getInputDefinitionsProvider().getDynamicEndpointDefinitions()) {
                    rawEndpointData2 = new HashMap();
                    rawEndpointData2.put("identifier", ed.getIdentifier());
                    rawEndpointData2.put(KEY_DATA_TYPES, ed.getPossibleDataTypes());
                    rawEndpointData2.put(KEY_DEFAULT_DATA_TYPE, ed.getDefaultDataType());
                    rawEndpointData2.put(KEY_INPUT_HANDLING_OPTIONS, ed.getInputDatumOptions());
                    rawEndpointData2.put(KEY_DEFAULT_INPUT_HANDLING, ed.getDefaultInputDatumHandling());
                    rawEndpointData2.put(KEY_EXECUTION_CONSTRAINT_OPTIONS, ed.getInputExecutionConstraintOptions());
                    rawEndpointData2.put(KEY_DEFAULT_EXECUTION_CONSTRAINT, ed.getDefaultInputExecutionConstraint());
                    Map<String, Map<String, Object>> rawMetadata = this.extractRawMetadata(ed);
                    rawEndpointData2.put(KEY_META_DATA, rawMetadata);
                    nodeInputSet.add(rawEndpointData2);
                }
                String nodeInputs = this.mapper.writeValueAsString(nodeInputSet);
                HashSet nodeOutputSet = new HashSet();
                for (EndpointDefinition ed : entry.getComponentInterface().getOutputDefinitionsProvider().getStaticEndpointDefinitions()) {
                    rawEndpointData = new HashMap<String, Object>();
                    rawEndpointData.put("name", ed.getName());
                    rawEndpointData.put(KEY_DATA_TYPES, ed.getPossibleDataTypes());
                    rawEndpointData.put(KEY_DEFAULT_DATA_TYPE, ed.getDefaultDataType());
                    nodeOutputSet.add(rawEndpointData);
                }
                for (EndpointDefinition ed : entry.getComponentInterface().getOutputDefinitionsProvider().getDynamicEndpointDefinitions()) {
                    rawEndpointData = new HashMap();
                    rawEndpointData.put("identifier", ed.getIdentifier());
                    rawEndpointData.put(KEY_DATA_TYPES, ed.getPossibleDataTypes());
                    rawEndpointData.put(KEY_DEFAULT_DATA_TYPE, ed.getDefaultDataType());
                    Map<String, Map<String, Object>> rawMetadata = this.extractRawMetadata(ed);
                    rawEndpointData.put(KEY_META_DATA, rawMetadata);
                    nodeOutputSet.add(rawEndpointData);
                }
                String nodeOutputs = this.mapper.writeValueAsString(nodeOutputSet);
                String toHash = String.valueOf(compInterface.getDisplayName()) + compInterface.getVersion() + nodeId + nodeName + nodeInputs + nodeOutputs + compInterface.getGroupName();
                this.toolTokens.add(new String[]{compInterface.getDisplayName(), compInterface.getVersion(), nodeId, nodeName, nodeInputs, nodeOutputs, compInterface.getGroupName(), Integer.toString(toHash.hashCode())});
                this.simpleToolTokens.add(new String[]{compInterface.getDisplayName(), compInterface.getVersion(), nodeId, nodeName});
            }
            catch (IOException iOException) {
                this.log.error((Object)"An error occured while creating descriptions of the available tools.");
            }
        }
    }

    private void addOrReplaceWorkflowInWfTokens(String publishId, String groupName, WorkflowDescription wd) {
        if (!this.checkIdString(publishId)) {
            this.log.error((Object)("Not listing the previously published remote access workflow " + publishId + "; the name contains characters that are not allowed anymore"));
            return;
        }
        String nodeId = this.platformService.getLocalDefaultLogicalNodeId().getLogicalNodeIdString();
        String nodeName = this.platformService.getLocalDefaultLogicalNodeId().getAssociatedDisplayName();
        String version = "1";
        if (groupName == null) {
            groupName = "SSH Remote Access Workflows";
        }
        ComponentDescription inputLoaderDesc = null;
        ComponentDescription outputCollectorDesc = null;
        for (WorkflowNode node : wd.getWorkflowNodes()) {
            ComponentDescription compDesc = node.getComponentDescription();
            String compId = compDesc.getIdentifier();
            if (compId.contains(DE_RCENVIRONMENT_SCPINPUTLOADER)) {
                inputLoaderDesc = compDesc;
                continue;
            }
            if (!compId.contains(DE_RCENVIRONMENT_SCPOUTPUTCOLLECTOR)) continue;
            outputCollectorDesc = compDesc;
        }
        if (inputLoaderDesc == null || outputCollectorDesc == null) {
            this.log.error((Object)("Error while parsing published workflow " + publishId));
            return;
        }
        try {
            HashSet nodeInputSet = new HashSet();
            HashMap<String, String> simpleInputsMap = new HashMap<String, String>();
            for (EndpointDescription ed : inputLoaderDesc.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                HashMap<String, Object> rawEndpointData = new HashMap<String, Object>();
                ArrayList<DataType> dataTypes = new ArrayList<DataType>();
                dataTypes.add(ed.getDataType());
                rawEndpointData.put(KEY_DATA_TYPES, dataTypes);
                rawEndpointData.put("name", ed.getName());
                rawEndpointData.put(KEY_DEFAULT_DATA_TYPE, ed.getDataType());
                nodeInputSet.add(rawEndpointData);
                simpleInputsMap.put(ed.getName(), ed.getDataType().getDisplayName());
            }
            String nodeInputs = this.mapper.writeValueAsString(nodeInputSet);
            HashSet nodeOutputSet = new HashSet();
            HashMap simpleOutputsMap = new HashMap();
            for (EndpointDescription ed : outputCollectorDesc.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
                HashMap<String, Object> rawEndpointData = new HashMap<String, Object>();
                rawEndpointData.put("name", ed.getName());
                ArrayList<DataType> dataTypes = new ArrayList<DataType>();
                dataTypes.add(ed.getDataType());
                rawEndpointData.put(KEY_DATA_TYPES, dataTypes);
                rawEndpointData.put(KEY_DEFAULT_DATA_TYPE, ed.getDataType());
                nodeOutputSet.add(rawEndpointData);
            }
            String nodeOutputs = this.mapper.writeValueAsString(nodeOutputSet);
            String toHash = String.valueOf(publishId) + version + nodeId + nodeName + nodeInputs + nodeOutputs;
            this.wfTokens.put(publishId, new String[]{publishId, version, groupName, nodeId, nodeName, nodeInputs, nodeOutputs, Integer.toString(toHash.hashCode())});
            this.simpleWfTokens.put(publishId, new String[]{publishId, version, nodeId, nodeName});
            this.wfInputs.put(publishId, simpleInputsMap);
            this.wfOutputs.put(publishId, simpleOutputsMap);
        }
        catch (IOException iOException) {
            this.log.error((Object)"An error occured while updating descriptions of the available workflows.");
        }
    }

    @Override
    public void printListOfAvailableTools(TextOutputReceiver outputReceiver, String format, boolean includeLoadData, int timeSpanMsec, int timeLimitMsec) throws InterruptedException, ExecutionException, TimeoutException {
        Map systemLoadData;
        if (includeLoadData) {
            HashSet<LogicalNodeId> reachableInstanceNodes = new HashSet<LogicalNodeId>();
            for (Object[] objectArray : this.toolTokens) {
                LogicalNodeId nodeIdObj = NodeIdentifierUtils.parseLogicalNodeIdStringWithExceptionWrapping((String)((String)objectArray[2]));
                reachableInstanceNodes.add(nodeIdObj);
            }
            systemLoadData = this.localSystemMonitoringAggregationService.collectSystemMonitoringDataWithTimeLimit(reachableInstanceNodes, timeSpanMsec, timeLimitMsec);
        } else {
            systemLoadData = null;
        }
        if ("csv".equals(format)) {
            this.printComponentsListAsCsv(outputReceiver, systemLoadData);
        } else if ("token-stream".equals(format)) {
            this.printComponentsListAsTokens(outputReceiver, systemLoadData);
        } else if ("simple".equals(format)) {
            this.printSimpleComponentsListAsTokens(outputReceiver, systemLoadData);
        } else {
            throw new IllegalArgumentException("Unrecognized output format: " + format);
        }
    }

    private void printSimpleComponentsListAsTokens(TextOutputReceiver outputReceiver, Map<LogicalNodeId, SystemLoadInformation> systemLoadData) {
        outputReceiver.addOutput(Integer.toString(this.simpleToolTokens.size()));
        if (systemLoadData != null) {
            outputReceiver.addOutput("9");
        } else {
            outputReceiver.addOutput("5");
        }
        for (String[] tokens : this.simpleToolTokens) {
            long availableRam;
            int timeSpan;
            int numSamples;
            double cpuAvg;
            int i = 0;
            while (i < tokens.length) {
                outputReceiver.addOutput(tokens[i]);
                ++i;
            }
            if (systemLoadData == null) continue;
            String nodeId = tokens[2];
            LogicalNodeId nodeIdObj = NodeIdentifierUtils.parseLogicalNodeIdStringWithExceptionWrapping((String)nodeId);
            SystemLoadInformation loadDataEntry = systemLoadData.get(nodeIdObj);
            if (loadDataEntry != null) {
                AverageOfDoubles cpuLoadAvg = loadDataEntry.getCpuLoadAvg();
                cpuAvg = cpuLoadAvg.getAverage() * 100.0;
                numSamples = cpuLoadAvg.getNumSamples();
                timeSpan = cpuLoadAvg.getNumSamples() * 1000;
                availableRam = loadDataEntry.getAvailableRam();
            } else {
                cpuAvg = -1.0;
                numSamples = -1;
                timeSpan = -1;
                availableRam = -1L;
            }
            outputReceiver.addOutput(StringUtils.format((String)FORMAT_2F, (Object[])new Object[]{cpuAvg}));
            outputReceiver.addOutput(Integer.toString(numSamples));
            outputReceiver.addOutput(Integer.toString(timeSpan));
            outputReceiver.addOutput(Long.toString(availableRam));
        }
    }

    @Override
    public void printToolDetails(TextOutputReceiver outputReceiver, String toolId, String toolVersion, String nodeId, boolean template) {
        DistributedComponentEntry entry = this.getMatchingComponentInstallationForTool(toolId, toolVersion, nodeId);
        if (template) {
            HashMap<String, String> inputsMap = new HashMap<String, String>();
            for (EndpointDefinition ed : entry.getComponentInterface().getInputDefinitionsProvider().getStaticEndpointDefinitions()) {
                inputsMap.put(ed.getName(), "<" + ed.getDefaultDataType().getDisplayName() + ">");
            }
            try {
                outputReceiver.addOutput(this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(inputsMap));
            }
            catch (IOException e) {
                this.log.error((Object)("Writing template failed: " + e.getMessage()));
            }
        } else {
            outputReceiver.addOutput("Inputs:");
            outputReceiver.addOutput(NAME_DATA_TYPE);
            for (EndpointDefinition ed : entry.getComponentInterface().getInputDefinitionsProvider().getStaticEndpointDefinitions()) {
                outputReceiver.addOutput(String.valueOf(ed.getName()) + TAB + ed.getDefaultDataType());
            }
            outputReceiver.addOutput("\nOutputs:");
            outputReceiver.addOutput(NAME_DATA_TYPE);
            for (EndpointDefinition ed : entry.getComponentInterface().getOutputDefinitionsProvider().getStaticEndpointDefinitions()) {
                outputReceiver.addOutput(String.valueOf(ed.getName()) + TAB + ed.getDefaultDataType());
            }
        }
    }

    @Override
    public void printWfDetails(TextOutputReceiver outputReceiver, String wfId, boolean template) {
        Map<String, String> simpleInputsMap = this.wfInputs.get(wfId);
        Map<String, String> simpleOutputsMap = this.wfInputs.get(wfId);
        if (template) {
            HashMap<String, String> inputsMap = new HashMap<String, String>();
            for (String inputName : simpleInputsMap.keySet()) {
                inputsMap.put(inputName, "<" + simpleInputsMap.get(inputName) + ">");
            }
            try {
                outputReceiver.addOutput(this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(inputsMap));
            }
            catch (IOException e) {
                this.log.error((Object)("Writing template failed: " + e.getMessage()));
            }
        } else {
            outputReceiver.addOutput("Inputs:");
            outputReceiver.addOutput(NAME_DATA_TYPE);
            for (String inputName : simpleInputsMap.keySet()) {
                outputReceiver.addOutput(String.valueOf(inputName) + TAB + simpleInputsMap.get(inputName));
            }
            outputReceiver.addOutput("\nOutputs:");
            outputReceiver.addOutput(NAME_DATA_TYPE);
            for (String outputName : simpleOutputsMap.keySet()) {
                outputReceiver.addOutput(String.valueOf(outputName) + TAB + simpleOutputsMap.get(outputName));
            }
        }
    }

    @Override
    public void printListOfAvailableWorkflows(TextOutputReceiver outputReceiver, String format) {
        if ("token-stream".equals(format)) {
            outputReceiver.addOutput(Integer.toString(this.wfTokens.size()));
            outputReceiver.addOutput("8");
            for (String[] tokens : this.wfTokens.values()) {
                int i = 0;
                while (i < tokens.length) {
                    outputReceiver.addOutput(tokens[i]);
                    ++i;
                }
            }
        } else if ("simple".equals(format)) {
            outputReceiver.addOutput(Integer.toString(this.simpleWfTokens.size()));
            outputReceiver.addOutput("4");
            for (String[] tokens : this.simpleWfTokens.values()) {
                int i = 0;
                while (i < tokens.length) {
                    outputReceiver.addOutput(tokens[i]);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Unrecognized output format: " + format);
        }
    }

    @Override
    public FinalWorkflowState runSingleToolWorkflow(RemoteComponentExecutionParameter parameters, SingleConsoleRowsProcessor consoleRowReceiver) throws IOException, WorkflowExecutionException {
        this.validateIdString(parameters.getToolId());
        this.validateVersionString(parameters.getToolVersion());
        ExecutionSetup executionSetup = this.generateSingleToolExecutionSetup(parameters);
        return this.executeConfiguredWorkflow(executionSetup, consoleRowReceiver, false);
    }

    @Override
    public FinalWorkflowState runPublishedWorkflowTemplate(String workflowId, String sessionToken, File inputFilesDir, File outputFilesDir, SingleConsoleRowsProcessor consoleRowReceiver, boolean uncompressedUpload, boolean simpleDescription) throws IOException, WorkflowExecutionException {
        this.validateIdString(workflowId);
        ExecutionSetup executionSetup = this.generateWorkflowExecutionSetup(workflowId, sessionToken, inputFilesDir, outputFilesDir, uncompressedUpload, simpleDescription);
        boolean neverDeleteExecutionData = false;
        String keepData = this.persistentSettingsService.readStringValue(PUBLISHED_WF_KEEP_DATA_KEY_PREFIX + workflowId);
        if (keepData != null) {
            neverDeleteExecutionData = Boolean.parseBoolean(keepData);
        }
        return this.executeConfiguredWorkflow(executionSetup, consoleRowReceiver, neverDeleteExecutionData);
    }

    @Override
    public void checkAndPublishWorkflowFile(File wfFile, File placeholdersFile, String publishId, String groupName, TextOutputReceiver outputReceiver, boolean persistent, boolean neverDeleteExecutionData) throws WorkflowExecutionException {
        WorkflowDescription wd;
        this.validateIdString(publishId);
        try {
            wd = this.workflowExecutionService.loadWorkflowDescriptionFromFileConsideringUpdates(wfFile, (WorkflowDescriptionLoaderCallback)new HeadlessWorkflowDescriptionLoaderCallback(outputReceiver));
        }
        catch (WorkflowFileException e) {
            throw new WorkflowExecutionException("Failed to load workflow file: " + wfFile.getAbsolutePath(), (Exception)((Object)e));
        }
        if (placeholdersFile != null) {
            try {
                this.workflowExecutionService.validatePlaceholdersFile(placeholdersFile);
            }
            catch (WorkflowFileException e) {
                throw new WorkflowExecutionException("Failed to validate placeholders file: " + wfFile.getAbsolutePath(), (Exception)((Object)e));
            }
        }
        File workflowStorageFile = this.getWorkflowStorageFile(publishId);
        File placeholderStorageFile = this.getPlaceholderStorageFile(publishId);
        if (!persistent && workflowStorageFile.exists()) {
            throw new WorkflowExecutionException("You are trying to overwrite a persistently published workflow with a temporary/transient one; if this is what you want to do, unpublish the old workflow first, then publish the new one again");
        }
        outputReceiver.addOutput(StringUtils.format((String)"Checking workflow file \"%s\"", (Object[])new Object[]{wfFile.getAbsolutePath()}));
        if (this.validateWorkflowFileAsTemplate(wd, outputReceiver)) {
            try {
                String wfFileContent = this.readFile(wfFile);
                String replaced = this.publishedWorkflowTemplates.put(publishId, wfFileContent);
                if (persistent) {
                    FileUtils.writeStringToFile((File)workflowStorageFile, (String)wfFileContent);
                    if (groupName != null) {
                        this.persistentSettingsService.saveStringValue(PUBLISHED_WF_GROUP_KEY_PREFIX + publishId, groupName);
                    }
                }
                if (placeholdersFile != null) {
                    String placeholdersFileContent = this.readFile(placeholdersFile);
                    this.publishedWorkflowTemplatePlaceholders.put(publishId, placeholdersFileContent);
                    if (persistent) {
                        FileUtils.writeStringToFile((File)placeholderStorageFile, (String)placeholdersFileContent);
                    }
                } else {
                    this.publishedWorkflowTemplatePlaceholders.put(publishId, null);
                }
                if (replaced == null) {
                    outputReceiver.addOutput(StringUtils.format((String)"Successfully published workflow \"%s\"", (Object[])new Object[]{publishId}));
                } else {
                    outputReceiver.addOutput(StringUtils.format((String)"Successfully updated the published workflow \"%s\"", (Object[])new Object[]{publishId}));
                }
            }
            catch (IOException iOException) {
                this.publishedWorkflowTemplates.remove(publishId);
                FileUtils.deleteQuietly((File)workflowStorageFile);
                throw new WorkflowExecutionException("Error publishing workflow file " + wfFile.getAbsolutePath());
            }
        }
        this.persistentSettingsService.saveStringValue(PUBLISHED_WF_KEEP_DATA_KEY_PREFIX + publishId, Boolean.toString(neverDeleteExecutionData));
        this.addOrReplaceWorkflowInWfTokens(publishId, groupName, wd);
    }

    @Override
    public void unpublishWorkflowForId(String publishId, TextOutputReceiver outputReceiver) throws WorkflowExecutionException {
        File placeholderStorageFile;
        this.validateIdString(publishId);
        String removed = this.publishedWorkflowTemplates.remove(publishId);
        this.publishedWorkflowTemplatePlaceholders.remove(publishId);
        File workflowStorageFile = this.getWorkflowStorageFile(publishId);
        if (workflowStorageFile.isFile()) {
            try {
                Files.delete(workflowStorageFile.toPath());
            }
            catch (IOException iOException) {
                throw new WorkflowExecutionException("Failed to unpublish the specified workflow; its storage file may be write-protected");
            }
        }
        if ((placeholderStorageFile = this.getPlaceholderStorageFile(publishId)).isFile()) {
            try {
                Files.delete(placeholderStorageFile.toPath());
            }
            catch (IOException iOException) {
                throw new WorkflowExecutionException("Failed to unpublish the published placeholder file for the specified workflow; its storage file may be write-protected");
            }
        }
        if (removed != null) {
            outputReceiver.addOutput(StringUtils.format((String)"Successfully unpublished workflow \"%s\"", (Object[])new Object[]{publishId}));
        } else {
            outputReceiver.addOutput(StringUtils.format((String)"ERROR: There is no workflow with id \"%s\" to unpublish", (Object[])new Object[]{publishId}));
        }
        this.wfTokens.remove(publishId);
        this.simpleWfTokens.remove(publishId);
        this.persistentSettingsService.delete(PUBLISHED_WF_KEEP_DATA_KEY_PREFIX + publishId);
        this.persistentSettingsService.delete(PUBLISHED_WF_GROUP_KEY_PREFIX + publishId);
    }

    @Override
    public void printSummaryOfPublishedWorkflows(TextOutputReceiver outputReceiver) {
        if (this.publishedWorkflowTemplates.isEmpty()) {
            outputReceiver.addOutput("There are no workflows published for remote execution");
            return;
        }
        outputReceiver.addOutput("Workflows published for remote execution:");
        for (String publishId : this.publishedWorkflowTemplates.keySet()) {
            String placeholders = "no";
            if (this.publishedWorkflowTemplatePlaceholders.get(publishId) != null) {
                placeholders = "yes";
            }
            outputReceiver.addOutput(StringUtils.format((String)"- %s (using placeholders: %s)", (Object[])new Object[]{publishId, placeholders}));
        }
    }

    @Override
    public String validateToolParametersAndGetFinalNodeId(String toolId, String toolVersion, String nodeId) throws WorkflowExecutionException {
        List<DistributedComponentEntry> availableTools = this.getMatchingPublishedTools();
        this.validateIdString(toolId);
        this.validateVersionString(toolVersion);
        DistributedComponentEntry nodeMatch = null;
        for (DistributedComponentEntry compInst : availableTools) {
            ComponentInterface compInterface = compInst.getComponentInterface();
            if (!toolId.equals(compInterface.getDisplayName()) || !toolVersion.equals(compInterface.getVersion())) continue;
            if (nodeId != null) {
                if (!nodeId.equals(compInst.getNodeId())) continue;
                return compInst.getNodeId();
            }
            if (nodeMatch == null) {
                nodeMatch = compInst;
                continue;
            }
            throw new WorkflowExecutionException(StringUtils.format((String)"Tool selection is ambiguous without a node id; tool '%s', version '%s' is provided by more than one node", (Object[])new Object[]{toolId, toolVersion}));
        }
        if (nodeId == null) {
            if (nodeMatch != null) {
                return nodeMatch.getNodeId();
            }
            throw new WorkflowExecutionException(StringUtils.format((String)"No matching tool for tool '%s' in version '%s'", (Object[])new Object[]{toolId, toolVersion, nodeId}));
        }
        throw new WorkflowExecutionException(StringUtils.format((String)"No matching tool for tool '%s' in version '%s', running on a node with id '%s'", (Object[])new Object[]{toolId, toolVersion, nodeId}));
    }

    @Reference
    public void bindWorkflowExecutionService(HeadlessWorkflowExecutionService newInstance) {
        this.workflowExecutionService = newInstance;
    }

    @Reference
    public void bindPersistentSettingsService(PersistentSettingsService newInstance) {
        this.persistentSettingsService = newInstance;
    }

    @Reference
    public void bindPlatformService(PlatformService newInstance) {
        this.platformService = newInstance;
    }

    @Reference
    public void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService newInstance) {
        this.componentKnowledgeService = newInstance;
    }

    @Reference
    public void bindLocalSystemMonitoringAggregationService(LocalSystemMonitoringAggregationService newInstance) {
        this.localSystemMonitoringAggregationService = newInstance;
    }

    @Reference
    public void bindEmbeddedSshServerControl(EmbeddedSshServerControl newInstance) {
        this.embeddedSshServerControl = newInstance;
    }

    @Reference
    public void bindConfigurationService(ConfigurationService newInstance) {
        this.configurationService = newInstance;
    }

    private void restoreWorkflowTemplatesFromPublishedWfStorage() {
        this.publishedWfStorageDir = new File(this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_INTERNAL_DATA), "ra/published-wf");
        this.publishedWfStorageDir.mkdirs();
        if (!this.publishedWfStorageDir.isDirectory()) {
            this.log.error((Object)("Failed to create Remote Access workflow storage directory " + this.publishedWfStorageDir.getAbsolutePath()));
            this.publishedWfStorageDir = null;
            return;
        }
        this.wfTokens = new HashMap<String, String[]>();
        this.simpleWfTokens = new HashMap<String, String[]>();
        this.wfInputs = new HashMap<String, Map<String, String>>();
        this.wfOutputs = new HashMap<String, Map<String, String>>();
        File[] fileArray = this.publishedWfStorageDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String wfId;
            File f = fileArray[n2];
            String filename = f.getName();
            if (filename.endsWith(PUBLISHED_WF_DATA_FILE_SUFFIX)) {
                wfId = filename.substring(0, filename.length() - PUBLISHED_WF_DATA_FILE_SUFFIX.length());
                if (this.initWorkflowTokens(f, wfId)) {
                    try {
                        this.publishedWorkflowTemplates.put(wfId, FileUtils.readFileToString((File)f));
                    }
                    catch (IOException e) {
                        this.log.error((Object)("Failed to restore data of published RemoteAccess workflow from storage file " + f.getAbsolutePath()), (Throwable)e);
                    }
                }
            } else if (filename.endsWith(PUBLISHED_WF_PLACEHOLDER_FILE_SUFFIX)) {
                wfId = filename.substring(0, filename.length() - PUBLISHED_WF_PLACEHOLDER_FILE_SUFFIX.length());
                try {
                    this.publishedWorkflowTemplatePlaceholders.put(wfId, FileUtils.readFileToString((File)f));
                }
                catch (IOException e) {
                    this.log.error((Object)("Failed to restore placeholder data of published RemoteAccess workflow from storage file " + f.getAbsolutePath()), (Throwable)e);
                }
            } else {
                this.log.error((Object)("Unexpected file in RemoteAccess storage directory, ignoring: " + f.getAbsolutePath()));
            }
            ++n2;
        }
    }

    private boolean initWorkflowTokens(File f, String wfId) {
        block3: {
            WorkflowDescription wd = null;
            TextOutputReceiver outputReceiver = new TextOutputReceiver(){

                public void addOutput(String line) {
                    RemoteAccessServiceImpl.this.log.debug((Object)("Output of command-line batch command(s): " + line));
                }

                public void onStart() {
                }

                public void onFatalError(Exception e) {
                    RemoteAccessServiceImpl.this.log.error((Object)e.getMessage());
                }

                public void onFinished() {
                }
            };
            wd = this.workflowExecutionService.loadWorkflowDescriptionFromFileConsideringUpdates(f, (WorkflowDescriptionLoaderCallback)new HeadlessWorkflowDescriptionLoaderCallback(outputReceiver), true);
            if (!this.validateWorkflowFileAsTemplate(wd, outputReceiver)) break block3;
            String groupName = this.persistentSettingsService.readStringValue(PUBLISHED_WF_GROUP_KEY_PREFIX + wfId);
            this.addOrReplaceWorkflowInWfTokens(wfId, groupName, wd);
            return true;
        }
        try {
            this.log.error((Object)("Failed to restore permanently published workflow " + wfId + ". Probably it was published with an older version" + " of RCE. Please publish the workflow again with the current RCE version."));
            return false;
        }
        catch (WorkflowExecutionException | WorkflowFileException e) {
            this.log.error((Object)("Failed to load published workflow file: " + f.getAbsolutePath()), e);
            return false;
        }
    }

    private File getWorkflowStorageFile(String id) throws WorkflowExecutionException {
        if (this.publishedWfStorageDir == null) {
            throw new WorkflowExecutionException("The workflow storage directory was not properly initialized; cannot execute this command");
        }
        File file = new File(this.publishedWfStorageDir, String.valueOf(id) + PUBLISHED_WF_DATA_FILE_SUFFIX);
        this.log.debug((Object)("Resolved workflow publish id to storage filename " + file.getAbsolutePath()));
        return file;
    }

    private File getPlaceholderStorageFile(String id) throws WorkflowExecutionException {
        if (this.publishedWfStorageDir == null) {
            throw new WorkflowExecutionException("The workflow storage directory was not properly initialized; cannot execute this command");
        }
        return new File(this.publishedWfStorageDir, String.valueOf(id) + PUBLISHED_WF_PLACEHOLDER_FILE_SUFFIX);
    }

    private boolean isComponentSuitableAsRemoteAccessTool(DistributedComponentEntry entry) {
        ComponentInterface compInterf = entry.getComponentInterface();
        if (!this.checkIdString(compInterf.getDisplayName()) || !this.checkVersionString(compInterf.getVersion())) {
            return false;
        }
        if (!compInterf.getIdentifierAndVersion().startsWith("de.rcenvironment.integration")) {
            return false;
        }
        return entry.getDeclaredPermissionSet().isPublic();
    }

    private List<DistributedComponentEntry> getMatchingPublishedTools() {
        ArrayList<DistributedComponentEntry> components = new ArrayList<DistributedComponentEntry>();
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        for (DistributedComponentEntry entry : compKnowledge.getKnownSharedInstallations()) {
            if (!this.isComponentSuitableAsRemoteAccessTool(entry)) continue;
            components.add(entry);
        }
        return components;
    }

    private DistributedComponentEntry getMatchingComponentInstallationForTool(String toolName, String toolVersion, String toolNodeId) {
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        DistributedComponentEntry matchingComponent = null;
        for (DistributedComponentEntry entry : compKnowledge.getKnownSharedInstallations()) {
            if (!entry.getComponentInterface().getDisplayName().equals(toolName) || !entry.getComponentInterface().getVersion().equals(toolVersion) || !entry.getNodeId().equals(toolNodeId)) continue;
            matchingComponent = entry;
        }
        return matchingComponent;
    }

    private String getFullIdentifierForTool(String toolNameAndVersion) {
        String[] splitToolId = toolNameAndVersion.split("/");
        String toolName = splitToolId[0];
        String toolVersion = splitToolId[1];
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        String fullId = null;
        for (DistributedComponentEntry entry : compKnowledge.getKnownSharedInstallations()) {
            if (!entry.getComponentInterface().getDisplayName().equals(toolName) || !entry.getComponentInterface().getVersion().equals(toolVersion)) continue;
            fullId = entry.getComponentInterface().getIdentifierAndVersion();
        }
        return fullId;
    }

    private ComponentInstallation getInputLoaderComponentInstallation() {
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        ComponentInstallation component = null;
        for (DistributedComponentEntry entry : compKnowledge.getAllLocalInstallations()) {
            if (!entry.getComponentInterface().getIdentifierAndVersion().startsWith(DE_RCENVIRONMENT_SCPINPUTLOADER)) continue;
            component = entry.getComponentInstallation();
        }
        return component;
    }

    private ComponentInstallation getOutputCollectorComponentInstallation() {
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        ComponentInstallation component = null;
        for (DistributedComponentEntry entry : compKnowledge.getAllLocalInstallations()) {
            if (!entry.getComponentInterface().getIdentifierAndVersion().startsWith(DE_RCENVIRONMENT_SCPOUTPUTCOLLECTOR)) continue;
            component = entry.getComponentInstallation();
        }
        return component;
    }

    private void printComponentsListAsCsv(TextOutputReceiver outputReceiver, Map<LogicalNodeId, SystemLoadInformation> systemLoadData) {
        CSVFormat csvFormat = CSVFormat.newFormat((char)' ').withQuote('\"').withQuoteMode(QuoteMode.ALL);
        if (this.toolTokens != null) {
            for (Object[] objectArray : this.toolTokens) {
                if (systemLoadData != null) {
                    long availableRam;
                    int timeSpan;
                    int numSamples;
                    double cpuAvg;
                    String nodeId = (String)objectArray[2];
                    LogicalNodeId nodeIdObj = NodeIdentifierUtils.parseLogicalNodeIdStringWithExceptionWrapping((String)nodeId);
                    SystemLoadInformation loadDataEntry = systemLoadData.get(nodeIdObj);
                    if (loadDataEntry != null) {
                        AverageOfDoubles cpuLoadAvg = loadDataEntry.getCpuLoadAvg();
                        cpuAvg = cpuLoadAvg.getAverage() * 100.0;
                        numSamples = cpuLoadAvg.getNumSamples();
                        timeSpan = cpuLoadAvg.getNumSamples() * 1000;
                        availableRam = loadDataEntry.getAvailableRam();
                    } else {
                        cpuAvg = -1.0;
                        numSamples = -1;
                        timeSpan = -1;
                        availableRam = -1L;
                    }
                    String line = csvFormat.format(new Object[]{objectArray, StringUtils.format((String)FORMAT_2F, (Object[])new Object[]{cpuAvg}), numSamples, timeSpan, availableRam});
                    outputReceiver.addOutput(line);
                    continue;
                }
                String line = csvFormat.format(objectArray);
                outputReceiver.addOutput(line);
            }
        }
    }

    private Map<String, Map<String, Object>> extractRawMetadata(EndpointDefinition ed) {
        HashMap<String, Map<String, Object>> rawMetadata = new HashMap<String, Map<String, Object>>();
        for (String key : ed.getMetaDataDefinition().getMetaDataKeys()) {
            HashMap<String, Object> metaDataForKey = new HashMap<String, Object>();
            metaDataForKey.put("guiName", ed.getMetaDataDefinition().getGuiName(key));
            metaDataForKey.put("guiPosition", Integer.toString(ed.getMetaDataDefinition().getGuiPosition(key)));
            metaDataForKey.put("guiGroup", ed.getMetaDataDefinition().getGuiGroup(key));
            metaDataForKey.put(KEY_POSSIBLE_VALUES, ed.getMetaDataDefinition().getPossibleValues(key));
            metaDataForKey.put(KEY_DEFAULT_VALUE, ed.getMetaDataDefinition().getDefaultValue(key));
            metaDataForKey.put("visibility", ed.getMetaDataDefinition().getVisibility(key));
            rawMetadata.put(key, metaDataForKey);
        }
        return rawMetadata;
    }

    private void printComponentsListAsTokens(TextOutputReceiver outputReceiver, Map<LogicalNodeId, SystemLoadInformation> systemLoadData) {
        outputReceiver.addOutput(Integer.toString(this.toolTokens.size()));
        if (systemLoadData != null) {
            outputReceiver.addOutput("11");
        } else {
            outputReceiver.addOutput("7");
        }
        for (String[] tokens : this.toolTokens) {
            long availableRam;
            int timeSpan;
            int numSamples;
            double cpuAvg;
            int i = 0;
            while (i < tokens.length) {
                outputReceiver.addOutput(tokens[i]);
                ++i;
            }
            if (systemLoadData == null) continue;
            String nodeId = tokens[2];
            LogicalNodeId nodeIdObj = NodeIdentifierUtils.parseLogicalNodeIdStringWithExceptionWrapping((String)nodeId);
            SystemLoadInformation loadDataEntry = systemLoadData.get(nodeIdObj);
            if (loadDataEntry != null) {
                AverageOfDoubles cpuLoadAvg = loadDataEntry.getCpuLoadAvg();
                cpuAvg = cpuLoadAvg.getAverage() * 100.0;
                numSamples = cpuLoadAvg.getNumSamples();
                timeSpan = cpuLoadAvg.getNumSamples() * 1000;
                availableRam = loadDataEntry.getAvailableRam();
            } else {
                cpuAvg = -1.0;
                numSamples = -1;
                timeSpan = -1;
                availableRam = -1L;
            }
            outputReceiver.addOutput(StringUtils.format((String)FORMAT_2F, (Object[])new Object[]{cpuAvg}));
            outputReceiver.addOutput(Integer.toString(numSamples));
            outputReceiver.addOutput(Integer.toString(timeSpan));
            outputReceiver.addOutput(Long.toString(availableRam));
        }
    }

    private boolean validateWorkflowFileAsTemplate(WorkflowDescription wd, TextOutputReceiver outputReceiver) throws WorkflowExecutionException {
        this.validateEquals(5, wd.getWorkflowVersion(), "Invalid workflow file version");
        int foundInputLoaders = 0;
        int foundOutputCollectors = 0;
        for (WorkflowNode node : wd.getWorkflowNodes()) {
            outputReceiver.addOutput("    Checking component \"" + node.getName() + "\"  [" + node.getIdentifierAsObject().toString() + "]");
            ComponentDescription compDesc = node.getComponentDescription();
            String compId = compDesc.getIdentifier();
            String compVersion = compDesc.getVersion();
            if (compId.contains(DE_RCENVIRONMENT_SCPINPUTLOADER)) {
                this.validateEquals("1.1", compVersion, "Invalid component version");
                ++foundInputLoaders;
                continue;
            }
            if (!compId.contains(DE_RCENVIRONMENT_SCPOUTPUTCOLLECTOR)) continue;
            this.validateEquals("1.1", compVersion, "Invalid component version");
            ++foundOutputCollectors;
        }
        if (foundInputLoaders == 1 && foundOutputCollectors == 1) {
            outputReceiver.addOutput("Validation successful.");
            return true;
        }
        outputReceiver.addOutput("Validation failed: The workflow has to contain exactly one input loader and exactly one output collector.");
        return false;
    }

    private void validateEquals(Object expected, Object actual, String message) throws WorkflowExecutionException {
        if (!expected.equals(actual)) {
            throw new WorkflowExecutionException(StringUtils.format((String)"%s: Expected \"%s\", but found \"%s\"", (Object[])new Object[]{message, expected, actual}));
        }
    }

    private boolean checkIdString(String id) {
        return !CommonIdRules.validateCommonIdRules((String)id).isPresent();
    }

    private boolean checkVersionString(String id) {
        return !CommonIdRules.validateCommonVersionStringRules((String)id).isPresent();
    }

    private void validateIdString(String id) throws WorkflowExecutionException {
        Optional valdationErrorMessage = CommonIdRules.validateCommonIdRules((String)id);
        if (valdationErrorMessage.isPresent()) {
            throw new WorkflowExecutionException("Invalid tool id or workflow id \"" + id + "\": " + valdationErrorMessage);
        }
    }

    private void validateVersionString(String id) throws WorkflowExecutionException {
        Optional valdationErrorMessage = CommonIdRules.validateCommonVersionStringRules((String)id);
        if (valdationErrorMessage.isPresent()) {
            throw new WorkflowExecutionException("Invalid version \"" + id + "\": " + valdationErrorMessage);
        }
    }

    private String readFile(File placeholdersFile) throws IOException {
        return FileUtils.readFileToString((File)placeholdersFile, (String)WORKFLOW_FILE_ENCODING);
    }

    private void renameAsOld(File outputFilesDir) {
        File tempDestination = new File(outputFilesDir.getParentFile(), String.valueOf(outputFilesDir.getName()) + ".old." + System.currentTimeMillis());
        outputFilesDir.renameTo(tempDestination);
        if (outputFilesDir.isDirectory()) {
            this.log.warn((Object)("Tried to move directory " + outputFilesDir.getAbsolutePath() + " to " + tempDestination.getAbsolutePath() + ", but it is still present"));
        }
    }

    private ExecutionSetup generateSingleToolExecutionSetup(RemoteComponentExecutionParameter parameterObject) throws IOException {
        Map metaData;
        DataType type;
        String identifier;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        String timestampString = dateFormat.format(new Date());
        WorkflowDescription workflowDesc = new WorkflowDescription(UUID.randomUUID().toString());
        workflowDesc.setWorkflowVersion(Integer.valueOf(5));
        workflowDesc.setName("Remote_Tool_Access-" + timestampString + "-" + parameterObject.getToolId());
        DistributedComponentEntry matchingComponentEntry = this.getMatchingComponentInstallationForTool(parameterObject.getToolId(), parameterObject.getToolVersion(), parameterObject.getToolNodeId());
        WorkflowNode tool = new WorkflowNode(new ComponentDescription(matchingComponentEntry.getComponentInstallation()));
        WorkflowNode inputloader = new WorkflowNode(new ComponentDescription(this.getInputLoaderComponentInstallation()));
        WorkflowNode outputcollector = new WorkflowNode(new ComponentDescription(this.getOutputCollectorComponentInstallation()));
        tool.setName(parameterObject.getToolId());
        tool.setLocation(400, 200);
        inputloader.setName("Scp Input Loader");
        inputloader.getConfigurationDescription().setConfigurationValue("UploadDirectory", parameterObject.getInputFilesDir().getAbsolutePath());
        inputloader.getConfigurationDescription().setConfigurationValue("UncompressedUpload", Boolean.toString(parameterObject.isUncompressedUpload()));
        inputloader.getConfigurationDescription().setConfigurationValue("SimpleDescriptionFormat", Boolean.toString(parameterObject.isSimpleDescriptionFormat()));
        inputloader.setLocation(200, 200);
        outputcollector.setName("Scp output collector");
        outputcollector.getConfigurationDescription().setConfigurationValue("DownloadDirectory", parameterObject.getOutputFilesDir().getAbsolutePath());
        outputcollector.getConfigurationDescription().setConfigurationValue("UncompressedDownload", Boolean.toString(parameterObject.isUncompressedUpload()));
        outputcollector.getConfigurationDescription().setConfigurationValue("SimpleDescriptionFormat", Boolean.toString(parameterObject.isSimpleDescriptionFormat()));
        outputcollector.setLocation(600, 200);
        workflowDesc.addWorkflowNode(inputloader);
        workflowDesc.addWorkflowNode(tool);
        workflowDesc.addWorkflowNode(outputcollector);
        if (parameterObject.getDynInputDesc() != null) {
            Set dynInputsSet = (Set)this.mapper.readValue(parameterObject.getDynInputDesc(), new HashSet().getClass());
            for (Map dynInput : dynInputsSet) {
                String inputName = (String)dynInput.get("name");
                identifier = (String)dynInput.get("identifier");
                type = DataType.valueOf((String)((String)dynInput.get(KEY_DATA_TYPE)));
                metaData = (Map)dynInput.get(KEY_META_DATA);
                tool.getInputDescriptionsManager().addDynamicEndpointDescription(identifier, inputName, type, metaData);
            }
        }
        if (parameterObject.getDynOutputDesc() != null) {
            Set dynOutputsSet = (Set)this.mapper.readValue(parameterObject.getDynOutputDesc(), new HashSet().getClass());
            for (Map dynOutput : dynOutputsSet) {
                String outputName = (String)dynOutput.get("name");
                identifier = (String)dynOutput.get("identifier");
                type = DataType.valueOf((String)((String)dynOutput.get(KEY_DATA_TYPE)));
                metaData = (Map)dynOutput.get(KEY_META_DATA);
                tool.getOutputDescriptionsManager().addDynamicEndpointDescription(identifier, outputName, type, metaData);
            }
        }
        Set nonReqInputsSet = new HashSet();
        if (parameterObject.getNotRequiredInputs() != null) {
            nonReqInputsSet = (Set)this.mapper.readValue(parameterObject.getNotRequiredInputs(), new HashSet().getClass());
        }
        EndpointDescriptionsManager inputLoaderOutputs = inputloader.getOutputDescriptionsManager();
        for (EndpointDescription inputDesc : tool.getInputDescriptionsManager().getEndpointDescriptions()) {
            String inputName = inputDesc.getName();
            DataType dataType = inputDesc.getDataType();
            EndpointDescription outputDesc = inputLoaderOutputs.addDynamicEndpointDescription("default", inputName, dataType, new HashMap());
            Connection inputConnection = new Connection(inputloader, outputDesc, tool, inputDesc);
            workflowDesc.addConnection(inputConnection);
            if (!nonReqInputsSet.contains(inputName)) continue;
            Map metaData2 = inputDesc.getMetaData();
            metaData2.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.NotRequired.toString());
            tool.getInputDescriptionsManager().editStaticEndpointDescription(inputName, dataType, metaData2);
            inputDesc.setMetaDataValue("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.NotRequired.toString());
        }
        EndpointDescriptionsManager outputCollectorInputs = outputcollector.getInputDescriptionsManager();
        for (EndpointDescription outputDesc : tool.getOutputDescriptionsManager().getEndpointDescriptions()) {
            String inputName = outputDesc.getName();
            DataType dataType = outputDesc.getDataType();
            EndpointDescription inputDesc = outputCollectorInputs.addDynamicEndpointDescription("default", inputName, dataType, new HashMap());
            Connection outputConnection = new Connection(tool, outputDesc, outputcollector, inputDesc);
            workflowDesc.addConnection(outputConnection);
        }
        File wfFile = this.tempFileService.createTempFileFromPattern("rta-*.wf");
        WorkflowDescriptionPersistenceHandler persistenceHandler = new WorkflowDescriptionPersistenceHandler();
        ByteArrayOutputStream content = persistenceHandler.writeWorkflowDescriptionToStream(workflowDesc);
        FileUtils.writeByteArrayToFile((File)wfFile, (byte[])content.toByteArray());
        return new ExecutionSetup(wfFile, null, parameterObject.getSessionToken(), parameterObject.getInputFilesDir(), parameterObject.getOutputFilesDir());
    }

    private ExecutionSetup generateWorkflowExecutionSetup(String workflowId, String sessionToken, File inputFilesDir, File outputFilesDir, boolean uncompressedUpload, boolean simpleDescriptionFormat) throws IOException, WorkflowExecutionException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        String timestampString = dateFormat.format(new Date());
        String template = this.publishedWorkflowTemplates.get(workflowId);
        String placeholdersFileContent = this.publishedWorkflowTemplatePlaceholders.get(workflowId);
        if (template == null) {
            throw new WorkflowExecutionException("There is no published workflow for id " + workflowId);
        }
        File placeholdersFile = null;
        if (placeholdersFileContent != null) {
            placeholdersFile = this.tempFileService.createTempFileFromPattern("rwa-properties-*.json");
            FileUtils.writeStringToFile((File)placeholdersFile, (String)placeholdersFileContent, (String)WORKFLOW_FILE_ENCODING);
        }
        String workflowContent = template.replace(WF_PLACEHOLDER_TIMESTAMP, timestampString).replace(WF_PLACEHOLDER_INPUT_DIR, this.formatPathForWorkflowFile(inputFilesDir)).replace(WF_PLACEHOLDER_OUTPUT_PARENT_DIR, this.formatPathForWorkflowFile(outputFilesDir)).replace(WF_PLACEHOLDER_SIMPLE_DESCRIPTION_FORMAT, Boolean.toString(simpleDescriptionFormat)).replace(WF_PLACEHOLDER_UNCOMPRESSED_UPLOAD, Boolean.toString(uncompressedUpload)).replace(WF_PLACEHOLDER_UNCOMPRESSED_DOWNLOAD, Boolean.toString(uncompressedUpload));
        File wfFile = this.tempFileService.createTempFileFromPattern("rwa-*.wf");
        FileUtils.write((File)wfFile, (CharSequence)workflowContent, (String)WORKFLOW_FILE_ENCODING);
        return new ExecutionSetup(wfFile, placeholdersFile, sessionToken, inputFilesDir, outputFilesDir);
    }

    private FinalWorkflowState executeConfiguredWorkflow(ExecutionSetup executionSetup, SingleConsoleRowsProcessor customConsoleRowReceiver, boolean neverDeleteExecutionData) throws WorkflowExecutionException {
        ExtendedHeadlessWorkflowExecutionContextBuilder exeContextBuilder;
        File logDir;
        this.log.debug((Object)("Executing remote access workflow " + executionSetup.getWorkflowFile().getAbsolutePath()));
        File inputFilesDir = executionSetup.getInputFilesDir();
        File outputFilesDir = executionSetup.getOutputFilesDir();
        if (outputFilesDir.isDirectory()) {
            this.renameAsOld(outputFilesDir);
        }
        if ((logDir = new File(outputFilesDir.getParent(), "logs")).isDirectory()) {
            this.renameAsOld(logDir);
        }
        logDir.mkdirs();
        CapturingTextOutReceiver outputReceiver = new CapturingTextOutReceiver();
        try {
            exeContextBuilder = new ExtendedHeadlessWorkflowExecutionContextBuilder(executionSetup.getWorkflowFile(), logDir);
        }
        catch (InvalidFilenameException invalidFilenameException) {
            throw new IllegalStateException();
        }
        exeContextBuilder.setPlaceholdersFile(executionSetup.getPlaceholderFile());
        exeContextBuilder.setTextOutputReceiver((TextOutputReceiver)outputReceiver);
        exeContextBuilder.setSingleConsoleRowsProcessor(customConsoleRowReceiver);
        exeContextBuilder.setAbortIfWorkflowUpdateRequired(true);
        if (neverDeleteExecutionData) {
            exeContextBuilder.setDeletionBehavior(HeadlessWorkflowExecutionService.DeletionBehavior.Never);
            exeContextBuilder.setDisposalBehavior(HeadlessWorkflowExecutionService.DisposalBehavior.Never);
        }
        WorkflowExecutionException executionException = null;
        FinalWorkflowState finalState = FinalWorkflowState.FAILED;
        try {
            HeadlessWorkflowExecutionContext context = exeContextBuilder.build();
            WorkflowExecutionInformation execInf = this.workflowExecutionService.startHeadlessWorkflowExecution(context);
            this.sessionTokenToWfExecInf.put(executionSetup.getSessionToken(), execInf);
            finalState = this.workflowExecutionService.waitForWorkflowTerminationAndCleanup(context);
            this.sessionTokenToWfExecInf.remove(executionSetup.getSessionToken());
        }
        catch (WorkflowExecutionException e) {
            executionException = e;
            File exceptionLogFile = new File(logDir, "error.log");
            try {
                FileUtils.writeStringToFile((File)exceptionLogFile, (String)("Workflow execution failed with an error: " + e.toString()));
            }
            catch (IOException iOException) {
                this.log.error((Object)("Failed to write exception log file " + exceptionLogFile.getAbsolutePath()));
            }
        }
        this.log.debug((Object)("Finished remote access workflow; captured output:\n" + outputReceiver.getBufferedOutput()));
        if (inputFilesDir.isDirectory()) {
            File tempDestination = new File(inputFilesDir.getParentFile(), "input.old." + System.currentTimeMillis());
            inputFilesDir.renameTo(tempDestination);
            if (inputFilesDir.isDirectory()) {
                this.log.warn((Object)("Tried to rename input directory " + inputFilesDir.getAbsolutePath() + " to " + tempDestination.getAbsolutePath() + ", but it is still present"));
            }
        }
        if (executionException != null) {
            throw executionException;
        }
        try {
            this.tempFileService.disposeManagedTempDirOrFile(executionSetup.getWorkflowFile());
        }
        catch (IOException iOException) {
            this.log.warn((Object)"Could not delete temporary workflow file");
        }
        return finalState;
    }

    private CharSequence formatPathForWorkflowFile(File directory) {
        return directory.getAbsolutePath().replaceAll("\\\\", "/");
    }

    @Override
    public void cancelToolOrWorkflow(String sessionToken) {
        WorkflowExecutionInformation wfExecInf = this.sessionTokenToWfExecInf.get(sessionToken);
        if (wfExecInf != null) {
            try {
                this.workflowExecutionService.cancel(wfExecInf.getWorkflowExecutionHandle());
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                this.log.warn((Object)StringUtils.format((String)"Failed to cancel workflow '%s'; cause: %s", (Object[])new Object[]{wfExecInf.getExecutionIdentifier(), e.getMessage()}));
            }
        } else {
            this.log.debug((Object)StringUtils.format((String)"Failed to cancel workflow for session token '%s'; it was not running or already finished.", (Object[])new Object[]{sessionToken}));
        }
    }

    @Override
    public void getToolDocumentation(TextOutputReceiver outputReceiver, String toolId, String nodeId, String hashValue, File outputFilePath) {
        String fullToolId = this.getFullIdentifierForTool(toolId);
        try {
            File doc = this.toolDocService.getToolDocumentation(fullToolId, nodeId, hashValue);
            FileUtils.copyDirectory((File)doc, (File)outputFilePath);
        }
        catch (RemoteOperationException | IOException e) {
            this.log.warn((Object)("Failed to download tool documentaion; cause; " + e.getMessage()));
        }
    }

    @Override
    public void getToolDocumentationList(TextOutputReceiver outputReceiver, String toolId) {
        String fullToolId = this.getFullIdentifierForTool(toolId);
        if (fullToolId != null) {
            Map toolDocMap = this.toolDocService.getComponentDocumentationList(fullToolId);
            outputReceiver.addOutput(Integer.toString(toolDocMap.size()));
            for (Map.Entry docEntry : toolDocMap.entrySet()) {
                outputReceiver.addOutput((String)docEntry.getKey());
                outputReceiver.addOutput((String)docEntry.getValue());
            }
        }
    }

    private static final class ExecutionSetup {
        private File workflowFile;
        private File placeholdersFile;
        private String sessionToken;
        private File inputFilesDir;
        private File outputFilesDir;

        ExecutionSetup(File wfFile, File placeholdersFile, String sessionToken, File inputFilesDir, File outputFilesDir) {
            this.workflowFile = wfFile;
            this.placeholdersFile = placeholdersFile;
            this.sessionToken = sessionToken;
            this.inputFilesDir = inputFilesDir;
            this.outputFilesDir = outputFilesDir;
        }

        public File getWorkflowFile() {
            return this.workflowFile;
        }

        public File getPlaceholderFile() {
            return this.placeholdersFile;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public File getInputFilesDir() {
            return this.inputFilesDir;
        }

        public File getOutputFilesDir() {
            return this.outputFilesDir;
        }
    }
}

