/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.sshconnection.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.communication.sshconnection.SshConnectionContext;
import de.rcenvironment.core.communication.sshconnection.SshConnectionService;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionSetup;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SshConnectionSetupCommandPlugin
implements CommandPlugin {
    private static final String CMD_SSH = "ssh";
    private SshConnectionService sshConnectionService;

    public void execute(CommandContext context) throws CommandException {
        context.consumeExpectedToken(CMD_SSH);
        String subCmd = context.consumeNextToken();
        if (subCmd == null) {
            this.performList(context);
        } else {
            List parameters = context.consumeRemainingTokens();
            if ("add".equals(subCmd)) {
                this.performAdd(context, parameters);
            } else if ("list".equals(subCmd)) {
                this.performList(context);
            } else if ("start".equals(subCmd)) {
                this.performStart(context, parameters);
            } else if ("stop".equals(subCmd)) {
                this.performStop(context, parameters);
            } else {
                throw CommandException.unknownCommand((CommandContext)context);
            }
        }
    }

    private void performAdd(final CommandContext context, List<String> parameters) throws CommandException {
        if (parameters.size() < 5 || parameters.size() > 5) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        final String connectionName = parameters.get(0);
        final String host = parameters.get(1);
        final int port = Integer.parseInt(parameters.get(2));
        final String username = parameters.get(3);
        final String keyfileLocation = parameters.get(4);
        ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

            @Override
            @TaskDescription(value="Create new SSH Connection.")
            public void run() {
                String id = SshConnectionSetupCommandPlugin.this.sshConnectionService.addSshConnection(new SshConnectionContext(null, connectionName, host, port, username, keyfileLocation, false, false, false));
                context.println((Object)("Added SSH connection setup, created id " + id));
            }
        });
    }

    private void performList(CommandContext context) {
        Collection<SshConnectionSetup> setups = this.sshConnectionService.getAllSshConnectionSetups();
        for (SshConnectionSetup setup : setups) {
            context.println((Object)StringUtils.format((String)"%s: %s:%s username: %s, keyfile: %s (id: %s)", (Object[])new Object[]{setup.getDisplayName(), setup.getHost(), setup.getPort(), setup.getUsername(), setup.getKeyfileLocation(), setup.getId()}));
        }
    }

    private void performStart(CommandContext context, List<String> parameters) throws CommandException {
        if (parameters.size() < 1) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        final String connectionId = parameters.get(0);
        ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

            @Override
            @TaskDescription(value="Start SSH Connection.")
            public void run() {
                SshConnectionSetupCommandPlugin.this.sshConnectionService.connectSession(connectionId);
            }
        });
    }

    private void performStop(CommandContext context, List<String> parameters) throws CommandException {
        if (parameters.size() < 1) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        String connectionId = parameters.get(0);
        this.sshConnectionService.disconnectSession(connectionId);
    }

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription(CMD_SSH, "", false, "short form of \"ssh list\"", new String[0]));
        contributions.add(new CommandDescription("ssh add", "<displayName> <host> <port> <username> <keyfileLocation>", false, "add a new ssh connection", new String[]{"(Example: TODO)"}));
        contributions.add(new CommandDescription("ssh list", "", false, "lists all ssh connections, including ids and connection states", new String[0]));
        contributions.add(new CommandDescription("ssh start", "<id>", false, "starts/connects an ssh connection (use \" ssh list\" to get the id)", new String[0]));
        contributions.add(new CommandDescription("ssh stop", "<id>", false, "stops/disconnects an ssh connection (use \" ssh list\" to get the id)", new String[0]));
        return contributions;
    }

    public void bindSshConnectionSetupService(SshConnectionService newInstance) {
        this.sshConnectionService = newInstance;
    }
}

