/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.datamanagement.browser;

import de.rcenvironment.core.authentication.AuthenticationException;
import de.rcenvironment.core.authorization.AuthorizationException;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.datamanagement.DataManagementService;
import de.rcenvironment.core.datamanagement.FileDataService;
import de.rcenvironment.core.datamanagement.commons.MetaData;
import de.rcenvironment.core.gui.datamanagement.browser.DMBrowserImages;
import de.rcenvironment.core.gui.datamanagement.browser.DMBrowserNodeContentAvailabilityHandler;
import de.rcenvironment.core.gui.datamanagement.browser.DMContentProvider;
import de.rcenvironment.core.gui.datamanagement.browser.DMLabelProvider;
import de.rcenvironment.core.gui.datamanagement.browser.DMTreeSorter;
import de.rcenvironment.core.gui.datamanagement.browser.Messages;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeUtils;
import de.rcenvironment.core.gui.datamanagement.commons.DataManagementWorkbenchUtils;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.tiglviewer.TiglViewerConstants;
import de.rcenvironment.core.gui.utils.common.ClipboardHelper;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineView;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class DataManagementBrowser
extends ViewPart
implements DMBrowserNodeContentAvailabilityHandler {
    public static final String ID = "de.rcenvironment.rce.gui.datamanagement.browser.DataManagementBrowser";
    private static final String ROOT_NODE_TITLE = "<root>";
    private static final String NODE_TEXT_FORMAT_TITLE_PLUS_HOSTNAME = "%s %s";
    private static final String BRACKET_OPEN = "[";
    private static final String BRACKET_CLOSE = "]";
    private static final String LOCAL = "local";
    private static final MetaData META_DATA_WORKFLOW_FINAL_STATE = new MetaData("rce.common.workflow_final_state", true, true);
    private static final MetaData METADATA_WORKFLOW_FILES_DELETED = new MetaData("rce.common.workflow_files_deleted", true, true);
    private static final MetaData METADATA_WORKFLOW_IS_MARKED_FOR_DELETION = new MetaData("rce.common.workflow_marked_for_deletion", true, true);
    private static final List<DMBrowserNodeType> SAVABLE_NODE_TYPES = new ArrayList<DMBrowserNodeType>();
    private static final List<DMBrowserNodeType> SAVE_AS_FOLDER_NODE_TYPES = new ArrayList<DMBrowserNodeType>();
    private static final List<DMBrowserNodeType> DELETABLE_NODE_TYPES = new ArrayList<DMBrowserNodeType>();
    private static final List<DMBrowserNodeType> REFRESHABLE_NODE_TYPES = new ArrayList<DMBrowserNodeType>();
    private static final List<DMBrowserNodeType> COMPARABLE_NODE_TYPES = new ArrayList<DMBrowserNodeType>();
    private static final List<DMBrowserNodeType> OPEN_IN_EDITOR_NODE_TYPES = new ArrayList<DMBrowserNodeType>();
    protected final Log log = LogFactory.getLog(this.getClass());
    protected DMTreeSorter treeSorter;
    private Object[] visibleExpandedElements = null;
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private DMContentProvider contentProvider;
    private Action sortAscendingName;
    private Action actionRefreshAll;
    private Action openInEditorAction;
    private Action openTiglAction;
    private Action doubleClickAction;
    private Action deleteNodeAction;
    private Action deleteFilesAction;
    private Action exportNodeToFileSystemAction;
    private Action exportNodeToProjectAction;
    private RefreshNodeAction refreshNodeAction;
    private CollapseAllNodesAction collapseAllNodesAction;
    private FileDataService fileDataService;
    private IAction sortDescendingName;
    private IAction sortTimestampAsc;
    private Action compareAction;
    private Action timelineAction;
    private Action copyAction;
    private Action sortTimestampDesc;
    private ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);

    static {
        SAVE_AS_FOLDER_NODE_TYPES.add(DMBrowserNodeType.Timeline);
        SAVE_AS_FOLDER_NODE_TYPES.add(DMBrowserNodeType.Components);
        SAVE_AS_FOLDER_NODE_TYPES.add(DMBrowserNodeType.Component);
        SAVE_AS_FOLDER_NODE_TYPES.add(DMBrowserNodeType.HistoryObject);
        SAVE_AS_FOLDER_NODE_TYPES.add(DMBrowserNodeType.Input);
        SAVE_AS_FOLDER_NODE_TYPES.add(DMBrowserNodeType.Output);
        SAVE_AS_FOLDER_NODE_TYPES.add(DMBrowserNodeType.IntermediateInputsFolder);
        SAVE_AS_FOLDER_NODE_TYPES.add(DMBrowserNodeType.LogFolder);
        SAVE_AS_FOLDER_NODE_TYPES.add(DMBrowserNodeType.ToolInputOutputFolder);
        SAVE_AS_FOLDER_NODE_TYPES.add(DMBrowserNodeType.DMDirectoryReference);
        SAVABLE_NODE_TYPES.add(DMBrowserNodeType.HistoryRoot);
        SAVABLE_NODE_TYPES.add(DMBrowserNodeType.DMFileResource);
        SAVABLE_NODE_TYPES.add(DMBrowserNodeType.Resource);
        SAVABLE_NODE_TYPES.add(DMBrowserNodeType.Float);
        SAVABLE_NODE_TYPES.add(DMBrowserNodeType.Vector);
        SAVABLE_NODE_TYPES.add(DMBrowserNodeType.ShortText);
        SAVABLE_NODE_TYPES.add(DMBrowserNodeType.Boolean);
        SAVABLE_NODE_TYPES.add(DMBrowserNodeType.Integer);
        SAVABLE_NODE_TYPES.add(DMBrowserNodeType.SmallTable);
        SAVABLE_NODE_TYPES.add(DMBrowserNodeType.Indefinite);
        SAVABLE_NODE_TYPES.add(DMBrowserNodeType.File);
        SAVABLE_NODE_TYPES.add(DMBrowserNodeType.CommonText);
        DELETABLE_NODE_TYPES.add(DMBrowserNodeType.Workflow);
        REFRESHABLE_NODE_TYPES.add(DMBrowserNodeType.Workflow);
        REFRESHABLE_NODE_TYPES.add(DMBrowserNodeType.Timeline);
        REFRESHABLE_NODE_TYPES.add(DMBrowserNodeType.Components);
        REFRESHABLE_NODE_TYPES.add(DMBrowserNodeType.WorkflowRunInformation);
        COMPARABLE_NODE_TYPES.add(DMBrowserNodeType.DMFileResource);
        OPEN_IN_EDITOR_NODE_TYPES.add(DMBrowserNodeType.Boolean);
        OPEN_IN_EDITOR_NODE_TYPES.add(DMBrowserNodeType.CommonText);
        OPEN_IN_EDITOR_NODE_TYPES.add(DMBrowserNodeType.DMFileResource);
        OPEN_IN_EDITOR_NODE_TYPES.add(DMBrowserNodeType.File);
        OPEN_IN_EDITOR_NODE_TYPES.add(DMBrowserNodeType.Float);
        OPEN_IN_EDITOR_NODE_TYPES.add(DMBrowserNodeType.Integer);
        OPEN_IN_EDITOR_NODE_TYPES.add(DMBrowserNodeType.ShortText);
        OPEN_IN_EDITOR_NODE_TYPES.add(DMBrowserNodeType.SmallTable);
        OPEN_IN_EDITOR_NODE_TYPES.add(DMBrowserNodeType.Matrix);
        OPEN_IN_EDITOR_NODE_TYPES.add(DMBrowserNodeType.Vector);
    }

    private void refresh(DMBrowserNode node) {
        this.visibleExpandedElements = this.viewer.getVisibleExpandedElements();
        DMBrowserNode toRefresh = node.getNodeWithTypeWorkflow();
        if (toRefresh == null) {
            return;
        }
        toRefresh.clearChildren();
        this.contentProvider.clear(toRefresh);
        if (this.viewer.getExpandedState((Object)toRefresh)) {
            this.viewer.refresh((Object)toRefresh);
        } else {
            this.contentProvider.getChildren(toRefresh);
        }
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
                Object selectedNode = thisSelection.getFirstElement();
                DataManagementBrowser.this.viewer.setExpandedState(selectedNode, !DataManagementBrowser.this.viewer.getExpandedState(selectedNode));
                DataManagementBrowser.this.visibleExpandedElements = DataManagementBrowser.this.viewer.getVisibleExpandedElements();
            }
        });
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent e) {
                ArrayList<Object> elements = new ArrayList<Object>();
                if (DataManagementBrowser.this.visibleExpandedElements != null) {
                    elements.addAll(Arrays.asList(DataManagementBrowser.this.visibleExpandedElements));
                }
                elements.add(e.getElement());
                DataManagementBrowser.this.visibleExpandedElements = elements.toArray();
            }

            public void treeCollapsed(TreeExpansionEvent e) {
                ArrayList<Object> elements = new ArrayList<Object>();
                if (DataManagementBrowser.this.visibleExpandedElements != null) {
                    elements.addAll(Arrays.asList(DataManagementBrowser.this.visibleExpandedElements));
                }
                elements.remove(e.getElement());
                DataManagementBrowser.this.visibleExpandedElements = elements.toArray();
            }
        });
        this.viewer.getControl().addKeyListener((KeyListener)new DataManagementKeyListener());
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        try {
            this.contentProvider = new DMContentProvider();
            this.contentProvider.addContentAvailabilityHandler(this);
            this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        }
        catch (AuthenticationException e) {
            this.log.error((Object)e);
        }
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DMLabelProvider());
        this.treeSorter = new DMTreeSorter(3);
        this.viewer.setSorter((ViewerSorter)this.treeSorter);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.initialize();
    }

    private void initialize() {
        this.fileDataService = (FileDataService)this.serviceRegistryAccess.getService(FileDataService.class);
        this.refresh();
    }

    private DMBrowserNode createRootNode() {
        DMBrowserNode rootNode = new DMBrowserNode(ROOT_NODE_TITLE);
        rootNode.setType(DMBrowserNodeType.HistoryRoot);
        return rootNode;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DataManagementBrowser.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefreshAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openInEditorAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        MenuManager subMenuManager = new MenuManager(Messages.sorting);
        subMenuManager.add((IAction)this.sortAscendingName);
        subMenuManager.add(this.sortDescendingName);
        subMenuManager.add(this.sortTimestampAsc);
        subMenuManager.add((IAction)this.sortTimestampDesc);
        MenuManager subMenuManagerExport = new MenuManager("Export");
        subMenuManagerExport.add((IAction)this.exportNodeToFileSystemAction);
        subMenuManagerExport.add((IAction)this.exportNodeToProjectAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openInEditorAction);
        if (OS.isFamilyWindows()) {
            manager.add((IAction)this.openTiglAction);
        }
        manager.add((IAction)this.refreshNodeAction);
        manager.add((IAction)this.actionRefreshAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)subMenuManager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)subMenuManagerExport);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.deleteFilesAction);
        manager.add((IAction)this.deleteNodeAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.timelineAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.compareAction);
        manager.add((IContributionItem)new Separator());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.sortAscendingName);
        manager.add(this.sortDescendingName);
        manager.add(this.sortTimestampAsc);
        manager.add((IAction)this.sortTimestampDesc);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshNodeAction);
        manager.add((IAction)this.actionRefreshAll);
        manager.add((IAction)this.collapseAllNodesAction);
        manager.add((IAction)this.deleteNodeAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
        this.sortAscendingName = new CustomSortAction(selectionProvider, Messages.sortUp, 1);
        this.sortAscendingName.setImageDescriptor(DMBrowserImages.IMG_SORT_ALPHABETICAL_ASC);
        this.sortDescendingName = new CustomSortAction(selectionProvider, Messages.sortDown, 2);
        this.sortDescendingName.setImageDescriptor(DMBrowserImages.IMG_SORT_ALPHABETICAL_DESC);
        this.sortTimestampAsc = new CustomSortAction(selectionProvider, Messages.sortTime, 0);
        this.sortTimestampAsc.setImageDescriptor(DMBrowserImages.IMG_SORT_TIMESTAMP_ASC);
        this.sortTimestampDesc = new CustomSortAction(selectionProvider, Messages.sortTimeDesc, 3);
        this.sortTimestampDesc.setImageDescriptor(DMBrowserImages.IMG_SORT_TIMESTAMP_DESC);
        this.compareAction = new CustomCompareAction(selectionProvider, Messages.compareMsg);
        this.compareAction.setEnabled(false);
        this.makeRefreshActions(selectionProvider);
        this.openInEditorAction = new OpenInEditorAction(selectionProvider, "Open in editor (read-only)");
        this.openInEditorAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.OPEN_READ_ONLY_16));
        this.openTiglAction = new OpenInTiglAction(selectionProvider, "Open in TiGL Viewer");
        this.openTiglAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.TIGL_ICON));
        this.doubleClickAction = this.openInEditorAction;
        this.deleteNodeAction = new CustomDeleteAction(selectionProvider, String.valueOf(Messages.deleteNodeActionContextMenuLabel) + Messages.shortcutDelete, false);
        this.deleteNodeAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.DELETE_16));
        this.deleteNodeAction.setEnabled(false);
        this.deleteFilesAction = new CustomDeleteAction(selectionProvider, Messages.deleteFilesActionContextMenuLabel, true);
        this.deleteFilesAction.setImageDescriptor(DMBrowserImages.IMG_DESC_DELETE_FILES);
        this.deleteFilesAction.setEnabled(false);
        this.exportNodeToFileSystemAction = new CustomExportAction(selectionProvider, String.valueOf(Messages.saveNodeToFilesystemActionContextMenuLabel) + Messages.saveNodeToFilesystemActionShortcut, ExportType.FILESYSTEM);
        this.exportNodeToFileSystemAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.EXPORT_16));
        this.exportNodeToProjectAction = new CustomExportAction(selectionProvider, String.valueOf(Messages.saveNodeToProjectActionContextMenuLabel) + Messages.saveNodeToProjectActionShortcut, ExportType.PROJECT);
        this.exportNodeToProjectAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.EXPORT_16));
        this.collapseAllNodesAction = new CollapseAllNodesAction(Messages.collapseAllNodesActionContextMenuLabel);
        this.collapseAllNodesAction.setImageDescriptor(DMBrowserImages.IMG_DESC_COLLAPSE_ALL);
        this.timelineAction = new OpenTimelineViewAction(selectionProvider, "Show Timeline");
        this.timelineAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)DMBrowserImages.IMG_TIMELINE));
        this.timelineAction.setEnabled(false);
        this.copyAction = new CopyNodeTitleAction(selectionProvider, "Copy");
        this.copyAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.COPY_16)));
        this.copyAction.setEnabled(false);
    }

    private void makeRefreshActions(ISelectionProvider selectionProvider) {
        this.actionRefreshAll = new Action(String.valueOf(Messages.refreshAllNodesActionContextMenuLabel) + Messages.shortcutRefreshAll){

            public void run() {
                DataManagementBrowser.this.refresh();
            }
        };
        this.actionRefreshAll.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.REFRESH_16));
        this.refreshNodeAction = new RefreshNodeAction(selectionProvider, String.valueOf(Messages.refreshNodeActionContextMenuLabel) + Messages.shortcutRefreshSelected);
        this.refreshNodeAction.setImageDescriptor(DMBrowserImages.IMG_DESC_REFRESH_NODE);
        this.refreshNodeAction.setEnabled(false);
    }

    private void refresh() {
        if (!this.viewer.getTree().isDisposed()) {
            this.actionRefreshAll.setEnabled(false);
            this.contentProvider.clear();
            this.viewer.getTree().setEnabled(false);
            DMBrowserNode rootNode = (DMBrowserNode)this.viewer.getInput();
            if (rootNode == null) {
                rootNode = this.createRootNode();
                this.viewer.setInput((Object)rootNode);
            } else {
                rootNode.clearChildren();
            }
            this.viewer.getTree().setEnabled(true);
            this.viewer.getTree().setFocus();
            this.viewer.refresh();
        }
    }

    private boolean mightHaveContent(DMBrowserNode node) {
        if (node.getDataReference() != null || node.getDataReferenceId() != null || node.getFileReferencePath() != null) {
            return true;
        }
        if (node.areChildrenKnown()) {
            return this.mightHaveContent(node.getChildren());
        }
        return true;
    }

    private boolean mightHaveContent(Collection<DMBrowserNode> nodes) {
        boolean result = false;
        for (DMBrowserNode node : nodes) {
            if (!this.mightHaveContent(node)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DMBrowserNode node;
                TreeSelection sel;
                if (event.getSelection() instanceof TreeSelection && (sel = (TreeSelection)event.getSelection()).getFirstElement() instanceof DMBrowserNode && (node = (DMBrowserNode)sel.getFirstElement()).isLeafNode().booleanValue()) {
                    DataManagementBrowser.this.doubleClickAction.run();
                }
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private Set<InstanceNodeSessionId> registerWorkflowHostService() {
        WorkflowHostService workflowHostService = (WorkflowHostService)this.serviceRegistryAccess.getService(WorkflowHostService.class);
        return workflowHostService.getWorkflowHostNodes();
    }

    private boolean isWorkflowHostReachable(ResolvableNodeId nodeID) {
        Set<InstanceNodeSessionId> registeredNodeID = this.registerWorkflowHostService();
        for (InstanceNodeSessionId nodeIdentifier : registeredNodeID) {
            if (!nodeID.isSameInstanceNodeAs((ResolvableNodeId)nodeIdentifier)) continue;
            return true;
        }
        return false;
    }

    private void disableUnreachableNode(ResolvableNodeId unreachableID) {
        TreeItem[] treeItemArray = this.viewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            DMBrowserNode node = (DMBrowserNode)item.getData();
            if (node != null) {
                ResolvableNodeId nodeID = node.getNodeIdentifier();
                if (node.isEnabled() && nodeID != null && nodeID.isSameInstanceNodeAs(unreachableID)) {
                    node.setTitle(StringUtils.format((String)NODE_TEXT_FORMAT_TITLE_PLUS_HOSTNAME, (Object[])new Object[]{node.getTitle(), "[offline]"}));
                    this.disableNode(node);
                }
            }
            ++n2;
        }
    }

    private void disableNode(DMBrowserNode node) {
        this.refreshNodeAction.setEnabled(false);
        this.disableNodeWithoutRefresh(node);
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh((Object)node);
        }
    }

    private void disableNodeWithoutRefresh(DMBrowserNode node) {
        node.setType(DMBrowserNodeType.Workflow_Disabled);
        node.markAsLeaf();
        node.setEnabled(false);
    }

    @Override
    public void handleContentAvailable(final DMBrowserNode node) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DMBrowserNode workflowNode;
                if (DataManagementBrowser.this.viewer.getTree().isDisposed()) {
                    return;
                }
                DataManagementBrowser.this.viewer.refresh((Object)node);
                if (node.getType() != DMBrowserNodeType.HistoryRoot && (workflowNode = node.getNodeWithTypeWorkflow()) != null && !workflowNode.getWorkflowHostName().equals(DataManagementBrowser.LOCAL) && !DataManagementBrowser.this.isWorkflowHostReachable(workflowNode.getNodeIdentifier())) {
                    DataManagementBrowser.this.disableUnreachableNode(workflowNode.getNodeIdentifier());
                }
                if (!node.areChildrenKnown()) {
                    DataManagementBrowser.this.viewer.setExpandedState((Object)node, false);
                } else {
                    DataManagementBrowser.this.viewer.setExpandedState((Object)node, true);
                }
                if (DataManagementBrowser.this.visibleExpandedElements != null) {
                    DataManagementBrowser.this.viewer.setExpandedElements(DataManagementBrowser.this.visibleExpandedElements);
                }
                if (node == DataManagementBrowser.this.viewer.getInput()) {
                    DataManagementBrowser.this.viewer.getTree().setEnabled(true);
                    DataManagementBrowser.this.actionRefreshAll.setEnabled(true);
                }
            }
        });
    }

    @Override
    public void handleContentRetrievalError(final DMBrowserNode node, Exception cause) {
        if (cause instanceof CommunicationException) {
            this.log.warn((Object)("Retrieving data from data management failed: " + cause.getMessage()));
        } else {
            this.log.error((Object)"Retrieving data from data management failed", (Throwable)cause);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (node == DataManagementBrowser.this.viewer.getInput()) {
                    DataManagementBrowser.this.viewer.getTree().setEnabled(true);
                    DataManagementBrowser.this.actionRefreshAll.setEnabled(true);
                }
                DataManagementBrowser.this.findAndDisableRootnode(node);
            }
        });
    }

    private void findAndDisableRootnode(DMBrowserNode node) {
        if (node.getParent().getType() == DMBrowserNodeType.HistoryRoot) {
            this.disableUnreachableNode(node.getNodeIdentifier());
        } else {
            this.findAndDisableRootnode(node.getParent());
        }
    }

    private final class CollapseAllNodesAction
    extends Action {
        CollapseAllNodesAction(String text) {
            super(text);
        }

        public void run() {
            DataManagementBrowser.this.viewer.collapseAll();
            DataManagementBrowser.this.visibleExpandedElements = DataManagementBrowser.this.viewer.getVisibleExpandedElements();
        }
    }

    class CompareItem
    implements IStreamContentAccessor,
    ITypedElement,
    IModificationDate {
        private java.io.File contents;

        CompareItem(java.io.File f) {
            this.contents = f;
        }

        public InputStream getContents() throws CoreException {
            try {
                return new ByteArrayInputStream(FileUtils.readFileToString((java.io.File)this.contents).getBytes());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public long getModificationDate() {
            return 0L;
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return null;
        }

        public String getType() {
            return null;
        }
    }

    private final class CopyNodeTitleAction
    extends SelectionProviderAction {
        private DMBrowserNode nodeSelected;

        private CopyNodeTitleAction(ISelectionProvider provider, String text) {
            super(provider, text);
        }

        public void selectionChanged(IStructuredSelection selection) {
            Object obj = selection.getFirstElement();
            if (selection.size() == 1 && obj instanceof DMBrowserNode) {
                this.nodeSelected = (DMBrowserNode)obj;
                if (this.nodeSelected.getType() == DMBrowserNodeType.InformationText) {
                    this.setEnabled(true);
                    return;
                }
            }
            this.setEnabled(false);
        }

        public void run() {
            String nodeTitle = this.nodeSelected.getTitle();
            if (nodeTitle.matches(".*: .*")) {
                nodeTitle = nodeTitle.split(": ")[1];
            }
            ClipboardHelper.setContent((String)nodeTitle);
        }
    }

    private final class CustomCompareAction
    extends SelectionProviderAction {
        private DMBrowserNode node;
        private DMBrowserNode node2;

        protected CustomCompareAction(ISelectionProvider provider, String text) {
            super(provider, text);
        }

        public void selectionChanged(IStructuredSelection selection) {
            if (selection.size() == 2) {
                Iterator iter = selection.iterator();
                Object obj = iter.next();
                Object obj2 = iter.next();
                if (obj instanceof DMBrowserNode && obj2 instanceof DMBrowserNode) {
                    this.node = (DMBrowserNode)obj;
                    this.node2 = (DMBrowserNode)obj2;
                    boolean compareEnabled = false;
                    if (COMPARABLE_NODE_TYPES.contains((Object)this.node.getType()) && COMPARABLE_NODE_TYPES.contains((Object)this.node2.getType()) && this.node.getType() == this.node2.getType()) {
                        compareEnabled = true;
                    }
                    DataManagementBrowser.this.compareAction.setEnabled(compareEnabled);
                }
            } else {
                DataManagementBrowser.this.compareAction.setEnabled(false);
            }
        }

        public void run() {
            if (this.node != null && this.node2 != null) {
                String dataReferenceId = this.node.getDataReferenceId();
                String associatedFilename = this.node.getAssociatedFilename();
                String dataReferenceId2 = this.node2.getDataReferenceId();
                String associatedFilename2 = this.node2.getAssociatedFilename();
                if (dataReferenceId == null || dataReferenceId2 == null) {
                    return;
                }
                try {
                    java.io.File left = TempFileServiceAccess.getInstance().createTempFileWithFixedFilename(associatedFilename);
                    java.io.File right = TempFileServiceAccess.getInstance().createTempFileWithFixedFilename(associatedFilename2);
                    DataManagementService dataManagementService = DataManagementWorkbenchUtils.getInstance().getDataManagementService();
                    dataManagementService.copyReferenceToLocalFile(dataReferenceId, left, (NetworkDestination)this.node.getNodeWithTypeWorkflow().getNodeIdentifier());
                    dataManagementService.copyReferenceToLocalFile(dataReferenceId2, right, (NetworkDestination)this.node.getNodeWithTypeWorkflow().getNodeIdentifier());
                    CompareConfiguration cc = new CompareConfiguration();
                    cc.setLeftLabel(left.getName());
                    cc.setRightLabel(right.getName());
                    CompareUI.openCompareEditor((CompareEditorInput)new FileCompareInput(cc, left, right));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (CommunicationException e) {
                    throw new RuntimeException(String.valueOf(StringUtils.format((String)"Failed to copy data reference from remote node @%s to local file: ", (Object[])new Object[]{this.node.getNodeWithTypeWorkflow().getNodeIdentifier()})) + e.getMessage(), e);
                }
            }
        }
    }

    private final class CustomDeleteAction
    extends SelectionProviderAction {
        private final List<DMBrowserNode> selectedNodes;
        private Display display;
        private boolean hasNotFinishedWorkflows;
        private boolean isFileAction;

        private CustomDeleteAction(ISelectionProvider provider, String text, boolean isFileAction) {
            super(provider, text);
            this.selectedNodes = new LinkedList<DMBrowserNode>();
            this.isFileAction = isFileAction;
        }

        public void selectionChanged(IStructuredSelection selection) {
            this.selectedNodes.clear();
            boolean enabled = DataManagementBrowser.this.fileDataService != null && !selection.isEmpty();
            this.hasNotFinishedWorkflows = false;
            if (enabled) {
                for (DMBrowserNode selectedNode : selection) {
                    if (DELETABLE_NODE_TYPES.contains((Object)selectedNode.getType())) {
                        boolean hasfinalState = selectedNode.getMetaData() != null && selectedNode.getMetaData().getValue(META_DATA_WORKFLOW_FINAL_STATE) != null;
                        boolean hasDataReferences = !Boolean.parseBoolean(selectedNode.getMetaData().getValue(METADATA_WORKFLOW_FILES_DELETED));
                        boolean isMarkedForDeletion = Boolean.parseBoolean(selectedNode.getMetaData().getValue(METADATA_WORKFLOW_IS_MARKED_FOR_DELETION));
                        if (hasfinalState && !isMarkedForDeletion && (hasDataReferences || !this.isFileAction)) {
                            this.selectedNodes.add(selectedNode);
                        }
                        this.hasNotFinishedWorkflows |= !hasfinalState;
                        continue;
                    }
                    enabled = false;
                }
                enabled &= !this.selectedNodes.isEmpty();
                this.display = Display.getCurrent();
            }
            this.setEnabled(enabled);
        }

        public void run() {
            String dialogMessage;
            String dialogTitle;
            final LinkedList<DMBrowserNode> browserNodesToDelete = new LinkedList<DMBrowserNode>(this.selectedNodes);
            String jobTitle = this.isFileAction ? StringUtils.format((String)Messages.jobTitleDeleteFiles, (Object[])new Object[]{browserNodesToDelete.size(), ((Object)browserNodesToDelete).toString()}) : StringUtils.format((String)Messages.jobTitleDelete, (Object[])new Object[]{browserNodesToDelete.size(), ((Object)browserNodesToDelete).toString()});
            Job job = new Job(jobTitle){

                protected IStatus run(IProgressMonitor monitor) {
                    for (final DMBrowserNode browserNodeToDelete : browserNodesToDelete) {
                        DMBrowserNode parentNode = browserNodeToDelete.getParent();
                        if (!CustomDeleteAction.this.isFileAction) {
                            boolean deleted = this.deleteWorkflowRun(browserNodeToDelete);
                            if (!deleted || parentNode == null) continue;
                            parentNode.removeChild(browserNodeToDelete);
                            continue;
                        }
                        this.deleteFiles(browserNodeToDelete);
                        CustomDeleteAction.this.setEnabled(false);
                        CustomDeleteAction.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                DataManagementBrowser.this.refresh(browserNodeToDelete);
                            }
                        });
                    }
                    if (!CustomDeleteAction.this.isFileAction) {
                        CustomDeleteAction.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                DataManagementBrowser.this.refresh();
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }

                private void deleteFiles(DMBrowserNode browserNode) {
                    DataManagementBrowser.this.contentProvider.deleteWorkflowRunFiles(browserNode);
                }

                private boolean deleteWorkflowRun(DMBrowserNode browserNode) {
                    return DataManagementBrowser.this.contentProvider.deleteWorkflowRun(browserNode);
                }
            };
            job.setUser(true);
            boolean schedule = true;
            Shell shell = Display.getCurrent().getActiveShell();
            if (!this.isFileAction) {
                dialogTitle = Messages.dialogTitleDelete;
                dialogMessage = this.hasNotFinishedWorkflows ? Messages.dialogMessageDeleteWithNotDeletableNodes : Messages.dialogMessageDelete;
            } else {
                dialogTitle = Messages.dialogTitleDeleteFiles;
                dialogMessage = this.hasNotFinishedWorkflows ? Messages.dialogMessageDeleteFilesWithNotDeletableNodes : Messages.dialogMessageDeleteFiles;
            }
            if (!MessageDialog.openConfirm((Shell)shell, (String)dialogTitle, (String)dialogMessage)) {
                schedule = false;
            }
            if (schedule) {
                job.schedule();
            }
        }
    }

    private final class CustomExportAction
    extends SelectionProviderAction {
        private final List<DMBrowserNode> selectedNodes;
        private Display display;
        private ExportType exportType;

        private CustomExportAction(ISelectionProvider provider, String text, ExportType exportType) {
            super(provider, text);
            this.selectedNodes = new LinkedList<DMBrowserNode>();
            this.setEnabled(false);
            this.exportType = exportType;
        }

        public void selectionChanged(IStructuredSelection selection) {
            boolean enabled;
            this.selectedNodes.clear();
            boolean bl = enabled = DataManagementBrowser.this.fileDataService != null && !selection.isEmpty();
            if (enabled) {
                for (DMBrowserNode selectedNode : selection) {
                    DMBrowserNodeType nodeType = selectedNode.getType();
                    if (selectedNode.isEnabled() && !selectedNode.areAllChildrenDisabled() && (SAVABLE_NODE_TYPES.contains((Object)nodeType) || SAVE_AS_FOLDER_NODE_TYPES.contains((Object)nodeType))) {
                        this.selectedNodes.add(selectedNode);
                        continue;
                    }
                    enabled = false;
                }
                enabled &= DataManagementBrowser.this.mightHaveContent(this.selectedNodes);
                this.display = Display.getCurrent();
            }
            this.setEnabled(enabled);
        }

        public void run() {
            final LinkedList<DMBrowserNode> browserNodesToSave = new LinkedList<DMBrowserNode>(this.selectedNodes);
            FileDialog fileDialog = new FileDialog(this.display.getActiveShell(), 8192);
            if (this.exportType == ExportType.PROJECT) {
                TreeSelection treeSelection;
                String exportLocationDefaultPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getAbsolutePath();
                IViewPart projectExplorerView = this.getProjectExplorer();
                if (projectExplorerView != null && (treeSelection = (TreeSelection)projectExplorerView.getViewSite().getSelectionProvider().getSelection()).size() == 1) {
                    if (treeSelection.getFirstElement() instanceof File) {
                        exportLocationDefaultPath = ((File)treeSelection.getFirstElement()).getParent().getLocation().toFile().getAbsolutePath();
                    } else if (treeSelection.getFirstElement() instanceof Folder) {
                        exportLocationDefaultPath = ((Folder)treeSelection.getFirstElement()).getLocation().toFile().getAbsolutePath();
                    } else if (treeSelection.getFirstElement() instanceof Project) {
                        exportLocationDefaultPath = ((Project)treeSelection.getFirstElement()).getLocation().toFile().getAbsolutePath();
                    }
                }
                fileDialog.setFilterPath(exportLocationDefaultPath);
                fileDialog.setText("Export to selected folder...");
            } else {
                fileDialog.setText("Export to file system...");
            }
            fileDialog.setFileName(((DMBrowserNode)browserNodesToSave.get(0)).getTitle().replace(":", "_"));
            String directoryPath = fileDialog.open();
            if (directoryPath == null) {
                return;
            }
            final java.io.File targetDirectory = new java.io.File(directoryPath);
            final ExportJob job = new ExportJob("Exporting", browserNodesToSave, targetDirectory);
            job.addJobChangeListener(new IJobChangeListener(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult() == Status.OK_STATUS) {
                        CustomExportAction.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                String location = job.getTargetFile() != null ? StringUtils.format((String)Messages.exportLocationText, (Object[])new Object[]{job.getTargetFile().getAbsolutePath()}) : StringUtils.format((String)Messages.exportLocationText, (Object[])new Object[]{targetDirectory.getAbsolutePath()});
                                if (CustomExportAction.this.exportType == ExportType.PROJECT) {
                                    try {
                                        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
                                    }
                                    catch (CoreException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                                new CustomPopupDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Workflow Data Browser\nData export", StringUtils.format((String)Messages.exportSuccessText, (Object[])new Object[]{browserNodesToSave.toString().replace(DataManagementBrowser.BRACKET_OPEN, "").replace(DataManagementBrowser.BRACKET_CLOSE, "")}), location).open();
                            }
                        });
                    } else if (event.getResult() == Status.CANCEL_STATUS) {
                        CustomExportAction.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)CustomExportAction.this.display.getActiveShell(), (String)"Error", (String)Messages.exportErrorText);
                            }
                        });
                    }
                }

                public void awake(IJobChangeEvent arg0) {
                }

                public void aboutToRun(IJobChangeEvent arg0) {
                }

                public void sleeping(IJobChangeEvent arg0) {
                }

                public void scheduled(IJobChangeEvent arg0) {
                }

                public void running(IJobChangeEvent arg0) {
                }
            });
            job.setUser(true);
            job.schedule();
        }

        private IViewPart getProjectExplorer() {
            IWorkbenchWindow[] workbenchs;
            IWorkbenchWindow[] iWorkbenchWindowArray = workbenchs = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = workbenchs.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow workbench = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = workbench.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    IViewPart projectExplorerView = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
                    if (projectExplorerView != null) {
                        return projectExplorerView;
                    }
                    ++n4;
                }
                ++n2;
            }
            return null;
        }

        private final class CustomPopupDialog
        extends PopupDialog {
            private static final int OFFSET = 15;
            private static final int DISPLAY_TIME = 10000;
            private final MouseListener mouseListener;
            private String messageText;
            private String titleText;

            CustomPopupDialog(Shell parent, String titleText, String messageText, String infoText) {
                super(parent, 4, false, false, false, false, false, titleText, infoText);
                this.mouseListener = new MouseListener(){

                    public void mouseUp(MouseEvent arg0) {
                        CustomPopupDialog.this.close();
                    }

                    public void mouseDown(MouseEvent arg0) {
                    }

                    public void mouseDoubleClick(MouseEvent arg0) {
                    }
                };
                this.titleText = titleText;
                this.messageText = messageText;
                CustomExportAction.this.display.timerExec(10000, new Runnable(){

                    @Override
                    public void run() {
                        CustomPopupDialog.this.close();
                    }
                });
            }

            protected Control createDialogArea(Composite parent) {
                Label infoText = new Label(parent, 4);
                infoText.setText(this.messageText);
                return infoText;
            }

            protected Control createTitleControl(Composite parent) {
                Composite c = new Composite(parent, 0);
                GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(2).applyTo(c);
                Label titleLabel = new Label(c, 0);
                if (this.titleText != null) {
                    titleLabel.setText(this.titleText);
                }
                Label closeLabel = new Label(parent, 0);
                closeLabel.setText("X");
                closeLabel.setAlignment(0x1000008);
                Font font = titleLabel.getFont();
                FontData[] fontDatas = font.getFontData();
                int i = 0;
                while (i < fontDatas.length) {
                    fontDatas[i].setStyle(1);
                    ++i;
                }
                Font titleFont = new Font((Device)titleLabel.getDisplay(), fontDatas);
                titleLabel.setFont(titleFont);
                closeLabel.setFont(titleFont);
                GridDataFactory.fillDefaults().indent(0, 0).applyTo((Control)c);
                GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).indent(0, 0).applyTo((Control)c);
                GridDataFactory.fillDefaults().align(0x1000008, 128).grab(true, false).indent(0, 0).applyTo((Control)closeLabel);
                closeLabel.addMouseListener(this.mouseListener);
                return c;
            }

            protected Point getInitialLocation(Point initialSize) {
                Rectangle bounds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds();
                return new Point(bounds.width + bounds.x - this.getDefaultSize().x - 15, bounds.height + bounds.y - this.getDefaultSize().y - 15);
            }
        }

        private final class ExportJob
        extends Job {
            private static final String DOT = ".";
            private List<DMBrowserNode> browserNodesToSave;
            private java.io.File targetDirectory;
            private java.io.File targetFile;

            protected ExportJob(String title, List<DMBrowserNode> browserNodesToSave, java.io.File ordnerPath) {
                super(title);
                this.browserNodesToSave = browserNodesToSave;
                this.targetDirectory = ordnerPath;
            }

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(StringUtils.format((String)"Exporting %d node(s): %s", (Object[])new Object[]{this.browserNodesToSave.size(), this.browserNodesToSave.toString()}).replace(DataManagementBrowser.BRACKET_OPEN, "").replace(DataManagementBrowser.BRACKET_CLOSE, ""), 2);
                monitor.worked(1);
                for (DMBrowserNode browserNodeToSave : this.browserNodesToSave) {
                    DMBrowserNode workflowNode = browserNodeToSave.getNodeWithTypeWorkflow();
                    if (workflowNode.getWorkflowHostName().equals(DataManagementBrowser.LOCAL) || DataManagementBrowser.this.isWorkflowHostReachable(workflowNode.getNodeIdentifier())) {
                        this.saveNode(browserNodeToSave);
                        continue;
                    }
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(1);
                return Status.OK_STATUS;
            }

            protected java.io.File getTargetFile() {
                return this.targetFile;
            }

            private void saveNode(DMBrowserNode browserNode) {
                if (SAVE_AS_FOLDER_NODE_TYPES.contains((Object)browserNode.getType())) {
                    if (!this.targetDirectory.exists()) {
                        this.targetDirectory.mkdir();
                    }
                    if (!browserNode.areChildrenKnown()) {
                        DataManagementBrowser.this.contentProvider.fetchChildren(browserNode);
                    }
                    DMBrowserNode[] dMBrowserNodeArray = DataManagementBrowser.this.contentProvider.getChildren(browserNode);
                    int n = dMBrowserNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DMBrowserNode child = dMBrowserNodeArray[n2];
                        if (child.isEnabled()) {
                            this.save(child, this.targetDirectory);
                        }
                        ++n2;
                    }
                } else {
                    String[] fileEnding;
                    String fileName = this.targetDirectory.getName();
                    this.targetDirectory = new java.io.File(this.targetDirectory.getAbsolutePath().replace(String.valueOf(java.io.File.separator) + fileName, ""));
                    if (!fileName.contains(DOT) && (fileEnding = browserNode.getAssociatedFilename().split(Pattern.quote(DOT))).length == 2) {
                        fileName = String.valueOf(fileName) + DOT + fileEnding[1];
                    }
                    this.targetFile = this.findUniqueFilename(this.targetDirectory, fileName);
                    if (browserNode.isEnabled()) {
                        this.save(browserNode.getDataReferenceId(), browserNode.getFileReferencePath(), this.targetFile.getName(), this.targetDirectory, browserNode.getNodeWithTypeWorkflow().getNodeIdentifier());
                    }
                }
            }

            private void save(DMBrowserNode browserNode, java.io.File directory) {
                String dataReferenceId = browserNode.getDataReferenceId();
                String fileReferencePath = browserNode.getFileReferencePath();
                String filename = browserNode.getAssociatedFilename();
                if (filename == null) {
                    filename = browserNode.getTitle();
                }
                filename = filename.replaceAll("[^-\\s\\(\\)._a-zA-Z0-9]", "_").trim();
                java.io.File nodeFile = this.findUniqueFilename(directory, filename);
                if (!browserNode.areChildrenKnown()) {
                    DataManagementBrowser.this.contentProvider.fetchChildren(browserNode);
                }
                if (browserNode.getNumChildren() > 0) {
                    nodeFile.mkdir();
                    DMBrowserNode[] dMBrowserNodeArray = DataManagementBrowser.this.contentProvider.getChildren(browserNode);
                    int n = dMBrowserNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DMBrowserNode child = dMBrowserNodeArray[n2];
                        if (child.isEnabled()) {
                            this.save(child, nodeFile);
                        }
                        ++n2;
                    }
                } else if (browserNode.isEnabled() && dataReferenceId != null || fileReferencePath != null) {
                    this.save(dataReferenceId, fileReferencePath, nodeFile.getName(), directory, browserNode.getNodeWithTypeWorkflow().getNodeIdentifier());
                }
            }

            private java.io.File findUniqueFilename(java.io.File directory, String filename) {
                java.io.File result = new java.io.File(directory, filename);
                if (!result.exists()) {
                    return result;
                }
                String prefix = filename;
                String postfix = "";
                Pattern pattern = Pattern.compile("^(.*)\\.([a-zA-Z0-9]+)$");
                Matcher matcher = pattern.matcher(filename);
                if (matcher.matches()) {
                    prefix = matcher.group(1);
                    postfix = DOT + matcher.group(2);
                }
                int i = 0;
                while ((result = new java.io.File(directory, StringUtils.format((String)"%s (%d)%s", (Object[])new Object[]{prefix, ++i, postfix}))).exists()) {
                }
                return result;
            }

            private void save(String dataReferenceId, String fileReferencePath, String filename, java.io.File directory, ResolvableNodeId rceNodeIdentifier) {
                try {
                    DataManagementWorkbenchUtils.getInstance().saveReferenceToFile(dataReferenceId, fileReferencePath, new java.io.File(directory, filename).getAbsolutePath(), rceNodeIdentifier);
                }
                catch (AuthorizationException | IOException | NullPointerException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private final class CustomSortAction
    extends SelectionProviderAction {
        private final List<DMBrowserNode> selectedNodes;
        private final int sortingType;

        private CustomSortAction(ISelectionProvider provider, String text, int sortingType) {
            super(provider, text);
            this.selectedNodes = new LinkedList<DMBrowserNode>();
            this.sortingType = sortingType;
            this.setChecked(DataManagementBrowser.this.treeSorter.getSortingType() == sortingType);
        }

        public void selectionChanged(IStructuredSelection selection) {
            DMBrowserNode node;
            this.selectedNodes.clear();
            boolean enabled = true;
            Object obj = selection.getFirstElement();
            if (obj instanceof DMBrowserNode && (enabled = DataManagementBrowser.this.treeSorter.isSortable(node = (DMBrowserNode)obj, this.sortingType))) {
                for (DMBrowserNode selectedNode : selection) {
                    this.selectedNodes.add(selectedNode);
                }
                enabled &= !this.selectedNodes.isEmpty();
            }
            this.setEnabled(enabled);
            this.setChecked((this.selectedNodes.isEmpty() || this.containsNodeTypeWorkflow(this.selectedNodes)) && DataManagementBrowser.this.treeSorter.getSortingType() == this.sortingType);
        }

        public void run() {
            DataManagementBrowser.this.visibleExpandedElements = DataManagementBrowser.this.viewer.getVisibleExpandedElements();
            if (this.selectedNodes.isEmpty() || this.containsNodeTypeWorkflow(this.selectedNodes)) {
                DataManagementBrowser.this.treeSorter.setSortingType(this.sortingType);
                DataManagementBrowser.this.treeSorter.enableSorting(true);
                DataManagementBrowser.this.viewer.refresh();
                this.setSortActionsChecked();
            } else {
                for (DMBrowserNode node : this.selectedNodes) {
                    if (!DataManagementBrowser.this.treeSorter.isSortable(node, this.sortingType) || !node.areChildrenKnown()) continue;
                    DataManagementBrowser.this.treeSorter.enableSorting(false);
                    this.setComparator(node);
                    this.setChecked(false);
                    DataManagementBrowser.this.viewer.refresh((Object)node);
                }
            }
            DataManagementBrowser.this.viewer.setExpandedElements(DataManagementBrowser.this.visibleExpandedElements);
        }

        private boolean containsNodeTypeWorkflow(List<DMBrowserNode> nodes) {
            for (DMBrowserNode node : nodes) {
                if (!node.getType().equals((Object)DMBrowserNodeType.Workflow)) continue;
                return true;
            }
            return false;
        }

        private void setSortActionsChecked() {
            DataManagementBrowser.this.sortAscendingName.setChecked(DataManagementBrowser.this.treeSorter.getSortingType() == 1);
            DataManagementBrowser.this.sortDescendingName.setChecked(DataManagementBrowser.this.treeSorter.getSortingType() == 2);
            DataManagementBrowser.this.sortTimestampAsc.setChecked(DataManagementBrowser.this.treeSorter.getSortingType() == 0);
            DataManagementBrowser.this.sortTimestampDesc.setChecked(DataManagementBrowser.this.treeSorter.getSortingType() == 3);
        }

        private void setComparator(DMBrowserNode node) {
            switch (this.sortingType) {
                case 0: {
                    node.sortChildren(DMBrowserNodeUtils.COMPARATOR_BY_HISTORY_TIMESTAMP);
                    break;
                }
                case 1: {
                    node.sortChildren(DMBrowserNodeUtils.COMPARATOR_BY_NODE_TITLE);
                    break;
                }
                case 2: {
                    node.sortChildren(DMBrowserNodeUtils.COMPARATOR_BY_NODE_TITLE_DESC);
                    break;
                }
                case 3: {
                    node.sortChildren(DMBrowserNodeUtils.COMPARATOR_BY_HISTORY_TIMESTAMP_DESC);
                    break;
                }
            }
        }
    }

    private final class DataManagementKeyListener
    implements KeyListener {
        private DataManagementKeyListener() {
        }

        public void keyPressed(KeyEvent event) {
            if (event.stateMask == 262144) {
                if (event.keyCode == 97) {
                    DataManagementBrowser.this.viewer.getTree().selectAll();
                    DataManagementBrowser.this.getSite().getSelectionProvider().setSelection(DataManagementBrowser.this.viewer.getSelection());
                } else if (event.keyCode == 99 && DataManagementBrowser.this.copyAction.isEnabled()) {
                    DataManagementBrowser.this.copyAction.run();
                } else if (event.keyCode == 116 && DataManagementBrowser.this.timelineAction.isEnabled()) {
                    DataManagementBrowser.this.timelineAction.run();
                } else if (event.keyCode == 0x100000E && DataManagementBrowser.this.refreshNodeAction.isEnabled()) {
                    DataManagementBrowser.this.refreshNodeAction.run();
                } else if (event.keyCode == 102 && DataManagementBrowser.this.exportNodeToFileSystemAction.isEnabled()) {
                    DataManagementBrowser.this.exportNodeToFileSystemAction.run();
                } else if (event.keyCode == 103 && DataManagementBrowser.this.exportNodeToProjectAction.isEnabled()) {
                    DataManagementBrowser.this.exportNodeToProjectAction.run();
                }
            } else if (event.keyCode == 127) {
                if (DataManagementBrowser.this.deleteNodeAction.isEnabled()) {
                    DataManagementBrowser.this.deleteNodeAction.run();
                }
            } else if (event.keyCode == 0x100000E && DataManagementBrowser.this.actionRefreshAll.isEnabled()) {
                DataManagementBrowser.this.actionRefreshAll.run();
            }
        }

        public void keyReleased(KeyEvent arg0) {
        }
    }

    private static enum ExportType {
        FILESYSTEM,
        PROJECT;

    }

    private class FileCompareInput
    extends CompareEditorInput {
        private java.io.File left;
        private java.io.File right;

        FileCompareInput(CompareConfiguration cc, java.io.File left, java.io.File right) {
            super(cc);
            this.left = left;
            this.right = right;
        }

        protected Object prepareInput(IProgressMonitor arg0) throws InvocationTargetException, InterruptedException {
            DiffNode result = new DiffNode(12);
            result.setAncestor((ITypedElement)new CompareItem(this.left));
            result.setLeft((ITypedElement)new CompareItem(this.left));
            result.setRight((ITypedElement)new CompareItem(this.right));
            return result;
        }
    }

    private final class OpenInEditorAction
    extends SelectionProviderAction {
        private OpenInEditorAction(ISelectionProvider provider, String text) {
            super(provider, text);
        }

        public void selectionChanged(IStructuredSelection selection) {
            DMBrowserNode node;
            Object obj = selection.getFirstElement();
            if (selection.size() == 1 && obj instanceof DMBrowserNode && (node = (DMBrowserNode)obj).isEnabled() && OPEN_IN_EDITOR_NODE_TYPES.contains((Object)node.getType())) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        public void run() {
            DMBrowserNode node;
            if (!this.isEnabled()) {
                return;
            }
            ISelection selection = DataManagementBrowser.this.viewer.getSelection();
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof DMBrowserNode && (node = (DMBrowserNode)object).getType() != DMBrowserNodeType.Workflow && node.getType() != DMBrowserNodeType.DMDirectoryReference) {
                String dataReferenceId = node.getDataReferenceId();
                String associatedFilename = node.getAssociatedFilename();
                String fileReferencePath = node.getFileReferencePath();
                if (associatedFilename == null) {
                    associatedFilename = "default";
                }
                DataManagementWorkbenchUtils.getInstance().tryOpenDataReferenceInReadonlyEditor(dataReferenceId, fileReferencePath, associatedFilename, node.getNodeWithTypeWorkflow().getNodeIdentifier(), false);
                return;
            }
        }
    }

    private final class OpenInTiglAction
    extends SelectionProviderAction {
        private OpenInTiglAction(ISelectionProvider provider, String text) {
            super(provider, text);
        }

        public void selectionChanged(IStructuredSelection selection) {
            DMBrowserNode node;
            Object obj = selection.getFirstElement();
            if (selection.size() == 1 && obj instanceof DMBrowserNode && (node = (DMBrowserNode)obj).isEnabled() && node.getType() == DMBrowserNodeType.DMFileResource && Arrays.asList(TiglViewerConstants.SUPPORTED_FILE_EXTENSIONS).contains(FilenameUtils.getExtension((String)node.getAssociatedFilename()).toLowerCase())) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        public void run() {
            DMBrowserNode node;
            if (!this.isEnabled()) {
                return;
            }
            ISelection selection = DataManagementBrowser.this.viewer.getSelection();
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof DMBrowserNode && (node = (DMBrowserNode)object).getType() != DMBrowserNodeType.Workflow && node.getType() != DMBrowserNodeType.DMDirectoryReference) {
                String dataReferenceId = node.getDataReferenceId();
                String associatedFilename = node.getAssociatedFilename();
                String fileReferencePath = node.getFileReferencePath();
                if (associatedFilename == null) {
                    associatedFilename = "default";
                }
                DataManagementWorkbenchUtils.getInstance().tryOpenDataReferenceInReadonlyEditor(dataReferenceId, fileReferencePath, associatedFilename, node.getNodeWithTypeWorkflow().getNodeIdentifier(), true);
                return;
            }
        }
    }

    private final class OpenTimelineViewAction
    extends SelectionProviderAction {
        private DMBrowserNode nodeSelected;

        private OpenTimelineViewAction(ISelectionProvider provider, String text) {
            super(provider, text);
        }

        public void selectionChanged(IStructuredSelection selection) {
            Object obj = selection.getFirstElement();
            if (selection.size() == 1 && obj instanceof DMBrowserNode) {
                this.nodeSelected = (DMBrowserNode)obj;
                if (this.nodeSelected.getType() == DMBrowserNodeType.Workflow || this.nodeSelected.getType() == DMBrowserNodeType.WorkflowRunInformation || this.nodeSelected.getType() == DMBrowserNodeType.Timeline || this.nodeSelected.getType() == DMBrowserNodeType.Components) {
                    this.setEnabled(true);
                    return;
                }
            }
            this.setEnabled(false);
        }

        public void run() {
            try {
                IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("de.rcenvironment.gui.Timeline", this.nodeSelected.getNodeWithTypeWorkflow().getWorkflowID(), 1);
                ((TimelineView)view).initialize(Long.valueOf(Long.parseLong(this.nodeSelected.getNodeWithTypeWorkflow().getWorkflowID())), (ResolvableNodeId)this.nodeSelected.getNodeWithTypeWorkflow().getWorkflowControllerNode());
            }
            catch (PartInitException e) {
                DataManagementBrowser.this.log.error((Object)("Failed to open timeline view for workflow: " + this.nodeSelected.getName()), (Throwable)e);
            }
        }
    }

    private final class RefreshNodeAction
    extends SelectionProviderAction {
        private final List<DMBrowserNode> selectedNodes;

        private RefreshNodeAction(ISelectionProvider provider, String text) {
            super(provider, text);
            this.selectedNodes = new LinkedList<DMBrowserNode>();
        }

        public void selectionChanged(IStructuredSelection selection) {
            boolean enabled = !selection.isEmpty();
            this.selectedNodes.clear();
            if (enabled) {
                for (DMBrowserNode selectedNode : selection) {
                    if (REFRESHABLE_NODE_TYPES.contains((Object)selectedNode.getType())) {
                        this.selectedNodes.add(selectedNode);
                        continue;
                    }
                    enabled = false;
                }
                enabled &= !this.selectedNodes.isEmpty();
            }
            this.setEnabled(enabled);
        }

        public void run() {
            for (DMBrowserNode node : this.selectedNodes) {
                DataManagementBrowser.this.refresh(node);
            }
        }
    }
}

