/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.LocalExecutionControllerUtilsService;
import de.rcenvironment.core.component.execution.api.WorkflowExecutionControllerCallback;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.workflow.execution.api.RemotableWorkflowExecutionControllerService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionController;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowStateNotificationSubscriber;
import de.rcenvironment.core.component.workflow.execution.impl.WorkflowExecutionInformationImpl;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowExecutionControllerImpl;
import de.rcenvironment.core.component.workflow.execution.spi.SingleWorkflowStateChangeListener;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.notification.NotificationService;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class WorkflowExecutionControllerServiceImpl
implements RemotableWorkflowExecutionControllerService {
    private BundleContext bundleContext;
    private WorkflowHostService workflowHostService;
    private LocalExecutionControllerUtilsService exeCtrlUtilsService;
    private NotificationService notificationService;
    private CommunicationService communicationService;
    private DistributedComponentKnowledgeService distributedComponentKnowledgeService;
    private Map<String, ServiceRegistration<?>> workflowServiceRegistrations = Collections.synchronizedMap(new HashMap());
    private Map<String, WorkflowExecutionInformation> workflowExecutionInformations = Collections.synchronizedMap(new HashMap());
    private final Log log = LogFactory.getLog(this.getClass());

    @Activate
    protected void activate(BundleContext context) {
        this.bundleContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public WorkflowExecutionInformation createExecutionController(WorkflowExecutionContext wfExeCtx, Map<String, String> executionAuthTokens, Boolean calledFromRemote) throws WorkflowExecutionException, RemoteOperationException {
        if (calledFromRemote.booleanValue() && !this.workflowHostService.getLogicalWorkflowHostNodes().contains(wfExeCtx.getNodeId())) {
            throw new WorkflowExecutionException(StringUtils.format((String)"Workflow execution request refused, as the requested instance is not declared as workflow host: %s", (Object[])new Object[]{wfExeCtx.getNodeId()}));
        }
        WorkflowExecutionControllerImpl workflowController = new WorkflowExecutionControllerImpl(wfExeCtx, ServiceRegistry.createAccessFor((Object)this));
        workflowController.setComponentExecutionAuthTokens(executionAuthTokens);
        String executionId = wfExeCtx.getExecutionIdentifier();
        this.registerExecutionController(workflowController, executionId);
        WorkflowExecutionInformationImpl workflowExecutionInformation = new WorkflowExecutionInformationImpl(wfExeCtx);
        workflowExecutionInformation.setIdentifier(wfExeCtx.getExecutionIdentifier());
        workflowExecutionInformation.setWorkflowState(WorkflowState.INIT);
        Map<String, WorkflowExecutionInformation> map = this.workflowExecutionInformations;
        synchronized (map) {
            this.workflowExecutionInformations.put(wfExeCtx.getExecutionIdentifier(), workflowExecutionInformation);
        }
        return workflowExecutionInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AllowRemoteAccess
    public void performDispose(final String wfExecutionId) throws RemoteOperationException {
        WorkflowStateNotificationSubscriber workflowStateDisposedListener = new WorkflowStateNotificationSubscriber(new SingleWorkflowStateChangeListener(){

            @Override
            public void onWorkflowStateChanged(WorkflowState newState) {
                if (newState == WorkflowState.DISPOSED) {
                    WorkflowExecutionControllerServiceImpl.this.dispose(wfExecutionId);
                } else if (newState != WorkflowState.DISPOSING) {
                    WorkflowExecutionControllerServiceImpl.this.log.warn((Object)StringUtils.format((String)"Received unexpected workflow state '%s' for workflow '%s'", (Object[])new Object[]{newState.getDisplayName(), wfExecutionId}));
                }
            }

            @Override
            public void onWorkflowNotAliveAnymore(String errorMessage) {
            }
        }, wfExecutionId){
            private static final long serialVersionUID = 3168599724769249933L;

            @Override
            public void processNotification(Notification notification) {
                super.processNotification(notification);
                if (WorkflowState.isWorkflowStateValid((String)((Object)notification.getBody())) && !WorkflowState.valueOf((String)((Object)notification.getBody())).equals((Object)WorkflowState.DISPOSING)) {
                    try {
                        WorkflowExecutionControllerServiceImpl.this.notificationService.unsubscribe("rce.component.workflow.state:" + wfExecutionId, (NotificationSubscriber)this);
                    }
                    catch (RemoteOperationException e) {
                        WorkflowExecutionControllerServiceImpl.this.log.warn((Object)StringUtils.format((String)"Failed to unsubscribe from state changes for workflow %s: %s", (Object[])new Object[]{wfExecutionId, e.getMessage()}));
                    }
                }
            }
        };
        try {
            this.notificationService.subscribe("rce.component.workflow.state:" + wfExecutionId, (NotificationSubscriber)workflowStateDisposedListener);
        }
        catch (RemoteOperationException e) {
            this.log.error((Object)("Failed to subscribe for workflow state changes before disposing: " + e.getMessage()));
            return;
        }
        try {
            this.getExecutionController(wfExecutionId).dispose();
        }
        catch (ExecutionControllerException e) {
            this.log.warn((Object)StringUtils.format((String)"Failed to dispose workflow (%s). It seems to be already disposed (%s).", (Object[])new Object[]{wfExecutionId, e.getMessage()}));
        }
        Map<String, WorkflowExecutionInformation> map = this.workflowExecutionInformations;
        synchronized (map) {
            this.workflowExecutionInformations.remove(wfExecutionId);
        }
    }

    private void dispose(String executionId) {
        this.unregisterExecutionController(executionId);
    }

    @AllowRemoteAccess
    public void performStart(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionController(executionId).start();
    }

    @AllowRemoteAccess
    public void performCancel(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionController(executionId).cancel();
    }

    @AllowRemoteAccess
    public void performPause(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionController(executionId).pause();
    }

    @AllowRemoteAccess
    public void performResume(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionController(executionId).resume();
    }

    @Override
    @AllowRemoteAccess
    public WorkflowState getWorkflowState(String executionId) throws ExecutionControllerException, RemoteOperationException {
        return this.getExecutionController(executionId).getState();
    }

    @Override
    @AllowRemoteAccess
    public Long getWorkflowDataManagementId(String executionId) throws ExecutionControllerException {
        return this.getExecutionController(executionId).getDataManagementId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public Collection<WorkflowExecutionInformation> getWorkflowExecutionInformations() throws ExecutionControllerException, RemoteOperationException {
        HashMap<String, WorkflowExecutionInformation> wfExeInfoSnapshot = null;
        Map<String, WorkflowExecutionInformation> map = this.workflowExecutionInformations;
        synchronized (map) {
            wfExeInfoSnapshot = new HashMap<String, WorkflowExecutionInformation>();
            wfExeInfoSnapshot.putAll(this.workflowExecutionInformations);
        }
        for (String executionId : wfExeInfoSnapshot.keySet()) {
            Long dmId;
            WorkflowState state;
            try {
                state = this.getWorkflowState(executionId);
                dmId = this.getWorkflowDataManagementId(executionId);
            }
            catch (ExecutionControllerException e) {
                this.log.debug((Object)StringUtils.format((String)"Removed workflow %s from temporary set of workflow execution infos: %s", (Object[])new Object[]{executionId, e.getMessage()}));
                continue;
            }
            ((WorkflowExecutionInformationImpl)wfExeInfoSnapshot.get(executionId)).setWorkflowState(state);
            ((WorkflowExecutionInformationImpl)wfExeInfoSnapshot.get(executionId)).setWorkflowDataManagementId(dmId);
        }
        return new HashSet<WorkflowExecutionInformation>(wfExeInfoSnapshot.values());
    }

    @Override
    @AllowRemoteAccess
    public Map<String, String> verifyComponentVisibility(List<String> componentRefs) {
        DistributedComponentKnowledge compKnowledge = this.distributedComponentKnowledgeService.getCurrentSnapshot();
        Set reachableLogicalNodes = this.communicationService.getReachableLogicalNodes();
        HashMap<String, String> result = new HashMap<String, String>();
        for (String compRef : componentRefs) {
            LogicalNodeId logicalNodeId;
            String[] refParts = StringUtils.splitAndUnescape((String)compRef);
            String resultKey = refParts[0];
            String componentIdAndVersion = refParts[1];
            try {
                logicalNodeId = NodeIdentifierUtils.parseLogicalNodeIdString((String)refParts[2]);
            }
            catch (IdentifierException identifierException) {
                result.put(resultKey, "Invalid node id: " + refParts[2]);
                continue;
            }
            if (!this.isNodeVisible(reachableLogicalNodes, logicalNodeId)) {
                result.put(resultKey, "The instance to run this component on is not visible from the workflow controller's instance. Check if they are located in disconnected networks.");
                continue;
            }
            if (this.isComponentVisible(compKnowledge, componentIdAndVersion, logicalNodeId)) continue;
            result.put(resultKey, "The workflow controller cannot access this component. Check if the controller needs to be in additional authorization groups.");
        }
        return result;
    }

    @Reference
    protected void bindWorkflowHostService(WorkflowHostService newService) {
        this.workflowHostService = newService;
    }

    @Reference
    protected void bindLocalExecutionControllerUtilsService(LocalExecutionControllerUtilsService newService) {
        this.exeCtrlUtilsService = newService;
    }

    @Reference
    protected void bindNotificationService(NotificationService newService) {
        this.notificationService = newService;
    }

    @Reference
    protected void setCommunicationService(CommunicationService newService) {
        this.communicationService = newService;
    }

    @Reference
    protected void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService newService) {
        this.distributedComponentKnowledgeService = newService;
    }

    private boolean isNodeVisible(Set<LogicalNodeId> reachableLogicalNodes, LogicalNodeId logicalNodeId) {
        return reachableLogicalNodes.contains(logicalNodeId);
    }

    private boolean isComponentVisible(DistributedComponentKnowledge compKnowledge, String componentIdAndVersion, LogicalNodeId logicalNodeId) {
        for (DistributedComponentEntry comp : compKnowledge.getKnownSharedInstallationsOnNode((ResolvableNodeId)logicalNodeId, false)) {
            if (!comp.getComponentInstallation().getInstallationId().equals(componentIdAndVersion)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerExecutionController(WorkflowExecutionController workflowController, String executionId) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("rce.component.execution.id", executionId);
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(new String[]{WorkflowExecutionController.class.getName(), WorkflowExecutionControllerCallback.class.getName()}, (Object)workflowController, properties);
        Map<String, ServiceRegistration<?>> map = this.workflowServiceRegistrations;
        synchronized (map) {
            this.workflowServiceRegistrations.put(executionId, serviceRegistration);
        }
    }

    private WorkflowExecutionController getExecutionController(String executionId) throws ExecutionControllerException {
        return (WorkflowExecutionController)this.exeCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, executionId, this.bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterExecutionController(String executionId) {
        Map<String, ServiceRegistration<?>> map = this.workflowServiceRegistrations;
        synchronized (map) {
            if (this.workflowServiceRegistrations.containsKey(executionId)) {
                this.workflowServiceRegistrations.get(executionId).unregister();
                this.workflowServiceRegistrations.remove(executionId);
            }
        }
    }
}

