/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import de.rcenvironment.core.configuration.bootstrap.profile.CommonProfile;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import de.rcenvironment.core.utils.executor.testutils.IntegrationTestExecutorUtils;
import de.rcenvironment.core.utils.testing.TestParametersProvider;
import de.rcenvironment.extras.testscriptrunner.common.CommonTestConfiguration;
import de.rcenvironment.extras.testscriptrunner.common.CommonUtils;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.CommonStateAndSteps;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.SshCommandExecutionDefinitions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;

public class RCEDefinitions {
    private CommonStateAndSteps commonState;
    private Map<String, String> dynamicSubstitutionMap;
    private File testDir = new File(CommonUtils.getValidatedSystemTempDir(), "rce-testing");

    public RCEDefinitions() throws IOException {
        this.testDir.mkdirs();
        if (!this.testDir.isDirectory()) {
            throw new IOException("Failed to create test dir");
        }
        this.commonState = CommonStateAndSteps.getCurrent();
        this.dynamicSubstitutionMap = new HashMap<String, String>();
        this.commonState.setParameterSubstitutionMap(this.dynamicSubstitutionMap);
    }

    @Given(value="^a random profile path with placeholder \\$\\{(.*?)\\}( which is locked)?$")
    public void createRandomDirAsProfileDir(String profilePlaceholder, String locked) throws Throwable {
        File profileDir = new File(this.testDir, UUID.randomUUID().toString());
        this.dynamicSubstitutionMap.put(profilePlaceholder, profileDir.getAbsolutePath());
        if (locked != null) {
            new CommonProfile.Builder(profileDir).create(true).migrate(true).buildUserProfile().attemptToLockProfileDirectory();
        }
    }

    @When(value="^calling RCE with parameters$")
    public void callingRceWithParameters(String parameters) throws Throwable {
        this.invokeRCE(CommonUtils.substitute(parameters, this.dynamicSubstitutionMap));
    }

    @When(value="^calling RCE$")
    public void callingRce() throws Throwable {
        this.invokeRCE("");
    }

    private void invokeRCE(String parameters) throws IOException, InterruptedException {
        TestParametersProvider testParameters = CommonTestConfiguration.getParameters();
        File rceExeLocation = testParameters.getExistingFile("testexecutable.path");
        String command = String.valueOf(rceExeLocation.getAbsolutePath()) + " " + parameters;
        final LocalApacheCommandLineExecutor executor = new LocalApacheCommandLineExecutor(rceExeLocation.getParentFile());
        executor.start(command);
        CapturingTextOutReceiver stdoutCapture = new CapturingTextOutReceiver(){
            private boolean cancelRequested = false;

            public synchronized void addOutput(String line) {
                super.addOutput(line);
                if (!this.cancelRequested && this.getBufferedOutput().contains("Early startup complete, running main application")) {
                    this.cancelRequested = true;
                    executor.cancel();
                }
            }
        };
        CapturingTextOutReceiver stderrCapture = new CapturingTextOutReceiver();
        TextStreamWatcher stdoutWatcher = new TextStreamWatcher(executor.getStdout(), ConcurrencyUtils.getAsyncTaskService(), new TextOutputReceiver[]{stdoutCapture}).start();
        TextStreamWatcher stderrWatcher = new TextStreamWatcher(executor.getStderr(), ConcurrencyUtils.getAsyncTaskService(), new TextOutputReceiver[]{stderrCapture}).start();
        int exitCode = executor.waitForTermination();
        stdoutWatcher.waitForTermination();
        stderrWatcher.waitForTermination();
        this.commonState.setCurrentExecutionResult(new IntegrationTestExecutorUtils.ExecutionResult(exitCode, stdoutCapture.getBufferedOutput(), stderrCapture.getBufferedOutput()));
    }

    @Given(value="^a RCE instance running as SSH server$")
    public void startRCEinstanceRunningAsSSHserver() throws Throwable {
        TestParametersProvider testParameters = CommonTestConfiguration.getParameters();
        File rceExeLocation = testParameters.getExistingFile("testexecutable.path");
        URL ressources = RCEDefinitions.class.getResource("");
        File profilePath = new File(new File(ressources.toURI()), "../../../../../profiles/sshServer");
        String command = String.valueOf(rceExeLocation.getAbsolutePath()) + " --profile " + profilePath.getCanonicalPath() + " --headless";
        LocalApacheCommandLineExecutor executor = new LocalApacheCommandLineExecutor(rceExeLocation.getParentFile());
        executor.start(command);
        final CountDownLatch earlyStartupCompleteLatch = new CountDownLatch(1);
        CapturingTextOutReceiver stdoutCapture = new CapturingTextOutReceiver(){
            private boolean earlyStartupComplete = false;

            public synchronized void addOutput(String line) {
                super.addOutput(line);
                if (!this.earlyStartupComplete && this.getBufferedOutput().contains("Early startup complete, running main application")) {
                    this.earlyStartupComplete = true;
                    earlyStartupCompleteLatch.countDown();
                }
            }
        };
        new TextStreamWatcher(executor.getStdout(), ConcurrencyUtils.getAsyncTaskService(), new TextOutputReceiver[]{stdoutCapture}).start();
        earlyStartupCompleteLatch.await();
    }

    @Then(value="^shutdown the RCE instance$")
    public void shutdownTheRCEinstance() throws Throwable {
        new SshCommandExecutionDefinitions().executeAndWait("shutdown", null);
    }
}

