/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import cucumber.api.DataTable;
import cucumber.api.java.After;
import cucumber.api.java.Before;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import de.rcenvironment.core.instancemanagement.InstanceConfigurationOperationSequence;
import de.rcenvironment.core.instancemanagement.InstanceManagementService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.PrefixingTextOutForwarder;
import de.rcenvironment.extras.testscriptrunner.definitions.common.AbstractStepDefinitionBase;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import de.rcenvironment.toolkit.modules.concurrency.api.RunnablesGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;

public class InstanceManagementStepDefinitions
extends AbstractStepDefinitionBase {
    private static final String WARNINGS_LOG_FILE_NAME = "warnings.log";
    private static final String DEBUG_LOG_FILE_NAME = "debug.log";
    private static final int IM_OPERATION_TIMEOUT = 30000;
    private static final ManagedInstance[] EMPTY_INSTANCE_ARRAY = new ManagedInstance[0];
    private static final Pattern INSTANCE_DEFINITION_PATTERN = Pattern.compile("(\\w+)( \\[.*\\])?");
    private static final Pattern INSTANCE_DEFINITION_ID_SUBPATTERN = Pattern.compile("Id=(\\w+)");
    private static final String ABSENT_COMPONENT_STRING = "(absent)";
    private final AtomicInteger portNumberGenerator = new AtomicInteger(52100);
    private final Collection<ManagedInstance> enabledInstances = new HashSet<ManagedInstance>();

    public InstanceManagementStepDefinitions(TestScenarioExecutionContext executionContext) {
        super(executionContext);
    }

    @Before
    public void initialize() {
        Assert.assertTrue((boolean)this.instancesById.isEmpty());
        Assert.assertTrue((boolean)this.enabledInstances.isEmpty());
    }

    @After
    public void tearDown() {
        this.tearDownLeftoverRunningInstances();
    }

    @Given(value="^(?:the )?(running )?instance[s]? \"([^\"]*)\" (?:based on template \"([^\"]*)\" )?using (?:the default build|build \"([^\"]*)\")$")
    public void givenInstancesUsingBuild(String autoStartPhrase, String instanceList, String optionalTemplateId, String buildOrInstallationId) throws Throwable {
        String installationId;
        if (buildOrInstallationId == null) {
            buildOrInstallationId = this.executionContext.getBuildUnderTestId();
        }
        PrefixingTextOutForwarder imOperationOutputReceiver = this.getTextoutReceiverForIMOperations();
        if (this.instanceManagementService.isSpecialInstallationId(buildOrInstallationId)) {
            installationId = buildOrInstallationId;
        } else {
            installationId = this.deriveImplicitInstallationIdFromBuildId(buildOrInstallationId);
            this.printToCommandConsole(StringUtils.format((String)"Setting up installation \"%s\" using build \"%s\"", (Object[])new Object[]{installationId, buildOrInstallationId}));
            this.instanceManagementService.setupInstallationFromUrlQualifier(installationId, buildOrInstallationId, InstanceManagementService.InstallationPolicy.IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT, (TextOutputReceiver)imOperationOutputReceiver, 30000L);
        }
        List<String> instanceDefinitionParts = this.parseInstanceList(instanceList);
        ArrayList<String> instanceIds = new ArrayList<String>();
        for (String instanceDefinition : instanceDefinitionParts) {
            Matcher matcher = INSTANCE_DEFINITION_PATTERN.matcher(instanceDefinition);
            if (!matcher.matches()) {
                Assert.fail((String)("Invalid instance definition part: " + instanceDefinition));
            }
            String instanceId = matcher.group(1);
            instanceIds.add(instanceId);
            String optionString = matcher.group(2);
            if (optionString == null) {
                optionString = "";
            }
            ManagedInstance instance = new ManagedInstance(instanceId, installationId, this.instanceManagementService);
            this.instancesById.put(instanceId, instance);
            this.enabledInstances.add(instance);
            this.printToCommandConsole(StringUtils.format((String)"Configuring test instance \"%s\"", (Object[])new Object[]{instanceId}));
            int imSshPortNumber = this.portNumberGenerator.incrementAndGet();
            InstanceConfigurationOperationSequence setupSequence = this.instanceManagementService.newConfigurationOperationSequence();
            if (optionalTemplateId == null) {
                setupSequence = setupSequence.resetConfiguration();
            } else {
                File testTemplateFile = new File(this.executionContext.getTestScriptLocation(), StringUtils.format((String)"instance_templates/%s.json", (Object[])new Object[]{optionalTemplateId}));
                if (!testTemplateFile.isFile()) {
                    throw new IOException("Specified template file " + optionalTemplateId + " was not found at expected location " + testTemplateFile);
                }
                setupSequence = setupSequence.applyTemplateFile(testTemplateFile);
            }
            if (optionString.contains("Relay")) {
                setupSequence = setupSequence.setRelayFlag(true);
            }
            if (optionString.contains("WorkflowHost") || optionString.contains("WfHost") || optionString.contains("WFHost")) {
                setupSequence = setupSequence.setWorkflowHostFlag(true);
            }
            Matcher idMatcher = INSTANCE_DEFINITION_ID_SUBPATTERN.matcher(optionString);
            String customNodeId = null;
            if (idMatcher.find()) {
                customNodeId = idMatcher.group(1);
            }
            setupSequence = setupSequence.enableImSshAccess(imSshPortNumber).setName(instanceId);
            if (customNodeId != null) {
                setupSequence = setupSequence.setCustomNodeId(customNodeId);
            }
            this.instanceManagementService.applyInstanceConfigurationOperations(instanceId, setupSequence, (TextOutputReceiver)imOperationOutputReceiver);
        }
        this.printToCommandConsole(StringUtils.format((String)"Auto-starting instance(s) \"%s\"", (Object[])new Object[]{instanceList}));
        if (autoStartPhrase != null) {
            this.instanceManagementService.startInstance(installationId, instanceIds, (TextOutputReceiver)imOperationOutputReceiver, 30000L, false);
        }
    }

    @When(value="^starting all instances( concurrently)?( in GUI mode)?$")
    public void whenStartingAllInstances(String startConcurrentlyFlag, String startWithGuiFlag) throws Throwable {
        boolean startWithGui;
        boolean startConcurrently = startConcurrentlyFlag != null;
        boolean bl = startWithGui = startWithGuiFlag != null;
        if (startConcurrently) {
            RunnablesGroup runnablesGroup = ConcurrencyUtils.getFactory().createRunnablesGroup();
            for (final ManagedInstance instance : this.enabledInstances) {
                runnablesGroup.add(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InstanceManagementStepDefinitions.this.startSingleInstance(instance, startWithGui);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            this.executeRunnablesGroupAndHandlePotentialErrors(runnablesGroup, "starting an instance");
        } else {
            for (ManagedInstance instance : this.enabledInstances) {
                this.startSingleInstance(instance, startWithGui);
            }
        }
    }

    @When(value="^stopping all instances( concurrently)?$")
    public void whenStoppingAllInstances(String stopConcurrently) throws Throwable {
        if (stopConcurrently != null) {
            RunnablesGroup runnablesGroup = ConcurrencyUtils.getFactory().createRunnablesGroup();
            for (final ManagedInstance instance : this.enabledInstances) {
                runnablesGroup.add(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InstanceManagementStepDefinitions.this.stopSingleInstance(instance);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            this.executeRunnablesGroupAndHandlePotentialErrors(runnablesGroup, "stopping an instance");
        } else {
            for (ManagedInstance instance : this.enabledInstances) {
                this.stopSingleInstance(instance);
            }
        }
    }

    @When(value="^scheduling (?:a|an instance) (shutdown|restart|reconnect) of \"([^\"]+)\" after (\\d+) seconds$")
    public void whenSchedulingNodeActionsAfterDelay(final String action, final String instanceId, int delaySeconds) throws Throwable {
        final ManagedInstance instance = this.resolveInstance(instanceId);
        ConcurrencyUtils.getAsyncTaskService().scheduleAfterDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    switch (action) {
                        case "shutdown": {
                            InstanceManagementStepDefinitions.this.stopSingleInstance(instance);
                            break;
                        }
                        case "restart": {
                            InstanceManagementStepDefinitions.this.stopSingleInstance(instance);
                            InstanceManagementStepDefinitions.this.startSingleInstance(instance, false);
                            break;
                        }
                        case "reconnect": {
                            InstanceManagementStepDefinitions.this.cycleAllOutgoingConnectionsOf(instance);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(action);
                        }
                    }
                }
                catch (IOException e) {
                    InstanceManagementStepDefinitions.this.log.error((Object)("Error while executing aynchonous action '" + action + "' on instance '" + instanceId + "'"), (Throwable)e);
                }
            }
        }, TimeUnit.SECONDS.toMillis(delaySeconds));
        this.printToCommandConsole(StringUtils.format((String)"Scheduling a '%s' action for instance '%s' after %d second(s)", (Object[])new Object[]{action, instanceId, delaySeconds}));
    }

    @Then(value="^instance[s]? \"([^\"]*)\" should be (stopped|running)$")
    public void thenInstancesShouldBeInState(String instanceList, String state) throws Throwable {
        boolean shouldBeRunning = "running".equals(state);
        for (String instanceId : this.parseInstanceList(instanceList)) {
            boolean isRunning = this.instanceManagementService.isInstanceRunning(instanceId);
            if (isRunning != shouldBeRunning) {
                throw new AssertionError((Object)StringUtils.format((String)"Instance state did not match expectation: Instance \"%s\" was in running state [%s] when it should have been [%s]", (Object[])new Object[]{instanceId, isRunning, shouldBeRunning}));
            }
        }
    }

    @Given(value="^configured network connection[s]? \"([^\"]*)\"$")
    public void givenConfiguredNetworkConnections(String connectionsSetup) throws Throwable {
        this.printToCommandConsole(StringUtils.format((String)"Configuring network connections (\"%s\")", (Object[])new Object[]{connectionsSetup}));
        Pattern p = Pattern.compile("\\s*(\\w+)->(\\w+)\\s*(?:\\[([\\w,\\s]*)\\])?\\s*");
        String[] stringArray = connectionsSetup.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String connectionSetupPart = stringArray[n2];
            Matcher m = p.matcher(connectionSetupPart);
            if (!m.matches()) {
                Assert.fail((String)("Syntax error in connection setup part: " + connectionSetupPart));
            }
            String clientInstanceId = m.group(1);
            String serverInstanceId = m.group(2);
            String connectionOptions = m.group(3);
            ManagedInstance serverInstance = this.resolveInstance(serverInstanceId);
            Integer serverPort = serverInstance.getServerPort();
            if (serverPort == null) {
                serverPort = this.portNumberGenerator.incrementAndGet();
                InstanceConfigurationOperationSequence operationSequence = this.instanceManagementService.newConfigurationOperationSequence().addServerPort("default", "127.0.0.1", serverPort.intValue());
                this.instanceManagementService.applyInstanceConfigurationOperations(serverInstanceId, operationSequence, (TextOutputReceiver)this.getTextoutReceiverForIMOperations());
                serverInstance.setServerPort(serverPort);
            }
            String serverPortString = serverPort.toString();
            String connectionEntryName = String.valueOf(serverInstanceId) + "_Port" + serverPortString;
            String cnListOutputConnectionName = StringUtils.format((String)"%s:%d", (Object[])new Object[]{"127.0.0.1", serverPort});
            boolean enableAutoStart = connectionOptions != null && connectionOptions.contains("autoStart");
            InstanceConfigurationOperationSequence operationSequence = this.instanceManagementService.newConfigurationOperationSequence().addNetworkConnection(connectionEntryName, "127.0.0.1", serverPort.intValue(), enableAutoStart, 5, 30, 1.5f);
            this.instanceManagementService.applyInstanceConfigurationOperations(clientInstanceId, operationSequence, (TextOutputReceiver)this.getTextoutReceiverForIMOperations());
            if (enableAutoStart) {
                this.resolveInstance(clientInstanceId).accessConfiguredAutostartConnectionIds().add(cnListOutputConnectionName);
            }
            ++n2;
        }
    }

    @Then(value="^all auto-start network connections should be ready within (\\d+) seconds$")
    public void thenAllAutoStartNetworkConnectionsShouldBeReadyWithinSeconds(int maxWaitTimeSeconds) throws Throwable {
        boolean success;
        ManagedInstance instance;
        int n;
        int n2;
        ManagedInstance[] managedInstanceArray;
        this.printToCommandConsole("Waiting for all auto-start network connections to complete");
        HashSet<ManagedInstance> pendingInstances = new HashSet<ManagedInstance>();
        for (ManagedInstance instance2 : this.enabledInstances) {
            if (instance2.accessConfiguredAutostartConnectionIds().isEmpty()) continue;
            pendingInstances.add(instance2);
        }
        long maximumTimestampForStandardAttempts = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxWaitTimeSeconds);
        while (!pendingInstances.isEmpty() && System.currentTimeMillis() <= maximumTimestampForStandardAttempts) {
            managedInstanceArray = this.detachedIterableCopy(pendingInstances);
            n2 = managedInstanceArray.length;
            n = 0;
            while (n < n2) {
                instance = managedInstanceArray[n];
                success = this.testIfConfiguredOutgoingConnectionsAreConnected(instance, false);
                if (success) {
                    pendingInstances.remove(instance);
                }
                ++n;
            }
        }
        if (!pendingInstances.isEmpty()) {
            managedInstanceArray = this.detachedIterableCopy(pendingInstances);
            n2 = managedInstanceArray.length;
            n = 0;
            while (n < n2) {
                instance = managedInstanceArray[n];
                success = this.testIfConfiguredOutgoingConnectionsAreConnected(instance, true);
                if (success) {
                    pendingInstances.remove(instance);
                }
                ++n;
            }
        }
        if (!pendingInstances.isEmpty()) {
            Assert.fail((String)("On " + pendingInstances.size() + " instance(s), the configured outgoing connections " + "were not established after waiting/retrying for " + maxWaitTimeSeconds + " second(s)"));
        }
    }

    @Then(value="^the visible network of \"([^\"]*)\" should (consist of|contain) \"([^\"]*)\"$")
    public void thenTheVisibleNetworkOfShouldConsistOf(String instanceId, String testType, String listOfExpectedVisibleInstances) throws Throwable {
        List<String> expectedVisibleInstances = this.parseInstanceList(listOfExpectedVisibleInstances);
        String commandOutput = this.executeCommandOnInstance(this.resolveInstance(instanceId), "net info", false);
        for (String expectedInstanceId : expectedVisibleInstances) {
            if (commandOutput.contains(expectedInstanceId)) continue;
            Assert.fail((String)("The visible network of instance " + instanceId + " does not contain the expected instance " + expectedInstanceId));
        }
        this.printToCommandConsole("Verified the visible network of instance \"" + instanceId + "\"");
        if ("consist of".equals(testType)) {
            this.printToCommandConsole("  Note: the full 'should consist of' syntax is not implemented yet and was tested as 'should contain' instead");
        }
    }

    @When(value="^executing (?:the )?command \"([^\"]*)\" on (?:instance )?\"([^\"]*)\"$")
    public void whenExecutingCommandOnSingleInstance(String commandString, String instanceId) throws Throwable {
        ManagedInstance instance = this.resolveInstance(instanceId);
        String commandOutput = this.executeCommandOnInstance(instance, commandString, true);
        instance.setLastCommandOutput(commandOutput);
        this.lastInstanceWithSingleCommandExecution = instance;
    }

    @When(value="^executing command \"([^\"]*)\" on all instances$")
    public void whenExecutingCommandOnAllInstances(String commandString) throws Throwable {
        for (ManagedInstance instance : this.enabledInstances) {
            this.executeCommandOnInstance(instance, commandString, true);
        }
        this.lastInstanceWithSingleCommandExecution = null;
    }

    @Then(value="^the (?:last )?output should (not )?contain (the pattern )?\"([^\"]*)\"$")
    public void thenTheLastOutputShouldContain(String negationFlag, String useRegexpMarker, String substring) throws Throwable {
        this.assertPropertyOfLastCommandOutput(this.lastInstanceWithSingleCommandExecution, negationFlag, useRegexpMarker, substring);
    }

    @Then(value="^the (?:last )?output of \"([^\"]*)\" should (not )?contain (the pattern )?\"([^\"]*)\"$")
    public void thenTheLastOutputOfInstanceShouldContain(String instanceId, String negationFlag, String useRegexpMarker, String substring) throws Throwable {
        ManagedInstance instance = this.resolveInstance(instanceId);
        this.assertPropertyOfLastCommandOutput(instance, negationFlag, useRegexpMarker, substring);
    }

    @Then(value="^the (?:last )?output of each instance should (not )?contain (the pattern )?\"([^\"]*)\"$")
    public void thenTheLastOutputOfEachInstanceShouldContain(String negationFlag, String useRegexpMarker, String substring) throws Throwable {
        for (ManagedInstance instance : this.enabledInstances) {
            this.assertPropertyOfLastCommandOutput(instance, negationFlag, useRegexpMarker, substring);
        }
    }

    @Then(value="^instance \"([^\"]*)\" should see these components:$")
    public void thenTheVisibleComponentsOfAnInstanceShouldBe(String instanceId, DataTable componentsTable) throws Throwable {
        ManagedInstance instance = this.resolveInstance(instanceId);
        HashMap<String, ComponentVisibilityState> visibilityMap = new HashMap<String, ComponentVisibilityState>();
        for (List criteriaRow : componentsTable.cells(0)) {
            String argNodeName = (String)criteriaRow.get(0);
            String argCompName = (String)criteriaRow.get(1);
            String expectedState = (String)criteriaRow.get(2);
            String mapKey = String.valueOf(argNodeName) + "/" + argCompName;
            ComponentVisibilityState entry = new ComponentVisibilityState(argCompName, argNodeName, expectedState, null);
            visibilityMap.put(mapKey, entry);
            this.log.debug((Object)("Parsed component expectation: " + entry));
        }
        String output = this.executeCommandOnInstance(instance, "components list --as-table --auth", false);
        String[] stringArray = output.split("\n");
        int argCompName = stringArray.length;
        int argNodeName = 0;
        while (argNodeName < argCompName) {
            String trimmedLine;
            String line = stringArray[argNodeName];
            if (!line.startsWith("Finished executing command") && !(trimmedLine = line.trim()).isEmpty()) {
                String[] lineParts = trimmedLine.split("\\|");
                if (lineParts.length != 6) {
                    this.log.error((Object)("Ignoring output line with unexpected number of elements: " + line));
                } else {
                    String componentRefName = lineParts[2];
                    String nodeName = lineParts[0];
                    String actualState = lineParts[5];
                    String mapKey = String.valueOf(nodeName) + "/" + componentRefName;
                    ComponentVisibilityState existing = (ComponentVisibilityState)visibilityMap.get(mapKey);
                    if (existing != null) {
                        existing.setActualState(actualState);
                    }
                }
            }
            ++argNodeName;
        }
        boolean hasMismatch = false;
        StringBuilder errorLines = new StringBuilder();
        for (ComponentVisibilityState entry : visibilityMap.values()) {
            if (entry.stateMatches()) continue;
            String errorLine = "  Unexpected component state: " + entry;
            errorLines.append("\n");
            errorLines.append(errorLine);
            this.printToCommandConsole(errorLine);
            hasMismatch = true;
        }
        if (hasMismatch) {
            Assert.fail((String)("At least one component had an unexpected visibility/authorization state: " + errorLines.toString()));
        }
    }

    @Then(value="^the ([^\"]+) file[s]? of (all instances) should (not )?contain \"([^\"]+)\"$")
    public void thenTheFilesOfInstancesShouldOrShouldNotContain(String relativeFilePath, String instances, String notFlag, String substring) throws Throwable {
        for (ManagedInstance instance : this.enabledInstances) {
            this.assertTheProfileRelativeFileOfInstanceContains(instance, relativeFilePath, substring);
        }
    }

    @Then(value="^the ([^\"]+) file[s]? of (all instances) should be absent or empty$")
    public void thenTheFilesOfInstancesShouldNotExistOrBeEmpty(String relativeFilePath, String instances) throws Throwable {
        for (ManagedInstance instance : this.enabledInstances) {
            this.assertTheProfileRelativeFileOfInstanceIsMissingOrEmpty(instance, relativeFilePath);
        }
    }

    @Then(value="^the log output of (all instances) should indicate a clean shutdown with no unexpected warnings or errors$")
    public void thenTheLogOutputShouldIndicateACleanShutdown(String instances) throws Throwable {
        for (ManagedInstance instance : this.enabledInstances) {
            this.assertTheProfileRelativeFileOfInstanceIsMissingOrEmpty(instance, WARNINGS_LOG_FILE_NAME);
            this.assertTheProfileRelativeFileOfInstanceContains(instance, DEBUG_LOG_FILE_NAME, "Known unfinished operations on shutdown: <none>");
            this.assertTheProfileRelativeFileOfInstanceContains(instance, DEBUG_LOG_FILE_NAME, "Main application shutdown complete, exit code: 0");
        }
    }

    @Then(value="^the log output of \"([^\"]*)\" should (not )?contain (the pattern )?\"([^\"]*)\"$")
    public void thenTheLogOutputShouldOrShouldNotContain(String instanceId, String negationFlag, String useRegexpMarker, String substring) throws Throwable {
        ManagedInstance instance = this.resolveInstance(instanceId);
        String fileContent = instance.getProfileRelativeFileContent(DEBUG_LOG_FILE_NAME, false);
        if (fileContent == null || fileContent.isEmpty()) {
            Assert.fail((String)StringUtils.format((String)"The expected file \"%s\" in profile \"%s\" does not exist or is empty", (Object[])new Object[]{DEBUG_LOG_FILE_NAME, instance}));
        }
        this.assertPropertyOfTextOutput(instance, negationFlag, useRegexpMarker, substring, fileContent, "debug.log content");
    }

    @When(value="^waiting for (\\d+) second[s]?$")
    public void whenWaitingForSeconds(int secondsToWait) throws Throwable {
        this.printToCommandConsole("Waiting for " + secondsToWait + " seconds(s)...");
        Thread.sleep(TimeUnit.SECONDS.toMillis(secondsToWait));
    }

    private void startSingleInstance(ManagedInstance instance, boolean withGUI) throws IOException {
        instance.onStarting();
        String installationId = instance.getInstallationId();
        this.printToCommandConsole(StringUtils.format((String)"Launching instance \"%s\" using installation \"%s\"", (Object[])new Object[]{instance, installationId}));
        this.instanceManagementService.startInstance(installationId, this.listOfSingleStringElement(instance.getId()), (TextOutputReceiver)this.getTextoutReceiverForIMOperations(), 30000L, withGUI);
    }

    private void stopSingleInstance(ManagedInstance instance) throws IOException {
        this.printToCommandConsole(StringUtils.format((String)"Stopping instance \"%s\"", (Object[])new Object[]{instance}));
        this.instanceManagementService.stopInstance(this.listOfSingleStringElement(instance.getId()), (TextOutputReceiver)this.getTextoutReceiverForIMOperations(), 30000L);
        instance.onStopped();
    }

    private void cycleAllOutgoingConnectionsOf(ManagedInstance instance) {
        String cnListOutput = this.executeCommandOnInstance(instance, "cn list", false);
        Pattern connectionIdPattern = Pattern.compile("^\\s*\\((\\d+)\\) ");
        Matcher matcher = connectionIdPattern.matcher(cnListOutput);
        int count = 0;
        while (matcher.find()) {
            ++count;
            String connectionIndex = matcher.group(1);
            this.executeCommandOnInstance(instance, "cn stop " + connectionIndex, false);
            this.executeCommandOnInstance(instance, "cn start " + connectionIndex, false);
        }
        if (count == 0) {
            this.printToCommandConsole("  WARNING: Attempted to stop and restart all outgoing connections of " + instance.getId() + ", but no connections were found");
        } else {
            this.printToCommandConsole("  Stopped and restarted " + count + " outgoing connection(s) of " + instance.getId());
        }
    }

    private void executeRunnablesGroupAndHandlePotentialErrors(RunnablesGroup runnablesGroup, String singleTaskDescription) {
        List exceptions = runnablesGroup.executeParallel();
        boolean hasFailure = false;
        for (RuntimeException e : exceptions) {
            if (e == null) continue;
            this.log.warn((Object)("Exception while asynchronously " + singleTaskDescription), (Throwable)e);
            hasFailure = true;
        }
        if (hasFailure) {
            for (RuntimeException e : exceptions) {
                if (e == null) continue;
                throw e;
            }
        }
    }

    private void assertPropertyOfLastCommandOutput(ManagedInstance instance, String negationFlag, String useRegexpMarker, String substring) {
        this.assertPropertyOfTextOutput(instance, negationFlag, useRegexpMarker, substring, instance.getLastCommandOutput(), "command output");
    }

    private void assertTheProfileRelativeFileOfInstanceContains(ManagedInstance instance, String relativeFilePath, String substring) throws IOException {
        String fileContent = instance.getProfileRelativeFileContent(relativeFilePath, false);
        if (fileContent == null) {
            Assert.fail((String)StringUtils.format((String)"The expected file \"%s\" in profile \"%s\" does not exist", (Object[])new Object[]{relativeFilePath, instance, substring}));
        } else if (!fileContent.contains(substring)) {
            Assert.fail((String)StringUtils.format((String)"The content of the file \"%s\" in profile \"%s\" did not contain \"%s\"", (Object[])new Object[]{relativeFilePath, instance, substring}));
        } else {
            this.printToCommandConsole(StringUtils.format((String)"  The file \"%s\" in profile \"%s\" contained the expected text \"%s\"", (Object[])new Object[]{relativeFilePath, instance, substring}));
        }
    }

    private void assertTheProfileRelativeFileOfInstanceIsMissingOrEmpty(ManagedInstance instance, String relativeFilePath) throws IOException {
        String fileContent = instance.getProfileRelativeFileContent(relativeFilePath, false);
        if (fileContent == null) {
            this.printToCommandConsole(StringUtils.format((String)"  The file \"%s\" in profile \"%s\" is absent as expected", (Object[])new Object[]{relativeFilePath, instance}));
        } else if (fileContent.isEmpty()) {
            this.printToCommandConsole(StringUtils.format((String)"  The file \"%s\" in profile \"%s\" is empty as expected", (Object[])new Object[]{relativeFilePath, instance}));
        } else {
            Assert.fail((String)StringUtils.format((String)"The file \"%s\" in profile \"%s\" should have been absent or empty, but exists (content size: %d characters); full file content:\n%s", (Object[])new Object[]{relativeFilePath, instance, fileContent.length(), fileContent}));
        }
    }

    private boolean testIfConfiguredOutgoingConnectionsAreConnected(ManagedInstance instance, boolean isFinalAttempt) {
        List<String> connectionIds = instance.accessConfiguredAutostartConnectionIds();
        String commandOutput = this.executeCommandOnInstance(instance, "cn list", false);
        int matches = 0;
        for (String connectionId : connectionIds) {
            Matcher matcher = Pattern.compile("'" + connectionId + "'.*?- (\\w+)").matcher(commandOutput);
            if (!matcher.find()) {
                if (!isFinalAttempt) continue;
                Assert.fail((String)StringUtils.format((String)"Unexpected state: Attempted to verify the state of connection \"%s\" on \"%s\", but it did not appear in the output of \"cn list\" at all; full command output:\n%s", (Object[])new Object[]{connectionId, instance, commandOutput}));
            }
            String state = matcher.group(1);
            if (matcher.find()) {
                Assert.fail((String)StringUtils.format((String)"Unexpected state: Found more than one entry for connection \"%s\" on \"%s\" in the output of \"cn list\"; full command output:\n%s", (Object[])new Object[]{connectionId, instance, commandOutput}));
            }
            if ("CONNECTED".equals(state)) {
                ++matches;
                continue;
            }
            if (!isFinalAttempt) continue;
            this.printToCommandConsole(StringUtils.format((String)"Failed expectation: the connection \"%s\" on \"%s\" should be in state \"CONNECTED\", but is \"%s\"", (Object[])new Object[]{connectionId, instance, state}));
        }
        boolean success = matches == connectionIds.size();
        return success;
    }

    private void tearDownLeftoverRunningInstances() {
        String instanceId;
        for (ManagedInstance instance : this.enabledInstances) {
            instanceId = instance.getId();
            try {
                if (!this.instanceManagementService.isInstanceRunning(instanceId)) continue;
                this.printToCommandConsole(StringUtils.format((String)"Stopping instance \"%s\" after test scenario \"%s\"", (Object[])new Object[]{instanceId, this.executionContext.getScenarioName()}));
                this.instanceManagementService.stopInstance(this.listOfSingleStringElement(instanceId), (TextOutputReceiver)this.getTextoutReceiverForIMOperations(), 30000L);
            }
            catch (IOException e) {
                this.printToCommandConsole("Error shutting down instance " + instanceId + ": " + e.toString());
            }
        }
        for (ManagedInstance instance : this.enabledInstances) {
            instanceId = instance.getId();
            try {
                if (!this.instanceManagementService.isInstanceRunning(instanceId)) continue;
                Assert.fail((String)StringUtils.format((String)"Instance \"%s\" is still detected as \"running\" after the post-test shutdown for scenario \"%s\"", (Object[])new Object[]{instanceId, this.executionContext.getScenarioName()}));
            }
            catch (IOException e) {
                this.printToCommandConsole("Error verifying shutdown state of instance " + instanceId + ": " + e.toString());
            }
        }
    }

    private List<String> listOfSingleStringElement(String element) {
        ArrayList<String> singleInstanceList = new ArrayList<String>();
        singleInstanceList.add(element);
        return singleInstanceList;
    }

    private String deriveImplicitInstallationIdFromBuildId(String buildId) {
        return buildId.replaceAll("[^\\w]", "_");
    }

    private PrefixingTextOutForwarder getTextoutReceiverForIMOperations() {
        return new PrefixingTextOutForwarder("  (IM output) ", this.outputReceiver);
    }

    private ManagedInstance[] detachedIterableCopy(Collection<ManagedInstance> pendingInstances) {
        return pendingInstances.toArray(EMPTY_INSTANCE_ARRAY);
    }

    private class ComponentVisibilityState {
        private String componentName;
        private String nodeName;
        private String expectedState;
        private String actualState;

        ComponentVisibilityState(String componentName, String nodeName, String expectedState, String actualState) {
            this.componentName = componentName;
            this.nodeName = nodeName;
            this.setExpectedState(expectedState);
            this.setActualState(actualState);
        }

        public void setExpectedState(String expectedState) {
            this.expectedState = Optional.ofNullable(expectedState).orElse(InstanceManagementStepDefinitions.ABSENT_COMPONENT_STRING);
        }

        public void setActualState(String actualState) {
            this.actualState = Optional.ofNullable(actualState).orElse(InstanceManagementStepDefinitions.ABSENT_COMPONENT_STRING);
        }

        public boolean stateMatches() {
            return this.expectedState.equals(this.actualState);
        }

        public String toString() {
            return StringUtils.format((String)"%s | %s | expected: %s | found: %s", (Object[])new Object[]{this.nodeName, this.componentName, this.expectedState, this.actualState});
        }
    }
}

