/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.toolintegration;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.integration.ToolIntegrationConstants;
import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.integration.ToolIntegrationService;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.gui.wizards.toolintegration.ChooseConfigurationPage;
import de.rcenvironment.core.gui.wizards.toolintegration.InOutputConfigurationPage;
import de.rcenvironment.core.gui.wizards.toolintegration.Messages;
import de.rcenvironment.core.gui.wizards.toolintegration.PropertyConfigurationPage;
import de.rcenvironment.core.gui.wizards.toolintegration.ScriptConfigurationPage;
import de.rcenvironment.core.gui.wizards.toolintegration.ToolCharacteristicsPage;
import de.rcenvironment.core.gui.wizards.toolintegration.ToolConfigurationPage;
import de.rcenvironment.core.gui.wizards.toolintegration.api.IntegrationWizardPageContributor;
import de.rcenvironment.core.gui.wizards.toolintegration.api.IntegrationWizardPageContributorRegistry;
import de.rcenvironment.core.gui.wizards.toolintegration.api.ToolIntegrationWizardPage;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ToolIntegrationWizard
extends Wizard {
    protected static ToolIntegrationService integrationService;
    private static final int MINIMUM_HEIGHT = 700;
    private static final int MINIMUM_WIDTH = 500;
    private static final Log LOGGER;
    protected ToolIntegrationContextRegistry integrationContextRegistry;
    private Map<String, Object> configurationMap;
    private ToolCharacteristicsPage characteristicsPage;
    private InOutputConfigurationPage inOutputPage;
    private PropertyConfigurationPage propertyPage;
    private ToolConfigurationPage toolPage;
    private ScriptConfigurationPage scriptPage;
    private final ServiceRegistryAccess serviceRegistryAccess;
    private ChooseConfigurationPage editConfigurationPage;
    private ToolIntegrationContext integrationContext;
    private final String wizardType;
    private String integrationType;
    private final Map<String, List<ToolIntegrationWizardPage>> additionalPages = new HashMap<String, List<ToolIntegrationWizardPage>>();
    private List<ToolIntegrationWizardPage> currentAdditionalPages = null;
    private Map<String, Object> previousConfiguration;
    private File toolDocuTarget;
    private File iconTarget;

    static {
        LOGGER = LogFactory.getLog(ToolIntegrationWizard.class);
    }

    public ToolIntegrationWizard(boolean progressMonitor, String type) {
        this.setNeedsProgressMonitor(progressMonitor);
        this.configurationMap = new HashMap<String, Object>();
        this.configurationMap.put("integrationType", "Common");
        this.setWindowTitle(Messages.wizardTitle);
        this.serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        integrationService = (ToolIntegrationService)this.serviceRegistryAccess.getService(ToolIntegrationService.class);
        this.integrationContextRegistry = (ToolIntegrationContextRegistry)this.serviceRegistryAccess.getService(ToolIntegrationContextRegistry.class);
        TrayDialog.setDialogHelpAvailable((boolean)true);
        this.wizardType = type;
    }

    public void addPages() {
        LinkedList<String> toolNames = new LinkedList<String>();
        for (String id : integrationService.getIntegratedComponentIds()) {
            toolNames.add(integrationService.getToolConfiguration(id).get("toolName").toString());
        }
        ArrayList<String> groupNames = new ArrayList<String>();
        LogicalNodeId localNode = ((PlatformService)this.serviceRegistryAccess.getService(PlatformService.class)).getLocalDefaultLogicalNodeId();
        Collection installations = this.getInitialComponentKnowledge().getAllInstallations();
        installations = ComponentUtils.eliminateComponentInterfaceDuplicates((Collection)installations, (LogicalNodeId)localNode);
        for (DistributedComponentEntry ci : installations) {
            ComponentInterface componentInterface = ci.getComponentInterface();
            String groupName = componentInterface.getGroupName();
            if (groupName.startsWith("_") || groupNames.contains(groupName)) continue;
            groupNames.add(groupName);
        }
        Collections.sort(groupNames, String.CASE_INSENSITIVE_ORDER);
        this.editConfigurationPage = new ChooseConfigurationPage(Messages.chooseConfigPageTitle, this.integrationContextRegistry.getAllIntegrationContexts(), this, this.wizardType);
        this.characteristicsPage = new ToolCharacteristicsPage(Messages.firstToolIntegrationPageTitle, this.configurationMap, toolNames, groupNames);
        this.inOutputPage = new InOutputConfigurationPage(Messages.inOuputPage, this.configurationMap);
        this.propertyPage = new PropertyConfigurationPage(Messages.propertyPage, this.configurationMap);
        this.toolPage = new ToolConfigurationPage(Messages.toolPage, this.configurationMap);
        this.scriptPage = new ScriptConfigurationPage(Messages.scriptPage, this.configurationMap);
        this.addPage((IWizardPage)this.editConfigurationPage);
        this.addPage((IWizardPage)this.characteristicsPage);
        this.addPage((IWizardPage)this.inOutputPage);
        this.addPage((IWizardPage)this.propertyPage);
        this.addPage((IWizardPage)this.toolPage);
        this.addPage((IWizardPage)this.scriptPage);
        this.getShell().setMinimumSize(500, 700);
        IntegrationWizardPageContributorRegistry contributorRegistry = (IntegrationWizardPageContributorRegistry)this.serviceRegistryAccess.getService(IntegrationWizardPageContributorRegistry.class);
        for (IntegrationWizardPageContributor contributor : contributorRegistry.getAllContributors()) {
            List<ToolIntegrationWizardPage> pages = contributor.getAdditionalPagesList(this.configurationMap);
            this.additionalPages.put(contributor.getType(), pages);
            for (ToolIntegrationWizardPage page : pages) {
                this.addPage((IWizardPage)page);
            }
        }
    }

    private DistributedComponentKnowledge getInitialComponentKnowledge() {
        DistributedComponentKnowledgeService registry = (DistributedComponentKnowledgeService)this.serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class);
        return registry.getCurrentSnapshot();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        ScriptConfigurationPage nextPage = null;
        if (this.currentAdditionalPages == null) {
            if (page.equals((Object)this.toolPage)) {
                nextPage = this.scriptPage;
            } else {
                if (page.equals((Object)this.scriptPage)) {
                    for (List<ToolIntegrationWizardPage> addPages : this.additionalPages.values()) {
                        for (ToolIntegrationWizardPage addPage : addPages) {
                            addPage.setPageComplete(true);
                        }
                    }
                    return null;
                }
                nextPage = super.getNextPage(page);
            }
        } else if (page.equals((Object)this.toolPage)) {
            nextPage = (IWizardPage)this.currentAdditionalPages.get(0);
        } else if (this.currentAdditionalPages.contains(page) && this.currentAdditionalPages.indexOf(page) < this.currentAdditionalPages.size() - 1) {
            nextPage = (IWizardPage)this.currentAdditionalPages.get(this.currentAdditionalPages.indexOf(page) + 1);
        } else if (this.currentAdditionalPages.contains(page) && this.currentAdditionalPages.indexOf(page) == this.currentAdditionalPages.size() - 1) {
            nextPage = this.scriptPage;
        } else {
            if (page.equals((Object)this.scriptPage)) {
                return null;
            }
            nextPage = super.getNextPage(page);
        }
        if (nextPage != null) {
            ((ToolIntegrationWizardPage)nextPage).updatePage();
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        ToolIntegrationWizardPage previousPage = null;
        if (this.currentAdditionalPages == null) {
            previousPage = page.equals((Object)this.scriptPage) ? this.toolPage : super.getPreviousPage(page);
        } else if (page.equals((Object)this.scriptPage)) {
            previousPage = (IWizardPage)this.currentAdditionalPages.get(this.currentAdditionalPages.size() - 1);
        } else if (this.currentAdditionalPages.contains(page) && this.currentAdditionalPages.indexOf(page) > 0) {
            previousPage = (IWizardPage)this.currentAdditionalPages.get(this.currentAdditionalPages.indexOf(page) - 1);
        } else if (this.currentAdditionalPages.contains(page) && this.currentAdditionalPages.indexOf(page) == 0) {
            previousPage = this.scriptPage;
        } else {
            if (page.equals((Object)this.editConfigurationPage)) {
                return null;
            }
            previousPage = super.getPreviousPage(page);
        }
        if (previousPage != null) {
            ((ToolIntegrationWizardPage)previousPage).updatePage();
        }
        return previousPage;
    }

    public boolean performFinish() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String integrationJobTitle = StringUtils.format((String)Messages.integrateToolJobTitle, (Object[])new Object[]{this.configurationMap.get("toolName")});
        new ToolIntegrationJob(integrationJobTitle, shell).schedule();
        return this.isConfigurationOk();
    }

    public boolean isConfigurationOk() {
        if (this.configurationMap == null || this.configurationMap.isEmpty()) {
            return false;
        }
        if (this.configurationMap.get("launchSettings") == null) {
            return false;
        }
        return this.configurationMap.get("toolName") != null;
    }

    private void determineIntegrationContext() {
        if (this.configurationMap.get("integrationType") != null) {
            for (ToolIntegrationContext context : this.integrationContextRegistry.getAllIntegrationContexts()) {
                if (!context.getContextType().equalsIgnoreCase(this.configurationMap.get("integrationType").toString())) continue;
                this.integrationContext = context;
            }
        } else {
            this.integrationContext = this.integrationContextRegistry.getToolIntegrationContextById(ToolIntegrationConstants.COMMON_TOOL_INTEGRATION_CONTEXT_UID);
        }
        if (this.integrationContext == null) {
            LOGGER.error((Object)("Found no integration context for integration type " + this.configurationMap.get("integrationType")));
        }
    }

    public void performSaveAs(String folderPath) {
        this.determineIntegrationContext();
        File toolConfigFile = new File(folderPath, String.valueOf(this.integrationContext.getNameOfToolIntegrationDirectory()) + File.separator + this.integrationContext.getToolDirectoryPrefix() + this.configurationMap.get("toolName"));
        try {
            integrationService.writeToolIntegrationFileToSpecifiedFolder(folderPath, this.configurationMap, this.integrationContext);
            MessageBox infoDialog = new MessageBox(this.getShell(), 34);
            if (toolConfigFile.exists()) {
                infoDialog.setText("Tool saved");
                infoDialog.setMessage(StringUtils.format((String)("Successfully saved tool: %s\nLocation: " + toolConfigFile.getAbsolutePath()), (Object[])new Object[]{this.configurationMap.get("toolName")}));
            } else {
                infoDialog.setText("Saving failed");
                infoDialog.setMessage(StringUtils.format((String)("Could not save tool: %s\nLocation tried: " + toolConfigFile.getAbsolutePath()), (Object[])new Object[]{this.configurationMap.get("toolName")}));
            }
            infoDialog.open();
        }
        catch (IOException e) {
            MessageBox errorDialog = new MessageBox(this.getShell(), 33);
            errorDialog.setText("Saving failed");
            errorDialog.setMessage(StringUtils.format((String)("Failed to save tool configuration to: " + toolConfigFile.getAbsolutePath() + "\nCause: " + e.getMessage()), (Object[])new Object[]{this.configurationMap.get("toolName")}));
            errorDialog.open();
        }
    }

    protected void bindIntegrationService(ToolIntegrationService newIntegrationService) {
        integrationService = newIntegrationService;
    }

    protected void bindIntegrationInformationRegistry(ToolIntegrationContextRegistry incIntegrationInformationRegistry) {
        this.integrationContextRegistry = incIntegrationInformationRegistry;
    }

    public void setConfigurationMap(Map<String, Object> newConfigurationMap) {
        this.configurationMap = newConfigurationMap;
        this.determineIntegrationContext();
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            ((ToolIntegrationWizardPage)page).setConfigMap(this.configurationMap);
            ++n2;
        }
    }

    public void setPreviousConfiguration(Map<String, Object> newPreviousConfiguration, File configJson) {
        HashMap<String, Object> configurationMapCopy = new HashMap<String, Object>();
        this.previousConfiguration = new HashMap<String, Object>(newPreviousConfiguration);
        if (newPreviousConfiguration != null) {
            configurationMapCopy.putAll(newPreviousConfiguration);
        }
        this.setConfigurationMap(configurationMapCopy);
        if (configJson != null) {
            if (newPreviousConfiguration != null && newPreviousConfiguration.get("integrationType") != null) {
                for (ToolIntegrationContext context : this.integrationContextRegistry.getAllIntegrationContexts()) {
                    if (!newPreviousConfiguration.get("integrationType").toString().equalsIgnoreCase(context.getContextType())) continue;
                    this.integrationContext = context;
                }
            } else {
                this.integrationContext = this.integrationContextRegistry.getToolIntegrationContextById(ToolIntegrationConstants.COMMON_TOOL_INTEGRATION_CONTEXT_UID);
            }
        }
        this.updateAllPages();
        for (Map.Entry<String, List<ToolIntegrationWizardPage>> addPages : this.additionalPages.entrySet()) {
            if (newPreviousConfiguration == null || addPages.getKey().equals(newPreviousConfiguration.get("integrationType"))) continue;
            for (ToolIntegrationWizardPage page : addPages.getValue()) {
                page.setPageComplete(true);
            }
        }
    }

    public void updateAllPages() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            boolean isAdditionalPage = false;
            for (Collection collection : this.additionalPages.values()) {
                if (!collection.contains(page)) continue;
                isAdditionalPage = true;
            }
            if (!isAdditionalPage || this.currentAdditionalPages != null && this.currentAdditionalPages.contains(page)) {
                ((ToolIntegrationWizardPage)page).updatePage();
            }
            ++n2;
        }
        this.getContainer().updateButtons();
    }

    public void removeOldIntegration() {
        File docDir;
        integrationService.setFileWatcherActive(false);
        String previousToolName = "";
        String toolName = (String)this.configurationMap.get("toolName");
        File previousToolDir = null;
        if (this.previousConfiguration != null) {
            previousToolName = (String)this.previousConfiguration.get("toolName");
            previousToolDir = new File(new File(this.integrationContext.getRootPathToToolIntegrationDirectory(), this.integrationContext.getNameOfToolIntegrationDirectory()), previousToolName);
        } else {
            previousToolName = toolName;
        }
        if (previousToolDir != null) {
            this.storeIconAndDocuInTempDir(previousToolDir);
        }
        integrationService.unregisterIntegration(previousToolName, this.integrationContext);
        integrationService.removeTool(previousToolName, this.integrationContext);
        if (!previousToolName.equals(toolName)) {
            File delete = previousToolDir;
            try {
                FileUtils.forceDelete((File)delete);
            }
            catch (IOException e) {
                LogFactory.getLog(ToolIntegrationWizard.class).error((Object)e);
            }
        } else if ((this.configurationMap.get("documentationFilePath") == null || ((String)this.configurationMap.get("documentationFilePath")).isEmpty()) && (docDir = new File(previousToolDir, "docs")).listFiles() != null) {
            File[] fileArray = docDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                try {
                    FileUtils.forceDelete((File)f);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Could not delete file in tool docs directory: ", (Throwable)e);
                }
                ++n2;
            }
        }
        integrationService.setFileWatcherActive(true);
    }

    private void storeIconAndDocuInTempDir(File previousToolDir) {
        try {
            File tempToolDir = TempFileServiceAccess.getInstance().createManagedTempDir();
            this.toolDocuTarget = null;
            if (new File(previousToolDir, "docs").exists()) {
                this.toolDocuTarget = new File(tempToolDir, "docs");
                FileUtils.copyDirectory((File)new File(previousToolDir, "docs"), (File)this.toolDocuTarget);
            }
            this.iconTarget = null;
            String iconPath = (String)this.previousConfiguration.get("toolIconPath");
            if (iconPath != null && !iconPath.isEmpty() && !new File(iconPath).isAbsolute() && new File(previousToolDir, iconPath).exists()) {
                this.iconTarget = new File(tempToolDir, iconPath);
                FileUtils.copyFile((File)new File(previousToolDir, iconPath), (File)this.iconTarget);
            }
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Could not create temporiary tool dir.", (Throwable)e);
        }
    }

    public String getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(String incIntegrationType, boolean template) {
        this.integrationType = incIntegrationType;
        this.determineIntegrationContext();
    }

    public void removeAdditionalPages() {
        this.currentAdditionalPages = null;
    }

    public void setAdditionalPages(String contextType) {
        this.currentAdditionalPages = this.additionalPages.get(contextType);
    }

    public Map<String, Object> getConfigurationMap() {
        return this.configurationMap;
    }

    public ToolIntegrationContext getCurrentContext() {
        if (this.integrationContext == null) {
            return this.integrationContextRegistry.getToolIntegrationContextById(ToolIntegrationConstants.COMMON_TOOL_INTEGRATION_CONTEXT_UID);
        }
        return this.integrationContext;
    }

    public void open() {
        this.editConfigurationPage.updatePage();
    }

    private final class ToolIntegrationJob
    extends Job {
        private final Shell shell;

        private ToolIntegrationJob(String name, Shell shell) {
            super(name);
            this.shell = shell;
        }

        protected IStatus run(IProgressMonitor monitor) {
            DistributedComponentKnowledge componentKnowledge;
            boolean existingComponentEntryPublished;
            File docsDir;
            if (!ToolIntegrationWizard.this.isConfigurationOk()) {
                return Status.CANCEL_STATUS;
            }
            ToolIntegrationWizard.this.determineIntegrationContext();
            integrationService.setFileWatcherActive(false);
            ToolIntegrationWizard.this.configurationMap.put("isActive", true);
            this.handleIcon();
            File toolPath = new File(new File(new File(ToolIntegrationWizard.this.integrationContext.getRootPathToToolIntegrationDirectory(), ToolIntegrationWizard.this.integrationContext.getNameOfToolIntegrationDirectory()), ToolIntegrationWizard.this.integrationContext.getToolDirectoryPrefix()), (String)ToolIntegrationWizard.this.configurationMap.get("toolName"));
            if (ToolIntegrationWizard.this.toolDocuTarget != null && ToolIntegrationWizard.this.configurationMap.get("documentationFilePath") != null && !((String)ToolIntegrationWizard.this.configurationMap.get("documentationFilePath")).isEmpty()) {
                try {
                    FileUtils.copyDirectory((File)ToolIntegrationWizard.this.toolDocuTarget, (File)new File(toolPath, "docs"));
                    TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(ToolIntegrationWizard.this.toolDocuTarget);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Could not copy icon from temporary tool directory.", (Throwable)e);
                }
            }
            if ((ToolIntegrationWizard.this.configurationMap.get("documentationFilePath") == null || ((String)ToolIntegrationWizard.this.configurationMap.get("documentationFilePath")).isEmpty()) && (docsDir = new File(toolPath, "docs")).exists()) {
                FileUtils.deleteQuietly((File)docsDir);
            }
            try {
                integrationService.writeToolIntegrationFile(ToolIntegrationWizard.this.configurationMap, ToolIntegrationWizard.this.integrationContext);
            }
            catch (IOException iOException) {
                return Status.CANCEL_STATUS;
            }
            if (!integrationService.isToolIntegrated(ToolIntegrationWizard.this.configurationMap, ToolIntegrationWizard.this.integrationContext)) {
                integrationService.integrateTool(ToolIntegrationWizard.this.configurationMap, ToolIntegrationWizard.this.integrationContext);
            }
            if (existingComponentEntryPublished = (componentKnowledge = ToolIntegrationWizard.this.getInitialComponentKnowledge()).getAllLocalInstallations().stream().filter(entry -> {
                String toolName = (String)ToolIntegrationWizard.this.configurationMap.get("toolName");
                return entry.getComponentInterface().getDisplayName().equals(toolName);
            }).anyMatch(entry -> entry.getType().isRemotelyAccessible())) {
                new UIJob("Show user warning for existing publication entries"){

                    public IStatus runInUIThread(IProgressMonitor arg0) {
                        MessageBox infoDialog = new MessageBox(ToolIntegrationJob.this.shell, 34);
                        infoDialog.setText("Tool updated");
                        infoDialog.setMessage(StringUtils.format((String)"The tool \"%s\" is published due to existing publication entries. Please check the publication settings in the view \"Component Publishing\"", (Object[])new Object[]{ToolIntegrationWizard.this.configurationMap.get("toolName")}));
                        infoDialog.open();
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            integrationService.setFileWatcherActive(true);
            integrationService.registerRecursive((String)ToolIntegrationWizard.this.configurationMap.get("toolName"), ToolIntegrationWizard.this.integrationContext);
            return Status.OK_STATUS;
        }

        private void handleIcon() {
            File icon;
            if (ToolIntegrationWizard.this.configurationMap.get("toolIconPath") != null && !(icon = new File((String)ToolIntegrationWizard.this.configurationMap.get("toolIconPath"))).isAbsolute() && ToolIntegrationWizard.this.iconTarget != null) {
                File toolConfigFile = new File(ToolIntegrationWizard.this.integrationContext.getRootPathToToolIntegrationDirectory(), String.valueOf(ToolIntegrationWizard.this.integrationContext.getNameOfToolIntegrationDirectory()) + File.separator + ToolIntegrationWizard.this.integrationContext.getToolDirectoryPrefix() + ToolIntegrationWizard.this.configurationMap.get("toolName"));
                icon = new File(toolConfigFile, icon.getName());
                try {
                    FileUtils.copyFile((File)ToolIntegrationWizard.this.iconTarget, (File)icon);
                    TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(ToolIntegrationWizard.this.iconTarget);
                    icon = new File(icon.getName());
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Could not copy icon from temporary tool directory.", (Throwable)e);
                }
            }
        }
    }
}

