/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.model;

import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSGraphLoop;
import de.rcenvironment.supplemental.cmdows.importer.model.CMDOWSProblemFormulation;
import de.rcenvironment.supplemental.cmdows.importer.model.SchemaHeader;
import de.rcenvironment.supplemental.cmdows.importer.model.WorkflowSchemaModel;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameter;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameterType;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class CMDOWSDataModel
implements WorkflowSchemaModel {
    private final Map<String, SchemaGraphNode<ExecutableBlock>> processGraph = new HashMap<String, SchemaGraphNode<ExecutableBlock>>();
    private final List<CMDOWSGraphLoop> processGraphLoops = new LinkedList<CMDOWSGraphLoop>();
    private final Map<String, SchemaGraphNode<Object>> dataGraph = new HashMap<String, SchemaGraphNode<Object>>();
    private Map<SchemaDesignParameterType, Set<SchemaDesignParameter>> paramPool = new HashMap<SchemaDesignParameterType, Set<SchemaDesignParameter>>();
    private String workflowName = "default";
    private SchemaHeader header;
    private CMDOWSProblemFormulation problemFormulation;

    public void addLoop(CMDOWSGraphLoop loop) {
        this.processGraphLoops.add(loop);
    }

    @Override
    public List<CMDOWSGraphLoop> getLoops() {
        return this.processGraphLoops;
    }

    public void addNodeToDataGraph(String uid, SchemaGraphNode<Object> node) {
        if (!this.dataGraph.containsKey(uid)) {
            this.dataGraph.put(uid, node);
        }
    }

    public void addNodeToProcessGraph(String uid, SchemaGraphNode<ExecutableBlock> node) {
        if (!this.processGraph.containsKey(uid)) {
            this.processGraph.put(uid, node);
        }
    }

    @Override
    public Map<String, SchemaGraphNode<ExecutableBlock>> getProcessGraph() {
        return Collections.unmodifiableMap(new HashMap<String, SchemaGraphNode<ExecutableBlock>>(this.processGraph));
    }

    @Override
    public Map<String, SchemaGraphNode<Object>> getDataGraph() {
        return Collections.unmodifiableMap(new HashMap<String, SchemaGraphNode<Object>>(this.dataGraph));
    }

    public void setWorkflowName(String name) {
        this.workflowName = name;
    }

    @Override
    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setHeader(SchemaHeader header) {
        this.header = header;
    }

    @Override
    public SchemaHeader getSchemaHeader() {
        return this.header;
    }

    public void setProblemFormulation(CMDOWSProblemFormulation problemFormulation) {
        this.problemFormulation = problemFormulation;
    }

    public CMDOWSProblemFormulation getProblemFormulation() {
        return this.problemFormulation;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.workflowName).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CMDOWSDataModel) {
            CMDOWSDataModel other = (CMDOWSDataModel)obj;
            return new EqualsBuilder().append((Object)this.workflowName, (Object)other.workflowName).isEquals();
        }
        return false;
    }

    public void setParamPool(Map<SchemaDesignParameterType, Set<SchemaDesignParameter>> pool) {
        this.paramPool = pool;
    }

    @Override
    public Set<SchemaDesignParameter> getDesignParameter(SchemaDesignParameterType type) {
        return this.paramPool.get((Object)type);
    }
}

