/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal;

import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.supplemental.cmdows.importer.api.SchemaParsingException;
import de.rcenvironment.supplemental.cmdows.importer.api.WorkflowDescriptionTranslatorService;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowBlockInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowEndpointInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSGraphLoop;
import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSWorkflowCreationUtils;
import de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks.ConsistencyConstraintFunctionBlock;
import de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks.ConvergerBlock;
import de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks.CoordinatorBlock;
import de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks.DOEBlock;
import de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks.DesignCompetenceBlock;
import de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks.MathematicalFunctionBlock;
import de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks.OptimizerBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.WorkflowSchemaModel;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockType;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.ProcessGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkflowDescriptionTranslatorServiceImpl
implements WorkflowDescriptionTranslatorService {
    private static final Log LOGGER = LogFactory.getLog(WorkflowDescriptionTranslatorServiceImpl.class);
    private static final double SUPPORTED_CMDOWS_VERSION = 0.8;
    private static DistributedComponentKnowledgeService disCompKnowledgeService;

    @Override
    public WorkflowDescription parseSchemaModelToWorkflowDescription(WorkflowSchemaModel schema, String cpacsPath, String[] mailInformation) throws SchemaParsingException {
        if (0.8 == schema.getSchemaHeader().getCmdowsVersion()) {
            WorkflowDescription wfDescription = this.createWorkflowDescription(schema);
            Map<String, ComponentInstallation> installations = WorkflowDescriptionTranslatorServiceImpl.initComponentInstallations();
            List<CMDOWSGraphLoop> loops = schema.getLoops();
            Map<String, WorkflowBlockInformation> nodeBlocks = WorkflowDescriptionTranslatorServiceImpl.createWorkflowNodesFromDesignDesciplines(schema, installations, loops, cpacsPath, mailInformation);
            String[] orderedBlocks = new String[nodeBlocks.size()];
            for (WorkflowBlockInformation nodeBlock : nodeBlocks.values()) {
                nodeBlock.addMergerNodes(schema, nodeBlock, installations);
                orderedBlocks[((ProcessGraphNode)schema.getProcessGraph().get((Object)nodeBlock.getNodeUID())).getPosition().intValue()] = nodeBlock.nodeUID;
            }
            ArrayList<WorkflowNode> allNodes = new ArrayList<WorkflowNode>();
            for (WorkflowBlockInformation block : nodeBlocks.values()) {
                allNodes.addAll(block.getWorkflowNodes());
            }
            wfDescription.addWorkflowNodes(allNodes);
            this.positionNodesAndLabels(orderedBlocks, nodeBlocks, wfDescription, loops, true);
            this.createWorkflowConnections(schema, wfDescription, nodeBlocks);
            return wfDescription;
        }
        throw new SchemaParsingException(StringUtils.format((String)"Unable to parse CMDOWS file: Version is %s, but the supported version is %s.", (Object[])new Object[]{schema.getSchemaHeader().getCmdowsVersion(), 0.8}));
    }

    private WorkflowDescription createWorkflowDescription(WorkflowSchemaModel schema) {
        WorkflowDescription desc = new WorkflowDescription(UUID.randomUUID().toString());
        desc.setWorkflowVersion(Integer.valueOf(5));
        desc.setName(schema.getWorkflowName());
        desc.setFileName(schema.getWorkflowName());
        return desc;
    }

    private static Map<String, WorkflowBlockInformation> createWorkflowNodesFromDesignDesciplines(WorkflowSchemaModel model, Map<String, ComponentInstallation> installations, List<CMDOWSGraphLoop> loops, String cpacsPath, String[] mailInformation) {
        Map<String, SchemaGraphNode<ExecutableBlock>> processGraph = model.getProcessGraph();
        HashMap<String, WorkflowBlockInformation> nodeBlocks = new HashMap<String, WorkflowBlockInformation>();
        for (Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode : processGraph.entrySet()) {
            ExecutableBlockType nodeType = processGraphNode.getValue().getNodeContent().getExecutableBlockType();
            WorkflowBlockInformation block = null;
            switch (nodeType) {
                case COORDINATOR: {
                    block = CoordinatorBlock.createBlock(installations, processGraphNode, model, cpacsPath);
                    break;
                }
                case OPTIMIZER: {
                    block = OptimizerBlock.createBlock(installations, processGraphNode, model);
                    break;
                }
                case DESIGN_COMPETENCE: {
                    block = DesignCompetenceBlock.createBlock(installations, processGraphNode, model, mailInformation);
                    break;
                }
                case CONSITENCY_CONSTRAINT_FUNCTION: {
                    block = ConsistencyConstraintFunctionBlock.createBlock(installations, processGraphNode, model);
                    break;
                }
                case CONVERGER: {
                    block = ConvergerBlock.createBlock(installations, processGraphNode, model);
                    break;
                }
                case DOE: {
                    block = DOEBlock.createBlock(installations, processGraphNode, model);
                    break;
                }
                case MATHEMATICAL_FUNCTION: {
                    block = MathematicalFunctionBlock.createBlock(installations, processGraphNode, model);
                    break;
                }
                default: {
                    LOGGER.error((Object)("Not recognized BlockNodeType:" + (Object)((Object)nodeType)));
                }
            }
            if (block == null) continue;
            nodeBlocks.put(processGraphNode.getKey(), block);
            CMDOWSGraphLoop loop = ((ProcessGraphNode)processGraphNode.getValue()).getLoop();
            ((WorkflowBlockInformation)nodeBlocks.get(processGraphNode.getKey())).setLoop(loop);
            if (loop.getLoopLevel() <= 2 || block.getMainNodeId() == null || !block.getWorkflowNode(block.getMainNodeId()).getComponentDescription().getComponentInterface().getIsLoopDriver()) continue;
            block.getWorkflowNode(block.getMainNodeId()).getConfigurationDescription().setConfigurationValue("isNestedLoop_5e0ed1cd", String.valueOf(true));
        }
        return nodeBlocks;
    }

    private void createWorkflowConnections(WorkflowSchemaModel schema, WorkflowDescription wfDescription, Map<String, WorkflowBlockInformation> blockInformation) {
        for (WorkflowBlockInformation workflowBlockInformation : blockInformation.values()) {
            workflowBlockInformation.linkInternalNodes(wfDescription, schema);
        }
        for (Map.Entry entry : schema.getProcessGraph().entrySet()) {
            for (SchemaGraphNode toNodeBlock : ((SchemaGraphNode)entry.getValue()).getAdjacencyList()) {
                WorkflowBlockInformation fromInfo = blockInformation.get(entry.getKey());
                WorkflowBlockInformation toInfo = blockInformation.get(toNodeBlock.getUID());
                CMDOWSGraphLoop fromLoop = fromInfo.getLoop();
                CMDOWSGraphLoop toLoop = toInfo.getLoop();
                EndpointCharacter loopType = EndpointCharacter.SAME_LOOP;
                if (fromLoop.getLoopStartProcessNumber() > toLoop.getLoopStartProcessNumber()) {
                    loopType = EndpointCharacter.OUTER_LOOP;
                }
                WorkflowEndpointInformation outputInfo = fromInfo.getCPACSOutputInformation(loopType);
                WorkflowEndpointInformation inputInfo = toInfo.getCPACSInputInformation(fromInfo.getNodeUID());
                if (inputInfo == null) {
                    inputInfo = toInfo.getCPACSInputInformation("uuidNotDefined");
                }
                if (outputInfo == null || inputInfo == null) continue;
                for (String inputName : inputInfo.getEndpointNames()) {
                    CMDOWSWorkflowCreationUtils.addWorkflowConnectionWithBendpoint(outputInfo.getNode(), outputInfo.getEndpointNames().get(0), inputInfo.getNode(), inputName, wfDescription);
                }
            }
        }
    }

    private void positionNodesAndLabels(String[] orderedBlocks, Map<String, WorkflowBlockInformation> nodeBlocks, WorkflowDescription wfDescription, List<CMDOWSGraphLoop> loops, boolean addLabel) {
        Color[] loopLevelColor = new Color[]{Color.CYAN, Color.BLACK, Color.LIGHT_GRAY};
        int nextBlockAbsoluteStartPosition = 54;
        HashMap<String, Integer[]> blockStarts = new HashMap<String, Integer[]>();
        int i = 0;
        while (i < orderedBlocks.length) {
            int labelStart = nextBlockAbsoluteStartPosition;
            nextBlockAbsoluteStartPosition = nodeBlocks.get(orderedBlocks[i]).setNodePositions(nextBlockAbsoluteStartPosition);
            if (addLabel) {
                WorkflowLabel blockLabel = new WorkflowLabel(nodeBlocks.get(orderedBlocks[i]).getNodeUID());
                blockLabel.setLocation(labelStart - 27, labelStart - 27);
                int size = nextBlockAbsoluteStartPosition - labelStart;
                blockLabel.setSize(size, size);
                blockLabel.setAlpha(140);
                blockLabel.setLabelPosition(WorkflowLabel.LabelPosition.TOPLEFT);
                blockLabel.setColorBackground(nodeBlocks.get(orderedBlocks[i]).getLabelColor());
                wfDescription.addWorkflowLabel(blockLabel);
            }
            blockStarts.put(orderedBlocks[i], new Integer[]{labelStart, nextBlockAbsoluteStartPosition});
            ++i;
        }
        for (CMDOWSGraphLoop loop : loops) {
            int start = loop.getLoopStartProcessNumber();
            if (start <= 0) continue;
            int loopLabelEnd = ((Integer[])blockStarts.get(orderedBlocks[loop.getHighestBlockPosition()]))[1];
            int loopLabelStart = ((Integer[])blockStarts.get(orderedBlocks[start]))[0];
            if (!addLabel) continue;
            WorkflowLabel loopLabel = new WorkflowLabel("Loop " + orderedBlocks[start]);
            loopLabel.setLocation(loopLabelStart - 27 - 2, loopLabelStart - 27 - 2);
            int size = loopLabelEnd - loopLabelStart + 4;
            loopLabel.setSize(size, size);
            loopLabel.setAlpha(180);
            loopLabel.setLabelPosition(WorkflowLabel.LabelPosition.TOPRIGHT);
            Color color = loopLevelColor[loop.getLoopLevel() % loopLevelColor.length];
            loopLabel.setColorBackground(new int[]{color.getRed(), color.getGreen(), color.getBlue()});
            loopLabel.setZIndex(-5);
            wfDescription.addWorkflowLabel(loopLabel);
        }
    }

    private static Map<String, ComponentInstallation> initComponentInstallations() {
        HashMap<String, ComponentInstallation> map = new HashMap<String, ComponentInstallation>();
        DistributedComponentKnowledge componentKnowledge = disCompKnowledgeService.getCurrentComponentKnowledge();
        Collection installations = componentKnowledge.getAllInstallations();
        for (ComponentInstallation installation : installations) {
            map.put(ComponentUtils.getComponentInterfaceIdentifierWithoutVersion((String)installation.getInstallationId()), installation);
        }
        return map;
    }

    protected static void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService newInstance) {
        disCompKnowledgeService = newInstance;
    }

    protected static void unbindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService oldnstance) {
        disCompKnowledgeService = null;
    }
}

