/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.gui.impl;

import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AdvancedBricsSettingsSection
extends ValidatingWorkflowNodePropertySection {
    private Text proxyHostText;
    private Text proxyPortText;

    protected void setWorkflowNode(WorkflowNode workflowNode) {
        boolean useProxy;
        super.setWorkflowNode(workflowNode);
        boolean bl = useProxy = this.getProperty("use_proxy") != null && Boolean.parseBoolean(this.getProperty("use_proxy"));
        if (this.proxyPortText != null) {
            this.proxyPortText.setEnabled(useProxy);
        }
        if (this.proxyHostText != null) {
            this.proxyHostText.setEnabled(useProxy);
        }
    }

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage propSheetPage) {
        super.createCompositeContent(parent, propSheetPage);
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)new GridData(768));
        this.createDataServerSection(parent, propSheetPage);
        this.createProxySection(parent, propSheetPage);
    }

    protected void createDataServerSection(Composite parent, TabbedPropertySheetPage propSheetPage) {
        Composite sectionComposite = this.createSectionComposite(parent, propSheetPage);
        Section dataServerSection = propSheetPage.getWidgetFactory().createSection(sectionComposite, 256);
        dataServerSection.setLayout((Layout)new GridLayout());
        dataServerSection.setLayoutData((Object)new GridData(772));
        dataServerSection.setText("Data Server Settings");
        Composite dataServerComposite = propSheetPage.getWidgetFactory().createComposite(sectionComposite);
        dataServerComposite.setLayout((Layout)new GridLayout(2, false));
        dataServerComposite.setLayoutData((Object)new GridData(772));
        Label dataServerLabel = new Label(dataServerComposite, 0);
        dataServerLabel.setText("Data server protocol");
        dataServerLabel.setBackground(dataServerComposite.getDisplay().getSystemColor(1));
        CCombo dataServerProtocolCombo = new CCombo(dataServerComposite, 8);
        dataServerProtocolCombo.add("SHPT4");
        dataServerProtocolCombo.add("SHPTA4");
        dataServerProtocolCombo.add("SHPT5");
        dataServerProtocolCombo.add("SHPTA5");
        dataServerProtocolCombo.setData("property.control", (Object)"data_server_protocol");
        dataServerProtocolCombo.setBackground(dataServerComposite.getDisplay().getSystemColor(1));
        Label authenticationLabel = new Label(dataServerComposite, 0);
        authenticationLabel.setText("Authentication protocol");
        authenticationLabel.setBackground(dataServerComposite.getDisplay().getSystemColor(1));
        CCombo authenticationProtocolCombo = new CCombo(dataServerComposite, 8);
        authenticationProtocolCombo.add("NTLM");
        authenticationProtocolCombo.add("NTLM-JCIFS");
        authenticationProtocolCombo.add("ADFS");
        authenticationProtocolCombo.setData("property.control", (Object)"authentication_protocol");
        authenticationProtocolCombo.setBackground(dataServerComposite.getDisplay().getSystemColor(1));
    }

    protected void createProxySection(Composite parent, TabbedPropertySheetPage propSheetPage) {
        Composite sectionComposite = this.createSectionComposite(parent, propSheetPage);
        Section proxySection = propSheetPage.getWidgetFactory().createSection(sectionComposite, 256);
        proxySection.setLayout((Layout)new GridLayout());
        proxySection.setLayoutData((Object)new GridData(772));
        proxySection.setText("Proxy Settings");
        Composite proxyComposite = propSheetPage.getWidgetFactory().createComposite(sectionComposite);
        proxyComposite.setLayout((Layout)new GridLayout(2, false));
        proxyComposite.setLayoutData((Object)new GridData(772));
        final Button useProxyButton = new Button(proxyComposite, 32);
        useProxyButton.setData("property.control", (Object)"use_proxy");
        useProxyButton.setText("Use proxy for connection");
        useProxyButton.setBackground(proxyComposite.getDisplay().getSystemColor(1));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        useProxyButton.setLayoutData((Object)data);
        this.proxyHostText = this.createLabelAndText("Proxy host", "proxy_host", proxyComposite);
        this.proxyPortText = this.createLabelAndText("Proxy port", "proxy_port", proxyComposite);
        this.proxyPortText.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(this.proxyPortText, 18));
        useProxyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                AdvancedBricsSettingsSection.this.proxyHostText.setEnabled(useProxyButton.getSelection());
                AdvancedBricsSettingsSection.this.proxyPortText.setEnabled(useProxyButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    private Text createLabelAndText(String labelText, String propKey, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setBackground(Display.getDefault().getSystemColor(1));
        Text text = new Text(parent, 2116);
        GridData data = new GridData(768);
        text.setLayoutData((Object)data);
        text.setData("property.control", (Object)propKey);
        return text;
    }

    private Composite createSectionComposite(Composite parent, TabbedPropertySheetPage propSheetPage) {
        Composite sectionComposite = propSheetPage.getWidgetFactory().createComposite(parent);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        sectionComposite.setLayout((Layout)gridLayout);
        sectionComposite.setLayoutData((Object)new GridData(1808));
        return sectionComposite;
    }
}

