/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks;

import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.AddDynamicInputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.AddDynamicOutputCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowBlockInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowEndpointInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSWorkflowCreationUtils;
import de.rcenvironment.supplemental.cmdows.importer.model.WorkflowSchemaModel;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.ProcessGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameter;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameterType;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConvergerBlock
extends WorkflowBlockInformation {
    private static final String START_SUFFIX = "_start";
    private WorkflowNode converger;
    private WorkflowNode outerLoopInputMerger;
    private WorkflowNode selfLoopInputMerger;
    private String[] outerLoopMergerLinks;
    private String[] selfLoopMergerLinks;

    public ConvergerBlock(String nodeUID) {
        super(nodeUID);
    }

    public static WorkflowBlockInformation createBlock(Map<String, ComponentInstallation> installations, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode, WorkflowSchemaModel model) {
        WorkflowNode newConverger;
        ConvergerBlock wbInfo = new ConvergerBlock(processGraphNode.getKey());
        wbInfo.converger = newConverger = CMDOWSWorkflowCreationUtils.createWorkflowNode(installations.get("de.rcenvironment.converger"), processGraphNode.getKey());
        wbInfo.setMainNodeId(newConverger.getIdentifier());
        wbInfo.createInternalMerger(installations, processGraphNode, model);
        List<SchemaGraphNode<Object>> allOutputs = model.getDataGraph().get(processGraphNode.getKey()).getAdjacencyList();
        for (SchemaGraphNode<Object> output : allOutputs) {
            SchemaDesignParameter schemaDesignParameter = (SchemaDesignParameter)output.getNodeContent();
            String name = schemaDesignParameter.getUID();
            if (schemaDesignParameter.getRelatedParameter() != null) {
                schemaDesignParameter = schemaDesignParameter.getRelatedParameter();
                name = schemaDesignParameter.getUID();
            }
            CMDOWSWorkflowCreationUtils.executeEndpointAddCommand(newConverger, (WorkflowNodeCommand)new AddDynamicInputCommand("valueToConverge", name, DataType.Float, Collections.emptyMap(), new Refreshable[0]));
            CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(wbInfo.selfLoopInputMerger.getOutputDescriptionsManager(), schemaDesignParameter.getUID(), name);
            HashMap<String, String> startMetaData = new HashMap<String, String>();
            startMetaData.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
            CMDOWSWorkflowCreationUtils.executeEndpointAddCommand(newConverger, (WorkflowNodeCommand)new AddDynamicInputCommand("startToConverge", String.valueOf(name) + START_SUFFIX, DataType.Float, startMetaData, "startValues", new Refreshable[0]));
            CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(wbInfo.outerLoopInputMerger.getOutputDescriptionsManager(), schemaDesignParameter.getUID(), String.valueOf(name) + "^0");
            CMDOWSWorkflowCreationUtils.executeEndpointAddCommand(newConverger, (WorkflowNodeCommand)new AddDynamicOutputCommand("valueToConverge", name, DataType.Float, Collections.emptyMap(), new Refreshable[0]));
            CMDOWSWorkflowCreationUtils.executeEndpointAddCommand(newConverger, (WorkflowNodeCommand)new AddDynamicOutputCommand("auxiliaryValue", String.valueOf(name) + "_is_converged", DataType.Boolean, Collections.emptyMap(), new Refreshable[0]));
            CMDOWSWorkflowCreationUtils.executeEndpointAddCommand(newConverger, (WorkflowNodeCommand)new AddDynamicOutputCommand("finalToConverge", String.valueOf(name) + "_converged", DataType.Float, Collections.emptyMap(), new Refreshable[0]));
        }
        CMDOWSWorkflowCreationUtils.addForwardingCPACSEndpoints(newConverger, "_converged");
        wbInfo.addWorkflowNode(newConverger);
        return wbInfo;
    }

    private void createInternalMerger(Map<String, ComponentInstallation> installations, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode, WorkflowSchemaModel schema) {
        Set<SchemaDesignParameter> ccv = schema.getDesignParameter(SchemaDesignParameterType.COUPLING_COPY_VARIABLE);
        HashMap<String, String> ccvToAdd = new HashMap<String, String>();
        for (SchemaDesignParameter couplingCopyVariable : ccv) {
            ccvToAdd.put(couplingCopyVariable.getRelatedParameter().getUID(), couplingCopyVariable.getUID());
        }
        this.outerLoopInputMerger = CMDOWSWorkflowCreationUtils.createMergerNodeWithMergingScript(String.valueOf(processGraphNode.getKey()) + "_Outer_Input", installations, ccvToAdd);
        this.selfLoopInputMerger = CMDOWSWorkflowCreationUtils.addMergerNodeWithDefaultScript(String.valueOf(processGraphNode.getKey()) + "_Self_Input", installations);
        this.addWorkflowNode(this.outerLoopInputMerger);
        this.addWorkflowNode(this.selfLoopInputMerger);
    }

    @Override
    public int[] getLabelColor() {
        return new int[]{254, 223, 196};
    }

    @Override
    public void addMergerNodes(WorkflowSchemaModel schema, WorkflowBlockInformation blockInfo, Map<String, ComponentInstallation> installations) {
        ProcessGraphNode processGraphNode = (ProcessGraphNode)schema.getProcessGraph().get(blockInfo.getNodeUID());
        List<SchemaGraphNode<ExecutableBlock>> parentNodeList = processGraphNode.getParentNodeList();
        LinkedList<SchemaGraphNode<ExecutableBlock>> outerParents = new LinkedList<SchemaGraphNode<ExecutableBlock>>();
        LinkedList<SchemaGraphNode<ExecutableBlock>> selfParents = new LinkedList<SchemaGraphNode<ExecutableBlock>>();
        for (SchemaGraphNode<ExecutableBlock> parentNode : parentNodeList) {
            int parentProcessNumber = ((ProcessGraphNode)parentNode).getStepNumber();
            if (blockInfo.getLoop().getLoopStartProcessNumber() > parentProcessNumber) {
                outerParents.add(parentNode);
                continue;
            }
            selfParents.add(parentNode);
        }
        LinkedList<String> endpoints = new LinkedList<String>();
        endpoints.add("XML");
        endpoints.add("XML to integrate");
        if (outerParents.size() > 1) {
            this.outerLoopMergerLinks = new String[outerParents.size() - 1];
        }
        this.addInputMerger(installations, processGraphNode, outerParents, this.outerLoopMergerLinks, this.outerLoopInputMerger, endpoints, schema);
        if (selfParents.size() > 1) {
            this.selfLoopMergerLinks = new String[selfParents.size() - 1];
        }
        this.addInputMerger(installations, processGraphNode, selfParents, this.selfLoopMergerLinks, this.selfLoopInputMerger, endpoints, schema);
    }

    @Override
    public void linkInternalNodes(WorkflowDescription wfDescription, WorkflowSchemaModel schema) {
        CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.outerLoopInputMerger, "XML", this.converger, "CPACS_start", wfDescription);
        CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.selfLoopInputMerger, "XML", this.converger, "CPACS", wfDescription);
        for (EndpointDescription desc : this.outerLoopInputMerger.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
            String nameInConverger = desc.getName().replace("^0", START_SUFFIX);
            if (nameInConverger.contains("^")) {
                nameInConverger = String.valueOf(nameInConverger.substring(0, nameInConverger.lastIndexOf(94) + 1)) + "c" + START_SUFFIX;
            }
            CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.outerLoopInputMerger, desc.getName(), this.converger, nameInConverger, wfDescription);
        }
        for (EndpointDescription desc : this.selfLoopInputMerger.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
            CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.selfLoopInputMerger, desc.getName(), this.converger, desc.getName(), wfDescription);
        }
        LinkedList<String> endpoints = new LinkedList<String>();
        endpoints.add("XML");
        endpoints.add("XML to integrate");
        this.linkInternalMerger(this.outerLoopMergerLinks, this.outerLoopInputMerger, endpoints, wfDescription);
        this.linkInternalMerger(this.selfLoopMergerLinks, this.selfLoopInputMerger, endpoints, wfDescription);
    }

    @Override
    public int setNodePositions(int absoluteStartPosition) {
        int convergerPosition = absoluteStartPosition;
        if (this.outerLoopMergerLinks != null) {
            convergerPosition += 40;
        }
        convergerPosition += 40;
        if (this.outerLoopMergerLinks != null) {
            this.positionLinkingMerger(convergerPosition, this.outerLoopMergerLinks, -162);
        }
        this.outerLoopInputMerger.setLocation(convergerPosition + 20, convergerPosition - 60);
        this.getWorkflowNode(this.mainNodeId).setLocation(convergerPosition, convergerPosition);
        this.selfLoopInputMerger.setLocation(convergerPosition + 20, convergerPosition + 101);
        if (this.selfLoopMergerLinks != null) {
            this.positionLinkingMerger(convergerPosition, this.selfLoopMergerLinks, 162);
            convergerPosition += 81;
        }
        return convergerPosition += 175;
    }

    @Override
    public WorkflowEndpointInformation getCPACSOutputInformation(EndpointCharacter type) {
        if (type == EndpointCharacter.OUTER_LOOP) {
            return new WorkflowEndpointInformation(this.converger, "CPACS_converged");
        }
        return new WorkflowEndpointInformation(this.converger, "CPACS");
    }
}

