/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.utils.common.testutils.XMLSupportServiceDefaultStub;
import de.rcenvironment.core.utils.common.xml.api.XMLSupportService;
import de.rcenvironment.supplemental.cmdows.importer.api.SchemaParsingException;
import de.rcenvironment.supplemental.cmdows.importer.api.WorkflowDescriptionTranslatorService;
import de.rcenvironment.supplemental.cmdows.importer.internal.CMDOWSParsingServiceImpl;
import de.rcenvironment.supplemental.cmdows.importer.model.SchemaHeader;
import de.rcenvironment.supplemental.cmdows.importer.model.WorkflowSchemaModel;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CMDOWSParsingServiceTest {
    private static final String D1 = "D1";
    private static final String D2 = "D2";
    private static final String COORDINATOR = "Coordinator";
    private static final String G1 = "G1";
    private static final String F = "F";
    private static final String GC = "Gc";
    private static final String G2 = "G2";
    private static final String OPTIMIZER = "Optimizer";
    private CMDOWSParsingServiceImpl service;
    private WorkflowSchemaModel model;

    @Before
    public void setUp() throws SchemaParsingException {
        this.service = new CMDOWSParsingServiceImpl();
        this.service.bindXMLSupportService((XMLSupportService)new XMLSupportServiceDefaultStub());
        this.service.parseSchemaToWorkflowFile(new File(this.getClass().getResource("/MDAO_IDF_corrected.xml").getFile()), (WorkflowDescriptionTranslatorService)new WorkflowTranslatorServiceMock(), "", "", "");
        this.model = this.service.getWorkflowModel();
    }

    @After
    public void tearDown() {
        this.service = null;
        this.model = null;
    }

    @Test
    public void testHeaderContent() {
        SchemaHeader header = this.model.getSchemaHeader();
        HashMap<String, String> expectedHeaderContent = new HashMap<String, String>(){
            private static final long serialVersionUID = 4252060704945454168L;
            {
                this.put("creator", "Erzeuger");
                this.put("description", "Test IDF file");
                this.put("timestamp", "2017-03-28T16:57:31.779000");
                this.put("fileVersion", "0.1");
                this.put("cmdowsVersion", "0.4");
            }
        };
        Assert.assertTrue((boolean)header.getCreator().equals(expectedHeaderContent.get("creator")));
        Assert.assertTrue((boolean)header.getDescription().equals(expectedHeaderContent.get("description")));
        Assert.assertTrue((boolean)header.getTimestamp().equals(expectedHeaderContent.get("timestamp")));
        Assert.assertTrue((header.getFileVersion() == Double.parseDouble((String)expectedHeaderContent.get("fileVersion")) ? 1 : 0) != 0);
        Assert.assertTrue((header.getCmdowsVersion() == Double.parseDouble((String)expectedHeaderContent.get("cmdowsVersion")) ? 1 : 0) != 0);
    }

    @Test
    public void testTrivialProcessGraphContent() {
        Map processGraph = this.model.getProcessGraph();
        LinkedList<String> expectedUIDsList = new LinkedList<String>(Arrays.asList(OPTIMIZER, G1, G2, F, GC, COORDINATOR, D2, D1));
        for (Map.Entry processGraphEntry : processGraph.entrySet()) {
            if (expectedUIDsList.contains(processGraphEntry.getKey())) {
                expectedUIDsList.remove(processGraphEntry.getKey());
            }
            Assert.assertTrue((((ExecutableBlock)((SchemaGraphNode)processGraphEntry.getValue()).getNodeContent()).getBlockName() != null ? 1 : 0) != 0);
            Assert.assertTrue((((SchemaGraphNode)processGraphEntry.getValue()).getUID() != null ? 1 : 0) != 0);
            Assert.assertTrue((((SchemaGraphNode)processGraphEntry.getValue()).getAdjacencyList().size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((((ExecutableBlock)((SchemaGraphNode)processGraphEntry.getValue()).getNodeContent()).getExecutableBlockType() != null ? 1 : 0) != 0);
        }
        Assert.assertTrue((expectedUIDsList.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testProcessGraphNodeChildren() {
        Map processGraph = this.model.getProcessGraph();
        LinkedList<String> optimizerChildrenUIDs = new LinkedList<String>(Arrays.asList(COORDINATOR, D2, D1));
        LinkedList<String> coordinatorChildrenUIDs = new LinkedList<String>(Arrays.asList(OPTIMIZER));
        LinkedList<String> d2ChildrenUIDs = new LinkedList<String>(Arrays.asList(GC, G2, F));
        LinkedList<String> d1ChildrenUIDs = new LinkedList<String>(Arrays.asList(F, G1, G2, GC));
        LinkedList<String> gcChildrenUIDs = new LinkedList<String>(Arrays.asList(OPTIMIZER));
        LinkedList<String> g1ChildrenUIDs = new LinkedList<String>(Arrays.asList(OPTIMIZER));
        LinkedList<String> g2ChildrenUIDs = new LinkedList<String>(Arrays.asList(OPTIMIZER));
        LinkedList<String> fChildrenUIDs = new LinkedList<String>(Arrays.asList(OPTIMIZER));
        for (Map.Entry entry : processGraph.entrySet()) {
            for (SchemaGraphNode block : ((SchemaGraphNode)entry.getValue()).getAdjacencyList()) {
                if (((String)entry.getKey()).equals(COORDINATOR)) {
                    coordinatorChildrenUIDs.remove(block.getUID());
                    continue;
                }
                if (((String)entry.getKey()).equals(D2)) {
                    d2ChildrenUIDs.remove(block.getUID());
                    continue;
                }
                if (((String)entry.getKey()).equals(D1)) {
                    d1ChildrenUIDs.remove(block.getUID());
                    continue;
                }
                if (((String)entry.getKey()).equals(OPTIMIZER)) {
                    optimizerChildrenUIDs.remove(block.getUID());
                    continue;
                }
                if (((String)entry.getKey()).equals(G1)) {
                    g1ChildrenUIDs.remove(block.getUID());
                    continue;
                }
                if (((String)entry.getKey()).equals(G2)) {
                    g2ChildrenUIDs.remove(block.getUID());
                    continue;
                }
                if (((String)entry.getKey()).equals(F)) {
                    fChildrenUIDs.remove(block.getUID());
                    continue;
                }
                if (!((String)entry.getKey()).equals(GC)) continue;
                gcChildrenUIDs.remove(block.getUID());
            }
        }
        Assert.assertTrue((optimizerChildrenUIDs.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((coordinatorChildrenUIDs.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((d2ChildrenUIDs.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((d1ChildrenUIDs.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((gcChildrenUIDs.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((g1ChildrenUIDs.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((g2ChildrenUIDs.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((fChildrenUIDs.size() == 0 ? 1 : 0) != 0);
    }

    private class WorkflowTranslatorServiceMock
    implements WorkflowDescriptionTranslatorService {
        private WorkflowTranslatorServiceMock() {
        }

        public WorkflowDescription parseSchemaModelToWorkflowDescription(WorkflowSchemaModel schema, String cpacs, String[] mailInfo) {
            return new WorkflowDescription("test");
        }
    }
}

