/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.execution.behavior.impl;

import de.rcenvironment.components.brics.execution.behavior.impl.AbstractBricsBehavior;
import de.rcenvironment.components.brics.execution.call.impl.BricsEnvironment;
import de.rcenvironment.components.brics.execution.facade.impl.BricsDownloadUploadFacade;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public abstract class AbstractBricsDownloadUploadBehavior
extends AbstractBricsBehavior {
    protected BricsDownloadUploadFacade bricsDownloadUploadFacade;
    protected String taskId;
    protected int count = 1;

    @Override
    public boolean treatStartAsComponentRun() {
        return true;
    }

    @Override
    public void start() throws ComponentException {
        super.start();
        this.checkUserConfiguredValue("task_name_id", "Task id missing");
        this.taskId = this.compContext.getConfigurationValue("task_name_id");
        this.bricsDownloadUploadFacade = this.bricsFacadeFactory.createBricsDownloadUploadFacade(this.createEnv(this.compContext), this.compContext.getLog());
        this.downloadFileAndWriteOrClose();
    }

    @Override
    protected Map<String, String> createEnv(ComponentContext componentContext) throws ComponentException {
        this.bricsScratchDir = this.createTemporaryDir();
        return BricsEnvironment.createDownloadUploadEnvironment(this.compContext, this.bricsScratchDir.getAbsolutePath());
    }

    protected void downloadFileAndWriteOrClose() throws ComponentException {
        File fileDir = null;
        try {
            fileDir = this.createTemporaryDir();
            try {
                if (this.downloadFileIntoDir(fileDir)) {
                    this.fetchFileFromDirAndWriteToOutput(fileDir);
                } else {
                    this.compContext.closeOutput("CPACS");
                }
            }
            catch (IOException e) {
                throw new ComponentException("Failed to download file through BRICS", (Throwable)e);
            }
        }
        finally {
            this.deleteTemporaryDir(fileDir);
        }
    }

    protected void uploadIncomingFile() throws ComponentException {
        File fileDir = null;
        try {
            fileDir = this.createTemporaryDirWithIncomingFile();
            try {
                this.uploadFileFromDir(fileDir);
            }
            catch (IOException e) {
                throw new ComponentException("Failed to upload file through BRICS", (Throwable)e);
            }
        }
        finally {
            this.deleteTemporaryDir(fileDir);
        }
    }

    protected abstract void uploadFileFromDir(File var1) throws IOException;

    protected abstract boolean downloadFileIntoDir(File var1) throws IOException;
}

