/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.execution;

import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ObjectNode;

public class BricsComponentsCommonDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String V1_1 = "1.1";
    private static final String V1_0 = "1";
    private static ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return new String[]{"de.rcenvironment.bricstask", "de.rcenvironment.bricsdu"};
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int versions = 0;
        if (silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V1_1) < 0) {
            versions |= 4;
        }
        return versions;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        block7: {
            if (!silent || formatVersion != 4) break block7;
            switch (description.getComponentVersion()) {
                case "1": {
                    description = this.updateFrom10To11(description);
                }
            }
        }
        return description;
    }

    private PersistentComponentDescription updateFrom10To11(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode configuration = node.get("configuration");
        if (configuration != null) {
            ObjectNode configNode = (ObjectNode)configuration;
            configNode.put("use_proxy", "false");
            configNode.put("proxy_host", "");
            configNode.put("proxy_port", "");
            configNode.put("data_server_protocol", "SHPT4");
            configNode.put("authentication_protocol", "NTLM");
            configNode.put("use_ssl_for_mail", "false");
            String newFolder = "Shared%20Documents/";
            String oldFolder = configNode.get("teamsite_folder").asText();
            if (oldFolder != null) {
                newFolder = String.valueOf(newFolder) + oldFolder;
            }
            configNode.put("teamsite_folder", newFolder);
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        PersistentComponentDescription newdesc = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        newdesc.setComponentVersion(V1_1);
        return newdesc;
    }
}

