/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks;

import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowBlockInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowEndpointInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSWorkflowCreationUtils;
import de.rcenvironment.supplemental.cmdows.importer.model.WorkflowSchemaModel;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public final class CoordinatorBlock
extends WorkflowBlockInformation {
    private WorkflowNode inputProvider = null;
    private WorkflowNode outputWriter = null;

    public CoordinatorBlock(String uid) {
        super(uid);
    }

    public static WorkflowBlockInformation createBlock(Map<String, ComponentInstallation> installations, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode, WorkflowSchemaModel model, String cpacsPath) {
        File cpacsFile;
        CoordinatorBlock wbInfo = new CoordinatorBlock(processGraphNode.getKey());
        String variableName = String.valueOf(processGraphNode.getKey()) + "-out";
        WorkflowNode inputProvider = CMDOWSWorkflowCreationUtils.createWorkflowNode(installations.get("de.rcenvironment.inputprovider"), variableName);
        wbInfo.setMainNodeId(inputProvider.getIdentifier());
        wbInfo.addWorkflowNode(inputProvider);
        wbInfo.inputProvider = inputProvider;
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (!cpacsPath.isEmpty() && (cpacsFile = new File(cpacsPath)).exists() && cpacsFile.isFile()) {
            metadata.put("startValue", cpacsFile.getAbsolutePath());
        }
        if (metadata.get("startValue") == null || ((String)metadata.get("startValue")).isEmpty()) {
            inputProvider.getConfigurationDescription().setConfigurationValue(variableName, "${" + variableName + "}");
            inputProvider.getConfigurationDescription().setConfigurationValue(String.valueOf(variableName) + "_datatype_799ef365", "file");
            metadata.put("fileSourceType", "atWorkflowStart");
            metadata.put("startValue", "${" + variableName + "}");
        }
        inputProvider.getOutputDescriptionsManager().addDynamicEndpointDescription("default", variableName, DataType.FileReference, metadata);
        WorkflowNode outputWriter = CMDOWSWorkflowCreationUtils.createWorkflowNode(installations.get("de.rcenvironment.outputwriter"), String.valueOf(processGraphNode.getKey()) + "-in");
        wbInfo.addWorkflowNode(outputWriter);
        wbInfo.outputWriter = outputWriter;
        HashMap<String, String> outputFileMetadata = new HashMap<String, String>();
        outputFileMetadata.put("filename", "CPACS_RESULT_[Timestamp].xml");
        outputFileMetadata.put("folderForSaving", "[root]\\");
        outputWriter.getInputDescriptionsManager().addDynamicEndpointDescription("default", "CPACS", DataType.FileReference, outputFileMetadata);
        return wbInfo;
    }

    @Override
    public WorkflowEndpointInformation getCPACSOutputInformation(EndpointCharacter character) {
        LinkedList<String> endpointNames = new LinkedList<String>();
        endpointNames.add(String.valueOf(this.getNodeUID()) + "-out");
        return new WorkflowEndpointInformation(this.inputProvider, endpointNames);
    }

    @Override
    public int setNodePositions(int absoluteStartPosition) {
        this.inputProvider.setLocation(absoluteStartPosition, absoluteStartPosition);
        this.outputWriter.setLocation(absoluteStartPosition + 60, absoluteStartPosition + 60);
        return absoluteStartPosition + 81 + 67;
    }

    @Override
    public int[] getLabelColor() {
        return new int[]{255, 255, 255};
    }

    @Override
    public WorkflowEndpointInformation getCPACSInputInformation(String fromUID) {
        LinkedList<String> endpoints = new LinkedList<String>();
        endpoints.add("CPACS");
        return new WorkflowEndpointInformation(this.outputWriter, endpoints);
    }
}

