/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks;

import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowBlockInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowEndpointInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSWorkflowCreationUtils;
import de.rcenvironment.supplemental.cmdows.importer.model.WorkflowSchemaModel;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.ProcessGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameter;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameterType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConsistencyConstraintFunctionBlock
extends WorkflowBlockInformation {
    private WorkflowNode inputMerger;
    private WorkflowNode outputMerger;

    public ConsistencyConstraintFunctionBlock(String nodeUID) {
        super(nodeUID);
    }

    public static WorkflowBlockInformation createBlock(Map<String, ComponentInstallation> installations, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode, WorkflowSchemaModel model) {
        ConsistencyConstraintFunctionBlock wbInfo = new ConsistencyConstraintFunctionBlock(processGraphNode.getKey());
        ComponentInstallation compInstallation = installations.get("de.rcenvironment.script");
        WorkflowNode scriptNode = CMDOWSWorkflowCreationUtils.createWorkflowNode(compInstallation, processGraphNode.getKey());
        wbInfo.setMainNodeId(scriptNode.getIdentifier());
        wbInfo.addWorkflowNode(scriptNode);
        wbInfo.createInternalMerger(installations, processGraphNode, model);
        ConsistencyConstraintFunctionBlock.configureScript(model, wbInfo, scriptNode);
        return wbInfo;
    }

    private static void configureScript(WorkflowSchemaModel model, ConsistencyConstraintFunctionBlock wbInfo, WorkflowNode scriptNode) {
        ConfigurationDescription configurationDescription = scriptNode.getConfigurationDescription();
        configurationDescription.setConfigurationValue("scriptLanguage", ScriptLanguage.Jython.getName());
        configurationDescription.setConfigurationValue("usageOfScript", "NEW");
        StringBuilder scriptHeader = new StringBuilder();
        StringBuilder scriptMain = new StringBuilder();
        StringBuilder scriptFooter = new StringBuilder();
        Set<SchemaDesignParameter> couplingCopyVariables = model.getDesignParameter(SchemaDesignParameterType.COUPLING_COPY_VARIABLE);
        Set<SchemaDesignParameter> consistancyConstraintVariables = model.getDesignParameter(SchemaDesignParameterType.CONSISTENCY_CONSTRAINT_VARIABLE);
        int i = 0;
        for (SchemaDesignParameter couplingCopyVariable : couplingCopyVariables) {
            for (SchemaDesignParameter consistancyConstraintVariable : consistancyConstraintVariables) {
                if (!couplingCopyVariable.getRelatedParameter().getUID().equals(consistancyConstraintVariable.getRelatedParameter().getUID())) continue;
                wbInfo.addConstraintFunction(couplingCopyVariable, consistancyConstraintVariable.getRelatedParameter(), consistancyConstraintVariable, scriptHeader, scriptMain, scriptFooter, i++);
            }
        }
        StringBuilder script = new StringBuilder();
        script.append((CharSequence)scriptHeader);
        script.append((CharSequence)scriptMain);
        script.append((CharSequence)scriptFooter);
        configurationDescription.setConfigurationValue("script", script.toString());
    }

    private void createInternalMerger(Map<String, ComponentInstallation> installations, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode, WorkflowSchemaModel schema) {
        Set<SchemaDesignParameter> ccv = schema.getDesignParameter(SchemaDesignParameterType.CONSISTENCY_CONSTRAINT_VARIABLE);
        HashMap<String, String> ccvToAdd = new HashMap<String, String>();
        for (SchemaDesignParameter consistancyConstraintVariable : ccv) {
            ccvToAdd.put(consistancyConstraintVariable.getRelatedParameter().getUID(), consistancyConstraintVariable.getUID());
        }
        this.inputMerger = CMDOWSWorkflowCreationUtils.createMergerNodeWithMergingScript(String.valueOf(processGraphNode.getKey()) + "_Input", installations, ccvToAdd);
        this.outputMerger = CMDOWSWorkflowCreationUtils.addMergerNodeWithDefaultScript(String.valueOf(processGraphNode.getKey()) + "_Output", installations);
        this.addWorkflowNode(this.inputMerger);
        this.addWorkflowNode(this.outputMerger);
    }

    private void addConstraintFunction(SchemaDesignParameter constraintVar, SchemaDesignParameter competenceVar, SchemaDesignParameter outputVar, StringBuilder scriptHeader, StringBuilder scriptMain, StringBuilder scriptFooter, int i) {
        scriptHeader.append(StringUtils.format((String)"%s = RCE.read_input(\"%s\")\n", (Object[])new Object[]{"constraintVar" + i, constraintVar.getUID()}));
        scriptHeader.append(StringUtils.format((String)"%s = RCE.read_input(\"%s\")\n", (Object[])new Object[]{"competenceVar" + i, competenceVar.getUID()}));
        scriptMain.append(StringUtils.format((String)"%s = (%s - %s)\n", (Object[])new Object[]{"Output" + i, "constraintVar" + i, "competenceVar" + i}));
        scriptFooter.append(StringUtils.format((String)"RCE.write_output(\"%s\", %s)\n", (Object[])new Object[]{outputVar.getUID(), "Output" + i}));
        WorkflowNode scriptNode = this.getWorkflowNode(this.getMainNodeId());
        scriptNode.getInputDescriptionsManager().addDynamicEndpointDescription("default", constraintVar.getUID(), DataType.Float, new HashMap());
        CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(this.inputMerger.getOutputDescriptionsManager(), constraintVar.getUID(), constraintVar.getUID());
        scriptNode.getInputDescriptionsManager().addDynamicEndpointDescription("default", competenceVar.getUID(), DataType.Float, new HashMap());
        CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(this.inputMerger.getOutputDescriptionsManager(), competenceVar.getUID(), competenceVar.getUID());
        scriptNode.getOutputDescriptionsManager().addDynamicEndpointDescription("default", outputVar.getUID(), DataType.Float, new HashMap());
        CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(this.outputMerger.getInputDescriptionsManager(), outputVar.getUID(), outputVar.getUID());
    }

    @Override
    public void addMergerNodes(WorkflowSchemaModel schema, WorkflowBlockInformation blockInfo, Map<String, ComponentInstallation> installations) {
        ProcessGraphNode processGraphNode = (ProcessGraphNode)schema.getProcessGraph().get(blockInfo.getNodeUID());
        List<SchemaGraphNode<ExecutableBlock>> parentNodeList = this.getParentsWithData(processGraphNode, schema);
        LinkedList<String> endpoints = new LinkedList<String>();
        endpoints.add("XML");
        endpoints.add("XML to integrate");
        if (parentNodeList.size() > 1) {
            this.mergerLinks = new String[parentNodeList.size() - 1];
        }
        this.addInputMerger(installations, processGraphNode, parentNodeList, this.mergerLinks, this.inputMerger, endpoints, schema);
    }

    @Override
    public void linkInternalNodes(WorkflowDescription wfDescription, WorkflowSchemaModel schema) {
        for (EndpointDescription desc : this.inputMerger.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
            CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.inputMerger, desc.getName(), this.getWorkflowNode(this.getMainNodeId()), desc.getName(), wfDescription);
        }
        for (EndpointDescription desc : this.outputMerger.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
            CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.getWorkflowNode(this.getMainNodeId()), desc.getName(), this.outputMerger, desc.getName(), wfDescription);
        }
        CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.inputMerger, "XML", this.outputMerger, "XML", wfDescription);
        CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.inputMerger, "XML", this.outputMerger, "XML to integrate", wfDescription);
        LinkedList<String> endpoints = new LinkedList<String>();
        endpoints.add("XML");
        endpoints.add("XML to integrate");
        this.linkInternalMerger(this.mergerLinks, this.inputMerger, endpoints, wfDescription);
    }

    @Override
    public WorkflowEndpointInformation getCPACSOutputInformation(EndpointCharacter character) {
        return new WorkflowEndpointInformation(this.outputMerger, "XML");
    }

    @Override
    public int[] getLabelColor() {
        return new int[]{241, 196, 209};
    }

    @Override
    public int setNodePositions(int absoluteStartPosition) {
        int mainNodePosition = absoluteStartPosition + 40;
        if (this.mergerLinks != null) {
            this.positionLinkingMerger(mainNodePosition += 60, this.mergerLinks, -121);
        }
        this.inputMerger.setLocation(mainNodePosition + 20, mainNodePosition - 60);
        this.getWorkflowNode(this.mainNodeId).setLocation(mainNodePosition, mainNodePosition);
        this.outputMerger.setLocation(mainNodePosition - 60, mainNodePosition + 20);
        return absoluteStartPosition + 81 + 162;
    }
}

