/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.supplemental.cmdows.importer.internal.workflowblocks;

import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowBlockInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.WorkflowEndpointInformation;
import de.rcenvironment.supplemental.cmdows.importer.internal.utils.CMDOWSWorkflowCreationUtils;
import de.rcenvironment.supplemental.cmdows.importer.model.WorkflowSchemaModel;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlock;
import de.rcenvironment.supplemental.cmdows.importer.model.executableblock.ExecutableBlockComponent;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.ProcessGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.graph.SchemaGraphNode;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameter;
import de.rcenvironment.supplemental.cmdows.importer.model.parameter.SchemaDesignParameterType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MathematicalFunctionBlock
extends WorkflowBlockInformation {
    private WorkflowNode inputMerger;
    private WorkflowNode outputMerger;

    public MathematicalFunctionBlock(String nodeUID) {
        super(nodeUID);
    }

    public static WorkflowBlockInformation createBlock(Map<String, ComponentInstallation> installations, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode, WorkflowSchemaModel model) {
        MathematicalFunctionBlock wbInfo = new MathematicalFunctionBlock(processGraphNode.getKey());
        ComponentInstallation compInstallation = installations.get("de.rcenvironment.script");
        WorkflowNode scriptNode = CMDOWSWorkflowCreationUtils.createWorkflowNode(compInstallation, processGraphNode.getKey());
        wbInfo.setMainNodeId(scriptNode.getIdentifier());
        wbInfo.addWorkflowNode(scriptNode);
        wbInfo.createInternalMerger(installations, processGraphNode);
        wbInfo.configureScript(scriptNode, processGraphNode);
        return wbInfo;
    }

    private void createInternalMerger(Map<String, ComponentInstallation> installations, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode) {
        this.inputMerger = CMDOWSWorkflowCreationUtils.addMergerNodeWithDefaultScript(String.valueOf(processGraphNode.getKey()) + "_Input", installations);
        this.outputMerger = CMDOWSWorkflowCreationUtils.addMergerNodeWithDefaultScript(String.valueOf(processGraphNode.getKey()) + "_Output", installations);
        this.addWorkflowNode(this.inputMerger);
        this.addWorkflowNode(this.outputMerger);
    }

    private void configureScript(WorkflowNode scriptNode, Map.Entry<String, SchemaGraphNode<ExecutableBlock>> processGraphNode) {
        ConfigurationDescription configurationDescription = scriptNode.getConfigurationDescription();
        configurationDescription.setConfigurationValue("scriptLanguage", ScriptLanguage.Jython.getName());
        configurationDescription.setConfigurationValue("usageOfScript", "NEW");
        Map<String, Object> metadata = processGraphNode.getValue().getNodeContent().getMetaData();
        StringBuilder scriptHeader = new StringBuilder();
        StringBuilder scriptMain = new StringBuilder();
        StringBuilder scriptFooter = new StringBuilder();
        scriptHeader.append("from math import *\n");
        Set<SchemaDesignParameter> inputs = ((ExecutableBlockComponent)processGraphNode.getValue().getNodeContent()).getExecutableBlockComponentInputs();
        Map equationLabel = (Map)metadata.get("equationLabel");
        if (equationLabel != null) {
            for (SchemaDesignParameter input : inputs) {
                CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(this.inputMerger.getOutputDescriptionsManager(), input.getUID(), input.getUID());
                scriptNode.getInputDescriptionsManager().addDynamicEndpointDescription("default", input.getUID(), DataType.Float, new HashMap());
                scriptHeader.append(StringUtils.format((String)"%s = RCE.read_input(\"%s\")\n", (Object[])new Object[]{equationLabel.get(input.getUID()), input.getUID()}));
            }
        }
        Set<SchemaDesignParameter> outputs = ((ExecutableBlockComponent)processGraphNode.getValue().getNodeContent()).getExecutableBlockComponentOutputs();
        int i = 0;
        for (SchemaDesignParameter output : outputs) {
            Map equations;
            if (!output.getSchemaDesignParameterType().equals((Object)SchemaDesignParameterType.DEFAULT) || (equations = (Map)output.getAdditionalInformation().get("equations")) == null || equations.size() <= 0 || !equations.containsKey("Python")) continue;
            CMDOWSWorkflowCreationUtils.addDynamicXMLEndpointsToComponent(this.outputMerger.getInputDescriptionsManager(), output.getUID(), output.getUID());
            scriptNode.getOutputDescriptionsManager().addDynamicEndpointDescription("default", output.getUID(), DataType.Float, new HashMap());
            scriptHeader.append(StringUtils.format((String)"%s = %s\n", (Object[])new Object[]{"Equation" + i, equations.get("Python")}));
            scriptFooter.append(StringUtils.format((String)"RCE.write_output(\"%s\", %s)\n", (Object[])new Object[]{output.getUID(), "Equation" + i}));
            ++i;
        }
        StringBuilder script = new StringBuilder();
        script.append((CharSequence)scriptHeader);
        script.append((CharSequence)scriptMain);
        script.append((CharSequence)scriptFooter);
        configurationDescription.setConfigurationValue("script", script.toString());
    }

    @Override
    public void addMergerNodes(WorkflowSchemaModel schema, WorkflowBlockInformation blockInfo, Map<String, ComponentInstallation> installations) {
        ProcessGraphNode processGraphNode = (ProcessGraphNode)schema.getProcessGraph().get(blockInfo.getNodeUID());
        List<SchemaGraphNode<ExecutableBlock>> parentNodeList = this.getParentsWithData(processGraphNode, schema);
        LinkedList<String> endpoints = new LinkedList<String>();
        endpoints.add("XML");
        endpoints.add("XML to integrate");
        if (parentNodeList.size() > 1) {
            this.mergerLinks = new String[parentNodeList.size() - 1];
        }
        this.addInputMerger(installations, processGraphNode, parentNodeList, this.mergerLinks, this.inputMerger, endpoints, schema);
    }

    @Override
    public void linkInternalNodes(WorkflowDescription wfDescription, WorkflowSchemaModel schema) {
        for (EndpointDescription desc : this.inputMerger.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
            CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.inputMerger, desc.getName(), this.getWorkflowNode(this.getMainNodeId()), desc.getName(), wfDescription);
        }
        for (EndpointDescription desc : this.outputMerger.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
            CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.getWorkflowNode(this.getMainNodeId()), desc.getName(), this.outputMerger, desc.getName(), wfDescription);
        }
        CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.inputMerger, "XML", this.outputMerger, "XML", wfDescription);
        CMDOWSWorkflowCreationUtils.addWorkflowConnection(this.inputMerger, "XML", this.outputMerger, "XML to integrate", wfDescription);
        LinkedList<String> endpoints = new LinkedList<String>();
        endpoints.add("XML");
        endpoints.add("XML to integrate");
        this.linkInternalMerger(this.mergerLinks, this.inputMerger, endpoints, wfDescription);
    }

    @Override
    public WorkflowEndpointInformation getCPACSOutputInformation(EndpointCharacter character) {
        return new WorkflowEndpointInformation(this.outputMerger, "XML");
    }

    @Override
    public int[] getLabelColor() {
        return new int[]{241, 196, 209};
    }

    @Override
    public int setNodePositions(int absoluteStartPosition) {
        int mainNodePosition = absoluteStartPosition + 40;
        if (this.mergerLinks != null) {
            this.positionLinkingMerger(mainNodePosition += 60, this.mergerLinks, -121);
            absoluteStartPosition += 81;
        }
        this.inputMerger.setLocation(mainNodePosition + 20, mainNodePosition - 60);
        this.getWorkflowNode(this.mainNodeId).setLocation(mainNodePosition, mainNodePosition);
        this.outputMerger.setLocation(mainNodePosition + 20, mainNodePosition + 101);
        return absoluteStartPosition + 162 + 54;
    }
}

