/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.execution.validation.impl;

import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractComponentValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractBricsComponentValidator
extends AbstractComponentValidator {
    protected List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription componentDescription) {
        String bricsInstall;
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        boolean selectAtWfStart = Boolean.valueOf(this.getProperty(componentDescription, "select_brics_root_at_wf_start"));
        if (!selectAtWfStart && ((bricsInstall = this.getProperty(componentDescription, "brics_root")) == null || bricsInstall.trim().isEmpty())) {
            ComponentValidationMessage noFile = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "brics_root", "", "BRICS installation missing");
            messages.add(noFile);
        }
        for (Map.Entry<String, String> entry : this.getConfigKeyAndErrorMessages().entrySet()) {
            this.checkIfConfigurationValueIsDefined(componentDescription, entry.getKey(), entry.getValue(), messages);
        }
        return messages;
    }

    protected abstract Map<String, String> getConfigKeyAndErrorMessages();

    private void checkIfConfigurationValueIsDefined(ComponentDescription componentDescription, String configKey, String message, List<ComponentValidationMessage> messages) {
        String configValue = this.getProperty(componentDescription, configKey);
        if (configValue == null || configValue.isEmpty()) {
            ComponentValidationMessage errorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, configKey, "", message);
            messages.add(errorMessage);
        }
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }
}

